/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.client.OAuthResponseMessage;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpMessageDecoder;
import net.oauth.http.HttpResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthClient {
    private final HttpClient http;
    public static final String PARAMETER_STYLE = "parameterStyle";
    public static final String ACCEPT_ENCODING = "HTTP.header.Accept-Encoding";
    protected static final String PUT = "PUT";
    protected static final String POST = "POST";
    protected static final String DELETE = "DELETE";
    protected static final String CONTENT_LENGTH = "Content-Length";

    public OAuthClient(HttpClient http) {
        this.http = http;
    }

    public void getRequestToken(OAuthAccessor accessor, String httpMethod) throws IOException, OAuthException, URISyntaxException {
        this.getRequestToken(accessor, httpMethod, null);
    }

    public void getRequestToken(OAuthAccessor accessor, String httpMethod, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        accessor.accessToken = null;
        accessor.tokenSecret = null;
        Object accessorSecret = accessor.getProperty("oauth_accessor_secret");
        if (accessorSecret != null) {
            ArrayList<? extends Map.Entry> p = parameters == null ? new ArrayList<Map.Entry>(1) : new ArrayList<Map.Entry>(parameters);
            p.add(new OAuth.Parameter("oauth_accessor_secret", accessorSecret.toString()));
            parameters = p;
        }
        OAuthMessage response = this.invoke(accessor, httpMethod, accessor.consumer.serviceProvider.requestTokenURL, parameters);
        accessor.requestToken = response.getParameter("oauth_token");
        accessor.tokenSecret = response.getParameter("oauth_token_secret");
        if (accessor.requestToken == null) {
            OAuthProblemException problem = new OAuthProblemException("parameter_absent");
            problem.setParameter("oauth_parameters_absent", "oauth_token");
            problem.getParameters().putAll(response.getDump());
            throw problem;
        }
    }

    public void getRequestToken(OAuthAccessor accessor) throws IOException, OAuthException, URISyntaxException {
        this.getRequestToken(accessor, null);
    }

    public OAuthMessage invoke(OAuthAccessor accessor, String httpMethod, String url, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        String ps = (String)accessor.consumer.getProperty(PARAMETER_STYLE);
        ParameterStyle style = ps == null ? ParameterStyle.BODY : Enum.valueOf(ParameterStyle.class, ps);
        OAuthMessage request = accessor.newRequestMessage(httpMethod, url, parameters);
        Object accepted = accessor.consumer.getProperty(ACCEPT_ENCODING);
        if (accepted != null) {
            request.getHeaders().add(new OAuth.Parameter("Accept-Encoding", accepted.toString()));
        }
        return this.invoke(request, style);
    }

    public OAuthMessage invoke(OAuthAccessor accessor, String url, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        return this.invoke(accessor, null, url, parameters);
    }

    public OAuthMessage invoke(OAuthMessage request) throws IOException, OAuthException {
        return this.invoke(request, ParameterStyle.BODY);
    }

    public OAuthMessage invoke(OAuthMessage request, ParameterStyle style) throws IOException, OAuthException {
        boolean isPost = POST.equalsIgnoreCase(request.method);
        InputStream body = request.getBodyAsStream();
        if (!(style != ParameterStyle.BODY || isPost && body == null)) {
            style = ParameterStyle.QUERY_STRING;
        }
        String url = request.URL;
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>(request.getHeaders());
        switch (style) {
            case QUERY_STRING: {
                url = OAuth.addParameters(url, request.getParameters());
                break;
            }
            case BODY: {
                byte[] form = OAuth.formEncode(request.getParameters()).getBytes(request.getBodyEncoding());
                headers.add(new OAuth.Parameter("Content-Type", "application/x-www-form-urlencoded"));
                headers.add(new OAuth.Parameter(CONTENT_LENGTH, String.valueOf(form.length)));
                body = new ByteArrayInputStream(form);
                break;
            }
            case AUTHORIZATION_HEADER: {
                headers.add(new OAuth.Parameter("Authorization", request.getAuthorizationHeader(null)));
                List<Map.Entry<String, String>> others = request.getParameters();
                if (others == null || others.isEmpty()) break;
                others = new ArrayList<Map.Entry<String, String>>(others);
                Iterator<Map.Entry<String, String>> p = others.iterator();
                while (p.hasNext()) {
                    if (!p.next().getKey().startsWith("oauth_")) continue;
                    p.remove();
                }
                if (isPost && body == null) {
                    byte[] form = OAuth.formEncode(others).getBytes(request.getBodyEncoding());
                    headers.add(new OAuth.Parameter("Content-Type", "application/x-www-form-urlencoded"));
                    headers.add(new OAuth.Parameter(CONTENT_LENGTH, String.valueOf(form.length)));
                    body = new ByteArrayInputStream(form);
                    break;
                }
                url = OAuth.addParameters(url, others);
            }
        }
        HttpMessage httpRequest = new HttpMessage(request.method, new URL(url), body);
        httpRequest.headers.addAll(headers);
        HttpResponseMessage httpResponse = this.http.execute(httpRequest);
        httpResponse = HttpMessageDecoder.decode(httpResponse);
        OAuthResponseMessage response = new OAuthResponseMessage(httpResponse);
        if (httpResponse.getStatusCode() != 200) {
            OAuthProblemException problem = new OAuthProblemException();
            try {
                response.getParameters();
            }
            catch (IOException iOException) {}
            problem.getParameters().putAll(response.getDump());
            try {
                InputStream b = ((OAuthMessage)response).getBodyAsStream();
                if (b != null) {
                    b.close();
                }
            }
            catch (IOException iOException) {}
            throw problem;
        }
        return response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParameterStyle {
        AUTHORIZATION_HEADER,
        BODY,
        QUERY_STRING;

    }
}

