/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.util;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.internal.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;

public abstract class LineDelimiterVerifier
extends InputStreamReader {
    private long lineDelimiterCount = 0L;
    private long markLineDelimiterCount = 0L;
    private boolean enabled = true;
    private FileLineDelimiter lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;

    public LineDelimiterVerifier(InputStream in, String encoding, FileLineDelimiter expectedLineTerminator) throws UnsupportedEncodingException {
        super(in, Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
        this.lineDelimiter = expectedLineTerminator;
    }

    public LineDelimiterVerifier(InputStream in, String encoding) throws UnsupportedEncodingException {
        this(in, encoding, FileLineDelimiter.LINE_DELIMITER_NONE);
    }

    public void mark(int readlimit) throws IOException {
        super.mark(readlimit);
        this.markLineDelimiterCount = this.lineDelimiterCount;
    }

    public void reset() throws IOException {
        super.reset();
        this.lineDelimiterCount = this.markLineDelimiterCount;
    }

    protected final void validateLineDelimiter(FileLineDelimiter delimiterFound) throws ContentLineDelimiterError {
        ++this.lineDelimiterCount;
        if (this.lineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) {
            this.lineDelimiter = delimiterFound;
        } else if (this.enabled && this.lineDelimiter != delimiterFound) {
            String msg = NLS.bind((String)Messages.getString("LineDelimiterVerifier_ErrorMismatchedDelimiters"), (Object)this.lineDelimiterCount, (Object[])new Object[]{delimiterFound.toString(), this.lineDelimiter.toString()});
            throw new ContentLineDelimiterError(msg);
        }
    }

    public final long getLineDelimiterCount() {
        return this.lineDelimiterCount;
    }

    public final FileLineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    final void setVerifyEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

