/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.util;

import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemUtil {
    private ItemUtil() {
    }

    public static ItemId<IFolder> getParent(IVersionable versionable) {
        IFolderHandle folder = versionable.getParent();
        if (folder != null) {
            return new ItemId((IItemHandle)versionable.getParent());
        }
        return ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
    }

    public static ItemId<IComponent> getComponent(IComponentHandle component) {
        if (component == null) {
            return ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        }
        return new ItemId((IItemHandle)component);
    }

    public static boolean containsItem(ItemId<IFolder> folder, IVersionable item) {
        return item.getParent() == null && folder == null || item.getParent() != null && item.getParent().getItemId().equals((Object)folder.getItemUUID());
    }

    public static ItemId<IContributor> getModifiedBy(IItem item) {
        IContributorHandle handle = item.getModifiedBy();
        if (handle == null) {
            return ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        }
        return new ItemId((IItemHandle)handle);
    }

    public static ItemId<IContributor> getCreator(IBaselineSet snapshot) {
        IContributorHandle handle = snapshot.getCreator();
        if (handle == null) {
            return ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        }
        return new ItemId((IItemHandle)handle);
    }

    public static ItemId<IContributor> getCreator(IBaseline baseline) {
        IContributorHandle handle = baseline.getCreator();
        if (handle == null) {
            return ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        }
        return new ItemId((IItemHandle)handle);
    }

    public static ItemId<IContributor> getContributor(IContributor contributor) {
        if (contributor == null) {
            return ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        }
        return ItemId.forItem((IItem)contributor);
    }

    public static IItemType getItemTypeForClass(Class clazz) {
        try {
            Field field = clazz.getDeclaredField("ITEM_TYPE");
            IItemType type = (IItemType)field.get(null);
            return type;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to determine the item type for class " + clazz.getName());
        }
    }

    public static List<ItemId<ILink>> getLinks(IChangeSetLinkSummary nextSummary) {
        return ItemLists.handlesToIds((Collection)nextSummary.getLinks());
    }

    public static ItemId getOwner(IWorkspace workspace) {
        return new ItemId((IItemHandle)workspace.getOwner());
    }

    public static ItemId<IComponent> getComponent(IBaseline baseline) {
        return ItemUtil.getComponent(baseline.getComponent());
    }
}

