/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.patch;

import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.internal.patch.ByteArrayLine;
import com.ibm.team.filesystem.common.internal.patch.ByteArrayLines;
import com.ibm.team.filesystem.common.internal.patch.ChangeClassifier;
import com.ibm.team.filesystem.common.internal.patch.CreatePatchDilemmaHandler;
import com.ibm.team.filesystem.common.internal.patch.HunkRange;
import com.ibm.team.filesystem.common.internal.patch.RangeDifference;
import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePatchUtil {
    public static final DateFormat DIFF_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS Z");
    public static final String PATCH_HEADER_PREFIX = "### Jazz Patch";
    public static final String PATCH_HEADER_VERSION = "1.0";
    static final String PATCH_HEADER = "### Jazz Patch 1.0\n";
    static final int CONTEXT_LINES = 3;
    public static final String NO_TRAILING_NL_STRING = "\n\\ No newline at end of file\n";
    static final String UTF8 = "UTF-8";
    static final byte[] NO_TRAILING_NL;
    static final String NONEXISTENT_PATH = "/dev/null";
    public static final String TOKEN_DATE = "#date:";
    public static final String TOKEN_COMPONENT = "#component:";
    public static final String TOKEN_WORK_ITEM = "#work_item:";
    public static final String TOKEN_MOVE = "#move:";
    public static final String TOKEN_COMMENT = "#comment:";
    public static final String TOKEN_ITEM_ID = "#itemid:";
    public static final String TOKEN_CHANGESET = "#changeset:";
    public static final String TOKEN_EMPTYFILE = "#emptyfile:";
    public static final String TOKEN_DELETE_FOLDER = "#delete_folder:";
    public static final String TOKEN_CREATE_FOLDER = "#create_folder:";
    public static final String TOKEN_BEFORE_STATE_ID = "#before_state:";
    public static final String TOKEN_AFTER_STATE_ID = "#after_state:";
    public static final String TOKEN_DELETE_LINK = "#delete_link:";
    public static final String TOKEN_CREATE_LINK = "#create_link:";
    public static final String TOKEN_CHANGE_LINK = "#change_link:";

    static {
        try {
            NO_TRAILING_NL = NO_TRAILING_NL_STRING.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createPatch(CreatePatchDilemmaHandler handler, OutputStream out, ConfigurationChange delta, ChangeDescription description, IPathResolver pathResolver, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResolvedConfigurationChangePaths paths = ResolvedConfigurationChangePaths.resolve(pathResolver, delta, true, true, (IProgressMonitor)progress.newChild(50));
        try {
            List<FileChange> changes = FileChange.filterNops(delta.getChanges());
            ChangeClassifier classifier = new ChangeClassifier(delta.getChanges());
            ArrayList textChanges = NewCollection.arrayList();
            textChanges.addAll(classifier.getTextChanges());
            if (!classifier.getNonText().isEmpty()) {
                Collection<FileChange> userResponse = handler.nonTextChangesDetected(classifier.getNonText());
                textChanges.addAll(userResponse);
            }
            SubMonitor writeProgress = progress.newChild(50);
            writeProgress.setWorkRemaining(textChanges.size() + changes.size());
            out.write(PATCH_HEADER.getBytes(UTF8));
            CreatePatchUtil.writeChangeDescription(out, description);
            HashSet<SiloedItemId<IVersionable>> itemIdsToWrite = new HashSet<SiloedItemId<IVersionable>>();
            HashMap changesById = NewCollection.hashMap();
            for (FileChange nextChange : changes) {
                ItemId<IFolder> parentId;
                itemIdsToWrite.add(nextChange.getSiloedItemId());
                ItemId parentComponent = nextChange.getSiloedItemId().getComponent();
                if (!nextChange.getInitial().isDeleted()) {
                    parentId = nextChange.getInitial().getPath().getParent();
                    itemIdsToWrite.add((SiloedItemId<IVersionable>)SiloedItemId.create(parentId, (ItemId)parentComponent));
                }
                if (!nextChange.getFinal().isDeleted()) {
                    parentId = nextChange.getFinal().getPath().getParent();
                    itemIdsToWrite.add((SiloedItemId<IVersionable>)SiloedItemId.create(parentId, (ItemId)parentComponent));
                }
                CollectionUtil.addToMapOfLists((Map)changesById, nextChange.getSiloedItemId(), (Object)nextChange);
            }
            ArrayList uniqueChanges = NewCollection.arrayList();
            for (Map.Entry next : changesById.entrySet()) {
                if (((List)next.getValue()).size() != 1) continue;
                uniqueChanges.add((FileChange)((List)next.getValue()).iterator().next());
            }
            CreatePatchUtil.writeItemIds(out, paths, itemIdsToWrite);
            CreatePatchUtil.writeStateChanges(out, paths, uniqueChanges);
            HashSet emptyAfterStates = NewCollection.hashSet();
            for (FileChange change : classifier.getFolderChanges()) {
                if (change.getFinal().isDeleted()) {
                    CreatePatchUtil.writeFolderDelete(out, paths.computePath(change.getSiloedItemId(), true, null).toPath());
                    continue;
                }
                if (change.getInitial().isDeleted()) {
                    CreatePatchUtil.writeFolderCreate(out, paths.computePath(change.getSiloedItemId(), false, null).toPath());
                    continue;
                }
                if (change.getInitial().getPath().equals(change.getFinal().getPath())) continue;
                CreatePatchUtil.writeMove(out, paths.computePath(change.getSiloedItemId(), true, null).toPath(), paths.computePath(change.getSiloedItemId(), false, null).toPath());
            }
            for (FileChange change : classifier.getLinkChanges()) {
                if (change.getFinal().isDeleted()) {
                    CreatePatchUtil.writeLinkDelete(out, paths.computePath(change.getSiloedItemId(), true, null).toPath());
                    continue;
                }
                if (change.getInitial().isDeleted()) {
                    CreatePatchUtil.writeLinkCreate(out, paths.computePath(change.getSiloedItemId(), false, null).toPath(), change.getFinal().getTarget());
                    continue;
                }
                if (!change.getInitial().getPath().equals(change.getFinal().getPath())) {
                    CreatePatchUtil.writeMove(out, paths.computePath(change.getSiloedItemId(), true, null).toPath(), paths.computePath(change.getSiloedItemId(), false, null).toPath());
                }
                if (!change.isModify()) continue;
                CreatePatchUtil.writeLinkChange(out, paths.computePath(change.getSiloedItemId(), false, null).toPath(), change.getFinal().getTarget());
            }
            for (FileChange change : textChanges) {
                if (!(change.getInitial().getPath().equals(change.getFinal().getPath()) || change.getInitial().isDeleted() || change.getFinal().isDeleted())) {
                    CreatePatchUtil.writeMove(out, paths.computePath(change.getSiloedItemId(), true, null).toPath(), paths.computePath(change.getSiloedItemId(), false, null).toPath());
                }
                IInputStreamProvider afterContents = change.getFinal().getContents();
                boolean emptyAfterState = false;
                if (InputStreamUtil.isEmpty((IInputStreamProvider)afterContents, (IProgressMonitor)writeProgress.newChild(1))) {
                    emptyAfterState = true;
                    emptyAfterStates.add(change);
                }
                if (change.getFinal().isDeleted() || !emptyAfterState) continue;
                CreatePatchUtil.writeEmptyFile(out, paths.computePath(change.getSiloedItemId(), false, null).toPath());
            }
            out.write("#\n".getBytes(UTF8));
            for (FileChange next : textChanges) {
                if (next.getInitial().isDeleted() && emptyAfterStates.contains(next)) continue;
                CreatePatchUtil.writeDiff(out, next, paths, null, (IProgressMonitor)writeProgress.newChild(1));
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static void writeStateChanges(OutputStream out, ResolvedConfigurationChangePaths paths, Collection<FileChange> changes) throws IOException, TeamRepositoryException {
        for (FileChange next : changes) {
            SiloedItemId<IVersionable> versionable = next.getSiloedItemId();
            String pathString = paths.computePath(versionable, true, null).toPath().toString();
            if (next.getInitial().isValidStateId()) {
                CreatePatchUtil.writeStateId(out, TOKEN_BEFORE_STATE_ID, pathString, next.getInitial().getStateId());
            }
            if (!next.getFinal().isValidStateId()) continue;
            CreatePatchUtil.writeStateId(out, TOKEN_AFTER_STATE_ID, pathString, next.getFinal().getStateId());
        }
    }

    private static void writeStateId(OutputStream out, String token, String pathString, StateId stateId) throws IOException {
        CreatePatchUtil.writeMetadata(out, token, new String[]{pathString, stateId.getItemUUID().getUuidValue(), stateId.getStateUUID().getUuidValue()});
    }

    private static void writeFolderCreate(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_CREATE_FOLDER, path.toString());
    }

    private static void writeFolderDelete(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_DELETE_FOLDER, path.toString());
    }

    private static void writeLinkCreate(OutputStream out, IPath path, String linkTarget) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_CREATE_LINK, new String[]{path.toString(), linkTarget});
    }

    private static void writeLinkChange(OutputStream out, IPath path, String linkTarget) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_CHANGE_LINK, new String[]{path.toString(), linkTarget});
    }

    private static void writeLinkDelete(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_DELETE_LINK, path.toString());
    }

    private static void writeEmptyFile(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_EMPTYFILE, path.toString());
    }

    private static void writeItemIds(OutputStream out, ResolvedConfigurationChangePaths paths, Collection<SiloedItemId<IVersionable>> itemIds) throws IOException, TeamRepositoryException {
        for (SiloedItemId<IVersionable> versionable : itemIds) {
            CreatePatchUtil.writeMetadata(out, TOKEN_ITEM_ID, new String[]{paths.computePath(versionable, true, null).toPath().toString(), versionable.getItemUUID().getUuidValue(), versionable.getComponentUUID().getUuidValue()});
        }
    }

    private static void writeChangeDescription(OutputStream out, ChangeDescription delta) throws IOException {
        if (!delta.getComment().equals("")) {
            CreatePatchUtil.writeMetadata(out, TOKEN_COMMENT, delta.getComment());
        }
        for (ItemId<IChangeSet> itemId : delta.getChangeSets()) {
            CreatePatchUtil.writeMetadata(out, TOKEN_CHANGESET, itemId.getItemUUID().getUuidValue());
        }
        CreatePatchUtil.writeMetadata(out, TOKEN_DATE, DIFF_DATE_FORMAT.format(delta.getDate()));
        if (!delta.getComponent().isNull()) {
            CreatePatchUtil.writeMetadata(out, TOKEN_COMPONENT, delta.getComponent().getItemUUID().getUuidValue());
        }
        for (ItemId<IChangeSet> itemId : delta.getWorkItems()) {
            CreatePatchUtil.writeMetadata(out, TOKEN_WORK_ITEM, new String[]{itemId.getItemUUID().getUuidValue(), itemId.getItemType().getName(), itemId.getItemType().getNamespaceURI()});
        }
    }

    public static String javaEncodeString(String unencoded) {
        boolean changed = false;
        CharBuffer buffer = CharBuffer.allocate(unencoded.length() * 2);
        char[] chars = new char[unencoded.length()];
        unencoded.getChars(0, unencoded.length(), chars, 0);
        int idx = 0;
        while (idx < chars.length) {
            char ch = chars[idx];
            boolean specialChar = true;
            switch (ch) {
                case '\n': {
                    buffer.put("\\n");
                    break;
                }
                case '\t': {
                    buffer.put("\\t");
                    break;
                }
                case '\b': {
                    buffer.put("\\b");
                    break;
                }
                case '\r': {
                    buffer.put("\\r");
                    break;
                }
                case '\"': {
                    buffer.put("\\\"");
                    break;
                }
                case '\'': {
                    buffer.put("\\'");
                    break;
                }
                case '\\': {
                    buffer.put("\\\\");
                    break;
                }
                default: {
                    specialChar = false;
                    buffer.put(ch);
                }
            }
            if (specialChar) {
                changed = true;
            }
            ++idx;
        }
        if (changed) {
            String result = new String(buffer.array(), 0, buffer.position());
            return result;
        }
        return unencoded;
    }

    public static int[] writeHunk(RangeDifference[] diff, int startIndex, List beforeLines, boolean beforeHasTrailingNL, List afterLines, boolean afterHasTrailingNL, OutputStream out, boolean doWrite) throws IOException {
        boolean goAgain;
        int i = startIndex;
        int beforeBegin = diff[i].leftStart();
        int commonBeforeBegin = Math.max(beforeBegin - 3, 0);
        int commonAfterBegin = diff[i].rightStart() - beforeBegin + commonBeforeBegin;
        int numBeforeLines = 0;
        int numAfterLines = 0;
        int j = commonBeforeBegin;
        while (j < beforeBegin) {
            if (doWrite) {
                out.write(32);
                out.write(((ByteArrayLine)beforeLines.get((int)j)).bytes);
            }
            ++numBeforeLines;
            ++numAfterLines;
            ++j;
        }
        do {
            int commonLinesEnd;
            int beforeEnd = diff[i].leftEnd();
            int j2 = beforeBegin;
            while (j2 < beforeEnd) {
                if (doWrite) {
                    out.write(45);
                    out.write(((ByteArrayLine)beforeLines.get((int)j2)).bytes);
                    if (!beforeHasTrailingNL && j2 == beforeLines.size() - 1) {
                        out.write(NO_TRAILING_NL);
                    }
                }
                ++numBeforeLines;
                ++j2;
            }
            int afterEnd = diff[i].rightEnd();
            int j3 = diff[i].rightStart();
            while (j3 < afterEnd) {
                if (doWrite) {
                    out.write(43);
                    out.write(((ByteArrayLine)afterLines.get((int)j3)).bytes);
                    if (!afterHasTrailingNL && j3 == afterLines.size() - 1) {
                        out.write(NO_TRAILING_NL);
                    }
                }
                ++numAfterLines;
                ++j3;
            }
            if (i < diff.length - 1) {
                int nextStart = diff[i + 1].leftStart();
                if (nextStart <= beforeEnd + 6) {
                    goAgain = true;
                    commonLinesEnd = nextStart;
                    beforeBegin = nextStart;
                    ++i;
                } else {
                    goAgain = false;
                    commonLinesEnd = beforeEnd + 3;
                }
            } else {
                goAgain = false;
                commonLinesEnd = Math.min(beforeEnd + 3, beforeLines.size());
            }
            int j4 = beforeEnd;
            while (j4 < commonLinesEnd) {
                if (doWrite) {
                    out.write(32);
                    out.write(((ByteArrayLine)beforeLines.get((int)j4)).bytes);
                    if (!beforeHasTrailingNL && j4 == beforeLines.size() - 1) {
                        out.write(NO_TRAILING_NL);
                    }
                }
                ++numBeforeLines;
                ++numAfterLines;
                ++j4;
            }
        } while (goAgain);
        return new int[]{commonBeforeBegin, numBeforeLines, commonAfterBegin, numAfterLines, i + 1};
    }

    public static String getFilePatchHeader(IPath beforePath, IPath afterPath, Date beforeDate, Date afterDate) {
        StringBuffer result = new StringBuffer();
        boolean isCreation = false;
        boolean isDeletion = true;
        if (beforePath == null || beforePath.isEmpty() || beforeDate == null) {
            isCreation = true;
            beforePath = new Path(NONEXISTENT_PATH);
            beforeDate = new Date(0L);
        }
        if (afterPath == null || afterPath.isEmpty() || afterDate == null) {
            isDeletion = true;
            afterPath = new Path(NONEXISTENT_PATH);
            afterDate = new Date(0L);
        }
        if (isCreation || isDeletion) {
            result.append("diff -u -N ");
        } else {
            result.append("diff -u ");
        }
        result.append(beforePath.toString());
        result.append(" ");
        result.append(afterPath.toString());
        result.append("\n--- ");
        result.append(beforePath.toString());
        result.append('\t');
        result.append(DIFF_DATE_FORMAT.format(beforeDate));
        result.append("\n+++ ");
        result.append(afterPath.toString());
        result.append('\t');
        result.append(DIFF_DATE_FORMAT.format(afterDate));
        result.append('\n');
        return result.toString();
    }

    public static void writeDiff(OutputStream out, FileChange change, ResolvedConfigurationChangePaths paths, Charset targetCharset, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        ByteArrayLines afterContents;
        ByteArrayLines beforeContents;
        if (targetCharset != null && !targetCharset.canEncode()) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        InputStream beforeStream = change.getInitial().getContents().getInputStream((IProgressMonitor)progress.newChild(25));
        InputStream afterStream = null;
        try {
            afterStream = change.getFinal().getContents().getInputStream((IProgressMonitor)progress.newChild(25));
            if (targetCharset != null) {
                String srcCharsetAfterName;
                String srcCharsetBeforeName = change.getInitial().getCharacterEncoding();
                Charset srcCharsetBefore = null;
                Charset srcCharsetAfter = null;
                if (srcCharsetBeforeName != "" && (srcCharsetAfterName = change.getFinal().getCharacterEncoding()) != "") {
                    try {
                        srcCharsetBefore = Charset.forName(srcCharsetBeforeName);
                        srcCharsetAfter = Charset.forName(srcCharsetAfterName);
                    }
                    catch (IllegalCharsetNameException illegalCharsetNameException) {
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {}
                }
                if (srcCharsetAfter != null) {
                    InputStreamReader r;
                    if (!srcCharsetBefore.equals(targetCharset)) {
                        r = new InputStreamReader(beforeStream, srcCharsetBefore.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
                        beforeStream = new ReaderToInputStream((Reader)r, targetCharset.name());
                    }
                    if (!srcCharsetAfter.equals(targetCharset)) {
                        r = new InputStreamReader(afterStream, srcCharsetAfter.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
                        afterStream = new ReaderToInputStream((Reader)r, targetCharset.name());
                    }
                }
            }
            beforeContents = new ByteArrayLines(beforeStream);
            afterContents = new ByteArrayLines(afterStream);
        }
        finally {
            try {
                beforeStream.close();
            }
            finally {
                if (afterStream != null) {
                    afterStream.close();
                }
            }
        }
        beforeStream = null;
        afterStream = null;
        progress.setWorkRemaining(50);
        RangeDifference[] diff = beforeContents.lcs(afterContents).getDifferences();
        progress.worked(50);
        if (diff.length != 0) {
            int[] counts;
            IPath beforePath = null;
            IPath afterPath = null;
            if (paths != null) {
                beforePath = change.getInitial().isDeleted() ? null : paths.computePath(change.getSiloedItemId(), true, null).toPath();
                afterPath = change.getFinal().isDeleted() ? null : paths.computePath(change.getSiloedItemId(), false, null).toPath();
            }
            out.write(CreatePatchUtil.getFilePatchHeader(beforePath, afterPath, change.getInitial().getTimestamp(), change.getFinal().getTimestamp()).getBytes(UTF8));
            List<ByteArrayLine> beforeLines = beforeContents.lines;
            boolean beforeHasTrailingNL = beforeContents.hasTrailingNL;
            List<ByteArrayLine> afterLines = afterContents.lines;
            boolean afterHasTrailingNL = afterContents.hasTrailingNL;
            int lastHunk = 0;
            do {
                counts = CreatePatchUtil.writeHunk(diff, lastHunk, beforeLines, beforeHasTrailingNL, afterLines, afterHasTrailingNL, null, false);
                HunkRange range = new HunkRange(counts[0], counts[1], counts[2], counts[3]);
                out.write((String.valueOf(range.toString()) + "\n").getBytes(UTF8));
                CreatePatchUtil.writeHunk(diff, lastHunk, beforeLines, beforeHasTrailingNL, afterLines, afterHasTrailingNL, out, true);
            } while ((lastHunk = counts[4]) < diff.length);
        }
    }

    public static void writeMove(OutputStream out, IPath beforePath, IPath afterPath) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_MOVE, new String[]{beforePath.toString(), afterPath.toString()});
    }

    private static void writeMetadata(OutputStream out, String token, String comment) throws IOException {
        CreatePatchUtil.writeMetadata(out, token, new String[]{comment});
    }

    public static void writeMetadata(OutputStream out, String token, String[] strings) throws IOException {
        out.write(token.getBytes(UTF8));
        int idx = 0;
        while (idx < strings.length) {
            out.write(" \"".getBytes(UTF8));
            out.write(CreatePatchUtil.javaEncodeString(strings[idx]).getBytes(UTF8));
            out.write("\"".getBytes(UTF8));
            ++idx;
        }
        out.write("\n".getBytes(UTF8));
    }
}

