/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.patch;

import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeClassifier {
    private Collection<FileChange> nonText = NewCollection.arrayList();
    private Collection<FileChange> textChanges = NewCollection.arrayList();
    private Collection<FileChange> folderChanges = NewCollection.arrayList();
    private Collection<FileChange> linkChanges = NewCollection.arrayList();

    public ChangeClassifier(Collection<FileChange> changes) {
        for (FileChange change : changes) {
            if (change.getItemId().getItemType() == IFolder.ITEM_TYPE) {
                this.folderChanges.add(change);
                continue;
            }
            if (change.getItemId().getItemType() == ISymbolicLink.ITEM_TYPE) {
                this.linkChanges.add(change);
                continue;
            }
            if (change.getInitial().isTextType() || change.getFinal().isTextType()) {
                this.textChanges.add(change);
                continue;
            }
            this.nonText.add(change);
        }
    }

    public Collection<FileChange> getNonText() {
        return this.nonText;
    }

    public Collection<FileChange> getTextChanges() {
        return this.textChanges;
    }

    public Collection<FileChange> getFolderChanges() {
        return this.folderChanges;
    }

    public Collection<FileChange> getLinkChanges() {
        return this.linkChanges;
    }
}

