/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.internal.repository.rcp.streams.ByteArrayInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Date;

public final class FileState {
    public static final String CHARACTER_ENCODING_UNKNOWN = "";
    public static final String FOLDER_TYPE = "inode/directory";
    public static final String SYMBOLICLINK_TYPE = "inode/symboliclink";
    private Date timestamp;
    private IInputStreamProvider contents;
    private VersionablePathSegment path;
    private String characterEncoding;
    private boolean isExecutable;
    private String mimeType;
    private boolean isTextType;
    private FileLineDelimiter lineDelimiter;
    private boolean isDeleted;
    private StateId theState;
    private final String target;

    public static FileState getDeletedState(IItemType type, VersionablePathSegment path) {
        if (path == null) {
            path = VersionablePathSegment.emptyPath();
        }
        String contentType = FileState.getContentType(type);
        return new FileState(path, new Date(0L), (IInputStreamProvider)EmptyInputStreamProvider.getDefault(), false, contentType, FileLineDelimiter.LINE_DELIMITER_NONE, false, CHARACTER_ENCODING_UNKNOWN, true, StateId.getDeletedState((ItemId)ItemId.getNullItem((IItemType)type)), null);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, IInputStreamProvider contents, boolean isExecutable, String mimeType, FileLineDelimiter delimiter, boolean isTextType, String characterEncoding, boolean isDeleted, StateId stateId) {
        return new FileState(path, timestamp, contents, isExecutable, mimeType, delimiter, isTextType, characterEncoding, isDeleted, stateId, null);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, boolean isDeleted, StateId stateId, String target) {
        ByteArrayInputStreamProvider streamProvider = new ByteArrayInputStreamProvider(target.getBytes());
        return FileState.create(path, timestamp, (IInputStreamProvider)streamProvider, isDeleted, stateId, target);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, IInputStreamProvider streamProvider, boolean isDeleted, StateId stateId, String target) {
        String contentType = FileState.getContentType(stateId.getItemType());
        String encoding = System.getProperty("file.encoding");
        if (encoding == null) {
            encoding = CHARACTER_ENCODING_UNKNOWN;
        }
        return new FileState(path, timestamp, streamProvider, false, contentType, FileLineDelimiter.LINE_DELIMITER_NONE, false, encoding, isDeleted, stateId, target);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, boolean isDeleted, StateId stateId) {
        String contentType = FileState.getContentType(stateId.getItemType());
        return new FileState(path, timestamp, (IInputStreamProvider)EmptyInputStreamProvider.getDefault(), false, contentType, FileLineDelimiter.LINE_DELIMITER_NONE, false, CHARACTER_ENCODING_UNKNOWN, isDeleted, stateId, null);
    }

    private FileState(VersionablePathSegment path, Date timestamp, IInputStreamProvider contents, boolean isExecutable, String mimeType, FileLineDelimiter delimiter, boolean isTextType, String characterEncoding, boolean isDeleted, StateId stateId, String target) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        this.theState = stateId;
        this.timestamp = timestamp;
        this.contents = contents;
        this.path = path;
        this.isExecutable = isExecutable;
        this.mimeType = mimeType;
        this.lineDelimiter = delimiter;
        this.isTextType = isTextType || FileState.isTextType(mimeType);
        this.characterEncoding = characterEncoding == null ? CHARACTER_ENCODING_UNKNOWN : characterEncoding;
        this.isDeleted = isDeleted;
        this.target = target;
    }

    public static boolean isTextType(String mimeType) {
        return mimeType != null && mimeType.toLowerCase().startsWith("text");
    }

    private static String getContentType(IItemType type) {
        String contentType = null;
        contentType = type == IFolder.ITEM_TYPE ? FOLDER_TYPE : (type == ISymbolicLink.ITEM_TYPE ? SYMBOLICLINK_TYPE : "application/unknown");
        return contentType;
    }

    public boolean isFolder() {
        return this.theState.getItemType() == IFolder.ITEM_TYPE;
    }

    public boolean isExectuable() {
        return this.isExecutable;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public FileLineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public boolean isTextType() {
        return this.isTextType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public VersionablePathSegment getPath() {
        return this.path;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public IInputStreamProvider getContents() {
        return this.contents;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public String toString() {
        String result = "FileState(";
        if (this.isDeleted) {
            return String.valueOf(result) + "deleted)";
        }
        return String.valueOf(result) + "FileState(contents " + this.contents.toString() + ", path= " + this.path + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.characterEncoding == null ? 0 : this.characterEncoding.hashCode());
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        result = 31 * result + (this.isDeleted ? 1231 : 1237);
        result = 31 * result + (this.isExecutable ? 1231 : 1237);
        result = 31 * result + (this.isTextType ? 1231 : 1237);
        result = 31 * result + (this.lineDelimiter == null ? 0 : this.lineDelimiter.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.theState == null ? 0 : this.theState.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileState other = (FileState)obj;
        if (this.characterEncoding == null ? other.characterEncoding != null : !this.characterEncoding.equals(other.characterEncoding)) {
            return false;
        }
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        if (this.isDeleted != other.isDeleted) {
            return false;
        }
        if (this.isExecutable != other.isExecutable) {
            return false;
        }
        if (this.isTextType != other.isTextType) {
            return false;
        }
        if (this.lineDelimiter == null ? other.lineDelimiter != null : !this.lineDelimiter.equals((Object)other.lineDelimiter)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.theState == null ? other.theState != null : !this.theState.equals((Object)other.theState)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public StateId getStateId() {
        return this.theState;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isValidStateId() {
        if (this.getStateId().getItemId().isNull()) {
            return false;
        }
        return this.isDeleted || !this.getStateId().isDeleted();
    }
}

