/*
 * Decompiled with CFR 0.152.
 */
package javax.wvcm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.wvcm.PropertyRequestItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyNameList
implements PropertyRequestItem {
    private static final PropertyName<?>[] EMPTY_PNA = new PropertyName[0];
    private final PropertyName<?>[] _propertyNames;
    private volatile Set<PropertyName<?>> _asSet = null;

    public PropertyNameList(PropertyName<?> ... propertyNames) {
        this._propertyNames = propertyNames == null || propertyNames.length == 0 ? EMPTY_PNA : propertyNames;
    }

    public PropertyName<?>[] getPropertyNames() {
        return this._propertyNames;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyNameList pnl = (PropertyNameList)o;
        return this.getPropertyNamesAsSet().equals(pnl.getPropertyNamesAsSet());
    }

    public int hashCode() {
        return this.getPropertyNamesAsSet().hashCode();
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append('[');
        PropertyName<?>[] propertyNameArray = this.getPropertyNames();
        int n = propertyNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyName<?> name = propertyNameArray[n2];
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(name.toString());
            ++n2;
        }
        builder.append(']');
        return builder.toString();
    }

    private Set<PropertyName<?>> getPropertyNamesAsSet() {
        if (this._asSet == null) {
            this._asSet = this._propertyNames == EMPTY_PNA ? Collections.emptySet() : new HashSet(Arrays.asList(this._propertyNames));
        }
        return this._asSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyName<T>
    implements PropertyRequestItem {
        private final String _namespace;
        private final String _name;

        PropertyName(String name) {
            this(null, name);
        }

        public PropertyName(String namespace, String name) {
            this._namespace = namespace;
            this._name = name;
        }

        public String getNamespace() {
            return this._namespace;
        }

        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this._namespace == null ? 0 : this._namespace.hashCode());
            result = 37 * result + this._name.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyName pn = (PropertyName)o;
            if (this._namespace == null) {
                return pn._namespace == null && this._name.equals(pn._name);
            }
            return this._namespace.equals(pn._namespace) && this._name.equals(pn._name);
        }

        public String toString() {
            if (this._namespace != null) {
                return String.valueOf(this._namespace) + ":" + this._name;
            }
            return this._name;
        }

        public PropertyRequestItem.NestedPropertyName<T> nest(PropertyRequestItem ... pnl) {
            return new PropertyRequestItem.NestedPropertyName(this, pnl);
        }

        public PropertyRequestItem.NestedPropertyName<T> nest(PropertyRequestItem.NestedPropertyName<?>[] pnl) {
            return new PropertyRequestItem.NestedPropertyName(this, (PropertyRequestItem[])pnl);
        }

        public PropertyRequestItem.NestedPropertyName<T> nest(PropertyName<?>[] pnl) {
            return new PropertyRequestItem.NestedPropertyName(this, (PropertyRequestItem[])pnl);
        }
    }
}

