/*
 * Decompiled with CFR 0.152.
 */
package javax.wvcm;

import java.text.MessageFormat;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

public class DetailedFeedback
implements Feedback {
    private static DetailedFeedback nullDetailedFeedback = new DetailedFeedback();
    private PropertyRequestItem.PropertyRequest _forResult = null;
    private PropertyRequestItem.PropertyRequest _forModified = null;
    private boolean _isAbortRequested = false;
    protected int _last = 0;

    static {
        DetailedFeedback.nullDetailedFeedback._last = 100;
    }

    private static boolean equalPropertyRequest(PropertyRequestItem.PropertyRequest pr1, PropertyRequestItem.PropertyRequest pr2) {
        if (pr1 == pr2) {
            return true;
        }
        if (pr1 != null) {
            return pr1.equals(pr2);
        }
        return false;
    }

    private static int normalize(int percent) {
        if (percent > 100) {
            return 100;
        }
        if (percent < 0) {
            return 0;
        }
        return percent;
    }

    public static Feedback fb(Feedback feedback) {
        if (feedback == null) {
            return nullDetailedFeedback;
        }
        return feedback;
    }

    public PropertyRequestItem.PropertyRequest getPropertyRequestForResult() {
        return this._forResult;
    }

    public PropertyRequestItem.PropertyRequest getPropertyRequestForModified() {
        return this._forModified;
    }

    public boolean isAbortRequested() {
        return this._isAbortRequested;
    }

    public Feedback nest() {
        return this.nest(null, 0);
    }

    public Feedback nest(PropertyRequestItem.PropertyRequest forResult) {
        return this.nest(forResult, 0);
    }

    public Feedback nest(int percentCompleted) {
        return this.nest(null, percentCompleted);
    }

    public Feedback nest(PropertyRequestItem.PropertyRequest forResult, int percentToBeCompleted) {
        percentToBeCompleted = DetailedFeedback.normalize(percentToBeCompleted);
        if (DetailedFeedback.equalPropertyRequest(forResult, this._forResult) && (this._last == 100 || this._last == 0 && percentToBeCompleted == 100)) {
            return this;
        }
        int end = this._last;
        if (end < percentToBeCompleted) {
            end = percentToBeCompleted;
        }
        return new NestedDetailedFeedback(this, forResult, end);
    }

    public String format(String fmt, Object ... arguments) {
        return MessageFormat.format(fmt, arguments);
    }

    public void notifyActive(String message) throws WvcmException {
    }

    public void notifyWarning(String message) throws WvcmException {
    }

    public void notifyIsModified(Resource resource) throws WvcmException {
    }

    public void notifyPercentComplete(int percentComplete) throws WvcmException {
        this._last = percentComplete = DetailedFeedback.normalize(percentComplete);
    }

    public void abortRequested(boolean isAbortRequested) {
        this._isAbortRequested = isAbortRequested;
    }

    public void setPropertyRequestForResult(PropertyRequestItem.PropertyRequest propertyRequestForResult) {
        this._forResult = propertyRequestForResult;
    }

    public void setPropertyRequestForModified(PropertyRequestItem.PropertyRequest propertyRequestForModified) {
        this._forModified = propertyRequestForModified;
    }

    public static class NestedDetailedFeedback
    implements Feedback {
        private DetailedFeedback _detailedFeedback = null;
        private PropertyRequestItem.PropertyRequest _forResult = null;
        private int _begin = 0;
        private int _end = 0;

        private NestedDetailedFeedback(DetailedFeedback detailedFeedback, PropertyRequestItem.PropertyRequest forResult, int end) {
            this._detailedFeedback = detailedFeedback;
            this._forResult = forResult;
            this._begin = detailedFeedback._last;
            this._end = end;
        }

        public PropertyRequestItem.PropertyRequest getPropertyRequestForResult() {
            return this._forResult;
        }

        public PropertyRequestItem.PropertyRequest getPropertyRequestForModified() {
            return this._detailedFeedback._forModified;
        }

        public boolean isAbortRequested() {
            return this._detailedFeedback.isAbortRequested();
        }

        public Feedback nest() {
            return this.nest(null, 0);
        }

        public Feedback nest(PropertyRequestItem.PropertyRequest forResult) {
            return this.nest(forResult, 0);
        }

        public Feedback nest(int percentCompleted) {
            return this.nest(null, percentCompleted);
        }

        public Feedback nest(PropertyRequestItem.PropertyRequest forResult, int percentToBeCompleted) {
            if (DetailedFeedback.equalPropertyRequest(forResult, this._forResult) && this._end - this._begin == 0) {
                return this;
            }
            percentToBeCompleted = DetailedFeedback.normalize(percentToBeCompleted);
            int end = this._begin + percentToBeCompleted * (this._end - this._begin) / 100;
            return new NestedDetailedFeedback(this._detailedFeedback, forResult, end);
        }

        public String format(String fmt, Object ... arguments) {
            return MessageFormat.format(fmt, arguments);
        }

        public void notifyActive(String message) throws WvcmException {
            this._detailedFeedback.notifyActive(message);
        }

        public void notifyWarning(String message) throws WvcmException {
            this._detailedFeedback.notifyWarning(message);
        }

        public void notifyIsModified(Resource resource) throws WvcmException {
            this._detailedFeedback.notifyIsModified(resource);
        }

        public void notifyPercentComplete(int percentComplete) throws WvcmException {
            int done = this._begin + (percentComplete = DetailedFeedback.normalize(percentComplete)) * (this._end - this._begin) / 100;
            if (done > this._detailedFeedback._last) {
                this._detailedFeedback.notifyPercentComplete(done);
            }
        }

        public void abortRequested(boolean isAbortRequested) {
            this._detailedFeedback._isAbortRequested = isAbortRequested;
        }

        public void setPropertyRequestForResult(PropertyRequestItem.PropertyRequest propertyRequestForResult) {
            this._forResult = propertyRequestForResult;
        }

        public void setPropertyRequestForModified(PropertyRequestItem.PropertyRequest propertyRequestForModified) {
            this._detailedFeedback._forModified = propertyRequestForModified;
        }
    }
}

