/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.process.common.IBehaviorConfiguration;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.process.DelegatedProcessOverride;
import com.ibm.team.scm.common.process.ProcessOverride;
import com.ibm.team.scm.common.process.ProcessProxy;
import com.ibm.team.scm.common.process.RepositoryRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class RunnableAdvisableOperation
extends AdvisableOperation {
    private RepositoryRunnable block;
    private ProcessProxy proxy;
    private String[] actionPaths = new String[0];
    private String[] secondaryActionPaths = new String[0];
    private IProcessArea[] secondaryProcessAreas = new IProcessArea[0];
    private Object returnValue;
    private ProcessOverride processOverride;
    private boolean ignoreException = false;
    private boolean shouldThrowPermissionDenied = false;
    private boolean isBeingRerun = false;

    protected RunnableAdvisableOperation(String operationId, Object operationData, IItem item, ProcessProxy proxy, String[] actionPaths, RepositoryRunnable block, IProgressMonitor monitor) {
        this(operationId, RunnableAdvisableOperation.init(item, operationData, proxy, monitor));
        this.block = block;
        this.proxy = proxy;
        if (actionPaths != null) {
            this.actionPaths = actionPaths;
        }
    }

    protected RunnableAdvisableOperation(String operationId, IItem item, ProcessProxy proxy, IProgressMonitor monitor) {
        this(operationId, RunnableAdvisableOperation.init(item, null, proxy, monitor));
        this.proxy = proxy;
    }

    private RunnableAdvisableOperation(String operationId, ProcessData data) {
        super(operationId, data.data, data.area, data.line);
    }

    public IOperationReport reRun(IBehaviorConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        this.isBeingRerun = true;
        return this.run(configuration, monitor);
    }

    public IOperationReport run(IBehaviorConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        this.returnValue = this.block.run(monitor);
        if (this.returnValue instanceof IOperationReport) {
            return (IOperationReport)this.returnValue;
        }
        if (this.returnValue instanceof IItemsResponse) {
            return ((IItemsResponse)this.returnValue).getOperationReport();
        }
        if (this.returnValue instanceof IObjectsResponse) {
            return ((IObjectsResponse)this.returnValue).getOperationReport();
        }
        return null;
    }

    public void setAction(String[] actionPaths) {
        this.actionPaths = actionPaths;
    }

    public void setProcessOverride(ProcessOverride processOverride) {
        this.processOverride = processOverride;
    }

    public void setBlock(RepositoryRunnable block) {
        this.block = block;
    }

    public String[] getActions() {
        return this.actionPaths;
    }

    public String[] getSecondaryActions(IProcessArea secondaryArea) {
        return this.secondaryActionPaths;
    }

    public boolean shouldThrowPermissionDeniedException() {
        return this.shouldThrowPermissionDenied;
    }

    public void setThrowPermissionDenied(boolean throwPDE) {
        this.shouldThrowPermissionDenied = throwPDE;
    }

    public boolean isBeingRerun() {
        return this.isBeingRerun;
    }

    public IProcessArea[] getSecondaryProcessAreas() {
        return this.secondaryProcessAreas;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public IItem getItemReturnValue() {
        if (this.returnValue instanceof IItemsResponse) {
            return ((IItemsResponse)this.returnValue).getClientItems()[0];
        }
        return null;
    }

    public Object getObjectReturnValue() {
        if (this.returnValue instanceof IObjectsResponse) {
            return ((IObjectsResponse)this.returnValue).getClientObjects()[0];
        }
        return null;
    }

    public IOperationReport processExec(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.processExec(false, monitor);
    }

    public IOperationReport processExec() throws TeamRepositoryException {
        return this.processExec(false, null);
    }

    public IOperationReport processExec(boolean preview, IProgressMonitor monitor) throws TeamRepositoryException {
        block6: {
            if (this.processOverride == null) {
                this.processOverride = new DelegatedProcessOverride(this.getProcessArea() == null);
            }
            try {
                if (this.getProcessArea() != null && !this.processOverride.shouldRun()) break block6;
                this.returnValue = this.processOverride.run(this.block);
                return null;
            }
            catch (TeamOperationCanceledException e) {
                if (this.proxy.ignoreProcessCancellationExceptions() || this.ignoreException) {
                    return e.getReport();
                }
                throw e;
            }
        }
        if (preview) {
            return this.wrap(this.proxy.advise(this, monitor));
        }
        return this.wrap(this.proxy.adviseAndExecute(this, monitor));
    }

    private static ProcessData init(IItem item, Object operationData, ProcessProxy proxy, IProgressMonitor monitor) {
        ProcessData data = new ProcessData();
        data.data = operationData;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            data.area = proxy.getProcessArea(item, (IProgressMonitor)progress.newChild(70));
            if (data.area instanceof ITeamArea) {
                data.line = proxy.getDevelopmentLine((ITeamArea)data.area, (IProgressMonitor)progress.newChild(30));
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            data.area = null;
            data.line = null;
        }
        progress.done();
        return data;
    }

    private IOperationReport wrap(IOperationReport report) {
        if (this.returnValue instanceof IItemsResponse) {
            ((IItemsResponse)this.returnValue).setOperationReport(report);
        } else if (this.returnValue instanceof IObjectsResponse) {
            ((IObjectsResponse)this.returnValue).setOperationReport(report);
        }
        return report;
    }

    public void setIgnoredExceptions(boolean ignoreException) {
        this.ignoreException = ignoreException;
    }

    public void setSecondaryProcessAreas(IProcessArea[] secondaryProcessAreas) {
        this.secondaryProcessAreas = secondaryProcessAreas;
    }

    public void setSecondaryActionPaths(String[] actionIds) {
        this.secondaryActionPaths = actionIds;
    }

    private static class ProcessData {
        public IProcessArea area;
        public IDevelopmentLine line;
        public Object data;

        private ProcessData() {
        }
    }
}

