/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.ItemProviderUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.LinkProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetLinks {
    public static final List<ILink> findLinks(ProviderFactory providerFactory, IChangeSetHandle changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ILink> links = new ArrayList<ILink>();
        LinkProvider linkProvider = providerFactory.getLinkProvider();
        IItemReference source = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)changeSetHandle, "", "");
        ILinkQueryPage results = linkProvider.findLinksBySource((IReference)source, (IProgressMonitor)progress.newChild(100));
        ILinkCollection collection = results.getAllLinksFromHereOn();
        links.addAll((Collection<ILink>)collection);
        return links;
    }

    public static Map<IChangeSet, List<IAuditable>> resolveLinks(ProviderFactory providerFactory, List<IChangeSetHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSet changeSet;
        ItemId auditable;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List changeSetIds = ItemLists.handlesToIds(handles);
        Map<ItemId<IChangeSet>, List<ItemId<IAuditable>>> unfetched = ItemProviderUtil.resolveLinks(providerFactory, changeSetIds, (IProgressMonitor)progress.newChild(60));
        HashSet toFetch = NewCollection.hashSet();
        for (ItemId<IChangeSet> nextCs : unfetched.keySet()) {
            auditable = ItemId.upcast(nextCs);
            toFetch.add(auditable);
            toFetch.addAll((Collection)unfetched.get(nextCs));
        }
        for (ItemId<IChangeSet> nextCs : changeSetIds) {
            auditable = ItemId.upcast(nextCs);
            toFetch.add(auditable);
        }
        Map fetched = ItemProviderUtil.fetchCurrents(providerFactory, toFetch, (IProgressMonitor)progress.newChild(40));
        HashMap<IChangeSet, List<IAuditable>> result = NewCollection.hashMap();
        for (Map.Entry<ItemId<IChangeSet>, List<ItemId<IAuditable>>> next : unfetched.entrySet()) {
            changeSet = (IChangeSet)fetched.get(next.getKey());
            if (changeSet == null) continue;
            ArrayList auditables = NewCollection.arrayList();
            for (ItemId<IAuditable> nextAuditable : next.getValue()) {
                IAuditable aud = (IAuditable)fetched.get(nextAuditable);
                if (aud == null) continue;
                auditables.add(aud);
            }
            result.put(changeSet, auditables);
        }
        for (ItemId nextCs : changeSetIds) {
            changeSet = (IChangeSet)fetched.get(nextCs);
            if (changeSet == null || result.containsKey(changeSet)) continue;
            result.put(changeSet, Collections.emptyList());
        }
        return result;
    }

    public static final String summarizeLinks(ProviderFactory providerFactory, List<ILink> links, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IManagedItemHandle> toFetch = new ArrayList<IManagedItemHandle>();
        for (ILink link : links) {
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference()) continue;
            IManagedItemHandle handle = (IManagedItemHandle)((IItemReference)targetRef).getReferencedItem();
            toFetch.add(handle);
        }
        List<IManagedItem> items = providerFactory.getItemProvider().fetchItems(toFetch, monitor);
        return ChangeSetLinks.summarizeItems(providerFactory, items, monitor);
    }

    public static final String summarizeItems(ProviderFactory providerFactory, List<IManagedItem> items, IProgressMonitor monitor) {
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        for (IItem iItem : items) {
            String summary = ChangeSetLinks.describe(iItem);
            if (summary == null) continue;
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(summary);
            first = false;
        }
        return buffer.toString();
    }

    public static final String describe(IItem item) {
        try {
            Method getDescriptionMethod = item.getClass().getMethod("getSummary", new Class[0]);
            Method getIdMethod = item.getClass().getMethod("getId", new Class[0]);
            String summary = (String)getDescriptionMethod.invoke((Object)item, new Object[0]);
            Integer id = (Integer)getIdMethod.invoke((Object)item, new Object[0]);
            return id + ": " + summary;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ItemProvider itemProvider, List<? extends IManagedItemHandle> items, IProgressMonitor monitor) throws TeamRepositoryException {
        if (items.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = NewCollection.hashMap();
        List<IManagedItem> fetched = itemProvider.fetchItems(items, monitor);
        for (IItem iItem : fetched) {
            if (iItem == null) continue;
            result.put(new ItemId((IItemHandle)iItem), iItem);
        }
        return result;
    }
}

