/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemLists {
    private ItemLists() {
    }

    public static <T extends IItem> List<ItemId<T>> statesToIds(Collection<StateId<T>> ids) {
        ArrayList<ItemId<T>> result = new ArrayList<ItemId<T>>();
        for (StateId<T> next : ids) {
            result.add(next.getItemId());
        }
        return result;
    }

    public static <T extends IItem> List<T> reorderByState(Collection<T> input, List<StateId<T>> order) {
        ArrayList result = new ArrayList();
        HashMap mapStatesOntoItems = new HashMap();
        for (IItem iItem : input) {
            if (iItem instanceof IVersionable) {
                mapStatesOntoItems.put(new StateId((IItemHandle)((IVersionable)iItem)), iItem);
                continue;
            }
            if (iItem instanceof IAuditable) {
                mapStatesOntoItems.put(new StateId((IItemHandle)((IAuditable)iItem)), iItem);
                continue;
            }
            throw new IllegalArgumentException("Only IAuditable & IVersionable supported");
        }
        for (StateId stateId : order) {
            result.add(mapStatesOntoItems.get(stateId));
        }
        return result;
    }

    public static <T extends IItem> List<T> reorderById(Collection<T> input, List<ItemId<T>> order) {
        ArrayList result = NewCollection.arrayList();
        HashMap mapIdsOntoItems = NewCollection.hashMap();
        for (IItem iItem : input) {
            if (iItem == null) continue;
            ItemId nextKey = new ItemId((IItemHandle)iItem);
            mapIdsOntoItems.put(nextKey, iItem);
        }
        for (ItemId itemId : order) {
            result.add((IItem)mapIdsOntoItems.get(itemId));
        }
        return result;
    }

    public static <T extends IItem> List<StateId<T>> reorderStatesById(Collection<StateId<T>> input, List<ItemId<T>> order) {
        ArrayList<StateId<T>> result = new ArrayList<StateId<T>>();
        HashMap<ItemId<T>, StateId<T>> mapStatesOntoItems = new HashMap<ItemId<T>, StateId<T>>();
        for (StateId<T> stateId : input) {
            ItemId<T> nextKey = stateId.getItemId();
            mapStatesOntoItems.put(nextKey, stateId);
        }
        for (ItemId itemId : order) {
            StateId nextState = (StateId)mapStatesOntoItems.get(itemId);
            if (nextState == null) {
                result.add(new StateId(itemId, StateId.STATE_DELETED));
                continue;
            }
            result.add(nextState);
        }
        return result;
    }

    public static <ItemType extends IItem> void updateIdMap(Map<ItemId<ItemType>, ItemType> map, Collection<ItemType> items) {
        for (IItem item : items) {
            map.put(ItemId.forItem(item), item);
        }
    }

    public static <T extends IItem> List idsToHandles(Collection<ItemId<T>> itemIds) {
        ArrayList result = new ArrayList(itemIds.size());
        for (ItemId<T> next : itemIds) {
            Object nextHandle = next.toHandle();
            if (nextHandle == null) continue;
            result.add(nextHandle);
        }
        return result;
    }

    public static <T extends IItem> List idsToHandles(Collection<ItemId<T>> itemIds, Object origin) {
        ArrayList result = new ArrayList();
        for (ItemId<T> next : itemIds) {
            Object nextHandle = next.toHandle(origin);
            if (nextHandle == null) continue;
            result.add(nextHandle);
        }
        return result;
    }

    public static <T extends IItemHandle> List handlesToIds(Collection<T> itemHandles) {
        ArrayList result = NewCollection.arrayList();
        for (IItemHandle next : itemHandles) {
            result.add(new ItemId(next));
        }
        return result;
    }

    public static <T extends IItem> List<ItemId<T>> itemsToIds(Collection<T> itemHandles) {
        ArrayList<ItemId<T>> result = NewCollection.arrayList();
        for (IItem next : itemHandles) {
            result.add(ItemId.forItem(next));
        }
        return result;
    }

    public static <T extends IItem> List<StateId<T>> itemsToStates(Collection<T> items) {
        ArrayList<StateId<T>> result = new ArrayList<StateId<T>>();
        for (IItem next : items) {
            if (next instanceof IAuditable) {
                result.add(new StateId((IItemHandle)((IAuditable)next)));
                continue;
            }
            if (next instanceof IVersionable) {
                result.add(new StateId((IItemHandle)((IVersionable)next)));
                continue;
            }
            throw new IllegalArgumentException("Only IAuditable and IVersionable supported");
        }
        return result;
    }

    public static List<StateId> handlesToStates(Collection<IItemHandle> itemHandles) {
        ArrayList<StateId> result = new ArrayList<StateId>();
        for (IItemHandle next : itemHandles) {
            if (next instanceof IAuditable) {
                result.add(new StateId((IItemHandle)((IAuditable)next)));
                continue;
            }
            if (next instanceof IVersionable) {
                result.add(new StateId((IItemHandle)((IVersionable)next)));
                continue;
            }
            throw new IllegalArgumentException("Only IAuditable and IVersionable supported");
        }
        return result;
    }

    public static <K, V extends IItem> Map<K, ItemId<V>> mapOfHandlesToMapOfIds(Map<K, ? extends IItemHandle> input) {
        HashMap ids = NewCollection.hashMap();
        for (Map.Entry<K, IItemHandle> next : input.entrySet()) {
            ids.put(next.getKey(), new ItemId(next.getValue()));
        }
        return ids;
    }

    public static List<IItemHandle> statesToHandles(Collection<StateId> itemStates) {
        ArrayList<IItemHandle> result = NewCollection.arrayList();
        for (StateId next : itemStates) {
            Object nextHandle = next.toHandle();
            if (nextHandle == null) continue;
            result.add((IItemHandle)nextHandle);
        }
        return result;
    }

    public static List statesToHandles(List<StateId> itemStates, Object origin) {
        ArrayList result = new ArrayList();
        for (StateId next : itemStates) {
            Object nextHandle = next.toHandle(origin);
            if (nextHandle == null) continue;
            result.add(nextHandle);
        }
        return result;
    }

    public static List<SiloedItemId<IVersionable>> makeSiloed(Collection<ItemId<IVersionable>> unsiloed, ItemId<IComponent> component) {
        ArrayList<SiloedItemId<IVersionable>> result = new ArrayList<SiloedItemId<IVersionable>>();
        for (ItemId<IVersionable> next : unsiloed) {
            result.add(SiloedItemId.create(next, component));
        }
        return result;
    }

    public static List<ItemId<IVersionable>> unSilo(Collection<SiloedItemId<IVersionable>> siloed, ItemId<IComponent> component) {
        ArrayList<ItemId<IVersionable>> result = new ArrayList<ItemId<IVersionable>>();
        for (SiloedItemId<IVersionable> next : siloed) {
            if (!next.getComponent().equals(component)) continue;
            result.add(next.getItemId());
        }
        return result;
    }
}

