/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.internal.dto.ComponentLocks;
import com.ibm.team.scm.common.internal.dto.WorkspaceLocks;
import com.ibm.team.scm.common.internal.dto.impl.ComponentReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockReport
implements IStreamLockReport {
    private final IWorkspaceHandle workspace;
    private final Map<UUID, IComponentLockReport> reports;

    public LockReport(WorkspaceLocks dto) {
        this(dto.getWorkspace(), LockReport.getComponentLocks(dto));
    }

    private static List<IComponentLockReport> getComponentLocks(WorkspaceLocks dto) {
        ArrayList<IComponentLockReport> componentLocks = new ArrayList<IComponentLockReport>();
        for (ComponentLocks l : dto.getComponentLocks()) {
            ComponentReport report = new ComponentReport(l);
            componentLocks.add(report);
        }
        return componentLocks;
    }

    public LockReport(IWorkspaceHandle workspaceHandle, Collection<IComponentLockReport> componentLocks) {
        this.workspace = workspaceHandle;
        this.reports = new HashMap<UUID, IComponentLockReport>();
        for (IComponentLockReport report : componentLocks) {
            this.reports.put(report.getComponent().getItemId(), report);
        }
    }

    @Override
    public Collection<IComponentLockReport> getComponentLocks() {
        return Collections.unmodifiableCollection(this.reports.values());
    }

    @Override
    public IWorkspaceHandle getStream() {
        return this.workspace;
    }

    @Override
    public IComponentLockReport getComponentLockReport(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        for (IComponentLockReport l : this.getComponentLocks()) {
            if (!l.getComponent().sameItemId((IItemHandle)component)) continue;
            return l;
        }
        return null;
    }
}

