/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal.process;

import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.process.ProcessProxy;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProcessUtils {

    public static class ClientProcessProxy
    extends ProcessProxy {
        private final IProcessClientService service;
        private final ITeamRepository repo;

        public ClientProcessProxy(ITeamRepository repo) {
            this.repo = repo;
            if (repo == null) {
                throw new IllegalArgumentException();
            }
            this.service = (IProcessClientService)repo.getClientLibrary(IProcessClientService.class);
        }

        public IOperationReport advise(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            return this.service.getClientProcess(operation.getProcessArea(), (IProgressMonitor)progress.newChild(1)).advise(operation, (IProgressMonitor)progress.newChild(1));
        }

        public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            return this.service.getClientProcess(operation.getProcessArea(), (IProgressMonitor)progress.newChild(1)).adviseAndExecute(operation, (IProgressMonitor)progress.newChild(1));
        }

        public IDevelopmentLine getDevelopmentLine(ITeamArea area, IProgressMonitor monitor) throws TeamRepositoryException {
            return ((IProcessItemService)this.repo.getClientLibrary(IProcessItemService.class)).getDevelopmentLine((IProcessArea)area, monitor);
        }

        public IContributorHandle getContributor() {
            return this.repo.loggedInContributor();
        }

        public boolean ignoreProcessCancellationExceptions() {
            return false;
        }

        public IProcessArea getProcessArea(IItem item, IProgressMonitor monitor) throws TeamRepositoryException {
            IItemHandle context = this.convert(item);
            if (context instanceof IProcessArea) {
                return (IProcessArea)context;
            }
            if (context instanceof IProcessAreaHandle) {
                return (IProcessArea)this.repo.itemManager().fetchCompleteItem(context, 0, monitor);
            }
            return null;
        }

        protected IAuditableHandle getComponentOwner(IComponentHandle component) {
            try {
                return SCMPlatform.getWorkspaceManager(this.repo).findOwnersForComponents(Collections.singletonList(component), null).get(0);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
        }
    }
}

