/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal.content;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.content.ScmClientUtil;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class MonitoredInputStream
extends InputStream {
    private final SubMonitor monitor;
    private final long estimatedBytes;
    private long readBytes;
    private boolean cancellable;
    private final String estimatedBytesHumanReadable;
    private final InputStream in;

    public MonitoredInputStream(InputStream in, long estimatedBytes, IProgressMonitor monitor) {
        this.in = in;
        this.estimatedBytes = estimatedBytes;
        this.readBytes = 0L;
        this.cancellable = true;
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        this.estimatedBytesHumanReadable = ScmClientUtil.bytesAsHumanReadable(estimatedBytes);
    }

    public int available() throws IOException {
        this.cancelIfRequested();
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.cancelIfRequested();
        this.monitor.subTask("");
        this.monitor.done();
    }

    public int read() throws IOException {
        this.cancelIfRequested();
        int b = this.in.read();
        if (b != -1) {
            this.advance(1L);
        }
        return b;
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        this.cancelIfRequested();
        int count = this.in.read(buffer, off, len);
        if (count > 0) {
            this.advance(count);
        }
        return count;
    }

    public long skip(long count) throws IOException {
        this.cancelIfRequested();
        long skipped = this.in.skip(count);
        if (skipped > 0L) {
            this.advance(skipped);
        }
        return skipped;
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private void cancelIfRequested() {
        if (this.cancellable && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void advance(long count) {
        int oldPercent = (int)(this.readBytes * 1000L / this.estimatedBytes);
        this.readBytes += count;
        int newPercent = (int)(this.readBytes * 1000L / this.estimatedBytes);
        this.monitor.worked(newPercent - oldPercent);
        String msg = NLS.bind((String)Messages.MonitoredInputStream_TransferStatus, (Object)ScmClientUtil.bytesAsHumanReadable(this.readBytes), (Object[])new Object[]{this.estimatedBytesHumanReadable});
        this.monitor.subTask(msg);
    }
}

