/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal.content;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.core.runtime.OperationCanceledException;

public class BufferedRequestEntity
implements RequestEntity {
    private final String contentType;
    private final long contentSize;
    private final int bufferSize;
    private final AbstractVersionedContentManagerInputStreamProvider stream;
    private final HttpMethod method;

    public BufferedRequestEntity(AbstractVersionedContentManagerInputStreamProvider stream, long size, String contentType, int bufferSize, HttpMethod method) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream may not be null");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than zero");
        }
        this.stream = stream;
        this.contentSize = size;
        this.contentType = contentType;
        this.bufferSize = bufferSize;
        this.method = method;
    }

    public void writeRequest(OutputStream out) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        int i = 0;
        try {
            InputStream in = this.stream.getInputStream(2);
            try {
                try {
                    in = this.stream.wrapInputStream(in);
                    while ((i = in.read(buffer)) >= 0) {
                        out.write(buffer, 0, i);
                    }
                }
                catch (OperationCanceledException e) {
                    this.method.abort();
                    throw e;
                }
            }
            finally {
                in.close();
            }
        }
        catch (TeamRepositoryException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public long getContentLength() {
        return this.contentSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRepeatable() {
        return true;
    }
}

