/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.client.DeliveryRequiresHistoryReorderingException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.Visibility;
import com.ibm.team.scm.client.VisibilityEnum;
import com.ibm.team.scm.client.internal.ChangeHistoryEvent;
import com.ibm.team.scm.client.internal.ChangeSetClientCache;
import com.ibm.team.scm.client.internal.ClientCurrentComponentInfo;
import com.ibm.team.scm.client.internal.CommitEvent;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.CurrentChangeSetEvent;
import com.ibm.team.scm.client.internal.FlowNodeConnection;
import com.ibm.team.scm.client.internal.FlowTable;
import com.ibm.team.scm.client.internal.ImportChangeSetResult;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorUtils;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.VersionableManager;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.client.internal.isv.IWorkspaceDeliverRunnable;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.client.internal.process.ClientAdvisableOperation;
import com.ibm.team.scm.client.internal.process.ProcessUtils;
import com.ibm.team.scm.client.interop.IImportChangeSetResult;
import com.ibm.team.scm.client.interop.IWorkspaceConnectionInteropAdapter;
import com.ibm.team.scm.common.AcceptFlags;
import com.ibm.team.scm.common.ChangeSetsNotOutgoingException;
import com.ibm.team.scm.common.CompletedChangeSetException;
import com.ibm.team.scm.common.DeliveryIntroducesConflictsException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidAuthenticationTokenException;
import com.ibm.team.scm.common.InvalidStreamOperationException;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.SyncReportInappropriateException;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IComponentizedAncestorList;
import com.ibm.team.scm.common.dto.IItemInfoData;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.BaselineHandle;
import com.ibm.team.scm.common.internal.ChangeSetHandle;
import com.ibm.team.scm.common.internal.ComponentFlow;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.FlowEntry;
import com.ibm.team.scm.common.internal.IScmImportService;
import com.ibm.team.scm.common.internal.VersionedContent;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.internal.WorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.BasisMapping;
import com.ibm.team.scm.common.internal.dto.ChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.dto.CommitParameter;
import com.ibm.team.scm.common.internal.dto.ComponentBaselineEntry;
import com.ibm.team.scm.common.internal.dto.ComponentChangeSetEntry;
import com.ibm.team.scm.common.internal.dto.ComponentInfo;
import com.ibm.team.scm.common.internal.dto.ComponentLocks;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ComponentizedFetchParameter;
import com.ibm.team.scm.common.internal.dto.ComponentizedFetchResult;
import com.ibm.team.scm.common.internal.dto.ComponentizedFolderEntryReport;
import com.ibm.team.scm.common.internal.dto.CustomVisibility;
import com.ibm.team.scm.common.internal.dto.ICommitParameter;
import com.ibm.team.scm.common.internal.dto.ItemConflictReport;
import com.ibm.team.scm.common.internal.dto.PredecessorInfo;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.ServiceConfigurationProvider;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import com.ibm.team.scm.common.internal.dto.UpdateReport;
import com.ibm.team.scm.common.internal.dto.WorkspaceDeliveryResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceImportResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceItemListResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceItemResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshParameter;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceUpdateReportResult;
import com.ibm.team.scm.common.internal.dto.impl.ComponentReport;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.process.ProcessProxy;
import com.ibm.team.scm.common.process.RepositoryRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceConnection
extends FlowNodeConnection
implements IWorkspaceConnection,
IWorkspaceOperationRunner {
    private static final ILockSearchResult NO_LOCKS = ScmDtoFactory.eINSTANCE.createLockSearchResult();
    private final IWorkspaceConnection.IConfigurationOpFactory configurationOpFactory = new ConfigurationOpFactory();
    private final ChangeSetClientCache changeSetCache = new ChangeSetClientCache();
    private final IWorkspaceConfiguration workspaceConfiguration;
    private final ILockSearchCriteria criteria;

    WorkspaceConnection(WorkspaceManager workspaceManager, WorkspaceRefreshResult refreshResult) throws TeamRepositoryException {
        super(workspaceManager, refreshResult);
        this.refresh(refreshResult, null, false);
        this.workspaceConfiguration = new WorkspaceConfigurationProxy();
        if (this.getResolvedWorkspace().isStream()) {
            this.criteria = ILockSearchCriteria.FACTORY.newInstance();
            this.criteria.getStreams().add((IWorkspaceHandle)this.getResolvedWorkspace().getItemHandle());
        } else {
            this.criteria = null;
        }
    }

    @Override
    public IUpdateReport conflictReport(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.conflictReport(null, monitor);
    }

    IUpdateReport conflictReport(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            IUpdateReport result = service.conflictReport(this.getWorkspaceHandle(), WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(80);
            SCMClientUtil.checkMonitor(monitor);
            IUpdateReport iUpdateReport = result;
            return iUpdateReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeSetHandle createChangeSet(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, "", false, null, monitor);
    }

    IChangeSetHandle createChangeSet(IComponentHandle component, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, "", false, syncInfo, monitor);
    }

    @Override
    public IChangeSetHandle createChangeSet(IComponentHandle component, String comment, boolean setCurrent, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, comment, setCurrent, null, monitor);
    }

    IChangeSetHandle createChangeSet(IComponentHandle component, String comment, boolean setCurrent, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_0);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " createChangeSet() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter delta = this.getDeltaParameter();
            WorkspaceItemResult serviceResult = service.createChangeSet(this.getWorkspaceHandle(), component, comment, setCurrent, delta, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            progress.worked(95);
            IChangeSet changeSet = (IChangeSet)serviceResult.getItem();
            serviceResult.unsetItem();
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), delta, false);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " createChangeSet() ends");
            IChangeSet iChangeSet = changeSet;
            return iChangeSet;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List activeChangeSets() {
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getActiveChangeSets();
        }
    }

    @Override
    public List<IChangeSetHandle> suspendedChangeSets() {
        return this.workspaceManager().suspendedChangeSets();
    }

    @Override
    public List<IChangeSetHandle> suspendedChangeSets(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        return this.workspaceManager().suspendedChangeSets(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List activeChangeSets(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getActiveChangeSetsByComponent(component);
        }
    }

    @Override
    public IUpdateReport moveFoldersBetweenComponents(IComponentHandle sourceComponent, IComponentHandle targetComponent, IFolderHandle[] folderHandles, IFolderHandle[] parentsToMoveInto, String sourceComment, String targetComment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.moveFoldersBetweenComponents(sourceComponent, targetComponent, folderHandles, parentsToMoveInto, sourceComment, targetComment, null, monitor);
    }

    IUpdateReport moveFoldersBetweenComponents(IComponentHandle sourceComponent, IComponentHandle targetComponent, IFolderHandle[] folderHandles, IFolderHandle[] parentsToMoveInto, String sourceComment, String targetComment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (sourceComponent == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (targetComponent == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (folderHandles == null || folderHandles.length == 0) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (parentsToMoveInto == null || parentsToMoveInto.length != folderHandles.length) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), sourceComponent);
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), targetComponent);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " moveFolders() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.moveFoldersWithHistory(this.getWorkspaceHandle(), sourceComponent, targetComponent, folderHandles, parentsToMoveInto, sourceComment, targetComment, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            progress.worked(95);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false);
                this.sendEvent(result.getReport());
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " moveFolders() ends");
            IUpdateReport iUpdateReport = result.getReport();
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void closeChangeSets(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, true, null, monitor);
    }

    void closeChangeSets(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, true, syncInfo, monitor);
    }

    @Override
    public void ensureClosed(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, false, null, monitor);
    }

    void ensureClosed(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, false, syncInfo, monitor);
    }

    private static void addBaselineEntries(List<ComponentBaselineEntry> cbe, Map<UUID, IComponentHandle> componentMap) {
        for (ComponentBaselineEntry be : cbe) {
            IComponentHandle c = be.getComponent();
            for (IBaselineHandle bh : be.getBaselines()) {
                componentMap.put(bh.getItemId(), c);
            }
        }
    }

    private static void addChangeSetEntries(List<ComponentChangeSetEntry> cce, Map<UUID, IComponentHandle> componentMap) {
        for (ComponentChangeSetEntry ce : cce) {
            IComponentHandle c = ce.getComponent();
            for (IChangeSetHandle ch : ce.getChangeSets()) {
                componentMap.put(ch.getItemId(), c);
            }
        }
    }

    private static void addBasisMappings(List<BasisMapping> bm, Map<UUID, IComponentHandle> componentMap) {
        for (BasisMapping b : bm) {
            componentMap.put(b.getBaseline().getItemId(), b.getComponent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, ChangeHistorySyncReport report, Collection<IBaselineHandle> baselines, Collection<IChangeSetHandle> changeSets, boolean lockRemote, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle cmp;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<UUID, IComponentHandle> componentMap = new HashMap<UUID, IComponentHandle>();
        WorkspaceConnection.addBaselineEntries(report.getIncomingComponentBaselineEntries(), componentMap);
        WorkspaceConnection.addBaselineEntries(report.getOutgoingComponentBaselineEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getIncomingComponentChangeSetEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getIncomingComponentChangeSetEntriesAfterBasis(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getOutgoingComponentChangeSetEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getOutgoingComponentChangeSetEntriesAfterBasis(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getCommonComponentBaselines(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getLocalBases(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getRemoteBases(), componentMap);
        IWorkspaceHandle remoteWorkspace = report.getRemote();
        WorkspaceConnection other = this.workspaceManager.getConnectionIfKnown(report.getRemote());
        ArrayList<IChangeSetHandle> toFetch = null;
        for (IBaselineHandle h : baselines) {
            cmp = (IComponentHandle)componentMap.get(h.getItemId());
            if (cmp == null && (cmp = this.getComponent(h)) == null && (cmp = this.getComponentFromBasis(h)) == null) {
                if (other != null) {
                    cmp = other.getComponentFromBasis(h);
                }
                if (cmp == null) {
                    if (toFetch == null) {
                        toFetch = new ArrayList<IChangeSetHandle>();
                    }
                    toFetch.add((IChangeSetHandle)h);
                    continue;
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
            if (!lockRemote) continue;
            lock.addExclusive((IContextHandle)remoteWorkspace, cmp);
        }
        for (IChangeSetHandle cs : changeSets) {
            cmp = (IComponentHandle)componentMap.get(cs.getItemId());
            if (cmp == null && (cmp = this.getComponent(cs)) == null) {
                Object object = this.lock;
                synchronized (object) {
                    cmp = this.changeSetCache.getComponent(cs);
                }
                if (cmp == null) {
                    if (other != null) {
                        object = other.lock;
                        synchronized (object) {
                            cmp = other.changeSetCache.getComponent(cs);
                        }
                    }
                    if (cmp == null) {
                        if (toFetch == null) {
                            toFetch = new ArrayList();
                        }
                        toFetch.add(cs);
                        continue;
                    }
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
            if (!lockRemote) continue;
            lock.addExclusive((IContextHandle)remoteWorkspace, cmp);
        }
        if (toFetch != null) {
            List fetched = this.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : fetched) {
                IComponentHandle cmp2;
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                if (i instanceof IBaseline) {
                    cmp2 = ((IBaseline)i).getComponent();
                } else if (i instanceof IChangeSet) {
                    cmp2 = ((IChangeSet)i).getComponent();
                } else {
                    throw new IllegalStateException();
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp2);
                if (lockRemote) {
                    lock.addExclusive((IContextHandle)remoteWorkspace, cmp2);
                }
                ++idx;
            }
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IComponentHandle getComponentFromBasis(IBaselineHandle h) {
        Object object = this.lock;
        synchronized (object) {
            for (ClientCurrentComponentInfo info : this.cachedComponents.values()) {
                if (!h.sameItemId((IItemHandle)info.basis())) continue;
                return info.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, List<? extends IChangeSetHandle> list1, List<? extends IChangeSetHandle> list2, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IChangeSetHandle> toFetch = null;
        Iterator<? extends IChangeSetHandle> i2 = list2.iterator();
        for (IChangeSetHandle iChangeSetHandle : list1) {
            IComponentHandle cmp = this.getComponent(iChangeSetHandle);
            if (cmp == null) {
                Object object = this.lock;
                synchronized (object) {
                    cmp = this.changeSetCache.getComponent(iChangeSetHandle);
                }
                if (cmp == null) {
                    IChangeSetHandle iChangeSetHandle2 = i2.next();
                    cmp = this.getComponent(iChangeSetHandle2);
                    if (cmp == null) {
                        object = this.lock;
                        synchronized (object) {
                            cmp = this.changeSetCache.getComponent(iChangeSetHandle2);
                        }
                        if (cmp == null) {
                            if (toFetch == null) {
                                toFetch = new ArrayList<IChangeSetHandle>();
                            }
                            toFetch.add(iChangeSetHandle2);
                            continue;
                        }
                    }
                } else {
                    i2.next();
                }
            } else {
                i2.next();
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
        }
        i2 = null;
        if (toFetch != null) {
            List list = this.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : list) {
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), ((IChangeSet)i).getComponent());
                ++idx;
            }
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, Collection<IChangeSetHandle> changeSets, ITeamRepository originRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IChangeSetHandle> toFetch = null;
        for (IChangeSetHandle cs : changeSets) {
            IComponentHandle cmp = this.getComponent(cs);
            if (cmp == null) {
                Iterator iterator = this.lock;
                synchronized (iterator) {
                    cmp = this.changeSetCache.getComponent(cs);
                }
                if (cmp == null) {
                    if (toFetch == null) {
                        toFetch = new ArrayList<IChangeSetHandle>();
                    }
                    toFetch.add(cs);
                    continue;
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
        }
        if (toFetch != null) {
            List fetched = originRepository.itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : fetched) {
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), ((IChangeSet)i).getComponent());
                ++idx;
            }
        }
        progress.done();
    }

    private IComponentHandle getComponent(IChangeSetHandle csh) {
        IChangeSet cs;
        if (csh instanceof IChangeSet && (cs = (IChangeSet)csh).getComponent() != null) {
            return cs.getComponent();
        }
        cs = (IChangeSet)this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)csh);
        if (cs != null && cs.getComponent() != null) {
            return cs.getComponent();
        }
        return null;
    }

    private IComponentHandle getComponent(IBaselineHandle bh) {
        IBaseline b;
        if (bh instanceof IBaseline && (b = (IBaseline)bh).getComponent() != null) {
            return b.getComponent();
        }
        b = (IBaseline)this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)bh);
        if (b != null && b.getComponent() != null) {
            return b.getComponent();
        }
        return null;
    }

    private void closeChangeSets(Collection changeSets, boolean checkActive, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(changeSets);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, changeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " closeChangeSets() begins");
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceItemListResult result = service.closeChangeSets(this.getWorkspaceHandle(), (IChangeSetHandle[])changeSets.toArray(new ChangeSetHandle[changeSets.size()]), checkActive, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
                progress.worked(90);
                this.acquire();
                try {
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets", new ArrayList(changeSets));
                    WorkspaceRefreshResult refreshResult = result.getRefreshResult();
                    this.refresh(refreshResult, deltaParameter, false);
                    this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                    result.unsetItems();
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " closeChangeSets() ends");
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport discardChangeSets(boolean preflight, Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.discardChangeSets(preflight, changeSets, null, monitor);
    }

    public List getMostRecentBaselinesAffecting(IComponentHandle component, List folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            for (Object element : folderHandles) {
                if (element == null) {
                    throw new IllegalArgumentException();
                }
                if (element instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            this.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            IBaseline[] baselines = service.getMostRecentBaselinesAffecting((IWorkspaceHandle)this.getResolvedWorkspace(), component, folderHandles.toArray(new IFolderHandle[folderHandles.size()]), this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List<IBaseline> list = Arrays.asList(baselines);
            return list;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void initializeMostRecentBaselinesAffecting(IComponentHandle component, List<? extends IBaselineHandle> baselines, List<? extends IFolderHandle> folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (baselines.size() != folderHandles.size()) {
                throw new IllegalArgumentException();
            }
            for (IFolderHandle iFolderHandle : folderHandles) {
                if (iFolderHandle == null) {
                    throw new IllegalArgumentException();
                }
                if (iFolderHandle instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            for (IFolderHandle iFolderHandle : baselines) {
                if (iFolderHandle != null) continue;
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            this.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            service.initializeMostRecentBaselinesAffecting((IWorkspaceHandle)this.getResolvedWorkspace(), component, baselines.toArray(new IBaselineHandle[baselines.size()]), folderHandles.toArray(new IFolderHandle[folderHandles.size()]), this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
        }
        finally {
            monitor.done();
        }
    }

    IUpdateReport discardChangeSets(boolean preflight, Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(changeSets);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, changeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
            lock.acquire((IProgressMonitor)progress.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " discardChangeSets() begins");
            }
        } else {
            lock = null;
        }
        progress.setWorkRemaining(95);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.discardChangeSets(this.getWorkspaceHandle(), preflight, (IChangeSetHandle[])changeSets.toArray(new ChangeSetHandle[changeSets.size()]), deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(90);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", new ArrayList(changeSets));
                    this.sendEvent(report);
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " discardChangeSets() ends");
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            progress.done();
        }
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        this.refresh(false, monitor);
    }

    @Override
    public void refresh(boolean replaceComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID txnId = UUID.generate();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) begins - tag " + txnId.getUuidValue());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                WorkspaceRefreshParameter parm = this.createRefreshParameter();
                WorkspaceRefreshResult refreshResult = this.refreshInternal((IProgressMonitor)progress.newChild(95), parm, txnId);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) acquires lock - tag " + txnId.getUuidValue());
                ContextLock lock = new ContextLock();
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle());
                lock.acquire((IProgressMonitor)progress.newChild(5));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) acquires lock - tag " + txnId.getUuidValue());
                try {
                    this.refresh(refreshResult, parm, false, " - tag " + txnId.getUuidValue());
                }
                finally {
                    lock.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            progress.done();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) ends - tag " + txnId.getUuidValue());
    }

    private WorkspaceRefreshResult refreshInternal(IProgressMonitor monitor, WorkspaceRefreshParameter parm) throws TeamRepositoryException {
        return this.refreshInternal(monitor, parm, null);
    }

    private WorkspaceRefreshResult refreshInternal(IProgressMonitor monitor, WorkspaceRefreshParameter parm, UUID txnId) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.workspaceManager.getServerConfigurationService();
            if (txnId != null) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refreshParameter created" + txnId.getUuidValue());
            }
            WorkspaceRefreshParameter[] workspaceRefreshParameters = new WorkspaceRefreshParameter[]{parm};
            WorkspaceRefreshResult refreshResult = service.refreshWorkspaces(workspaceRefreshParameters, IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor))[0];
            if (txnId != null) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refreshResult returned" + txnId.getUuidValue());
            }
            if (refreshResult == null) {
                throw new ItemNotFoundException(this.getResolvedWorkspace().getItemHandle());
            }
            WorkspaceRefreshResult workspaceRefreshResult = refreshResult;
            return workspaceRefreshResult;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceRefreshParameter createRefreshParameter() {
        WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
        parm.setContributorState(this.workspaceManager.getRefreshParameter());
        Object object = this.lock;
        synchronized (object) {
            IWorkspace resolvedWorkspace = this.getResolvedWorkspace();
            parm.setWorkspace((IWorkspaceHandle)resolvedWorkspace.getStateHandle());
            parm.getActiveChangeSets().addAll(this.activeChangeSets());
            for (ICurrentComponentInfo iCurrentComponentInfo : this.getComponentsInfo()) {
                ComponentStateSummary state = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
                state.setChangeHistoryState(((SyncTime)iCurrentComponentInfo.changeHistoryTime()).getValue());
                state.setComponent(iCurrentComponentInfo.getComponent());
                state.setConfigurationState(((SyncTime)iCurrentComponentInfo.configurationTime()).getValue());
                state.setLockState(((SyncTime)iCurrentComponentInfo.lockTime()).getValue());
                parm.getCurrentComponents().add(state);
            }
        }
        return parm;
    }

    public void refresh(WorkspaceRefreshResult data, WorkspaceRefreshParameter parm) throws TeamRepositoryException {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.refresh(data, parm, false);
    }

    @Override
    protected void refresh(WorkspaceRefreshResult refreshResult, WorkspaceRefreshParameter parm, boolean replaceComponent) throws TeamRepositoryException {
        this.refresh(refreshResult, parm, replaceComponent, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(WorkspaceRefreshResult refreshResult, WorkspaceRefreshParameter parm, boolean replaceComponent, String tag) throws TeamRepositoryException {
        if (!refreshResult.getWorkspace().sameItemId((IItemHandle)this.workspaceHandle)) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) begins " + tag);
        this.workspaceManager().refresh(refreshResult.getContributorState());
        this.acquire();
        try {
            Object object = this.lock;
            synchronized (object) {
                Map afterActive;
                Workspace workspaceFromServer = (Workspace)refreshResult.getWorkspace();
                List componentList = refreshResult.getComponents();
                Map previousBases = this.getBases();
                HashMap<UUID, IComponentHandle> previousComponents = new HashMap<UUID, IComponentHandle>();
                for (ClientCurrentComponentInfo i : this.cachedComponents.values()) {
                    previousComponents.put(i.getComponent().getItemId(), i.getComponent());
                }
                Map beforeActive = ConfigUtil.tableForItems(this.changeSetCache.getActiveChangeSets());
                TreeMap<IComponentHandle, IBaselineHandle> newBases = new TreeMap<IComponentHandle, IBaselineHandle>(ItemUtil.itemIdComparator);
                newBases.putAll(previousBases);
                HashMap<UUID, ClientCurrentComponentInfo> componentMap = new HashMap<UUID, ClientCurrentComponentInfo>(this.cachedComponents);
                HashMap oldcomponentMap = new HashMap(this.cachedComponents);
                Iterator iter = componentList.iterator();
                HashMap<UUID, IComponentHandle> newComponents = new HashMap<UUID, IComponentHandle>();
                TreeMap<IComponentHandle, IChangeSetHandle> currentChangeSets = new TreeMap<IComponentHandle, IChangeSetHandle>(ItemUtil.itemIdComparator);
                HashSet<UUID> staleComponents = new HashSet<UUID>();
                boolean locksChanged = false;
                while (iter.hasNext()) {
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> previousConflicts;
                    ComponentInfo entry = (ComponentInfo)iter.next();
                    if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) > 0) {
                        staleComponents.add(entry.getComponent().getItemId());
                        continue;
                    }
                    ClientCurrentComponentInfo ci = (ClientCurrentComponentInfo)this.cachedComponents.get(entry.getComponent().getItemId());
                    if (ci != null) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + entry.getComponent().getItemId().getUuidValue() + " has local chTime=" + ci.changeHistoryTime().toString() + " and supplied chTime=" + entry.getChangeHistoryState() + tag);
                    } else {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + entry.getComponent().getItemId().getUuidValue() + " has supplied chTime=" + entry.getChangeHistoryState() + tag);
                    }
                    if (ci == null) {
                        locksChanged = true;
                    } else if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                        locksChanged = true;
                    } else {
                        long currentCHTime;
                        long previousLockTime = ((SyncTime)ci.lockTime()).getValue();
                        long currentLockTime = entry.getLockState();
                        long previousCHTime = ((SyncTime)ci.changeHistoryTime()).getValue();
                        if (WorkspaceConnection.compareTimes(previousCHTime, currentCHTime = entry.getChangeHistoryState()) > 0) {
                            boolean stale = true;
                            if (parm != null) {
                                UUID cmpId = entry.getComponent().getItemId();
                                for (ComponentStateSummary summary : parm.getCurrentComponents()) {
                                    UUID componentId = summary.getComponent().getItemId();
                                    if (!componentId.equals((Object)cmpId)) continue;
                                    if (summary.getChangeHistoryState() != previousCHTime) break;
                                    stale = false;
                                    break;
                                }
                            }
                            if (stale) {
                                staleComponents.add(entry.getComponent().getItemId());
                                continue;
                            }
                        }
                        locksChanged |= WorkspaceConnection.compareTimes(previousLockTime, currentLockTime) < 0;
                    }
                    ClientCurrentComponentInfo newInfo = new ClientCurrentComponentInfo(entry.getDeliveredBy(), entry.getDeliveryDate(), entry.getBasis(), entry.getIndex() + 1L, (ISyncTime)new SyncTime(entry.getConfigurationState()), (ISyncTime)new SyncTime(entry.getChangeHistoryState()), entry.getComponent(), entry.getChangehistory(), entry.getConflicts(), (ISyncTime)new SyncTime(entry.getLockState()));
                    componentMap.put(entry.getComponent().getItemId(), newInfo);
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> currentConflicts = newInfo.getConflicts();
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> map = previousConflicts = ci == null ? Collections.EMPTY_MAP : ci.getConflicts();
                    if (!previousConflicts.equals(currentConflicts)) {
                        this.sendEvent("com.ibm.team.scm.ConflictUpdate", Collections.EMPTY_LIST, entry.getComponent());
                    }
                    newComponents.put(entry.getComponent().getItemId(), entry.getComponent());
                    if (entry.getBasis() != null) {
                        newBases.put(entry.getComponent(), entry.getBasis());
                    }
                    IChangeSetHandle current = entry.getCurrentChangeSet();
                    IChangeSetHandle oldCurrent = this.changeSetCache.getCurrentChangeSet(entry.getComponent());
                    if (current == null && oldCurrent != null || current != null && !current.sameItemId((IItemHandle)oldCurrent)) {
                        this.sendCurrentChangeSetEvent(current, oldCurrent, entry.getComponent());
                    }
                    currentChangeSets.put(entry.getComponent(), current == null ? ChangeSetClientCache.CURRENT_UNSET : current);
                }
                if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                    for (IComponentHandle deleted : refreshResult.getRemovedComponents()) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + deleted.getItemId().getUuidValue() + " is removed." + tag);
                        UUID componentId = deleted.getItemId();
                        componentMap.remove(componentId);
                        IChangeSetHandle oldCurrent = this.changeSetCache.getCurrentChangeSet(deleted);
                        if (oldCurrent != null) {
                            this.sendCurrentChangeSetEvent(null, oldCurrent, deleted);
                        }
                        currentChangeSets.put(deleted, ChangeSetClientCache.CURRENT_UNSET);
                        newBases.remove(deleted);
                    }
                }
                Set newBasesIds = ConfigUtil.getItemIds(newBases.values());
                Set prevBasesIds = ConfigUtil.getItemIds(previousBases.values());
                if (replaceComponent || !newBasesIds.equals(prevBasesIds)) {
                    this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "bases", previousBases, newBases);
                }
                if (locksChanged) {
                    this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "stream locks", null, null);
                }
                if (!previousComponents.keySet().equals(componentMap.keySet())) {
                    Collection value;
                    newComponents.keySet().removeAll(previousComponents.keySet());
                    previousComponents.keySet().removeAll(componentMap.keySet());
                    if (!newComponents.isEmpty()) {
                        String eventType = "com.ibm.team.repository.PropertyAddMany";
                        value = newComponents.values();
                        if (newComponents.size() == 1) {
                            eventType = "com.ibm.team.repository.PropertyAdd";
                            value = newComponents.values().iterator().next();
                        }
                        if (eventType == "com.ibm.team.repository.PropertyAdd") {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - newComponent added " + tag);
                        } else {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - newComponents added " + tag);
                        }
                        this.sendPropertyChangeEvent(eventType, "components", null, value);
                    }
                    if (!previousComponents.isEmpty()) {
                        String eventType = "com.ibm.team.repository.PropertyRemoveMany";
                        value = previousComponents.values();
                        if (previousComponents.size() == 1) {
                            eventType = "com.ibm.team.repository.PropertyRemove";
                            value = previousComponents.values().iterator().next();
                        }
                        if (eventType == "com.ibm.team.repository.PropertyRemove") {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component removed" + tag);
                        } else {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - components removed" + tag);
                        }
                        this.sendPropertyChangeEvent(eventType, "components", value, null);
                    }
                }
                if (parm != null) {
                    for (ComponentStateSummary summary : parm.getCurrentComponents()) {
                        ClientCurrentComponentInfo oldInfo;
                        UUID componentId = summary.getComponent().getItemId();
                        ClientCurrentComponentInfo newInfo = (ClientCurrentComponentInfo)componentMap.get(componentId);
                        if (newInfo != (oldInfo = (ClientCurrentComponentInfo)oldcomponentMap.get(componentId)) || newInfo != null && WorkspaceConnection.compareTimes(summary.getChangeHistoryState(), ((SyncTime)newInfo.changeHistoryTime()).getValue()) >= 0) continue;
                        staleComponents.add(componentId);
                    }
                }
                oldcomponentMap = null;
                this.changeSetCache.updateCaches(refreshResult, currentChangeSets, staleComponents);
                this.cachedComponents = Collections.unmodifiableMap(componentMap);
                HashMap temp = new HashMap(this.inaccessibleComponents);
                temp.keySet().removeAll(ConfigUtil.getItemIds((Collection)refreshResult.getUnreachableComponentsRemoved()));
                temp.keySet().removeAll(ConfigUtil.getItemIds((Collection)refreshResult.getRemovedComponents()));
                temp.putAll(ConfigUtil.tableForItems((Collection)refreshResult.getNewUnreachableComponents()));
                this.inaccessibleComponents = Collections.unmodifiableMap(temp);
                if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                    List flows = workspaceFromServer.getFlows();
                    CurrentFlows currentFlows = workspaceFromServer.getCurrentFlows();
                    TreeMap<IComponentHandle, CurrentFlows> currentComponentFlows = new TreeMap<IComponentHandle, CurrentFlows>(ItemUtil.itemIdComparator);
                    for (ComponentFlow e : workspaceFromServer.getCurrentComponentFlows()) {
                        currentComponentFlows.put(e.getComponent(), e.getCurrentFlows());
                    }
                    this.flowTable = new FlowTable(flows.toArray(new FlowEntry[flows.size()]), currentFlows, currentComponentFlows);
                    this.vTime = new SyncTime(workspaceFromServer.getTime());
                    this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(workspaceFromServer));
                }
                if (!(afterActive = ConfigUtil.tableForItems(this.changeSetCache.getActiveChangeSets())).keySet().equals(beforeActive.keySet())) {
                    HashMap added = new HashMap(afterActive);
                    added.keySet().removeAll(beforeActive.keySet());
                    if (!added.isEmpty()) {
                        for (IChangeSet cs : added.values()) {
                            this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", Collections.singletonList(cs), this.changeSetCache.getComponent((IChangeSetHandle)cs));
                        }
                    }
                }
                ArrayList<IChangeSet> valid = new ArrayList<IChangeSet>(refreshResult.getActiveChangeSets().size());
                for (IChangeSet cs : refreshResult.getActiveChangeSets()) {
                    if (staleComponents.contains(cs.getComponent().getItemId())) continue;
                    valid.add(cs);
                }
                if (!valid.isEmpty()) {
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing " + valid.size() + " active change sets " + tag);
                    for (IChangeSet cs : valid) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing change set " + cs.getItemId().getUuidValue() + " to stateId " + cs.getStateId().getUuidValue() + " " + tag);
                    }
                    this.teamRepository().itemManager().applyItemUpdates(valid);
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing " + valid.size() + " active change sets " + tag);
                }
                this.clearRefreshResult(refreshResult);
            }
        }
        finally {
            this.release();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) ends " + tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshWorkspace(Workspace w) {
        this.acquire();
        try {
            Object object = this.lock;
            synchronized (object) {
                block9: {
                    if (WorkspaceConnection.compareTimes(this.vTime.getValue(), w.getTime()) < 0) break block9;
                    return;
                }
                List flows = w.getFlows();
                CurrentFlows currentFlows = w.getCurrentFlows();
                TreeMap<IComponentHandle, CurrentFlows> currentComponentFlows = new TreeMap<IComponentHandle, CurrentFlows>(ItemUtil.itemIdComparator);
                for (ComponentFlow e : w.getCurrentComponentFlows()) {
                    currentComponentFlows.put(e.getComponent(), e.getCurrentFlows());
                }
                this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(w));
                this.vTime = new SyncTime(w.getTime());
                this.flowTable = new FlowTable(flows.toArray(new FlowEntry[flows.size()]), currentFlows, currentComponentFlows);
            }
        }
        finally {
            this.release();
        }
    }

    protected void clearRefreshResult(WorkspaceRefreshResult refreshResult) {
        refreshResult.unsetActiveChangeSets();
        refreshResult.unsetContributorState();
        refreshResult.unsetActiveRemoved();
        refreshResult.unsetWorkspaceItemId();
        refreshResult.unsetWorkspace();
        refreshResult.unsetComponents();
    }

    @Override
    public IUpdateReport accept(int flags, IWorkspaceConnection acceptSource, IChangeHistorySyncReport syncReport, List baselines, List incomingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.accept(flags, acceptSource, syncReport, baselines, incomingChangeSets, null, monitor);
    }

    IUpdateReport accept(int flags, IWorkspaceConnection acceptSource, IChangeHistorySyncReport syncReport, List baselines, List incomingChangeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (incomingChangeSets == null) {
            throw new IllegalArgumentException();
        }
        for (Object o : baselines) {
            if (o != null && o instanceof BaselineHandle) continue;
            throw new IllegalArgumentException();
        }
        for (Object o : incomingChangeSets) {
            if (o != null && o instanceof ChangeSetHandle) continue;
            throw new IllegalArgumentException();
        }
        IWorkspaceHandle remoteWorkspaceHandle = this.checkedGetRemote(syncReport, acceptSource);
        IWorkspaceHandle handle = this.getWorkspaceHandle();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.checkLocal(syncReport, handle, (IProgressMonitor)sm.newChild(5));
        List sortedIncomingCsHandleList = this.checkAgainstReport((ChangeHistorySyncReport)syncReport, true, incomingChangeSets);
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, (ChangeHistorySyncReport)syncReport, baselines, sortedIncomingCsHandleList, false, (IProgressMonitor)sm.newChild(4));
            lock.acquire((IProgressMonitor)sm.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " acceptCombined() begins");
            }
        } else {
            sm.setWorkRemaining(90);
            lock = null;
        }
        try {
            WorkspaceUpdateReportResult result;
            this.validate();
            ChangeSetHandle[] sortedIncomingCsHandles = sortedIncomingCsHandleList.toArray(new ChangeSetHandle[sortedIncomingCsHandleList.size()]);
            IScmService service = this.workspaceManager.getServerConfigurationService();
            boolean retry = true;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            while (true) {
                RemoteRepoDescriptor remoteDescriptor = this.extractRemoteDescriptor(acceptSource, sm.newChild(5));
                try {
                    result = service.acceptCombined(handle, flags, remoteWorkspaceHandle, remoteDescriptor, (IBaselineHandle[])baselines.toArray(new BaselineHandle[baselines.size()]), (IChangeSetHandle[])sortedIncomingCsHandles, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)sm));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (!retry) {
                        throw e;
                    }
                    retry = false;
                    this.resetRemoteDescriptor(acceptSource);
                    sm.setWorkRemaining(90);
                    continue;
                }
                break;
            }
            IUpdateReport updateReport = result.getReport();
            sm.worked(80);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false);
                    this.sendEvent(updateReport);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", new ArrayList(baselines), new ArrayList(incomingChangeSets));
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " acceptCombined() ends");
            }
            IUpdateReport iUpdateReport = updateReport;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            sm.done();
        }
    }

    @Override
    public IUpdateReport accept(int flags, List incoming, ITeamRepository optionalTeamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.accept(flags, incoming, optionalTeamRepository, null, monitor);
    }

    IUpdateReport accept(int flags, List incoming, ITeamRepository optionalTeamRepository, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (incoming == null) {
            throw new IllegalArgumentException();
        }
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(incoming);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, incoming, optionalTeamRepository == null ? this.teamRepository() : optionalTeamRepository, (IProgressMonitor)sm.newChild(9));
            lock.acquire((IProgressMonitor)sm.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " accept() begins");
            }
        } else {
            lock = null;
            sm.setWorkRemaining(90);
        }
        try {
            WorkspaceUpdateReportResult result;
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            boolean retry = true;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            while (true) {
                RemoteRepoDescriptor remoteDescriptor = null;
                if (optionalTeamRepository != null && !optionalTeamRepository.getId().equals((Object)this.teamRepository().getId())) {
                    remoteDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(optionalTeamRepository, (IProgressMonitor)sm.newChild(5));
                }
                try {
                    result = service.accept(this.getWorkspaceHandle(), flags, (IChangeSetHandle[])incoming.toArray(new ChangeSetHandle[incoming.size()]), remoteDescriptor, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)sm));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (!retry) {
                        throw e;
                    }
                    retry = false;
                    RemoteRepoDescriptorUtils.resetRemoteDescriptor(this.teamRepository());
                    sm.setWorkRemaining(90);
                    continue;
                }
                break;
            }
            IUpdateReport report = result.getReport();
            sm.worked(80);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false);
                    this.sendEvent(report);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", new ArrayList(incoming));
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " accept() ends");
            }
            sm.done();
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
        }
    }

    @Override
    public IUpdateReport resume(int flags, List<IChangeSetHandle> incoming, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.resume(flags, incoming, null, monitor);
    }

    IUpdateReport resume(int flags, List<IChangeSetHandle> incoming, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (incoming == null) {
            throw new IllegalArgumentException();
        }
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(incoming);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, incoming, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
            lock.acquire((IProgressMonitor)progress.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " resume() begins");
            }
        } else {
            lock = null;
        }
        progress.setWorkRemaining(95);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.resume(this.getWorkspaceHandle(), flags, (IChangeSetHandle[])incoming.toArray(new ChangeSetHandle[incoming.size()]), deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(90);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false);
                    this.sendEvent(report);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", new ArrayList<IChangeSetHandle>(incoming));
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " resume() ends");
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            progress.done();
        }
    }

    @Override
    public List<IComponentLockReport> deliver(IWorkspaceConnection remoteConnection, IChangeHistorySyncReport syncReport, List baselines, List outgoingChangeSets, IProgressMonitor m) throws TeamRepositoryException {
        return this.deliver(remoteConnection, syncReport, baselines, outgoingChangeSets, null, null, m);
    }

    List<IComponentLockReport> deliver(IWorkspaceConnection remoteWorkspaceConnection, final IChangeHistorySyncReport syncReport, final List baselines, final List outgoingChangeSets, final ISynchronizationInfo syncInfo, final IWorkspaceOperationRunner.IWorkspaceOperationRunnable preConditionRunnable, IProgressMonitor m) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)100);
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (outgoingChangeSets == null) {
            throw new IllegalArgumentException();
        }
        this.checkLocal(syncReport, this.getWorkspaceHandle(), (IProgressMonitor)progress.newChild(1));
        this.checkedGetRemote(syncReport, remoteWorkspaceConnection);
        final WorkspaceConnection remoteConnection = (WorkspaceConnection)remoteWorkspaceConnection;
        final IScmService service = remoteConnection.workspaceManager.getServerConfigurationService();
        DeliverOperationData deliverData = new DeliverOperationData((ProcessProxy)new ProcessUtils.ClientProcessProxy(this.teamRepository()), this.getResolvedWorkspace(), remoteConnection.getResolvedWorkspace(), baselines, outgoingChangeSets);
        final ClientAdvisableOperation operation = new ClientAdvisableOperation(remoteConnection.teamRepository(), "com.ibm.team.scm.client.deliver", deliverData, (IItem)remoteConnection.getResolvedWorkspace(), (IProgressMonitor)progress.newChild(4));
        operation.setIgnoredExceptions(false);
        final ArrayList<IComponentLockReport> result = new ArrayList<IComponentLockReport>();
        operation.setBlock(new RepositoryRunnable(){

            public Object run(IProgressMonitor topMonitor) throws TeamRepositoryException {
                return WorkspaceConnection.this.runDeliver(new IWorkspaceDeliverRunnable(){

                    public IObjectsResponse deliver(IWorkspaceConnection workspace, IWorkspaceConnection targetWorkspace, IBaselineHandle[] baselines, IChangeSetHandle[] outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
                        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        if (preConditionRunnable != null && operation.isBeingRerun()) {
                            preConditionRunnable.run((IProgressMonitor)sm.newChild(5));
                        }
                        if (!targetWorkspace.sameRepository(workspace) && outgoingChangeSets.length > 0) {
                            List fullChangesets = workspace.teamRepository().itemManager().fetchCompleteItems(Arrays.asList(outgoingChangeSets), 2, (IProgressMonitor)sm.newChild(5));
                            ArrayList<IChangeSetHandle> toClose = new ArrayList<IChangeSetHandle>();
                            for (IChangeSet cs : fullChangesets) {
                                if (!cs.isActive()) continue;
                                toClose.add((IChangeSetHandle)cs.getItemHandle());
                            }
                            if (!toClose.isEmpty()) {
                                workspace.closeChangeSets(toClose, (IProgressMonitor)sm.newChild(5));
                            }
                        }
                        boolean retry = true;
                        while (true) {
                            IItemInfoData data;
                            sm.setWorkRemaining(85);
                            RemoteRepoDescriptor sourceRepoDescriptor = !remoteConnection.sameRepository(WorkspaceConnection.this) ? RemoteRepoDescriptorUtils.getRemoteDescriptor(WorkspaceConnection.this.teamRepository(), (IProgressMonitor)sm.newChild(5)) : null;
                            try {
                                WorkspaceRefreshParameter deltaParameter1 = WorkspaceConnection.this.getDeltaParameter();
                                WorkspaceRefreshParameter deltaParameter2 = ((WorkspaceConnection)targetWorkspace).getDeltaParameter();
                                IObjectsResponse resp = service.deliverCombined((IWorkspaceHandle)workspace.getResolvedWorkspace().getItemHandle(), sourceRepoDescriptor, (IWorkspaceHandle)targetWorkspace.getResolvedWorkspace().getItemHandle(), baselines, outgoingChangeSets, deltaParameter1, deltaParameter2, WorkspaceConnection.getSyncTimes(syncInfo), WorkspaceConnection.this.monitorFor((IProgressMonitor)sm));
                                sm.done();
                                return resp;
                            }
                            catch (InvalidAuthenticationTokenException e) {
                                if (!retry) {
                                    throw e;
                                }
                                retry = false;
                                RemoteRepoDescriptorUtils.resetRemoteDescriptor(WorkspaceConnection.this.teamRepository());
                                continue;
                            }
                            catch (DeliveryIntroducesConflictsException e) {
                                data = e.getInfo();
                                this.checkForHistoryReordering(workspace, targetWorkspace, baselines, outgoingChangeSets, sm, data);
                                throw e;
                            }
                            catch (NWayConflictUnsupportedException e) {
                                data = e.getInfo();
                                this.checkForHistoryReordering(workspace, targetWorkspace, baselines, outgoingChangeSets, sm, data);
                                throw e;
                            }
                            break;
                        }
                    }

                    private void checkForHistoryReordering(IWorkspaceConnection workspace, IWorkspaceConnection targetWorkspace, IBaselineHandle[] baselines, IChangeSetHandle[] outgoingChangeSets, SubMonitor sm, IItemInfoData data) throws TeamRepositoryException, DeliveryRequiresHistoryReorderingException {
                        IComponentHandle comp = data.getComponent();
                        IChangeHistorySyncReport sr = workspace.compareTo(targetWorkspace, WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, Collections.EMPTY_LIST, (IProgressMonitor)sm.newChild(5));
                        boolean hasIncoming = this.hasIncoming(sr, comp);
                        boolean deliveringAllOutgoing = this.deliveringAllOutgoing(comp, sr, baselines, outgoingChangeSets, sm.newChild(20));
                        if (!hasIncoming && deliveringAllOutgoing) {
                            IComponent component = (IComponent)WorkspaceConnection.this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)comp, 0, (IProgressMonitor)sm.newChild(4));
                            String componentName = component.getName();
                            DeliveryRequiresHistoryReorderingException drhre = new DeliveryRequiresHistoryReorderingException(NLS.bind((String)Messages.WorkspaceConnection_Requires_Reordering, (Object)componentName, (Object[])new Object[0]));
                            drhre.setData(comp);
                            throw drhre;
                        }
                    }

                    private boolean hasIncoming(IChangeHistorySyncReport sr, IComponentHandle comp) {
                        return !sr.incomingChangeSets(comp).isEmpty();
                    }

                    private boolean deliveringAllOutgoing(IComponentHandle component, IChangeHistorySyncReport sr, IBaselineHandle[] baselines, IChangeSetHandle[] outgoingChangeSets, SubMonitor monitor) throws TeamRepositoryException {
                        List outgoingBaselines = sr.outgoingBaselines(component);
                        if (outgoingBaselines.isEmpty()) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        Set outgoingBaselineIds = ConfigUtil.getItemIds((Collection)sr.outgoingBaselines(component));
                        Set specifiedBaselineIds = ConfigUtil.getItemIds(Arrays.asList(baselines));
                        specifiedBaselineIds.retainAll(outgoingBaselineIds);
                        if (specifiedBaselineIds.isEmpty()) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        IBaselineHandle outgoingBaseline = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((UUID)specifiedBaselineIds.iterator().next(), null);
                        if (outgoingBaselines.size() <= 1) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        IBaselineHandle latest = (IBaselineHandle)outgoingBaselines.get(0);
                        if (latest.sameItemId((IItemHandle)outgoingBaseline)) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        IBaselineConnection current = (this).WorkspaceConnection.this.workspaceManager.getBaselineConnection(outgoingBaseline, (IProgressMonitor)monitor.newChild(5));
                        IChangeHistorySyncReport compareBaselines = current.compareTo(latest, (IProgressMonitor)monitor.newChild(5));
                        if (compareBaselines.incomingChangeSets().isEmpty()) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        return false;
                    }

                    private boolean checkChangesOnly(IComponentHandle component, IChangeHistorySyncReport sr, IChangeSetHandle[] outgoingChangeSets) {
                        Set delivering = ConfigUtil.getItemIds(Arrays.asList(outgoingChangeSets));
                        Set outgoingCs = ConfigUtil.getItemIds((Collection)sr.outgoingChangeSets(component));
                        return delivering.containsAll(outgoingCs);
                    }
                }, remoteConnection, syncReport, baselines, outgoingChangeSets, result, topMonitor);
            }
        });
        operation.processExec((IProgressMonitor)progress.newChild(95));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " deliver() ends");
        return result;
    }

    @Override
    public IOperationReport runDeliver(IWorkspaceDeliverRunnable runnable, IWorkspaceConnection remoteConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselineHandles, List<IChangeSetHandle> outgoingChangeSets, List<IComponentLockReport> result2, IProgressMonitor monitor) throws TeamRepositoryException {
        List sortedChangeSetHandles = this.checkAgainstReport((ChangeHistorySyncReport)syncReport, false, outgoingChangeSets);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, (ChangeHistorySyncReport)syncReport, baselineHandles, sortedChangeSetHandles, true, (IProgressMonitor)sm.newChild(9));
        lock.acquire((IProgressMonitor)sm.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " deliver() begins");
        try {
            ((WorkspaceConnection)remoteConnection).validate();
            this.validate();
            WorkspaceHandle remoteWorkspaceHandle = (WorkspaceHandle)remoteConnection.getResolvedWorkspace();
            IObjectsResponse response = runnable.deliver(this, remoteConnection, (IBaselineHandle[])baselineHandles.toArray(new BaselineHandle[baselineHandles.size()]), (IChangeSetHandle[])sortedChangeSetHandles.toArray(new ChangeSetHandle[sortedChangeSetHandles.size()]), (IProgressMonitor)sm.newChild(80));
            WorkspaceDeliveryResult result = (WorkspaceDeliveryResult)response.getClientObjects()[0];
            remoteConnection.teamRepository().itemManager().applyItemUpdates(result.getItems());
            result.unsetItems();
            this.acquire();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            try {
                if (this.sameRepository(remoteConnection)) {
                    this.refresh(result.getRefreshResult(), deltaParameter);
                }
                this.sendDeliverEvent("com.ibm.team.scm.ChangeHistoryEvent.Deliver", new ArrayList<IBaselineHandle>(baselineHandles), sortedChangeSetHandles, (IFlowNodeHandle)remoteWorkspaceHandle);
            }
            finally {
                this.release();
            }
            ((WorkspaceConnection)remoteConnection).refresh(result.getTargetRefreshResult(), deltaParameter);
            if (result.getLocksToRelease() != null) {
                for (ComponentLocks cl : result.getLocksToRelease().getComponentLocks()) {
                    result2.add((IComponentLockReport)new ComponentReport(cl));
                }
            }
            IOperationReport iOperationReport = response.getOperationReport();
            return iOperationReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            sm.done();
        }
    }

    private Set<UUID> checkForDuplicates(Collection changeSets) {
        HashSet<UUID> result = new HashSet<UUID>();
        for (Object element : changeSets) {
            if (element == null || !(element instanceof IChangeSetHandle)) {
                throw new IllegalArgumentException();
            }
            if (result.add(((IChangeSetHandle)element).getItemId())) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    private List checkAgainstReport(ChangeHistorySyncReport report, boolean incoming, List changeSets) throws TeamRepositoryException {
        Set<UUID> uniqueCsIds = this.checkForDuplicates(changeSets);
        HashSet<UUID> reportCsIds = new HashSet<UUID>();
        ArrayList<IChangeSetHandle> sortedCsHandles = new ArrayList<IChangeSetHandle>(changeSets.size());
        List reportList = incoming ? report.incomingChangeSets() : report.outgoingChangeSets();
        for (IChangeSetHandle csh : reportList) {
            reportCsIds.add(csh.getItemId());
            if (!uniqueCsIds.contains(csh.getItemId())) continue;
            sortedCsHandles.add(csh);
        }
        if (!reportCsIds.containsAll(uniqueCsIds)) {
            HashSet<UUID> notContainedIds = new HashSet<UUID>(uniqueCsIds);
            notContainedIds.removeAll(reportCsIds);
            String msg = incoming ? Messages.WorkspaceConnection_1 : Messages.WorkspaceConnection_2;
            if (!incoming) {
                throw new ChangeSetsNotOutgoingException((Object)this.teamRepository(), msg);
            }
            throw new TeamRepositoryException((Object)this.teamRepository(), msg);
        }
        return sortedCsHandles;
    }

    private void checkLocal(IChangeHistorySyncReport syncReport, IWorkspaceHandle localHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 100);
        IWorkspaceHandle reportLocalHandle = ((ChangeHistorySyncReport)syncReport).getLocal();
        if (reportLocalHandle == null) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_3);
        }
        if (!reportLocalHandle.sameItemId((IItemHandle)localHandle)) {
            IWorkspace reportWorkspace = (IWorkspace)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)reportLocalHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            IWorkspace workspace = (IWorkspace)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)localHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            String message = NLS.bind((String)Messages.WorkspaceConnection_4, (Object[])new Object[]{reportWorkspace.getName(), workspace.getName()}, (Object[])new Object[0]);
            throw new SyncReportInappropriateException((Object)this.teamRepository(), message);
        }
        monitor.done();
    }

    private IWorkspaceHandle checkedGetRemote(IChangeHistorySyncReport syncReport, IWorkspaceConnection connection) throws TeamRepositoryException {
        IWorkspaceHandle remote = ((ChangeHistorySyncReport)syncReport).getRemote();
        if (remote == null) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_5);
        }
        if (!remote.sameItemId((IItemHandle)connection.getResolvedWorkspace())) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_5);
        }
        return remote;
    }

    @Override
    public IWorkspaceConnection.IConfigurationOpFactory configurationOpFactory() {
        return this.configurationOpFactory;
    }

    @Override
    public IUpdateReport commit(IChangeSetHandle activeChangeSet, Collection configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.commit(activeChangeSet, configOps, null, monitor);
    }

    IUpdateReport commit(IChangeSetHandle activeChangeSet, Collection configOps, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (activeChangeSet == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_6);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, Collections.singletonList(activeChangeSet), this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() begins");
        try {
            this.validate();
            HashSet<UUID> itemIds = new HashSet<UUID>();
            ICommitParameter instruction = ICommitParameter.FACTORY.create(activeChangeSet);
            HashMap<UUID, IVersionable> toSaveMap = new HashMap<UUID, IVersionable>();
            for (IWorkspaceConnection.IConfigurationOp element : configOps) {
                this.processConfigOp(element, itemIds, toSaveMap, instruction);
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.batchCommit((IWorkspaceHandle)this.getResolvedWorkspace(), new ICommitParameter[]{instruction}, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress));
            progress.worked(90);
            IUpdateReport report = result.getReport();
            WorkspaceConnection.applyUpdatesAfterCommit(toSaveMap, report);
            this.acquire();
            try {
                this.sendCommitEvent(activeChangeSet);
                this.sendEvent(report);
                this.refresh(result.getRefreshResult(), deltaParameter, false);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    private static void applyUpdatesAfterCommit(Map<UUID, IVersionable> toSaveMap, IUpdateReport report) {
        for (IItemUpdateReport r : report.updates()) {
            IVersionable v;
            IVersionableHandle h = r.getNewCurrentState();
            if (h == null || (v = toSaveMap.get(h.getItemId())) == null) continue;
            WorkspaceConnection.adjustAllContentAfterSave((EObject)v, (IVersionableHandle)h.getItemType().createItemHandle(h.getItemId(), h.getStateId()));
        }
    }

    private static void adjustAllContentAfterSave(EObject currentChild, IVersionableHandle h) {
        EList features = currentChild.eClass().getEAllReferences();
        List values = null;
        int i = 0;
        while (i < features.size()) {
            EReference reference = (EReference)features.get(i);
            if (ItemUtil.isPersistent((EClass)currentChild.eClass(), (EStructuralFeature)reference) && reference.isContainment() && currentChild.eIsSet((EStructuralFeature)reference)) {
                Object value = currentChild.eGet((EStructuralFeature)reference);
                if (reference.isMany()) {
                    values = (List)value;
                    int j = 0;
                    while (j < values.size()) {
                        Object child = values.get(j);
                        if (child != null) {
                            if (child instanceof VersionedContent) {
                                WorkspaceConnection.adjustContentAfterSave((VersionedContent)child, h);
                            } else {
                                WorkspaceConnection.adjustAllContentAfterSave((EObject)child, h);
                            }
                        }
                        ++j;
                    }
                } else if (value instanceof VersionedContent) {
                    WorkspaceConnection.adjustContentAfterSave((VersionedContent)value, h);
                } else {
                    WorkspaceConnection.adjustAllContentAfterSave((EObject)value, h);
                }
            }
            ++i;
        }
    }

    private static void adjustContentAfterSave(VersionedContent vc, IVersionableHandle h) {
        vc.setOriginalContainingState(h);
    }

    @Override
    public IUpdateReport commit(List<IChangeSetHandle> activeChangeSets, List<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.commit(activeChangeSets, configOps, null, monitor);
    }

    IUpdateReport commit(List<IChangeSetHandle> activeChangeSets, List<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configOps, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (activeChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (activeChangeSets.size() != configOps.size()) {
            throw new IllegalArgumentException();
        }
        if (activeChangeSets.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_9);
        }
        if (ConfigUtil.getItemIds(activeChangeSets).size() != activeChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, activeChangeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() begins");
        try {
            this.validate();
            CommitParameter[] instructions = new CommitParameter[configOps.size()];
            HashMap<UUID, IVersionable> toSaveMap = new HashMap<UUID, IVersionable>();
            int i = 0;
            while (i < instructions.length) {
                HashSet<UUID> itemIds = new HashSet<UUID>();
                ICommitParameter instruction = ICommitParameter.FACTORY.create(activeChangeSets.get(i));
                for (IWorkspaceConnection.IConfigurationOp iConfigurationOp : configOps.get(i)) {
                    this.processConfigOp(iConfigurationOp, itemIds, toSaveMap, instruction);
                }
                instructions[i] = instruction;
                ++i;
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.batchCommit((IWorkspaceHandle)this.getResolvedWorkspace(), (ICommitParameter[])instructions, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress));
            progress.worked(90);
            IUpdateReport iUpdateReport = result.getReport();
            WorkspaceConnection.applyUpdatesAfterCommit(toSaveMap, iUpdateReport);
            this.acquire();
            try {
                for (IChangeSetHandle ch : activeChangeSets) {
                    this.sendCommitEvent(ch);
                }
                this.sendEvent(iUpdateReport);
                this.refresh(result.getRefreshResult(), deltaParameter, false);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() ends");
            IUpdateReport iUpdateReport2 = iUpdateReport;
            return iUpdateReport2;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    private void processConfigOp(IWorkspaceConnection.IConfigurationOp element, Set<UUID> itemIds, Map<UUID, IVersionable> itemsToSave, ICommitParameter instruction) throws TeamRepositoryException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof SaveOp) {
            SaveOp op = (SaveOp)element;
            IVersionable item = op.item;
            if (!itemIds.add(item.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            if (!item.isWorkingCopy()) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
            }
            instruction.addItemToSave(op.item);
            itemsToSave.put(item.getItemId(), item);
            return;
        }
        if (element instanceof RevertOp) {
            RevertOp op = (RevertOp)element;
            if (!itemIds.add(op.itemStateHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToRevert(op.itemStateHandle);
            return;
        }
        if (element instanceof DeleteOp) {
            DeleteOp op = (DeleteOp)element;
            if (!itemIds.add(op.itemHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToDelete(op.itemHandle);
            return;
        }
        if (element instanceof DeleteSubtreeOp) {
            DeleteSubtreeOp op = (DeleteSubtreeOp)element;
            if (!itemIds.add(op.folderHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addFolderToDeleteSubtree(op.folderHandle);
            return;
        }
        if (element instanceof UndoOp) {
            UndoOp op = (UndoOp)element;
            if (!itemIds.add(op.itemHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToUndo(op.itemHandle);
            return;
        }
        if (element instanceof MergeOp) {
            MergeOp op = (MergeOp)element;
            IWorkspaceConnection.IMergeResultOp innerOp = op.getInnerOp();
            if (itemIds.contains(innerOp.getItemHandle().getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            this.processConfigOp(innerOp, itemIds, itemsToSave, instruction);
            PredecessorInfo info = ScmDtoFactory.eINSTANCE.createPredecessorInfo();
            info.setItemId(innerOp.getItemHandle().getItemId());
            info.setPredecessor(op.getSelectedState());
            info.setMergePredecessor(op.getProposedState());
            instruction.addPredecessorInformation(info);
            return;
        }
        if (element instanceof MarkAsMergedOp) {
            MarkAsMergedOp op = (MarkAsMergedOp)element;
            if (!itemIds.add(op.item.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            PredecessorInfo info = ScmDtoFactory.eINSTANCE.createPredecessorInfo();
            info.setItemId(op.item.getItemId());
            info.setPredecessor(op.getSelectedState());
            info.setMergePredecessor(op.getProposedState());
            if (!info.isValid()) {
                throw new IllegalArgumentException("MarkAsMerge operation malformed.");
            }
            instruction.addPredecessorInformation(info);
            instruction.addItemToMarkAsMerged(op.item);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IUpdateReport suspend(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.suspend(changeSets, null, monitor);
    }

    IUpdateReport suspend(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, changeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " suspend() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            ChangeSetHandle[] array = changeSets.toArray(new ChangeSetHandle[changeSets.size()]);
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.suspend(this.getWorkspaceHandle(), (IChangeSetHandle[])array, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false);
                this.sendEvent(report);
                this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", new ArrayList(changeSets));
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " suspend() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void removeSuspended(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.removeSuspended(changeSets, null, monitor);
    }

    void removeSuspended(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.workspaceManager.removeSuspended(changeSets, monitor);
    }

    @Override
    public void setCurrentChangeSet(IChangeSetHandle current, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setCurrentChangeSet(current, null, monitor);
    }

    void setCurrentChangeSet(IChangeSetHandle current, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (current == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_12);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, Collections.singleton(current), this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() begins");
        try {
            try {
                this.validate();
                if (!this.isActive(current)) {
                    throw new CompletedChangeSetException(Messages.WorkspaceConnection_13);
                }
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceRefreshResult result = service.setCurrentChangeSet(this.getWorkspaceHandle(), current, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
                progress.worked(90);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() beforeRefresh");
                this.refresh(result, deltaParameter, false);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void unsetCurrentChangeSet(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        this.unsetCurrentChangeSet(component, null, monitor);
    }

    void unsetCurrentChangeSet(IComponentHandle component, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_14);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " unsetCurrentChangeSet() begins");
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceRefreshResult result = service.unsetCurrentChangeSet(this.getWorkspaceHandle(), component, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
                progress.worked(95);
                this.refresh(result, deltaParameter, false);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " unsetCurrentChangeSet() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(IChangeSetHandle changeSet) {
        Set ids = null;
        Object object = this.lock;
        synchronized (object) {
            ids = ConfigUtil.getItemIds(this.changeSetCache.getActiveChangeSets());
        }
        return ids.contains(changeSet.getItemId());
    }

    private void sendCurrentChangeSetEvent(IChangeSetHandle current, IChangeSetHandle oldCurrent, IComponentHandle component) {
        this.queue(new CurrentChangeSetEvent(this, current, oldCurrent, component));
    }

    private void sendCommitEvent(IChangeSetHandle changeSet) {
        this.queue(new CommitEvent(this, "com.ibm.team.scm.Commit", changeSet));
    }

    private void sendDeliverEvent(String type, List baselineHandles, List changeSetHandles, IFlowNodeHandle deliverTarget) {
        this.queue(new ChangeHistoryEvent(this, type, baselineHandles, changeSetHandles, null, deliverTarget));
    }

    public void committedWork(IChangeSetHandle changeSet, IUpdateReport updateReport, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset,ur,monitor) begins");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.acquire();
            try {
                this.sendCommitEvent(changeSet);
                this.sendEvent(updateReport);
            }
            finally {
                this.release();
            }
            ContextLock lock = new ContextLock();
            HashSet<UUID> before = new HashSet<UUID>();
            IWorkspaceHandle ws = this.getWorkspaceHandle();
            for (IComponentStateSummary s : updateReport.getComponentStatesBefore()) {
                before.add(s.getComponent().getItemId());
                lock.addExclusive((IContextHandle)ws, s.getComponent());
            }
            for (IComponentStateSummary s : updateReport.getComponentStatesAfter()) {
                if (before.remove(s.getComponent().getItemId())) continue;
                lock.clear();
                lock.addExclusive((IContextHandle)ws);
                break;
            }
            if (!before.isEmpty()) {
                lock.clear();
                lock.addExclusive((IContextHandle)ws);
            }
            before = null;
            lock.acquire((IProgressMonitor)progress.newChild(1));
            try {
                WorkspaceRefreshParameter parm = this.createRefreshParameter();
                WorkspaceRefreshResult r = this.refreshInternal((IProgressMonitor)progress.newChild(95), parm);
                this.refresh(r, parm);
            }
            finally {
                lock.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset,ur,monitor) ends");
        }
        finally {
            progress.done();
        }
    }

    public void committedWork(List changeSets, IUpdateReport[] reports, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset[],ur[],monitor) begins");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ContextLock lock = new ContextLock();
            this.acquire();
            try {
                int i = 0;
                while (i < reports.length) {
                    HashSet<UUID> before = new HashSet<UUID>();
                    IWorkspaceHandle ws = this.getWorkspaceHandle();
                    for (IComponentStateSummary s : reports[i].getComponentStatesBefore()) {
                        before.add(s.getComponent().getItemId());
                        lock.addExclusive((IContextHandle)ws, s.getComponent());
                    }
                    for (IComponentStateSummary s : reports[i].getComponentStatesAfter()) {
                        if (before.remove(s.getComponent().getItemId())) continue;
                        lock.clear();
                        lock.addExclusive((IContextHandle)ws);
                        break;
                    }
                    if (!before.isEmpty()) {
                        lock.clear();
                        lock.addExclusive((IContextHandle)ws);
                    }
                    this.sendEvent(reports[i]);
                    ++i;
                }
                i = 0;
                while (i < changeSets.size()) {
                    this.sendCommitEvent((IChangeSetHandle)changeSets.get(i));
                    ++i;
                }
            }
            finally {
                this.release();
            }
            lock.acquire((IProgressMonitor)progress.newChild(1));
            try {
                WorkspaceRefreshParameter parm = this.createRefreshParameter();
                WorkspaceRefreshResult r = this.refreshInternal((IProgressMonitor)progress.newChild(95), parm);
                this.refresh(r, parm);
            }
            finally {
                lock.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset[],ur[],monitor) ends");
        }
        finally {
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChangeSetHandle getCurrentChangeSet(IComponentHandle componentHandle) {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " getCurrentChangeSet(Comp) begins");
        if (componentHandle == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        IChangeSetHandle changeSet = null;
        Object object = this.lock;
        synchronized (object) {
            changeSet = this.changeSetCache.getCurrentChangeSet(componentHandle);
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " getCurrentChangeSet(Comp) ends");
        return changeSet;
    }

    @Override
    public List retrieveComponentStateSummaries(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            IComponentStateSummary[] summaries = service.getWorkspaceComponentStateSummaries(this.getWorkspaceHandle(), this.monitorFor(monitor));
            monitor.worked(80);
            ArrayList<IComponentStateSummary> result = new ArrayList<IComponentStateSummary>(summaries.length);
            int i = 0;
            while (i < summaries.length) {
                IComponentStateSummary summary = summaries[i];
                result.add(summary);
                ++i;
            }
            SCMClientUtil.checkMonitor(monitor);
            ArrayList<IComponentStateSummary> arrayList = result;
            return arrayList;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void relocateChanges(List<? extends IChangeSetHandle> targetChangeSets, List<? extends IVersionableHandle> itemsToMove, List<? extends IChangeSetHandle> sourceChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.relocateChanges(targetChangeSets, itemsToMove, sourceChangeSets, null, monitor);
    }

    void relocateChanges(List<? extends IChangeSetHandle> targetChangeSets, List<? extends IVersionableHandle> itemsToMove, List<? extends IChangeSetHandle> sourceChangeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (itemsToMove == null) {
            throw new IllegalArgumentException();
        }
        if (sourceChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (targetChangeSets.size() != sourceChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        int size = itemsToMove.size();
        if (size != sourceChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        HashSet<UUID> itemIds = new HashSet<UUID>();
        int i = 0;
        while (i < size) {
            IChangeSetHandle source = sourceChangeSets.get(i);
            IChangeSetHandle target = targetChangeSets.get(i);
            IVersionableHandle item = itemsToMove.get(i);
            if (item == null) {
                throw new IllegalArgumentException();
            }
            if (!itemIds.add(item.getItemId())) {
                throw new IllegalArgumentException();
            }
            if (source == null) {
                throw new IllegalArgumentException();
            }
            if (target == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, sourceChangeSets, targetChangeSets, (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " relocateChanges begins");
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceItemListResult result = service.relocateChanges(this.getWorkspaceHandle(), targetChangeSets.toArray(new IChangeSetHandle[size]), itemsToMove.toArray(new IVersionableHandle[size]), sourceChangeSets.toArray(new IChangeSetHandle[size]), deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
                this.acquire();
                try {
                    HashSet<UUID> sendAlready = new HashSet<UUID>();
                    for (IChangeSetHandle iChangeSetHandle : targetChangeSets) {
                        if (sendAlready.contains(iChangeSetHandle.getItemId())) continue;
                        this.sendCommitEvent(iChangeSetHandle);
                        sendAlready.add(iChangeSetHandle.getItemId());
                    }
                    WorkspaceRefreshResult workspaceRefreshResult = result.getRefreshResult();
                    this.refresh(workspaceRefreshResult, deltaParameter, false);
                    this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                    result.unsetItems();
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " relocateChanges ends");
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
        }
        progress.done();
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.getWorkspaceHandle();
    }

    private IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == IWorkspaceConnectionInteropAdapter.class) {
            return new IWorkspaceConnectionInteropAdapter(){

                public IImportChangeSetResult importChangeSet(IComponentHandle componentHandle, String comment, Collection configOps, long creationTime, IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
                    return WorkspaceConnection.this.importChangeSet(componentHandle, comment, configOps, creationTime, contributor, monitor);
                }

                public IBaseline createPostImportBaseline(IComponentHandle componentHandle, String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
                    return WorkspaceConnection.this.createPostImportBaseline(componentHandle, name, comment, null, monitor);
                }
            };
        }
        return null;
    }

    IBaseline createPostImportBaseline(IComponentHandle component, String name, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createPostImportBaseline begins");
        try {
            IBaseline iBaseline;
            this.validate();
            IScmImportService service = this.workspaceManager.getScmImportService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceItemListResult serviceResult = service.createPostImportBaseline(this.getWorkspaceHandle(), component, name, comment, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            progress.worked(95);
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), deltaParameter, false);
                IBaseline baseline = (IBaseline)serviceResult.getItems().get(0);
                this.teamRepository().itemManager().applyItemUpdates(serviceResult.getItems());
                serviceResult.unsetItems();
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createPostImportBaseline ends");
                iBaseline = baseline;
            }
            catch (Throwable throwable) {
                this.release();
                throw throwable;
            }
            this.release();
            return iBaseline;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    IImportChangeSetResult importChangeSet(IComponentHandle component, String comment, Collection configOps, long creationTime, IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_18);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " importChangeSet begins");
        try {
            this.validate();
            IScmImportService service = this.workspaceManager.getScmImportService();
            HashSet<UUID> itemIds = new HashSet<UUID>();
            HashMap<UUID, IVersionable> toSaveMap = new HashMap<UUID, IVersionable>();
            ICommitParameter instruction = ICommitParameter.FACTORY.create();
            for (IWorkspaceConnection.IConfigurationOp element : configOps) {
                this.processConfigOp(element, itemIds, toSaveMap, instruction);
            }
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceImportResult serviceResult = service.importChangeSet(this.getWorkspaceHandle(), component, comment, instruction, creationTime, contributor, deltaParameter, this.monitorFor((IProgressMonitor)progress));
            progress.worked(95);
            IChangeSet changeSet = (IChangeSet)serviceResult.getItem();
            IUpdateReport report = serviceResult.getReport();
            serviceResult.unsetItem();
            WorkspaceConnection.applyUpdatesAfterCommit(toSaveMap, report);
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), deltaParameter, false);
                this.sendEvent(report);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " importChangeSet ends");
            ImportChangeSetResult importChangeSetResult = new ImportChangeSetResult(changeSet, report);
            return importChangeSetResult;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IBaselineConnection createBaseline(IComponentHandle component, String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createBaseline(component, name, comment, null, monitor);
    }

    IBaselineConnection createBaseline(IComponentHandle component, String name, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (name == null) {
            name = "";
        }
        if (comment == null) {
            comment = "";
        }
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaseline begins");
        try {
            IBaselineConnection iBaselineConnection;
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceItemListResult result = service.createBaseline(handle, component, name, comment, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            progress.worked(95);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false);
                IBaseline baseline = (IBaseline)result.getItems().get(0);
                this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                result.unsetItems();
                IBaselineConnection b = this.workspaceManager.getBaselineConnection(baseline, (IProgressMonitor)progress.newChild(4));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaseline ends");
                iBaselineConnection = b;
            }
            catch (Throwable throwable) {
                try {
                    this.release();
                    throw throwable;
                }
                catch (ItemNotFoundException e) {
                    throw this.expandItemNotFoundDetails(e);
                }
            }
            this.release();
            return iBaselineConnection;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IBaselineSetHandle createBaselineSet(Collection excludedComponents, String name, String comment, boolean createNewBaselines, IProgressMonitor monitor) throws TeamRepositoryException {
        if (excludedComponents == null) {
            excludedComponents = Collections.EMPTY_LIST;
        }
        ISynchronizationInfo syncInfo = ISynchronizationInfo.FACTORY.newInstance();
        if (this.isStream()) {
            ArrayList<UUID> excludedComUUIDs = new ArrayList<UUID>();
            for (IComponentHandle exludedComponentHandle : excludedComponents) {
                excludedComUUIDs.add(exludedComponentHandle.getItemId());
            }
            for (IComponentHandle component : this.getComponents()) {
                if (excludedComUUIDs.contains(component.getItemId())) continue;
                ICurrentComponentInfo componentInfo = this.getComponentInfo(component);
                syncInfo.addChangeHistoryTime((IWorkspaceHandle)this.workspace, component, componentInfo.changeHistoryTime());
                syncInfo.addConfigurationTime((IWorkspaceHandle)this.workspace, component, componentInfo.configurationTime());
            }
        } else {
            syncInfo = null;
        }
        return this.createBaselineSet(excludedComponents, name, comment, createNewBaselines, syncInfo, monitor);
    }

    IBaselineSetHandle createBaselineSet(Collection excludedComponents, String name, String comment, boolean createNewBaselines, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ComponentHandle[] excludedComponentsArray = null;
        if (excludedComponents != null && excludedComponents.size() > 0) {
            for (Object element : excludedComponents) {
                if (element == null || !(element instanceof IComponentHandle)) {
                    throw new IllegalArgumentException();
                }
                this.checkKnownComponent((IComponentHandle)element, (IProgressMonitor)progress.newChild(0));
            }
            excludedComponentsArray = excludedComponents.toArray(new ComponentHandle[excludedComponents.size()]);
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            comment = "";
        }
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaselineSet begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceItemListResult result = service.createBaselineSet(handle, (IComponentHandle[])excludedComponentsArray, name, comment, createNewBaselines, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor((IProgressMonitor)progress));
            progress.worked(95);
            IBaselineSet b = (IBaselineSet)result.getItems().get(0);
            this.teamRepository().itemManager().applyItemUpdates(result.getItems());
            result.unsetItems();
            this.acquire();
            try {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "baseline sets", null, b);
                this.refresh(result.getRefreshResult(), deltaParameter, false);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaselineSet ends");
            }
            finally {
                this.release();
            }
            IBaselineSet iBaselineSet = b;
            return iBaselineSet;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport conflictReport() {
        UpdateReport result = ScmDtoFactory.eINSTANCE.createUpdateReport();
        result.setStateAfter(this.workspace.getTime());
        result.setStateBefore(this.workspace.getTime());
        Collection<? extends ICurrentComponentInfo> infos = this.getComponentsInfo();
        for (ClientCurrentComponentInfo clientCurrentComponentInfo : infos) {
            Map<UUID, ClientCurrentComponentInfo.ConflictInfo> conflicts = clientCurrentComponentInfo.getConflicts();
            for (ClientCurrentComponentInfo.ConflictInfo conflict : conflicts.values()) {
                ItemConflictReport icr = conflict.toItemConflictReport();
                result.getConflicts().add(icr);
            }
        }
        return result;
    }

    @Override
    public IUpdateReport conflictReport(IComponentHandle component) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        this.checkKnownComponent(component, null);
        UpdateReport result = ScmDtoFactory.eINSTANCE.createUpdateReport();
        result.setStateAfter(this.workspace.getTime());
        result.setStateBefore(this.workspace.getTime());
        ClientCurrentComponentInfo info = (ClientCurrentComponentInfo)this.getComponentInfo(component);
        Map<UUID, ClientCurrentComponentInfo.ConflictInfo> conflicts = info.getConflicts();
        for (ClientCurrentComponentInfo.ConflictInfo conflict : conflicts.values()) {
            ItemConflictReport icr = conflict.toItemConflictReport();
            result.getConflicts().add(icr);
        }
        return result;
    }

    @Override
    public Visibility getVisibility() {
        if (this.isStream()) {
            throw new IllegalArgumentException();
        }
        UUID customContext = this.workspace.getCustomContext();
        if (customContext == null) {
            return Visibility.PUBLIC;
        }
        if (customContext.equals((Object)SCMClientUtil.CUSTOM_PRIVATE)) {
            return Visibility.PRIVATE;
        }
        return new Visibility(VisibilityEnum.PROTECTED, (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(customContext, null));
    }

    @Override
    public void setVisibility(Visibility visibility, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isStream()) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            try {
                WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " setVisibility() begins");
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                IWorkspaceHandle handle = this.getWorkspaceHandle();
                CustomVisibility viz = this.convert(visibility.getVisibility());
                Workspace workspace = (Workspace)service.setWorkspaceVisibility(handle, viz, (IAuditableHandle)visibility.getProjectAreaScope(), null, this.monitorFor((IProgressMonitor)progress));
                this.refreshWorkspace(workspace);
                WorkspaceConnection.log("Workspace " + workspace.getItemId().getUuidValue() + " setName() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    private CustomVisibility convert(VisibilityEnum visibility) {
        if (visibility.equals((Object)VisibilityEnum.PRIVATE_TO_OWNER)) {
            return CustomVisibility.PRIVATE_LITERAL;
        }
        if (visibility.equals((Object)VisibilityEnum.PROTECTED)) {
            return CustomVisibility.PROJECT_LITERAL;
        }
        if (visibility.equals((Object)VisibilityEnum.PUBLIC_TO_ALL)) {
            return CustomVisibility.PUBLIC_LITERAL;
        }
        return null;
    }

    @Override
    public List<IComponentLockReport> runDeliverWithPrecondition(IWorkspaceOperationRunner.IWorkspaceOperationRunnable preConditionCheck, IWorkspaceConnection remoteWorkspaceConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.deliver(remoteWorkspaceConnection, syncReport, baselines, outgoingChangeSets, null, preConditionCheck, monitor);
    }

    @Override
    public IWorkspaceConfiguration configuration() {
        return this.workspaceConfiguration;
    }

    @Override
    public ILockSearchResult getLocks(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            this.validate();
            if (this.isStream()) {
                ILockSearchResult iLockSearchResult = this.workspaceManager().findLocks(this.criteria, 512, (IProgressMonitor)mon.newChild(99));
                return iLockSearchResult;
            }
            ILockSearchResult iLockSearchResult = NO_LOCKS;
            return iLockSearchResult;
        }
        finally {
            mon.done();
        }
    }

    @Override
    public IUpdateReport harmonizeHistory(IWorkspaceConnection remoteConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            this.validate();
            if (remoteConnection == null) {
                throw new IllegalArgumentException();
            }
            if (componentHandle == null) {
                throw new IllegalArgumentException();
            }
            WorkspaceConnection conn = (WorkspaceConnection)remoteConnection;
            conn.validate();
            IWorkspaceHandle remoteWorkspace = conn.getWorkspaceHandle();
            IWorkspaceHandle ws = this.getWorkspaceHandle();
            WorkspaceRefreshParameter delta = this.getDeltaParameter();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = null;
            boolean retry = true;
            while (true) {
                RemoteRepoDescriptor remoteDescriptor = this.extractRemoteDescriptor(conn, mon.newChild(5));
                try {
                    result = service.harmonizeWorkspaceHistory(ws, remoteWorkspace, remoteDescriptor, componentHandle, delta, this.monitorFor((IProgressMonitor)mon));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (!retry) {
                        throw e;
                    }
                    retry = false;
                    RemoteRepoDescriptorUtils.resetRemoteDescriptor(this.teamRepository());
                    mon.setWorkRemaining(90);
                    continue;
                }
                break;
            }
            IUpdateReport updateReport = result.getReport();
            mon.worked(80);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), delta, false);
                this.sendEvent(updateReport);
                this.sendEvent("com.ibm.team.scm.HistoryRestructure", Collections.EMPTY_LIST, componentHandle);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " harmonizeHistory() ends");
            IUpdateReport iUpdateReport = updateReport;
            return iUpdateReport;
        }
        finally {
            mon.done();
        }
    }

    static class ConfigurationOpFactory
    implements IWorkspaceConnection.IConfigurationOpFactory {
        ConfigurationOpFactory() {
        }

        public IWorkspaceConnection.ISaveOp save(IVersionable item) {
            if (item == null) {
                throw new IllegalArgumentException();
            }
            if (!item.isWorkingCopy()) {
                throw new IllegalArgumentException();
            }
            return new SaveOp(item, null, null);
        }

        public IWorkspaceConnection.IDeleteOp delete(IVersionableHandle itemHandle) {
            if (itemHandle == null) {
                throw new IllegalArgumentException();
            }
            return new DeleteOp(itemHandle);
        }

        public IWorkspaceConnection.IRevertOp revert(IVersionableHandle itemStateHandle) {
            if (itemStateHandle == null || !itemStateHandle.hasStateId()) {
                throw new IllegalArgumentException();
            }
            return new RevertOp(itemStateHandle);
        }

        public IWorkspaceConnection.IDeleteSubtreeOp deleteSubtree(IFolderHandle folderHandle) {
            if (folderHandle == null) {
                throw new IllegalArgumentException();
            }
            return new DeleteSubtreeOp(folderHandle);
        }

        public IWorkspaceConnection.IUndoOp undo(IVersionableHandle itemHandle) {
            if (itemHandle == null) {
                throw new IllegalArgumentException();
            }
            return new UndoOp(itemHandle);
        }

        public IWorkspaceConnection.IMarkAsMergedOp markAsMerged(IVersionableHandle item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            if (item == null) {
                throw new IllegalArgumentException();
            }
            return new MarkAsMergedOp(item, predecessor, mergePredecessor);
        }

        public IWorkspaceConnection.IMergeOp merge(IWorkspaceConnection.IMergeResultOp nestedOp, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            if (nestedOp == null) {
                throw new IllegalArgumentException();
            }
            return new MergeOp(nestedOp, predecessor, mergePredecessor);
        }
    }

    private static class DeleteOp
    implements IWorkspaceConnection.IDeleteOp {
        final IVersionableHandle itemHandle;

        DeleteOp(IVersionableHandle itemHandle) {
            this.itemHandle = itemHandle;
        }

        public IVersionableHandle getItemHandle() {
            return this.itemHandle;
        }
    }

    private static class DeleteSubtreeOp
    implements IWorkspaceConnection.IDeleteSubtreeOp {
        final IFolderHandle folderHandle;

        DeleteSubtreeOp(IFolderHandle folderHandle) {
            this.folderHandle = folderHandle;
        }

        public IFolderHandle getFolderHandle() {
            return this.folderHandle;
        }
    }

    private static class MarkAsMergedOp
    implements IWorkspaceConnection.IMarkAsMergedOp {
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;
        final IVersionableHandle item;

        public MarkAsMergedOp(IVersionableHandle item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.item = item;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        public IVersionableHandle getItemHandle() {
            return this.item;
        }

        public IVersionableHandle getProposedState() {
            return this.mergePred;
        }

        public IVersionableHandle getSelectedState() {
            return this.pred;
        }
    }

    private static class MergeOp
    implements IWorkspaceConnection.IMergeOp {
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;
        final IWorkspaceConnection.IMergeResultOp nestedOp;

        public MergeOp(IWorkspaceConnection.IMergeResultOp nestedOp, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.nestedOp = nestedOp;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        public IWorkspaceConnection.IMergeResultOp getInnerOp() {
            return this.nestedOp;
        }

        public IVersionableHandle getProposedState() {
            return this.mergePred;
        }

        public IVersionableHandle getSelectedState() {
            return this.pred;
        }
    }

    private static class RevertOp
    implements IWorkspaceConnection.IRevertOp {
        final IVersionableHandle itemStateHandle;

        RevertOp(IVersionableHandle itemStateHandle) {
            this.itemStateHandle = itemStateHandle;
        }

        public IVersionableHandle getItemHandle() {
            return this.itemStateHandle;
        }
    }

    private static class SaveOp
    implements IWorkspaceConnection.ISaveOp {
        final IVersionable item;
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;

        SaveOp(IVersionable item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.item = item;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        public IVersionable getItem() {
            return this.item;
        }

        public IVersionableHandle getMergePredecessor() {
            return this.mergePred;
        }

        public IVersionableHandle getPredecessor() {
            return this.pred;
        }

        public IVersionableHandle getItemHandle() {
            return this.item;
        }
    }

    private static class UndoOp
    implements IWorkspaceConnection.IUndoOp {
        final IVersionableHandle itemHandle;

        UndoOp(IVersionableHandle itemHandle) {
            this.itemHandle = itemHandle;
        }

        public IVersionableHandle getItemHandle() {
            return this.itemHandle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WorkspaceConfigurationProxy
    implements IWorkspaceConfiguration {
        @Override
        public List<IComponentizedAncestorList> fetchAncestorsByName(String exactVersionableName, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                if (exactVersionableName == null || exactVersionableName.equals("")) {
                    throw new IllegalArgumentException();
                }
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                SCMClientUtil.checkMonitor(monitor);
                IComponentizedAncestorList[] reports = service.workspaceFindVersionablesByName(WorkspaceConnection.this.workspaceHandle, exactVersionableName, Connection.getSyncTimes(null), WorkspaceConnection.this.monitorFor(monitor));
                List<IComponentizedAncestorList> list = Arrays.asList(reports);
                return list;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public Map<UUID, Map<UUID, ? extends IVersionable>> fetchCompleteItems(List<? extends IComponentHandle> components, List<List<? extends IVersionableHandle>> versionableItemsByComponent, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                if (components == null) {
                    throw new IllegalArgumentException();
                }
                HashSet<UUID> componentIds = new HashSet<UUID>();
                HashMap<UUID, ServiceConfigurationProvider> configProviders = new HashMap<UUID, ServiceConfigurationProvider>((int)((double)components.size() / 0.75));
                for (IComponentHandle iComponentHandle : components) {
                    if (iComponentHandle == null) {
                        throw new IllegalArgumentException();
                    }
                    if (!componentIds.add(iComponentHandle.getItemId())) {
                        throw new IllegalArgumentException();
                    }
                    WorkspaceConnection.this.checkKnownComponent(iComponentHandle, monitor);
                    configProviders.put(iComponentHandle.getItemId(), ServiceConfigurationProvider.FACTORY.create(WorkspaceConnection.this.workspaceHandle, iComponentHandle));
                }
                if (versionableItemsByComponent == null) {
                    throw new IllegalArgumentException();
                }
                if (versionableItemsByComponent.size() != components.size()) {
                    throw new IllegalArgumentException();
                }
                boolean bl = false;
                int i = 0;
                ArrayList batches = new ArrayList();
                HashMap<UUID, ComponentizedFetchParameter> current = new HashMap<UUID, ComponentizedFetchParameter>();
                for (List<? extends IVersionableHandle> items : versionableItemsByComponent) {
                    ComponentizedFetchParameter param = ScmDtoFactory.eINSTANCE.createComponentizedFetchParameter();
                    IComponentHandle ch = components.get(i++);
                    current.put(ch.getItemId(), param);
                    if (items == null) {
                        throw new IllegalArgumentException();
                    }
                    for (IVersionableHandle iVersionableHandle : items) {
                        int n;
                        if (iVersionableHandle == null) {
                            throw new IllegalArgumentException();
                        }
                        if (n < 2048) {
                            param.getHandles().add(iVersionableHandle);
                            n += 1;
                            continue;
                        }
                        batches.add(current);
                        current = new HashMap();
                        param = ScmDtoFactory.eINSTANCE.createComponentizedFetchParameter();
                        n = 1;
                        current.put(ch.getItemId(), param);
                        param.getHandles().add(iVersionableHandle);
                    }
                }
                batches.add(current);
                SCMClientUtil.checkMonitor(monitor);
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                monitor.worked(20);
                HashMap<UUID, Map<UUID, ? extends IVersionable>> result = new HashMap<UUID, Map<UUID, ? extends IVersionable>>();
                for (UUID compId : componentIds) {
                    result.put(compId, new HashMap());
                }
                VersionableManager vman = (VersionableManager)WorkspaceConnection.this.workspaceManager().versionableManager();
                int ticks = 75 / batches.size();
                for (Map map : batches) {
                    int size = map.size();
                    ServiceConfigurationProvider[] cfgs = new ServiceConfigurationProvider[size];
                    ComponentizedFetchParameter[] parm = new ComponentizedFetchParameter[size];
                    UUID[] compId = new UUID[size];
                    int j = 0;
                    for (UUID componentId : map.keySet()) {
                        cfgs[j] = (ServiceConfigurationProvider)configProviders.get(componentId);
                        compId[j] = componentId;
                        parm[j++] = (ComponentizedFetchParameter)map.get(componentId);
                    }
                    ComponentizedFetchResult[] fromServer = service.configurationBatchFetch(cfgs, parm, null, null, WorkspaceConnection.this.monitorFor(monitor));
                    SCMClientUtil.checkMonitor(monitor);
                    monitor.worked(ticks);
                    j = 0;
                    while (j < size) {
                        UUID componentId = compId[j];
                        Map perComponent = (Map)result.get(componentId);
                        ComponentizedFetchResult r = fromServer[j];
                        i = 0;
                        while (i < r.getItemIds().size()) {
                            Object v = (IVersionable)r.getStates().get(i);
                            v = v.getStateId().equals((Object)ItemUtil.DELETED_UUID) ? null : (IVersionable)vman.applyItemStates(Collections.singletonList(v)).get(0);
                            UUID itemId = (UUID)r.getItemIds().get(i);
                            perComponent.put(itemId, v);
                            ++i;
                        }
                        ++j;
                    }
                }
                HashMap<UUID, Map<UUID, ? extends IVersionable>> hashMap = result;
                return hashMap;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public Map<UUID, Map<String, IVersionableHandle>> childEntriesForRoots(IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                SCMClientUtil.checkMonitor(monitor);
                ComponentizedFolderEntryReport[] fromServer = service.configurationBatchChildEntriesForRoot(WorkspaceConnection.this.workspaceHandle, Connection.getSyncTimes(null), WorkspaceConnection.this.monitorFor(monitor));
                HashMap<UUID, Map<String, IVersionableHandle>> result = new HashMap<UUID, Map<String, IVersionableHandle>>((int)((double)fromServer.length / 0.75));
                ComponentizedFolderEntryReport[] componentizedFolderEntryReportArray = fromServer;
                int n = fromServer.length;
                int n2 = 0;
                while (n2 < n) {
                    ComponentizedFolderEntryReport report = componentizedFolderEntryReportArray[n2];
                    result.put(report.getComponent().getItemId(), report.getReport().getEntries());
                    ++n2;
                }
                HashMap<UUID, Map<String, IVersionableHandle>> hashMap = result;
                return hashMap;
            }
            finally {
                monitor.done();
            }
        }
    }
}

