/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.Component;
import com.ibm.team.scm.common.internal.ComponentEntry;
import com.ibm.team.scm.common.internal.ComponentOwnerHandle;
import com.ibm.team.scm.common.internal.Configuration;
import com.ibm.team.scm.common.internal.ConfigurationHandle;
import com.ibm.team.scm.common.internal.StateSelection;
import com.ibm.team.scm.common.internal.Versionable;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryItemProvider
implements ItemProvider {
    private final IItemManager itemManager;
    private final IVersionableManager versionableManager;
    private final IWorkspaceManager mgr;

    public RepositoryItemProvider(ITeamRepository repo) {
        this.itemManager = repo.itemManager();
        this.versionableManager = SCMPlatform.getWorkspaceManager(repo).versionableManager();
        this.mgr = SCMPlatform.getWorkspaceManager(repo);
    }

    public List<IManagedItem> fetchItems(List<? extends IManagedItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.itemManager.fetchCompleteItems(handles, 1, monitor);
    }

    public List<IAuditable> fetchStates(List<? extends IAuditableHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.itemManager.fetchCompleteStates(handles, monitor);
    }

    public Collection<StateSelection> fetchStateSelections(ConfigurationHandle configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Configuration config = (Configuration)this.itemManager.fetchCompleteItem((IItemHandle)configuration, 1, (IProgressMonitor)progress.newChild(20));
        Configuration baseConfig = null;
        if (!config.getOverridesConfiguration().sameItemId((IItemHandle)config)) {
            List cfgs = this.itemManager.fetchCompleteItems(Arrays.asList(config.getOverridesConfiguration(), config.getBaseConfiguration()), 1, (IProgressMonitor)progress.newChild(80));
            config = (Configuration)cfgs.get(0);
            baseConfig = (Configuration)cfgs.get(1);
        } else if (config.getBaseConfiguration() != null) {
            baseConfig = (Configuration)this.itemManager.fetchCompleteItem((IItemHandle)config.getBaseConfiguration(), 1, (IProgressMonitor)progress.newChild(80));
        }
        if (baseConfig == null) {
            progress.done();
            return config.getSelections();
        }
        if (config.getSelections().isEmpty()) {
            progress.done();
            return baseConfig.getSelections();
        }
        HashMap<UUID, StateSelection> selections = new HashMap<UUID, StateSelection>((int)(config.getNumSelectionsInBase() * 2L));
        for (StateSelection sel : baseConfig.getSelections()) {
            if (sel.getState() == null) continue;
            selections.put(sel.getItem().getItemId(), sel);
        }
        for (StateSelection sel : config.getSelections()) {
            if (sel.getState() != null) {
                selections.put(sel.getItem().getItemId(), sel);
                continue;
            }
            selections.remove(sel.getItem().getItemId());
        }
        progress.done();
        return selections.values();
    }

    public List<ItemProvider.VRecord> fetchVersionables(List<? extends IVersionableHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        List versionables = this.versionableManager.fetchCompleteStates(handles, monitor);
        ArrayList<ItemProvider.VRecord> result = new ArrayList<ItemProvider.VRecord>(versionables.size());
        for (Versionable v : versionables) {
            result.add(new ItemProvider.VRecord(v.getParentId(), v.getStateId(), v.getName()));
        }
        return result;
    }

    public String getRepositoryURI() {
        return this.itemManager.teamRepository().getRepositoryURI();
    }

    public IManagedItem fetchItem(IManagedItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IManagedItem)this.itemManager.fetchCompleteItem((IItemHandle)handle, 1, monitor);
    }

    public Collection<ComponentEntry> fetchComponentEntriesFor(IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return ((WorkspaceManager)this.mgr).getComponentEntries(workspace, (IProgressMonitor)progress);
    }

    public int maxItemsPerRequest() {
        return Integer.MAX_VALUE;
    }

    public int maxStatesPerRequest() {
        return Integer.MAX_VALUE;
    }

    public int maxVersionablesPerRequest() {
        return Integer.MAX_VALUE;
    }

    public ConfigurationHandle getConfiguration(ChangeHistoryHandle chh) throws TeamRepositoryException {
        return ((WorkspaceManager)this.mgr).getConfigurationForHistory(chh);
    }

    public ComponentOwnerHandle getOwnerRecord(Component component, IProgressMonitor monitor) throws TeamRepositoryException {
        return ((WorkspaceManager)this.mgr).getOwnerRecord(component);
    }

    public List<IAuditableHandle> getComponentOwners(List<IComponentHandle> components, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.mgr.findOwnersForComponents(components, monitor);
    }

    public IContributor getLoggedInContributor() throws TeamRepositoryException {
        return this.itemManager.teamRepository().loggedInContributor();
    }
}

