/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.FlowEntry;
import com.ibm.team.scm.common.internal.RemoteDescriptor;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowTable
implements IFlowTable {
    private final boolean isWorkingCopy;
    private List<IFlowEntry> acceptEntries;
    private List<IFlowEntry> deliverEntries;
    private CurrentFlows currentFlows;
    private Map<IComponentHandle, CurrentFlows> currentComponentFlows = new TreeMap<IComponentHandle, CurrentFlows>(ItemUtil.itemIdComparator);
    private static final String SCOPED_DESCRIPTION = "Scoped";

    FlowTable(IFlowTable table, boolean workingCopy) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.isWorkingCopy = workingCopy;
        this.acceptEntries = new ArrayList<IFlowEntry>(EcoreUtil.copyAll((Collection)table.acceptSources()));
        this.deliverEntries = new ArrayList<IFlowEntry>(EcoreUtil.copyAll((Collection)table.deliverTargets()));
        this.currentFlows = (CurrentFlows)EcoreUtil.copy((EObject)((EObject)((FlowTable)table).getCurrentFlows()));
        Map<IComponentHandle, CurrentFlows> tableCurrentComponentFlows = ((FlowTable)table).getCurrentComponentFlows();
        for (Map.Entry<IComponentHandle, CurrentFlows> entry : tableCurrentComponentFlows.entrySet()) {
            this.currentComponentFlows.put((IComponentHandle)EcoreUtil.copy((EObject)((EObject)entry.getKey())), (CurrentFlows)EcoreUtil.copy((EObject)((EObject)entry.getValue())));
        }
    }

    public IFlowTable getWorkingCopy() {
        return new FlowTable(this, true);
    }

    public FlowTable() {
        this(new FlowEntry[0], ScmFactory.eINSTANCE.createCurrentFlows(), new TreeMap<IComponentHandle, CurrentFlows>(ItemUtil.itemIdComparator));
    }

    public FlowTable(FlowEntry[] specifiedEntries, CurrentFlows currentFlows, Map<IComponentHandle, CurrentFlows> currentComponentFlows) {
        if (specifiedEntries == null) {
            throw new IllegalArgumentException();
        }
        this.isWorkingCopy = false;
        this.acceptEntries = new ArrayList<IFlowEntry>(specifiedEntries.length);
        this.deliverEntries = new ArrayList<IFlowEntry>(specifiedEntries.length);
        boolean foundCurrentAccept = currentFlows.getCurrentAcceptFlow() == null;
        boolean foundDefaultAccept = currentFlows.getDefaultAcceptFlow() == null;
        boolean foundCurrentDeliver = currentFlows.getCurrentDeliverFlow() == null;
        boolean foundDefaultDeliver = currentFlows.getDefaultDeliverFlow() == null;
        int i = 0;
        while (i < specifiedEntries.length) {
            if (specifiedEntries[i] == null) {
                throw new IllegalArgumentException();
            }
            FlowEntry entry = (FlowEntry)EcoreUtil.copy((EObject)((EObject)specifiedEntries[i]));
            if ((entry.getFlags() & 1) != 0) {
                this.acceptEntries.add((IFlowEntry)entry);
                if (entry.getFlowNode().getItemId().equals((Object)currentFlows.getCurrentAcceptFlow())) {
                    foundCurrentAccept = true;
                }
                if (entry.getFlowNode().getItemId().equals((Object)currentFlows.getDefaultAcceptFlow())) {
                    foundDefaultAccept = true;
                }
            } else if ((entry.getFlags() & 2) != 0) {
                this.deliverEntries.add((IFlowEntry)entry);
                if (entry.getFlowNode().getItemId().equals((Object)currentFlows.getCurrentDeliverFlow())) {
                    foundCurrentDeliver = true;
                }
                if (entry.getFlowNode().getItemId().equals((Object)currentFlows.getDefaultDeliverFlow())) {
                    foundDefaultDeliver = true;
                }
            }
            ++i;
        }
        if (!foundCurrentAccept) {
            throw new IllegalArgumentException("Specified current accept flow is not in the list of specified entries");
        }
        if (!foundDefaultAccept) {
            throw new IllegalArgumentException("Specified default accept flow is not in the list of specified entries");
        }
        if (!foundCurrentDeliver) {
            throw new IllegalArgumentException("Specified current deliver flow is not in the list of specified entries");
        }
        if (!foundDefaultDeliver) {
            throw new IllegalArgumentException("Specified default deliver flow is not in the list of specified entries");
        }
        this.currentFlows = (CurrentFlows)EcoreUtil.copy((EObject)((EObject)currentFlows));
        for (Map.Entry<IComponentHandle, CurrentFlows> entry : currentComponentFlows.entrySet()) {
            this.currentComponentFlows.put(entry.getKey(), (CurrentFlows)EcoreUtil.copy((EObject)((EObject)entry.getValue())));
        }
    }

    public List deliverTargets() {
        return Collections.unmodifiableList(this.deliverEntries);
    }

    public List acceptSources() {
        return Collections.unmodifiableList(this.acceptEntries);
    }

    public void addDeliverFlow(IFlowNodeHandle target, UUID remoteRepoIdentifier, String remoteRepoURI, Collection componentScopes, String description) {
        Collection<IComponentHandle> typedScopes = this.checkComponentScopes(componentScopes);
        if (remoteRepoIdentifier != null && remoteRepoURI == null) {
            throw new IllegalArgumentException();
        }
        this.deliverEntries = this.addFlow(this.deliverEntries, target, remoteRepoIdentifier, remoteRepoURI, typedScopes, 2, description);
    }

    public void addAcceptFlow(IFlowNodeHandle source, UUID remoteRepoIdentifier, String remoteRepoURI, Collection componentScopes, String description) {
        Collection<IComponentHandle> typedScopes = this.checkComponentScopes(componentScopes);
        if (remoteRepoIdentifier != null && remoteRepoURI == null) {
            throw new IllegalArgumentException();
        }
        this.acceptEntries = this.addFlow(this.acceptEntries, source, remoteRepoIdentifier, remoteRepoURI, typedScopes, 1, description);
    }

    public IFlowEntry getAcceptFlow(IFlowNodeHandle source) {
        return this.getFlow(source, Collections.EMPTY_LIST, 1);
    }

    public IFlowEntry getAcceptFlow(IFlowNodeHandle source, Collection componentScopes) {
        Collection<IComponentHandle> typedScopes = this.checkComponentScopes(componentScopes);
        return this.getFlow(source, typedScopes, 1);
    }

    public IFlowEntry getDeliverFlow(IFlowNodeHandle target) {
        return this.getFlow(target, Collections.EMPTY_LIST, 2);
    }

    public IFlowEntry getDeliverFlow(IFlowNodeHandle target, Collection componentScopes) {
        Collection<IComponentHandle> typedScopes = this.checkComponentScopes(componentScopes);
        return this.getFlow(target, typedScopes, 2);
    }

    public void setFlowEntryDescription(IFlowEntry entry, String description) {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isWorkingCopy) {
            throw new IllegalStateException();
        }
        FlowEntry flowInTable = this.getFlow(entry.getFlowNode(), entry.getComponentScopes(), ((FlowEntry)entry).getFlags());
        if (flowInTable != entry) {
            throw new IllegalArgumentException();
        }
        flowInTable.setDescription(description);
    }

    public final CurrentFlows getCurrentFlows() {
        return this.currentFlows;
    }

    public final Map<IComponentHandle, CurrentFlows> getCurrentComponentFlows() {
        return this.currentComponentFlows;
    }

    public final IFlowEntry getCurrentAcceptFlow() {
        return this.getFlowEntry(this.acceptEntries, this.currentFlows.getCurrentAcceptFlow());
    }

    public final IFlowEntry getCurrentAcceptFlow(IComponentHandle component) {
        CurrentFlows flows = this.currentComponentFlows.get(component);
        if (flows == null) {
            return null;
        }
        return this.getFlowEntry(this.acceptEntries, flows.getCurrentAcceptFlow());
    }

    public final IFlowEntry getCurrentDeliverFlow() {
        return this.getFlowEntry(this.deliverEntries, this.currentFlows.getCurrentDeliverFlow());
    }

    public IFlowEntry getCurrentDeliverFlow(IComponentHandle component) {
        CurrentFlows flows = this.currentComponentFlows.get(component);
        if (flows == null) {
            return null;
        }
        return this.getFlowEntry(this.deliverEntries, flows.getCurrentDeliverFlow());
    }

    public final IFlowEntry getDefaultAcceptFlow() {
        return this.getFlowEntry(this.acceptEntries, this.currentFlows.getDefaultAcceptFlow());
    }

    public final IFlowEntry getDefaultAcceptFlow(IComponentHandle component) {
        CurrentFlows flows = this.currentComponentFlows.get(component);
        if (flows == null) {
            return null;
        }
        return this.getFlowEntry(this.acceptEntries, flows.getDefaultAcceptFlow());
    }

    public final IFlowEntry getDefaultDeliverFlow() {
        return this.getFlowEntry(this.deliverEntries, this.currentFlows.getDefaultDeliverFlow());
    }

    public final IFlowEntry getDefaultDeliverFlow(IComponentHandle component) {
        CurrentFlows flows = this.currentComponentFlows.get(component);
        if (flows == null) {
            return null;
        }
        return this.getFlowEntry(this.deliverEntries, flows.getDefaultDeliverFlow());
    }

    private IFlowEntry getFlowEntry(List<IFlowEntry> entriesList, UUID currentId) {
        for (IFlowEntry i : entriesList) {
            FlowEntry f = (FlowEntry)i;
            if (!f.getFlowNode().getItemId().equals((Object)currentId)) continue;
            return f;
        }
        return null;
    }

    public void setCurrent(IFlowEntry entry) {
        FlowEntry flowInTable = this.getFlowInTable(entry);
        if ((flowInTable.getFlags() & 1) != 0) {
            this.currentFlows.setCurrentAcceptFlow(flowInTable.getFlowNode().getItemId());
        } else if ((flowInTable.getFlags() & 2) != 0) {
            this.currentFlows.setCurrentDeliverFlow(flowInTable.getFlowNode().getItemId());
        }
    }

    public void setCurrent(IFlowEntry entry, IComponentHandle component) {
        FlowEntry flowInTable = this.getFlowInTable(entry);
        CurrentFlows flows = this.getOrCreateCurrentFlows(component);
        if ((flowInTable.getFlags() & 1) != 0) {
            flows.setCurrentAcceptFlow(flowInTable.getFlowNode().getItemId());
        } else if ((flowInTable.getFlags() & 2) != 0) {
            flows.setCurrentDeliverFlow(flowInTable.getFlowNode().getItemId());
        }
    }

    public void setDefault(IFlowEntry entry) {
        FlowEntry flowInTable = this.getFlowInTable(entry);
        if ((flowInTable.getFlags() & 1) != 0) {
            this.currentFlows.setDefaultAcceptFlow(flowInTable.getFlowNode().getItemId());
        } else if ((flowInTable.getFlags() & 2) != 0) {
            this.currentFlows.setDefaultDeliverFlow(flowInTable.getFlowNode().getItemId());
        }
    }

    public void setDefault(IFlowEntry entry, IComponentHandle component) {
        FlowEntry flowInTable = this.getFlowInTable(entry);
        CurrentFlows flows = this.getOrCreateCurrentFlows(component);
        if ((flowInTable.getFlags() & 1) != 0) {
            flows.setDefaultAcceptFlow(flowInTable.getFlowNode().getItemId());
        } else if ((flowInTable.getFlags() & 2) != 0) {
            flows.setDefaultDeliverFlow(flowInTable.getFlowNode().getItemId());
        }
    }

    private FlowEntry getFlowInTable(IFlowEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isWorkingCopy) {
            throw new IllegalStateException();
        }
        FlowEntry flowInTable = this.getFlow(entry.getFlowNode(), entry.getComponentScopes(), ((FlowEntry)entry).getFlags());
        if (flowInTable != entry) {
            throw new IllegalArgumentException();
        }
        return flowInTable;
    }

    private CurrentFlows getOrCreateCurrentFlows(IComponentHandle component) {
        CurrentFlows flows = this.getCurrentFlows(component);
        if (flows == null) {
            flows = ScmFactory.eINSTANCE.createCurrentFlows();
            this.currentComponentFlows.put(component, flows);
        }
        return flows;
    }

    private CurrentFlows getCurrentFlows(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        return this.currentComponentFlows.get(component);
    }

    public void unsetCurrentAcceptFlow() {
        this.currentFlows.unsetCurrentAcceptFlow();
    }

    public void unsetCurrentAcceptFlow(IComponentHandle component) {
        CurrentFlows flows = this.getCurrentFlows(component);
        if (flows != null) {
            flows.unsetCurrentAcceptFlow();
        }
    }

    public void unsetCurrentDeliverFlow() {
        this.currentFlows.unsetCurrentDeliverFlow();
    }

    public void unsetCurrentDeliverFlow(IComponentHandle component) {
        CurrentFlows flows = this.getCurrentFlows(component);
        if (flows != null) {
            flows.unsetCurrentDeliverFlow();
        }
    }

    public void unsetDefaultAcceptFlow() {
        this.currentFlows.unsetDefaultAcceptFlow();
    }

    public void unsetDefaultAcceptFlow(IComponentHandle component) {
        CurrentFlows flows = this.getCurrentFlows(component);
        if (flows != null) {
            flows.unsetDefaultAcceptFlow();
        }
    }

    public void unsetDefaultDeliverFlow() {
        this.currentFlows.unsetDefaultDeliverFlow();
    }

    public void unsetDefaultDeliverFlow(IComponentHandle component) {
        CurrentFlows flows = this.getCurrentFlows(component);
        if (flows != null) {
            flows.unsetDefaultDeliverFlow();
        }
    }

    public void removeDeliverFlow(IFlowNodeHandle target) {
        this.deliverEntries = this.removeFlow(this.deliverEntries, target);
    }

    public void removeAcceptFlow(IFlowNodeHandle source) {
        this.acceptEntries = this.removeFlow(this.acceptEntries, source);
    }

    public void removeAll(IFlowNodeHandle target) {
        this.acceptEntries = this.removeFlow(this.acceptEntries, target);
        this.deliverEntries = this.removeFlow(this.deliverEntries, target);
    }

    private List removeFlow(List entries, IFlowNodeHandle target) {
        if (!this.isWorkingCopy) {
            throw new IllegalStateException();
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            FlowEntry f = (FlowEntry)it.next();
            if (!f.getFlowNode().sameItemId((IItemHandle)target)) continue;
            this.removeAndUnsetCurrentFlows(it, f);
        }
        return entries;
    }

    private void removeAndUnsetCurrentFlows(Iterator it, FlowEntry f) {
        it.remove();
        this.unsetCurrentFlows(f, this.currentFlows);
        for (CurrentFlows flows : this.currentComponentFlows.values()) {
            this.unsetCurrentFlows(f, flows);
        }
    }

    private void unsetCurrentFlows(FlowEntry f, CurrentFlows currentFlows) {
        if (f.getFlowNode().getItemId().equals((Object)currentFlows.getCurrentAcceptFlow())) {
            currentFlows.unsetCurrentAcceptFlow();
        }
        if (f.getFlowNode().getItemId().equals((Object)currentFlows.getCurrentDeliverFlow())) {
            currentFlows.unsetCurrentDeliverFlow();
        }
        if (f.getFlowNode().getItemId().equals((Object)currentFlows.getDefaultAcceptFlow())) {
            currentFlows.unsetDefaultAcceptFlow();
        }
        if (f.getFlowNode().getItemId().equals((Object)currentFlows.getDefaultDeliverFlow())) {
            currentFlows.unsetDefaultDeliverFlow();
        }
    }

    private List addFlow(List<IFlowEntry> entries, IFlowNodeHandle node, UUID remoteRepoId, String remoteRepoURI, Collection<IComponentHandle> componentScopes, int flowArc, String description) throws IllegalArgumentException {
        if (!this.isWorkingCopy) {
            throw new IllegalStateException();
        }
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (componentScopes == null) {
            throw new IllegalArgumentException();
        }
        Set componentIds = ConfigUtil.getItemIds(componentScopes);
        Iterator<IFlowEntry> it = entries.iterator();
        while (it.hasNext()) {
            FlowEntry entry = (FlowEntry)it.next();
            if (!entry.getFlowNode().sameItemId((IItemHandle)node)) continue;
            if (entry.getComponentScopes().isEmpty()) {
                this.removeAndUnsetCurrentFlows(it, entry);
                continue;
            }
            Map itemMap = ConfigUtil.tableForItems((Collection)entry.getComponentScopes());
            HashSet entryComponentIds = new HashSet(itemMap.keySet());
            if (entryComponentIds.removeAll(componentIds)) {
                if (entryComponentIds.isEmpty()) {
                    this.removeAndUnsetCurrentFlows(it, entry);
                    continue;
                }
                ArrayList<IComponentHandle> componentsToKeep = new ArrayList<IComponentHandle>(entryComponentIds.size());
                for (UUID iterId : entryComponentIds) {
                    componentsToKeep.add((IComponentHandle)itemMap.get(iterId));
                }
                entry.getComponentScopes().clear();
                entry.getComponentScopes().addAll(componentsToKeep);
                continue;
            }
            entry.getComponentScopes().addAll(componentScopes);
            return entries;
        }
        FlowEntry entry = ScmFactory.eINSTANCE.createFlowEntry();
        entry.setFlags(flowArc);
        if (!(node instanceof IWorkspaceHandle)) {
            throw new IllegalArgumentException();
        }
        entry.setTargetWorkspace((IWorkspaceHandle)node);
        entry.setDescription(description);
        if (remoteRepoId != null) {
            RemoteDescriptor remote = ScmFactory.eINSTANCE.createRemoteDescriptor();
            remote.setRepoRoot(remoteRepoId);
            remote.setRepoURI(remoteRepoURI);
            entry.setRemoteDescriptor(remote);
        }
        for (IComponentHandle component : componentScopes) {
            entry.addComponent(component);
        }
        entries.add((IFlowEntry)entry);
        return entries;
    }

    private FlowEntry getFlow(IFlowNodeHandle flowNode, Collection componentScopes, int flowArc) {
        if (flowNode == null) {
            throw new IllegalArgumentException();
        }
        List<IFlowEntry> toSearch = (flowArc & 1) != 0 ? this.acceptEntries : this.deliverEntries;
        Set expectedScopeIds = ConfigUtil.getItemIds((Collection)componentScopes);
        for (FlowEntry flowEntry : toSearch) {
            if (!flowEntry.getFlowNode().sameItemId((IItemHandle)flowNode)) continue;
            if (componentScopes.isEmpty()) {
                return flowEntry;
            }
            Set actualScopeIds = ConfigUtil.getItemIds((Collection)flowEntry.getComponentScopes());
            if (!actualScopeIds.equals(expectedScopeIds)) continue;
            return flowEntry;
        }
        return null;
    }

    private Collection<IComponentHandle> checkComponentScopes(Collection componentScopes) {
        if (componentScopes == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<UUID> componentIds = new HashSet<UUID>();
        for (Object scope : componentScopes) {
            if (scope == null) {
                throw new IllegalArgumentException();
            }
            if (!(scope instanceof IComponentHandle)) {
                throw new IllegalArgumentException();
            }
            if (componentIds.add(((IComponentHandle)scope).getItemId())) continue;
            throw new IllegalArgumentException();
        }
        return componentScopes;
    }

    public Collection getComponentScopes(IFlowNodeHandle node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        IFlowEntry deliverEntry = this.getDeliverFlow(node);
        if (deliverEntry == null || !SCOPED_DESCRIPTION.equals(deliverEntry.getDescription())) {
            return Collections.EMPTY_LIST;
        }
        IFlowEntry acceptEntry = this.getAcceptFlow(node);
        return acceptEntry == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(acceptEntry.getComponentScopes());
    }

    public void setComponentScopes(IFlowNodeHandle node, Collection componentScopes) {
        IFlowEntry deliverEntry;
        if (!this.isWorkingCopy) {
            throw new IllegalStateException();
        }
        if (node == null || componentScopes == null) {
            throw new IllegalStateException();
        }
        FlowEntry acceptEntry = (FlowEntry)this.getAcceptFlow(node);
        if (acceptEntry == null) {
            this.addAcceptFlow(node, null, null, Collections.EMPTY_LIST, "");
            acceptEntry = (FlowEntry)this.getAcceptFlow(node);
        }
        if ((deliverEntry = this.getDeliverFlow(node)) == null) {
            this.addDeliverFlow(node, null, null, Collections.EMPTY_LIST, "");
            deliverEntry = this.getDeliverFlow(node);
        }
        Iterator i = acceptEntry.getComponentScopes().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        acceptEntry.getComponentScopes().addAll(componentScopes);
        this.setFlowEntryDescription(deliverEntry, SCOPED_DESCRIPTION);
    }
}

