/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.content;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.content.AbstractDownloadHandler;
import com.ibm.team.scm.client.content.AbstractUploadHandler;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.content.ScmClientUtil;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProgressHandlingVersionedContentManagerSession<StoreContext, RetrieveContext> {
    private long startTime = -1L;
    private long lastMonitorUpdate = -1L;
    private static final long UPDATE_INTERVAL = 500000000L;
    private long transferCount = 0L;
    protected final long expectedTransfers;
    private long completedTransfers;
    private long completedBytes;
    protected final SubMonitor monitor;
    private final Object lock = new Object();
    private boolean externallyTrackedMonitoring;

    public ProgressHandlingVersionedContentManagerSession(String name, long totalWork, boolean externallyTrackedMonitoring, IProgressMonitor mon) {
        this.monitor = SubMonitor.convert((IProgressMonitor)mon, (String)name, (int)1000);
        this.expectedTransfers = totalWork;
        this.externallyTrackedMonitoring = externallyTrackedMonitoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementTransferCount(long howMuch) {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        Object object = this.lock;
        synchronized (object) {
            int oldWorked = this.expectedTransfers <= 0L ? 0 : (int)(this.completedTransfers * 1000L / this.expectedTransfers);
            this.completedTransfers += howMuch;
            int newWorked = this.expectedTransfers <= 0L ? 0 : (int)(this.completedTransfers * 1000L / this.expectedTransfers);
            if ((newWorked -= oldWorked) != 0) {
                this.monitor.worked(newWorked);
            }
            assert (this.completedTransfers <= this.expectedTransfers);
        }
        this.updateProgressMonitor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveContent(IVersionableHandle handle, IVersionedContent content, AbstractDownloadHandler<RetrieveContext> handler, RetrieveContext context) throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            ++this.transferCount;
        }
        this.internalRetrieveContent(handle, content, handler, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeContent(AbstractUploadHandler<StoreContext> handler) throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            ++this.transferCount;
        }
        this.internalStoreContent(handler);
    }

    protected abstract void internalRetrieveContent(IVersionableHandle var1, IVersionedContent var2, AbstractDownloadHandler<RetrieveContext> var3, RetrieveContext var4) throws TeamRepositoryException;

    protected abstract void internalStoreContent(AbstractUploadHandler<StoreContext> var1) throws TeamRepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logTransferStart() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.startTime == -1L) {
                this.startTime = System.nanoTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logTransferredBytes(long bytes) {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        Object object = this.lock;
        synchronized (object) {
            assert (this.transferCount > 0L);
            this.completedBytes += bytes;
        }
        this.updateProgressMonitor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logTransferCompleted() {
        boolean finished;
        boolean forceUpdate;
        Object object = this.lock;
        synchronized (object) {
            --this.transferCount;
            int oldWorked = 0;
            if (!this.externallyTrackedMonitoring && this.expectedTransfers > 0L) {
                oldWorked = (int)(this.completedTransfers * 1000L / this.expectedTransfers);
            }
            ++this.completedTransfers;
            if (!this.externallyTrackedMonitoring) {
                int newWorked = this.expectedTransfers <= 0L ? 0 : (int)(this.completedTransfers * 1000L / this.expectedTransfers);
                if ((newWorked -= oldWorked) != 0) {
                    this.monitor.worked(newWorked);
                }
            }
            assert (this.completedTransfers <= this.expectedTransfers);
            assert (this.transferCount >= 0L);
            forceUpdate = this.transferCount == 0L;
            finished = this.expectedTransfers == this.completedTransfers;
        }
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateProgressMonitor(forceUpdate);
        if (finished) {
            this.monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgressMonitor(boolean force) {
        long snapStartTime;
        long snapLastUpdate;
        long now = System.nanoTime();
        Object object = this.lock;
        synchronized (object) {
            snapLastUpdate = this.lastMonitorUpdate;
            snapStartTime = this.startTime;
        }
        if (force || snapLastUpdate == -1L || now - snapLastUpdate > 500000000L) {
            this.monitor.subTask(this.getDownloadStats(snapStartTime == -1L ? 0L : now - snapStartTime));
            object = this.lock;
            synchronized (object) {
                this.lastMonitorUpdate = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDownloadStats(long totalTime) {
        String ts;
        long transfersExpected;
        long transfersComplete;
        long bytesComplete;
        Object object = this.lock;
        synchronized (object) {
            bytesComplete = this.completedBytes;
            transfersComplete = this.completedTransfers;
            transfersExpected = this.expectedTransfers;
            if (totalTime == 0L) {
                ts = null;
            } else {
                double amt = (double)this.completedBytes / ((double)totalTime / 1.0E9);
                ts = ScmClientUtil.bytesAsHumanReadable((long)amt);
            }
        }
        if (ts != null) {
            return String.format(Messages.ProgressHandlingVersionedContentManagerSession_0, ScmClientUtil.bytesAsHumanReadable(bytesComplete), transfersComplete, transfersExpected, ts);
        }
        return String.format(Messages.ProgressHandlingVersionedContentManagerSession_1, ScmClientUtil.bytesAsHumanReadable(bytesComplete), transfersComplete, transfersExpected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCanceled() {
        Object object = this.lock;
        synchronized (object) {
            return this.monitor.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCompletedTransfers() {
        Object object = this.lock;
        synchronized (object) {
            return this.completedTransfers;
        }
    }
}

