/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.content;

import com.ibm.team.repository.client.util.ThreadPool;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.content.AbstractDownloadHandler;
import com.ibm.team.scm.client.content.AbstractUploadHandler;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.BasicVersionedContentManager;
import com.ibm.team.scm.client.content.CombinedCancellationMonitor;
import com.ibm.team.scm.client.content.ProgressHandlingVersionedContentManagerSession;
import com.ibm.team.scm.client.content.ProgressTrackingInputStream;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAsyncVersionedContentManagerSession<StoreContext, RetrieveContext>
extends ProgressHandlingVersionedContentManagerSession<StoreContext, RetrieveContext> {
    protected final BasicVersionedContentManager<StoreContext, RetrieveContext, ?> manager;
    protected final ThreadPool threadPool;

    public BasicAsyncVersionedContentManagerSession(int numThreads, boolean allowFailures, String name, long totalWork, BasicVersionedContentManager<StoreContext, RetrieveContext, ?> manager, IProgressMonitor mon) {
        super(name, totalWork, false, mon);
        this.manager = manager;
        this.threadPool = new ThreadPool(numThreads, allowFailures);
    }

    protected void join() throws TeamRepositoryException {
        try {
            this.threadPool.join();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected InputStream getInputStream(IVersionableHandle handle, IVersionedContent content, RetrieveContext context, IProgressMonitor mon) throws TeamRepositoryException {
        return this.manager.retrieveContentStream(handle, content, context, mon);
    }

    protected IStatus internalDoRetrieveContent(IVersionableHandle handle, IVersionedContent content, RetrieveContext context, AbstractDownloadHandler<RetrieveContext> handler, IProgressMonitor mon) {
        try {
            this.handleCancel(handle, content, context, handler);
            handler.downloadStart(handle, content, context);
            ProgressTrackingInputStream in = new ProgressTrackingInputStream(this.getInputStream(handle, content, context, (IProgressMonitor)new CombinedCancellationMonitor(mon, this)), this);
            try {
                handler.downloadStreamAcquired(handle, content, context, in);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
            this.handleCancel(handle, content, context, handler);
            handler.downloadCompleted(handle, content, context);
            this.handleCancel(handle, content, context, handler);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus statusToReturn;
            block15: {
                statusToReturn = null;
                if (e instanceof OperationCanceledException) {
                    statusToReturn = Status.CANCEL_STATUS;
                } else if (e.getCause() instanceof CoreException) {
                    statusToReturn = new MultiStatus("com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_0, (Throwable)e);
                    ((MultiStatus)statusToReturn).add(((CoreException)e.getCause()).getStatus());
                } else {
                    statusToReturn = new Status(4, "com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_0, (Throwable)e);
                }
                try {
                    handler.downloadFailed(handle, content, context, e);
                }
                catch (Exception unexpectedFailure) {
                    Object anotherError = unexpectedFailure instanceof OperationCanceledException ? Status.CANCEL_STATUS : new Status(4, statusToReturn.getPlugin(), 0, e.getMessage(), (Throwable)e);
                    if (statusToReturn instanceof MultiStatus) {
                        ((MultiStatus)statusToReturn).add(anotherError);
                        break block15;
                    }
                    statusToReturn = new MultiStatus(statusToReturn.getPlugin(), 0, new IStatus[]{statusToReturn, anotherError}, statusToReturn.getMessage(), null);
                }
            }
            return statusToReturn;
        }
    }

    @Override
    protected void internalRetrieveContent(final IVersionableHandle handle, final IVersionedContent content, final AbstractDownloadHandler<RetrieveContext> handler, final RetrieveContext context) throws TeamRepositoryException {
        ThreadPool.Task task = new ThreadPool.Task(){

            public IStatus run(IProgressMonitor mon) {
                return BasicAsyncVersionedContentManagerSession.this.internalDoRetrieveContent(handle, content, context, handler, mon);
            }
        };
        try {
            this.threadPool.addTask(task);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    protected IVersionedContent internalDoStoreContent(AbstractUploadHandler<StoreContext> handler, AbstractVersionedContentManagerInputStreamProvider provider, ContentHash predecessorHintHash, StoreContext ctx, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.manager.storeContent(provider, predecessorHintHash, ctx, monitor);
    }

    protected IStatus internalDoStoreContent(AbstractUploadHandler<StoreContext> handler, IProgressMonitor mon) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new CombinedCancellationMonitor(mon, this), (int)100);
        while (true) {
            try {
                this.handleCancel(handler);
                ContentHash predecessorHintHash = handler.getPredecessorHintHash();
                StoreContext ctx = handler.getContext();
                handler.uploadStart();
                final AbstractVersionedContentManagerInputStreamProvider wrappedStreamProvider = handler.getStreamProvider();
                AbstractVersionedContentManagerInputStreamProvider overridenProvider = new AbstractVersionedContentManagerInputStreamProvider(){

                    public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                        return wrappedStreamProvider.getInputStream(flags);
                    }

                    public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                        return new ProgressTrackingInputStream(wrappedStreamProvider.wrapInputStream(in), BasicAsyncVersionedContentManagerSession.this);
                    }

                    public void dispose() throws IOException, TeamRepositoryException {
                        wrappedStreamProvider.dispose();
                    }
                };
                IVersionedContent content = this.internalDoStoreContent(handler, overridenProvider, predecessorHintHash, ctx, (IProgressMonitor)progress.newChild(99));
                this.handleCancel(handler);
                handler.uploadCompleted(content);
                this.handleCancel(handler);
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                IStatus statusToReturn;
                block11: {
                    if (e instanceof OperationCanceledException) {
                        statusToReturn = Status.CANCEL_STATUS;
                    } else if (e.getCause() instanceof CoreException) {
                        statusToReturn = new MultiStatus("com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_1, (Throwable)e);
                        ((MultiStatus)statusToReturn).add(((CoreException)e.getCause()).getStatus());
                    } else {
                        statusToReturn = new Status(4, "com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_1, (Throwable)e);
                    }
                    try {
                        AbstractUploadHandler.UploadFailureDirection direction;
                        progress.setWorkRemaining(101);
                        if ((direction = handler.uploadFailed(e, (IProgressMonitor)progress.newChild(1))) == AbstractUploadHandler.UploadFailureDirection.RETRY) continue;
                        if (direction == AbstractUploadHandler.UploadFailureDirection.CONTINUE) {
                            statusToReturn = Status.OK_STATUS;
                        }
                    }
                    catch (Exception unexpectedFailure) {
                        Object anotherError = unexpectedFailure instanceof OperationCanceledException ? Status.CANCEL_STATUS : new Status(4, statusToReturn.getPlugin(), 0, e.getMessage(), (Throwable)e);
                        if (statusToReturn instanceof MultiStatus) {
                            ((MultiStatus)statusToReturn).add(anotherError);
                            break block11;
                        }
                        statusToReturn = new MultiStatus(statusToReturn.getPlugin(), 0, new IStatus[]{statusToReturn, anotherError}, statusToReturn.getMessage(), null);
                    }
                }
                return statusToReturn;
            }
            break;
        }
    }

    @Override
    protected void internalStoreContent(final AbstractUploadHandler<StoreContext> handler) throws TeamRepositoryException {
        ThreadPool.Task task = new ThreadPool.Task(){

            public IStatus run(IProgressMonitor mon) {
                return BasicAsyncVersionedContentManagerSession.this.internalDoStoreContent(handler, mon);
            }
        };
        try {
            this.threadPool.addTask(task);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    protected void handleCoreException(CoreException e) throws TeamRepositoryException {
        IStatus status = e.getStatus();
        assert (status.isOK()) : "Unexpected status value. An OK status should not be thrown.";
        if (status.matches(8)) {
            throw new OperationCanceledException();
        }
        try {
            throw new TeamRepositoryException(e.getStatus().getException().getMessage(), (Throwable)e);
        }
        catch (NullPointerException nullPointerException) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected void handleCancel(IVersionableHandle handle, IVersionedContent content, RetrieveContext ctx, AbstractDownloadHandler<RetrieveContext> handler) throws TeamRepositoryException {
        if (this.isCanceled()) {
            handler.downloadCanceled(handle, content, ctx);
            throw new OperationCanceledException();
        }
    }

    protected void handleCancel(AbstractUploadHandler<StoreContext> handler) throws TeamRepositoryException {
        if (this.isCanceled()) {
            handler.uploadCanceled();
            throw new OperationCanceledException();
        }
    }

    @Override
    protected boolean isCanceled() {
        boolean canceled = super.isCanceled();
        if (canceled) {
            this.threadPool.setCancellation(Status.CANCEL_STATUS);
        }
        return canceled || this.threadPool.isCanceled();
    }

    protected IStatus[] getErrorStatus() {
        return this.threadPool.getErrorStatus();
    }
}

