/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.content.BasicVersionedContentManager;
import com.ibm.team.scm.client.content.IVersionedContentManager;

public final class SCMPlatform {
    public static IWorkspaceManager getWorkspaceManager(ITeamRepository repo) {
        if (repo == null) {
            throw new IllegalArgumentException();
        }
        return (IWorkspaceManager)repo.getClientLibrary(IWorkspaceManager.class);
    }

    public static IVersionedContentManager getContentManager(ITeamRepository repo) {
        return SCMPlatform.getWorkspaceManager(repo).getSCMContentManager();
    }

    public static Object getClientLibrary(IItemHandle handle, Class clazz) {
        ITeamRepository repo = (ITeamRepository)handle.getOrigin();
        return repo.getClientLibrary(clazz);
    }

    public static void setMaxContentThreads(int count) {
        BasicVersionedContentManager.setMaxSimultaneousDownloads(count);
    }

    public static int getMaxContentThreads() {
        return BasicVersionedContentManager.getMaxSimultaneousDownloads();
    }

    private SCMPlatform() {
    }
}

