/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;

public final class ParmsLoadRule
implements IParameterWrapper {
    public String sandboxPath;
    public String relativeLoadPath;
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String loadRuleFileItemId;
    public String loadRuleFileContents;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.sandboxPath, requestName, parameterName, "sandboxPath");
        this.sandboxPath = ParmValidation.validCanonicalPath(this.sandboxPath, requestName, parameterName, "sandboxPath");
        if (this.relativeLoadPath != null && this.relativeLoadPath.trim().length() > 0) {
            this.relativeLoadPath = ParmValidation.validRelativeCanonicalPath(this.sandboxPath, this.relativeLoadPath, requestName, parameterName, "relativeLoadPath");
        }
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        ParmValidation.requiredValue(this.componentItemId, requestName, parameterName, "componentItemId");
        if (!(this.loadRuleFileContents != null && this.loadRuleFileContents.length() != 0 || this.loadRuleFileItemId != null && this.loadRuleFileItemId.length() != 0)) {
            throw new IllegalArgumentException(NLS.bind((String)"Either {0} or {1} must be supplied for {2} in {3} operation request", (Object)"loadRuleFileContents", (Object[])new Object[]{"loadRuleFileItemId", ParmValidation.getParameterName(parameterName), requestName}));
        }
        if (this.relativeLoadPath == null) {
            this.relativeLoadPath = "";
        }
    }

    public IComponentHandle getComponentHandle() {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }

    public IFileItemHandle getLoadRuleFileItemHandle() {
        if (this.loadRuleFileItemId == null || this.loadRuleFileItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.loadRuleFileItemId), null);
    }
}

