/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;

public final class ParmsContext
implements IParameterWrapper {
    public String repositoryUrl;
    public String itemId;
    public String type;

    public ParmsContext() {
    }

    public ParmsContext(String type, String url, String itemId) {
        this.type = type;
        this.repositoryUrl = url;
        this.itemId = itemId;
    }

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.repositoryUrl, requestName, parameterName, "repositoryUrl");
        ParmValidation.requiredValue(this.itemId, requestName, parameterName, "itemId");
        ParmValidation.inEnum(this.type, requestName, new String[]{"baseline", "baselineset", "workspace"}, parameterName, "type");
    }

    public IItemHandle getContextHandle() {
        if (this.type == null || this.itemId == null) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.repositoryUrl);
        UUID uuid = UUID.valueOf((String)this.itemId);
        if (this.type.equals("baseline")) {
            return IBaseline.ITEM_TYPE.createItemHandle((Object)repo, uuid, null);
        }
        if (this.type.equals("baselineset")) {
            return IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, uuid, null);
        }
        if (this.type.equals("workspace")) {
            return IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, uuid, null);
        }
        return null;
    }
}

