/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.operations;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class LockEntry {
    private ITeamRepository repo;
    private IWorkspaceHandle workspaceHandle;
    private IWorkspaceConnection workspaceConnection;
    private IComponentHandle componentHandle;
    private IVersionableHandle versionableHandle;
    private IContributorHandle contributorHandle;

    public LockEntry(ITeamRepository iTeamRepository, IWorkspaceHandle iWorkspaceHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IContributorHandle iContributorHandle) {
        this.repo = iTeamRepository;
        this.workspaceHandle = iWorkspaceHandle;
        this.componentHandle = iComponentHandle;
        this.versionableHandle = iVersionableHandle;
        this.contributorHandle = iContributorHandle;
    }

    public LockEntry(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IContributorHandle iContributorHandle) {
        this(iWorkspaceConnection.teamRepository(), (IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), iComponentHandle, iVersionableHandle, iContributorHandle);
        this.workspaceConnection = iWorkspaceConnection;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public IWorkspaceHandle getStream() {
        return this.workspaceHandle;
    }

    public IComponentHandle getComponent() {
        return this.componentHandle;
    }

    public IVersionableHandle getVersionable() {
        return this.versionableHandle;
    }

    public IContributorHandle getContributor() {
        return this.contributorHandle;
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (this.workspaceConnection == null) {
            this.workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo).getWorkspaceConnection(this.workspaceHandle, iProgressMonitor);
        }
        return this.workspaceConnection;
    }

    public static List createEntries(ITeamRepository iTeamRepository, IStreamLockReport iStreamLockReport) {
        ArrayList<LockEntry> arrayList = new ArrayList<LockEntry>();
        IWorkspaceHandle iWorkspaceHandle = iStreamLockReport.getStream();
        for (IComponentLockReport iComponentLockReport : iStreamLockReport.getComponentLocks()) {
            IComponentHandle iComponentHandle = iComponentLockReport.getComponent();
            for (IVersionableLock iVersionableLock : iComponentLockReport.getLocks()) {
                arrayList.add(new LockEntry(iTeamRepository, iWorkspaceHandle, iComponentHandle, iVersionableLock.getVersionable(), iVersionableLock.getContributor()));
            }
        }
        return arrayList;
    }
}

