/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommitDilemmaHandler
extends UpdateDilemmaHandler {
    private static CommitDilemmaHandler instance;

    public static CommitDilemmaHandler getDefault() {
        if (instance == null) {
            instance = new CommitDilemmaHandler();
        }
        return instance;
    }

    protected CommitDilemmaHandler() {
    }

    public int lineDelimiterErrors(Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        int n = 0;
        for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : collection) {
            if (iLineDelimiterUploadFailure.isAtomicCommit()) continue;
            iLineDelimiterUploadFailure.setSkipFailure(true);
            ++n;
        }
        if (n > 0) {
            return 0;
        }
        return 2;
    }

    public int encodingErrors(Collection collection, IProgressMonitor iProgressMonitor) {
        int n = 0;
        for (IEncodingUploadFailure iEncodingUploadFailure : collection) {
            if (iEncodingUploadFailure.isUnknownEncoding() || iEncodingUploadFailure.isMalformedContent()) {
                if (iEncodingUploadFailure.getOriginalEncoding() == null) {
                    iEncodingUploadFailure.setIgnoreEncoding(true);
                    ++n;
                    continue;
                }
                if (!iEncodingUploadFailure.getEncoding().equals(iEncodingUploadFailure.getOriginalEncoding()) && iEncodingUploadFailure.getOriginalEncoding() != null) {
                    try {
                        if (Charset.isSupported(iEncodingUploadFailure.getOriginalEncoding())) {
                            iEncodingUploadFailure.setAlternativeEncoding(iEncodingUploadFailure.getOriginalEncoding());
                            ++n;
                            continue;
                        }
                    }
                    catch (IllegalCharsetNameException illegalCharsetNameException) {}
                }
            }
            if (iEncodingUploadFailure.isAtomicCommit()) continue;
            iEncodingUploadFailure.setSkipFailure(true);
            ++n;
        }
        if (n != 0) {
            return 0;
        }
        return 2;
    }

    public int nonAtomicCommit(IWorkspaceConnection iWorkspaceConnection, int n, int n2) {
        return 0;
    }

    public static /* bridge */ /* synthetic */ UpdateDilemmaHandler getDefault() {
        return CommitDilemmaHandler.getDefault();
    }
}

