/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.StringMatcher$Position;
import java.util.Vector;

public class StringMatcher {
    protected String fPattern;
    protected int fLength;
    protected boolean fIgnoreWildCards;
    protected boolean fIgnoreCase;
    protected boolean fHasLeadingStar;
    protected boolean fHasTrailingStar;
    protected String[] fSegments;
    protected int fBound = 0;
    private String fOriginalPattern;
    protected static final char fSingleWildCard = '\u0000';

    public StringMatcher$Position find(String string, int n, int n2) {
        if (this.fPattern == null || string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        int n3 = string.length();
        if (n < 0) {
            n = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < 0 || n >= n2) {
            return null;
        }
        if (this.fLength == 0) {
            return new StringMatcher$Position(n, n);
        }
        if (this.fIgnoreWildCards) {
            int n4 = this.posIn(string, n, n2);
            if (n4 < 0) {
                return null;
            }
            return new StringMatcher$Position(n4, n4 + this.fLength);
        }
        int n5 = this.fSegments.length;
        if (n5 == 0) {
            return new StringMatcher$Position(n, n2);
        }
        int n6 = n;
        int n7 = -1;
        int n8 = 0;
        while (n8 < n5 && n6 < n2) {
            String string2 = this.fSegments[n8];
            int n9 = this.regExpPosIn(string, n6, n2, string2);
            if (n9 < 0) {
                return null;
            }
            if (n8 == 0) {
                n7 = n9;
            }
            n6 = n9 + string2.length();
            ++n8;
        }
        if (n8 < n5) {
            return null;
        }
        return new StringMatcher$Position(n7, n6);
    }

    public StringMatcher(String string, boolean bl, boolean bl2) {
        this.fIgnoreCase = bl;
        this.fIgnoreWildCards = bl2;
        this.fLength = string.length();
        this.fOriginalPattern = string;
        this.fPattern = this.fIgnoreCase ? string.toUpperCase() : string;
        if (this.fIgnoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    public boolean isIgnoreCase() {
        return this.fIgnoreCase;
    }

    public String getPattern() {
        return this.fOriginalPattern;
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String var1_1, int var2_2, int var3_3) {
        if (var1_1 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (var2_2 > var3_3) {
            return false;
        }
        if (this.fIgnoreWildCards) {
            return var3_3 - var2_2 == this.fLength && this.fPattern.regionMatches(this.fIgnoreCase, 0, var1_1, var2_2, this.fLength) != false;
        }
        var4_4 = this.fSegments.length;
        if (var4_4 == 0 && (this.fHasLeadingStar || this.fHasTrailingStar)) {
            return true;
        }
        if (var2_2 == var3_3) {
            return this.fLength == 0;
        }
        if (this.fLength == 0) {
            return var2_2 == var3_3;
        }
        var5_5 = var1_1.length();
        if (var2_2 < 0) {
            var2_2 = 0;
        }
        if (var3_3 > var5_5) {
            var3_3 = var5_5;
        }
        var6_6 = var2_2;
        var7_7 = var3_3 - this.fBound;
        if (var7_7 < 0) {
            return false;
        }
        var8_8 = 0;
        var9_9 = this.fSegments[var8_8];
        var10_10 = var9_9.length();
        if (!this.fHasLeadingStar) {
            if (!this.regExpRegionMatches(var1_1, var2_2, var9_9, 0, var10_10)) {
                return false;
            }
            ++var8_8;
            var6_6 += var10_10;
        }
        if (this.fSegments.length != 1 || this.fHasLeadingStar || this.fHasTrailingStar) ** GOTO lbl39
        return var6_6 == var3_3;
lbl-1000:
        // 1 sources

        {
            var9_9 = this.fSegments[var8_8];
            var12_12 = var9_9.indexOf(0);
            if (var12_12 < 0 ? (var11_11 = this.textPosIn(var1_1, var6_6, var3_3, var9_9)) < 0 : (var11_11 = this.regExpPosIn(var1_1, var6_6, var3_3, var9_9)) < 0) {
                return false;
            }
            var6_6 = var11_11 + var9_9.length();
            ++var8_8;
lbl39:
            // 2 sources

            ** while (var8_8 < var4_4)
        }
lbl40:
        // 1 sources

        if (!this.fHasTrailingStar && var6_6 != var3_3) {
            var11_11 = var9_9.length();
            return this.regExpRegionMatches(var1_1, var3_3 - var11_11, var9_9, 0, var11_11);
        }
        return var8_8 == var4_4;
    }

    public boolean match(String string) {
        return this.match(string, 0, string.length());
    }

    private void parseNoWildCards() {
        this.fSegments = new String[1];
        this.fSegments[0] = this.fPattern;
        this.fBound = this.fLength;
    }

    private void parseWildCards() {
        if (this.fPattern.startsWith("*")) {
            this.fHasLeadingStar = true;
        }
        if (this.fPattern.endsWith("*") && this.fLength > 1 && this.fPattern.charAt(this.fLength - 2) != '\\') {
            this.fHasTrailingStar = true;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block5: while (n < this.fLength) {
            char c = this.fPattern.charAt(n++);
            switch (c) {
                case '\\': {
                    char c2;
                    if (n >= this.fLength) {
                        stringBuffer.append(c);
                        break;
                    }
                    if ((c2 = this.fPattern.charAt(n++)) == '*' || c2 == '?' || c2 == '\\') {
                        stringBuffer.append(c2);
                        break;
                    }
                    stringBuffer.append(c);
                    stringBuffer.append(c2);
                    break;
                }
                case '*': {
                    if (stringBuffer.length() <= 0) continue block5;
                    vector.addElement(stringBuffer.toString());
                    this.fBound += stringBuffer.length();
                    stringBuffer.setLength(0);
                    break;
                }
                case '?': {
                    stringBuffer.append('\u0000');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
            this.fBound += stringBuffer.length();
        }
        this.fSegments = new String[vector.size()];
        vector.copyInto(this.fSegments);
    }

    protected int posIn(String string, int n, int n2) {
        int n3 = n2 - this.fLength;
        if (!this.fIgnoreCase) {
            int n4 = string.indexOf(this.fPattern, n);
            if (n4 == -1 || n4 > n3) {
                return -1;
            }
            return n4;
        }
        int n5 = n;
        while (n5 <= n3) {
            if (string.regionMatches(true, n5, this.fPattern, 0, this.fLength)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    protected int regExpPosIn(String string, int n, int n2, String string2) {
        int n3 = string2.length();
        int n4 = n2 - n3;
        int n5 = n;
        while (n5 <= n4) {
            if (this.regExpRegionMatches(string, n5, string2, 0, n3)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String string, int n, String string2, int n2, int n3) {
        while (n3-- > 0) {
            char c;
            char c2 = string.charAt(n++);
            char c3 = string2.charAt(n2++);
            if (!this.fIgnoreWildCards && c3 == '\u0000' || c3 == c2 || this.fIgnoreCase && (c = Character.toUpperCase(c2)) == c3) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String string, int n, int n2, String string2) {
        int n3 = string2.length();
        int n4 = n2 - n3;
        if (!this.fIgnoreCase) {
            int n5 = string.indexOf(string2, n);
            if (n5 == -1 || n5 > n4) {
                return -1;
            }
            return n5;
        }
        int n6 = n;
        while (n6 <= n4) {
            if (string.regionMatches(true, n6, string2, 0, n3)) {
                return n6;
            }
            ++n6;
        }
        return -1;
    }

    public boolean containsWildcards() {
        if (this.fHasLeadingStar || this.fHasTrailingStar || this.fSegments.length > 1) {
            return true;
        }
        String[] stringArray = this.fSegments;
        int n = this.fSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.indexOf(0) >= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

