/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class PathUtils {
    public static IPath getPath(List list) {
        return PathUtils.getPath(list.toArray(new String[list.size()]));
    }

    public static IPath getPath(String[] stringArray) {
        return (IPath)new Path(PathUtils.getString(stringArray));
    }

    public static File getFile(File file, String[] stringArray) {
        return new File(file, PathUtils.getString(stringArray));
    }

    public static String getString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append('/').append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static IPath getPath(IPath iPath, String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < stringArray.length) {
            stringBuffer.append('/').append(stringArray[n2]);
            ++n2;
        }
        return iPath.append(stringBuffer.toString());
    }

    public static IPath getPath(IPath iPath, String[] stringArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        n2 = Math.min(stringArray.length, n2);
        int n3 = n;
        while (n3 < n2) {
            stringBuffer.append('/').append(stringArray[n3]);
            ++n3;
        }
        if (iPath == null) {
            iPath = new Path("/");
        }
        return iPath.append(stringBuffer.toString());
    }

    /*
     * Unable to fully structure code
     */
    public static boolean samePath(IPath var0, boolean var1_1, IPath var2_2, boolean var3_3) {
        var4_4 = var1_1 & var3_3;
        if (var0 == null ? var2_2 != null : var2_2 == null) {
            return false;
        }
        var5_5 = var2_2.segments();
        var6_6 = var0.segments();
        var7_7 = var6_6.length;
        if (var7_7 == var5_5.length) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (!(var4_4 != false ? var6_6[var7_7].equals(var5_5[var7_7]) == false : var6_6[var7_7].equalsIgnoreCase(var5_5[var7_7]) == false)) continue;
            return false;
lbl11:
            // 2 sources

            ** while (--var7_7 >= 0)
        }
lbl12:
        // 1 sources

        var8_8 = var0.getDevice();
        var9_9 = var2_2.getDevice();
        if (var4_4) {
            return var8_8 == var9_9 || var8_8 != null && var8_8.equals(var9_9) != false;
        }
        return var8_8 == var9_9 || var8_8 != null && var8_8.equalsIgnoreCase(var9_9) != false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sameRelativePath(IPath var0, boolean var1_1, IPath var2_2, boolean var3_3) {
        var4_4 = var1_1 & var3_3;
        if (var0 == null ? var2_2 != null : var2_2 == null) {
            return false;
        }
        var5_5 = var2_2.segments();
        var6_6 = var0.segments();
        var7_7 = var6_6.length;
        if (var7_7 == var5_5.length) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (!(var4_4 != false ? var6_6[var7_7].equals(var5_5[var7_7]) == false : var6_6[var7_7].equalsIgnoreCase(var5_5[var7_7]) == false)) continue;
            return false;
lbl11:
            // 2 sources

            ** while (--var7_7 >= 0)
        }
lbl12:
        // 1 sources

        return true;
    }

    public static boolean isPrefixOf(IPath iPath, boolean bl, IPath iPath2) {
        if (iPath.getDevice() == null || iPath.getDevice().length() == 0 ? iPath2.getDevice() != null && iPath2.getDevice().length() != 0 : !iPath.getDevice().equalsIgnoreCase(iPath2.getDevice())) {
            return false;
        }
        if (iPath.isEmpty() || iPath.isRoot() && iPath2.isAbsolute()) {
            return true;
        }
        int n = iPath.segmentCount();
        if (n > iPath2.segmentCount()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (bl ? !iPath.segment(n2).equals(iPath2.segment(n2)) : !iPath.segment(n2).equalsIgnoreCase(iPath2.segment(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean overlapsButNotEqual(IPath iPath, boolean bl, IPath iPath2, boolean bl2) {
        boolean bl3 = bl & bl2;
        if (iPath.getDevice() == null || iPath.getDevice().length() == 0 ? iPath2.getDevice() != null && iPath2.getDevice().length() != 0 : !iPath.getDevice().equalsIgnoreCase(iPath2.getDevice())) {
            return false;
        }
        if (iPath.isEmpty() || iPath.isRoot() && iPath2.isAbsolute()) {
            return true;
        }
        if (iPath.segmentCount() == iPath2.segmentCount()) {
            return false;
        }
        int n = Math.min(iPath.segmentCount(), iPath2.segmentCount());
        int n2 = 0;
        while (n2 < n) {
            if (bl3 ? !iPath.segment(n2).equals(iPath2.segment(n2)) : !iPath.segment(n2).equalsIgnoreCase(iPath2.segment(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isLoadedWithAnotherName(ISandbox iSandbox, IPath iPath, String string) {
        boolean bl = iSandbox.isCaseSensitive() ? !iPath.lastSegment().equals(string) : !iPath.lastSegment().toLowerCase().equals(string.toLowerCase());
        return bl;
    }

    public static String getRealPath(String string) {
        try {
            return ManagedFileStore.getResolvedPath(string);
        }
        catch (CoreException coreException) {
            return new File(string).getAbsolutePath();
        }
    }

    public static boolean exists(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IFileInfo iFileInfo;
        block3: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath);
            try {
                iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(100));
                if (!iFileInfo.getAttribute(32)) break block3;
                return true;
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.PathUtils_0, (Object)iPath.toString(), (Object[])new Object[0]), (Throwable)coreException)));
            }
        }
        return iFileInfo.exists();
    }

    public static ResourceType getResourceType(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath);
        try {
            IFileInfo iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(100));
            if (iFileInfo.getAttribute(32)) {
                return ResourceType.SYMBOLIC_LINK;
            }
            if (iFileInfo.isDirectory()) {
                return ResourceType.FOLDER;
            }
            if (iFileInfo.exists()) {
                return ResourceType.FILE;
            }
            return null;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.PathUtils_1, (Object)iPath.toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
    }
}

