/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$IIgnoreReason;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider$IIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreUtils {
    public static void findIgnoresForEvent(final IIgnoreEvent event, final IIgnoredForRuleController listener) throws FileSystemClientException {
        final Exception[] exception = new Exception[1];
        IIgnoreManager localManager = null;
        try {
            localManager = (IIgnoreManager)event.getEventSource();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Could not cast an ignore event to be an IIgnoreManager", e);
        }
        final IIgnoreManager manager = localManager;
        for (IShareable root : event.getRoots()) {
            ((Shareable)root).getFileStorage().accept(new IFileStorageVisitor(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean visit(IFileStorage storage, IProgressMonitor progress) {
                    if (exception[0] != null) {
                        return false;
                    }
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
                    try {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        Shareable shareable = storage.getShareable();
                        if (!event.isEffectiveBelow(shareable)) {
                            return false;
                        }
                        if (listener.shouldSkip(null, shareable, (IProgressMonitor)monitor.newChild(1))) {
                            return false;
                        }
                        if (!manager.shouldBeIgnored(shareable, (IProgressMonitor)monitor.newChild(1))) return true;
                        listener.addIgnored(null, shareable, (IProgressMonitor)monitor.newChild(1));
                        return false;
                    }
                    catch (FileSystemClientException e) {
                        exception[0] = e;
                        return false;
                    }
                    finally {
                        monitor.done();
                    }
                }
            }, Integer.MAX_VALUE, null);
        }
    }

    public static void findIgnoresForRules(Collection rules, final Collection collection, IProgressMonitor progress) throws FileSystemClientException {
        IgnoreUtils.findIgnoresForRules(rules, new IIgnoredForRuleController(){

            public void addIgnored(IIgnoreProvider$IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
                collection.add(shareable);
            }

            public boolean shouldSkip(IIgnoreProvider$IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
                return shareable.shouldBeIgnored(monitor);
            }
        }, progress);
    }

    public static void findIgnoresForRules(Collection rules, final boolean visitCurrentlyIgnored, final Collection collection, IProgressMonitor progress) throws FileSystemClientException {
        IgnoreUtils.findIgnoresForRules(rules, visitCurrentlyIgnored, new IIgnoredForRuleController(){

            public void addIgnored(IIgnoreProvider$IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
                collection.add(shareable);
            }

            public boolean shouldSkip(IIgnoreProvider$IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
                return !visitCurrentlyIgnored && shareable.shouldBeIgnored(monitor);
            }
        }, progress);
    }

    public static void findIgnoresForRules(Collection rules, IIgnoredForRuleController listener, IProgressMonitor progress) throws FileSystemClientException {
        IgnoreUtils.findIgnoresForRules(rules, false, listener, progress);
    }

    public static void findIgnoresForRules(Collection rules, boolean allowCurrentlyIgnored, final IIgnoredForRuleController listener, IProgressMonitor progress) throws FileSystemClientException {
        if (rules == null) {
            throw new IllegalArgumentException("rules may not be null");
        }
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)rules.size());
        for (final IIgnoreProvider$IIgnoreRule rule : rules) {
            SubMonitor subMonitor = monitor.newChild(1);
            subMonitor.beginTask(Messages.IgnoreUtils_0, 100);
            List roots = rule.getEffectiveFrom((IProgressMonitor)subMonitor.newChild(5));
            subMonitor.setWorkRemaining(roots.size());
            for (IShareable root : roots) {
                subMonitor.setTaskName(NLS.bind((String)Messages.IgnoreUtils_1, (Object)root.getLocalPath().toString(), (Object[])new Object[0]));
                ((Shareable)root).getFileStorage().accept(new IFileStorageVisitor(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public boolean visit(IFileStorage storage, IProgressMonitor progress) {
                        if (exception[0] != null) {
                            return false;
                        }
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
                        try {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            Shareable shareable = storage.getShareable();
                            if (!rule.isEffectiveBelow(shareable)) {
                                return false;
                            }
                            if (listener.shouldSkip(rule, shareable, (IProgressMonitor)monitor.newChild(1))) {
                                return false;
                            }
                            if (!rule.shouldBeIgnored(shareable)) return true;
                            listener.addIgnored(rule, shareable, (IProgressMonitor)monitor.newChild(1));
                            return false;
                        }
                        catch (FileSystemClientException e) {
                            exception[0] = e;
                            return false;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (exception[0] == null) continue;
            throw exception[0];
        }
    }

    public static void removeContainedRules(List<IgnoreRule> localRules) {
        Iterator<IgnoreRule> it = localRules.iterator();
        while (it.hasNext()) {
            IgnoreRule rule = it.next();
            IShareable ignoreFile = rule.getFile();
            boolean remove = false;
            for (IgnoreRule potentialParent : localRules) {
                if (!IgnoreUtils.ruleOccludes(potentialParent, ignoreFile)) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
    }

    private static boolean ruleOccludes(IgnoreRule potentialParent, IShareable shareable) {
        for (IShareable effectiveFrom : potentialParent.getEffectiveFrom(null)) {
            IPath shareablePath;
            IPath root = effectiveFrom.getLocalPath();
            if (!root.isPrefixOf(shareablePath = shareable.getLocalPath())) continue;
            int len = root.segmentCount();
            while (len < shareablePath.segmentCount()) {
                IPath walker = shareablePath.removeLastSegments(shareablePath.segmentCount() - len);
                if (potentialParent.shouldBeIgnored(walker)) {
                    return true;
                }
                ++len;
            }
        }
        return false;
    }

    public static HashSet<IIgnoreProvider$IIgnoreRule> extractRulesFromReasons(List<IIgnoreManager$IIgnoreReason> reasons) {
        HashSet<IIgnoreProvider$IIgnoreRule> rules = new HashSet<IIgnoreProvider$IIgnoreRule>();
        for (IIgnoreManager$IIgnoreReason reason : reasons) {
            rules.addAll(reason.getRules());
        }
        return rules;
    }

    public static String describeRule(IIgnoreProvider$IIgnoreRule rule) {
        return rule.getShortDescription();
    }

    public static interface IIgnoredForRuleController {
        public void addIgnored(IIgnoreProvider$IIgnoreRule var1, IShareable var2, IProgressMonitor var3) throws FileSystemClientException;

        public boolean shouldSkip(IIgnoreProvider$IIgnoreRule var1, IShareable var2, IProgressMonitor var3) throws FileSystemClientException;
    }
}

