/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock$$Cold;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class FilesystemLock {
    private final File lockFile;
    protected RandomAccessFile lockRAF;
    protected FileLock lock;
    private static final HashMap lockMap = new HashMap();

    public FilesystemLock(File file) {
        this.lockFile = file;
    }

    public FilesystemLock(IPath iPath) {
        this.lockFile = iPath.toFile();
    }

    public File getFile() {
        return this.lockFile;
    }

    public boolean isAcquired() {
        return FilesystemLock.isAquired(this);
    }

    public boolean acquire(IProgressMonitor iProgressMonitor) {
        if (FilesystemLock.acquirePath(this)) {
            boolean bl = false;
            try {
                boolean bl2 = bl = this.acquireInternal(iProgressMonitor);
                return bl2;
            }
            finally {
                if (!bl) {
                    FilesystemLock.releasePath(this);
                }
            }
        }
        return false;
    }

    private boolean acquireInternal(IProgressMonitor iProgressMonitor) {
        if (this.lockFile.exists() && this.lockFile.isDirectory()) {
            throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.FilesystemLock_DIRECTORY_COLLISION, (Object)this.lockFile.getAbsolutePath()));
        }
        if (this.lockFile.exists()) {
            if (!this.lockFile.isFile()) {
                return false;
            }
        } else {
            File file = this.lockFile.getParentFile();
            if (file.exists() ? !file.isDirectory() : !file.mkdirs()) {
                return false;
            }
            try {
                if (!this.lockFile.createNewFile()) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        try {
            this.lockRAF = new RandomAccessFile(this.lockFile, "rw");
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            try {
                this.lock = this.lockRAF.getChannel().tryLock(0L, 1L, false);
            }
            catch (IOException iOException) {
                if (this.lock == null) {
                    try {
                        this.lockRAF.close();
                    }
                    catch (IOException iOException2) {}
                    return false;
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (this.lock == null) {
                try {
                    this.lockRAF.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            throw throwable;
        }
        if (this.lock == null) {
            try {
                this.lockRAF.close();
            }
            catch (IOException iOException) {}
            return false;
        }
        return true;
    }

    public boolean acquire(long l, IProgressMonitor iProgressMonitor) throws  {
        return FilesystemLock$$Cold.acquire(this, l, iProgressMonitor);
    }

    public void release(IProgressMonitor iProgressMonitor) {
        FilesystemLock.releasePath(this);
        if (this.lock != null) {
            this.lock = null;
        }
        if (this.lockRAF != null) {
            try {
                this.lockRAF.close();
                this.lockRAF = null;
            }
            catch (IOException iOException) {}
        }
        this.lockFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean acquirePath(FilesystemLock filesystemLock) {
        HashMap hashMap = lockMap;
        synchronized (hashMap) {
            FilesystemLock filesystemLock2 = (FilesystemLock)lockMap.get(filesystemLock.lockFile);
            if (filesystemLock2 == null) {
                lockMap.put(filesystemLock.lockFile, filesystemLock);
            }
            return filesystemLock2 == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePath(FilesystemLock filesystemLock) {
        HashMap hashMap = lockMap;
        synchronized (hashMap) {
            lockMap.remove(filesystemLock.lockFile);
        }
    }

    public IPath getPath() {
        return (IPath)new Path(this.lockFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isAquired(FilesystemLock filesystemLock) {
        HashMap hashMap = lockMap;
        synchronized (hashMap) {
            FilesystemLock filesystemLock2 = (FilesystemLock)lockMap.get(filesystemLock.lockFile);
            return filesystemLock2 == filesystemLock;
        }
    }
}

