/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionUtil {
    public static List<Throwable> flattenThrowable(Throwable t) {
        if (!(t instanceof CoreException)) {
            return Collections.singletonList(t);
        }
        CoreException e = (CoreException)t;
        IStatus s = e.getStatus();
        if (s == null) {
            if (e.getCause() == null) {
                return Collections.singletonList(e);
            }
            return Collections.singletonList(e);
        }
        return ExceptionUtil.flattenThrowable(s);
    }

    public static List<Throwable> flattenThrowable(IStatus s) {
        if (s.isMultiStatus()) {
            ArrayList<Throwable> toReturn = new ArrayList<Throwable>(s.getChildren().length);
            IStatus[] iStatusArray = s.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                toReturn.addAll(ExceptionUtil.flattenThrowable(child));
                ++n2;
            }
            return toReturn;
        }
        if (s.getException() == null) {
            return Collections.emptyList();
        }
        return ExceptionUtil.flattenThrowable(s.getException());
    }

    public static List<IStatus> findDescendents(IStatus s) {
        if (s.isMultiStatus()) {
            ArrayList<IStatus> toReturn = new ArrayList<IStatus>(s.getChildren().length);
            IStatus[] iStatusArray = s.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                toReturn.addAll(ExceptionUtil.findDescendents(child));
                ++n2;
            }
            return toReturn;
        }
        return Collections.singletonList(s);
    }

    public static boolean contains(CoreException e, Class<? extends Exception> exceptionClass) {
        return ExceptionUtil.contains(ExceptionUtil.flattenThrowable(e), exceptionClass);
    }

    public static boolean contains(List<Throwable> list, Class<? extends Exception> exceptionClass) {
        for (Throwable t : list) {
            if (!ExceptionUtil.contains(t, exceptionClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Throwable t, Class<? extends Exception> exceptionClass) {
        if (exceptionClass.isAssignableFrom(t.getClass())) {
            return true;
        }
        if (t.getCause() != null) {
            return ExceptionUtil.contains(t.getCause(), exceptionClass);
        }
        return false;
    }

    public static List<IStatus> findLeaves(CoreException e) {
        ArrayList<IStatus> toReturn = new ArrayList<IStatus>();
        if (e.getCause() != e) {
            if (e.getCause() instanceof CoreException) {
                toReturn.addAll(ExceptionUtil.findLeaves((CoreException)e.getCause()));
            }
            if (e.getCause() != null && e.getCause().getCause() instanceof CoreException) {
                toReturn.addAll(ExceptionUtil.findLeaves((CoreException)e.getCause().getCause()));
            }
        }
        if (toReturn.size() == 0 && e.getStatus() != null) {
            toReturn.addAll(ExceptionUtil.findLeaves(e.getStatus()));
        }
        return toReturn;
    }

    public static List<IStatus> findLeaves(IStatus status) {
        if (status.getChildren().length == 0) {
            if (status.getException() != null && status.getException() instanceof CoreException) {
                return ExceptionUtil.findLeaves((CoreException)status.getException());
            }
            if (status.getException() instanceof TeamRepositoryException && status.getException().getCause() instanceof CoreException) {
                return ExceptionUtil.findLeaves((CoreException)status.getException().getCause());
            }
            return Collections.singletonList(status);
        }
        ArrayList<IStatus> toReturn = new ArrayList<IStatus>();
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            toReturn.addAll(ExceptionUtil.findLeaves(child));
            ++n2;
        }
        return toReturn;
    }
}

