/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils$1;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils$2;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils$VersionableExtractor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class ChangeSetRefreshUtils {
    public static void refreshForBaselineChange(IFilesystemRefresher iFilesystemRefresher, Collection collection, IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (list.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.setWorkRemaining(2 * list.size());
        List list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, (IProgressMonitor)subMonitor.newChild(list.size()));
        for (IBaseline iBaseline : list2) {
            iFilesystemRefresher.addToRefresh(collection, iWorkspaceConnection.getContextHandle(), iBaseline.getComponent(), (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static void refreshLocalForAddition(IFilesystemRefresher iFilesystemRefresher, Map map, IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshLocalFor(new ChangeSetRefreshUtils$1(), iWorkspaceConnection, list, iFilesystemRefresher, map, iProgressMonitor);
    }

    public static void refreshLocalForRemoval(IFilesystemRefresher iFilesystemRefresher, Map map, IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshLocalFor(new ChangeSetRefreshUtils$2(), iWorkspaceConnection, list, iFilesystemRefresher, map, iProgressMonitor);
    }

    private static void refreshLocalFor(ChangeSetRefreshUtils$VersionableExtractor changeSetRefreshUtils$VersionableExtractor, IWorkspaceConnection iWorkspaceConnection, List list, IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        SubMonitor subMonitor22;
        SubMonitor subMonitor3 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)5);
        List list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, (IProgressMonitor)subMonitor3.newChild(1));
        LinkedList<IVersionableHandle> linkedList = new LinkedList<IVersionableHandle>();
        ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>();
        Set set = map.keySet();
        SubMonitor subMonitor4 = subMonitor3.newChild(1, 2);
        subMonitor4.beginTask(null, list2.size());
        for (SubMonitor subMonitor22 : list2) {
            object5 = subMonitor4.newChild(1);
            object5.beginTask(null, 2);
            for (Object object42 : subMonitor22.changes()) {
                object3 = changeSetRefreshUtils$VersionableExtractor.extract((IChange)object42);
                if (object3 == null) continue;
                linkedList.add((IVersionableHandle)object3);
                arrayList.add(subMonitor22.getComponent());
                object2 = ChangeSetRefreshUtils.getAllShareablesFor(iWorkspaceConnection.getContextHandle(), subMonitor22.getComponent(), object42.item(), set, object5.newChild(1));
                iFilesystemRefresher.addToRefresh((Collection)object2);
            }
        }
        subMonitor22 = subMonitor3.newChild(1);
        Collection collection = ChangeSetRefreshUtils.findComponentsIn(map, iWorkspaceConnection);
        subMonitor22.setWorkRemaining(collection.size());
        object42 = collection.iterator();
        while (object42.hasNext()) {
            object5 = (IComponentHandle)object42.next();
            object = subMonitor22.newChild(1);
            object3 = iWorkspaceConnection.conflictReport((IComponentHandle)object5).conflicts();
            object.setWorkRemaining(object3.size());
            subMonitor = object3.iterator();
            while (subMonitor.hasNext()) {
                object2 = (IItemConflictReport)subMonitor.next();
                Object object6 = object2.getProposedContributorState();
                if (object6 != null) {
                    linkedList.add((IVersionableHandle)object6);
                    arrayList.add(object2.getComponent());
                }
                Collection collection2 = ChangeSetRefreshUtils.getAllShareablesFor(iWorkspaceConnection.getContextHandle(), object2.getComponent(), object2.item(), set, object.newChild(1));
                iFilesystemRefresher.addToRefresh(collection2);
            }
        }
        object5 = SCMPlatform.getWorkspaceManager((ITeamRepository)iWorkspaceConnection.teamRepository()).versionableManager().fetchCompleteStates((List)linkedList, (IProgressMonitor)subMonitor3.newChild(1));
        object42 = new ArrayList(object5.size());
        object = new ArrayList(object5.size());
        object2 = object5.iterator();
        while (object2.hasNext()) {
            object3 = (IVersionable)object2.next();
            ((ArrayList)object42).add(object3.getParent());
            ((ArrayList)object).add(object3.getName());
        }
        object3 = subMonitor3.newChild(1);
        object3.setWorkRemaining(linkedList.size());
        int n = 0;
        while (n < linkedList.size()) {
            subMonitor = object3.newChild(1);
            subMonitor.setWorkRemaining(map.size());
            for (Object object6 : map.keySet()) {
                IShareable iShareable = object6.findShareable(iWorkspaceConnection.getContextHandle(), (IComponentHandle)arrayList.get(n), (IVersionableHandle)((ArrayList)object42).get(n), (IProgressMonitor)object3.newChild(1));
                if (iShareable == null) continue;
                IShareable iShareable2 = object6.findShareable(iShareable.getLocalPath().append((String)((ArrayList)object).get(n)), ResourceType.getResourceType((IVersionableHandle)object5.get(n)));
                iFilesystemRefresher.addToRefresh(iShareable2);
            }
            ++n;
        }
    }

    private static Collection findComponentsIn(Map map, IWorkspaceConnection iWorkspaceConnection) throws TeamRepositoryException {
        HashMap<UUID, IComponentHandle> hashMap = new HashMap<UUID, IComponentHandle>();
        List list = iWorkspaceConnection.getComponents();
        for (Set set : map.values()) {
            block1: for (ConfigurationDescriptor configurationDescriptor : set) {
                for (IComponentHandle iComponentHandle : list) {
                    if (!iComponentHandle.getItemId().equals((Object)configurationDescriptor.componentHandle.getItemId())) continue;
                    hashMap.put(configurationDescriptor.componentHandle.getItemId(), configurationDescriptor.componentHandle);
                    continue block1;
                }
            }
        }
        return hashMap.values();
    }

    private static Collection getAllShareablesFor(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, Collection collection, SubMonitor subMonitor) throws FileSystemClientException {
        ArrayList<IShareable> arrayList = new ArrayList<IShareable>(collection.size());
        subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)collection.size());
        for (ISandbox iSandbox : collection) {
            IShareable iShareable = iSandbox.findShareable(iContextHandle, iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(1));
            if (iShareable == null) continue;
            arrayList.add(iShareable);
        }
        return arrayList;
    }
}

