/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSnapshot
implements ISnapshot {
    public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<SiloedItemId<IVersionable>, VersionablePath> result = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        Map<ItemId<IComponent>, IItemContext> contexts = this.getContexts((IProgressMonitor)progress.newChild(20));
        HashMap itemsByComponent = new HashMap();
        progress.setWorkRemaining(unresolved.size());
        for (SiloedItemId<IVersionable> siloedItemId : unresolved) {
            ItemId component = siloedItemId.getComponent();
            if (contexts.containsKey(component)) {
                CollectionUtil.addToMapOfLists(itemsByComponent, (Object)component, (Object)siloedItemId.getItemId());
                continue;
            }
            progress.worked(1);
            result.put(siloedItemId, VersionablePath.create(Collections.emptyList(), siloedItemId, (boolean)false, (boolean)false));
        }
        for (ItemId itemId : contexts.keySet()) {
            IItemContext nextContext = contexts.get(itemId);
            List versionables = (List)itemsByComponent.get(itemId);
            if (versionables == null) continue;
            Map<ItemId<IVersionable>, VersionablePath> paths = nextContext.resolve(versionables, (IProgressMonitor)progress.newChild(versionables.size()));
            for (Map.Entry<ItemId<IVersionable>, VersionablePath> nextEntry : paths.entrySet()) {
                result.put((SiloedItemId<IVersionable>)SiloedItemId.create(nextEntry.getKey(), (ItemId)itemId), nextEntry.getValue());
            }
        }
        return result;
    }

    @Override
    public IItemContext getContextFor(ItemId<IComponent> componentId, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<ItemId<IComponent>, IItemContext> contexts = this.getContexts(monitor);
        if (contexts.containsKey(componentId)) {
            return contexts.get(componentId);
        }
        return EmptyNamespace.create(this.getRepository(), componentId).getContext(null);
    }

    @Override
    public void addChangeListener(IChangeListener changeListener) {
    }

    @Override
    public void removeChangeListener(IChangeListener changeListener) {
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
    }
}

