/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.share.UnshareOperation$1;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class UnshareOperation
extends FileSystemOperation
implements IUnshareOperation {
    private ArrayList sharesToUnshare;
    private boolean deleteContent;
    private Collection shareablesToUnshare;
    private ArrayList configurationsToUnshare;
    private UnshareDilemmaHandler unshareDilemmaHandler;

    public UnshareOperation(UnshareDilemmaHandler unshareDilemmaHandler) {
        super(unshareDilemmaHandler == null ? UnshareDilemmaHandler.getDefault() : unshareDilemmaHandler);
        this.unshareDilemmaHandler = unshareDilemmaHandler == null ? UnshareDilemmaHandler.getDefault() : unshareDilemmaHandler;
        this.deleteContent = false;
        this.configurationsToUnshare = new ArrayList();
        this.sharesToUnshare = new ArrayList();
        this.shareablesToUnshare = new ArrayList();
    }

    public void requestUnshareShares(Collection collection) {
        this.sharesToUnshare.addAll(collection);
    }

    public void requestUnshare(IConnection iConnection, Collection collection) {
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.configurationsToUnshare = new ArrayList();
        for (IComponentHandle iComponentHandle : collection) {
            this.configurationsToUnshare.add(new ConfigurationDescriptor(iConnection, iComponentHandle));
        }
    }

    public void requestUnshare(Collection collection) {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.configurationsToUnshare = new ArrayList();
        this.configurationsToUnshare.addAll(collection);
    }

    public void setDeleteContent(boolean bl) {
        this.deleteContent = bl;
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Set set = this.getAffectedConfigurations();
        UnshareOperation$1 unshareOperation$1 = new UnshareOperation$1(this, set);
        this.runWithinFileSystemLock(unshareOperation$1, Messages.UnshareProjectsOperation_0, iProgressMonitor);
    }

    private Set getAffectedConfigurations() {
        this.shareablesToUnshare = new ArrayList();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.configurationsToUnshare != null) {
            for (Object object : this.configurationsToUnshare) {
                if (object.getClass() != ConfigurationDescriptor.class) {
                    hashSet.add(new ConfigurationDescriptor(((ConfigurationDescriptor)object).id, ((ConfigurationDescriptor)object).uri, ((ConfigurationDescriptor)object).connectionHandle, ((ConfigurationDescriptor)object).componentHandle));
                    continue;
                }
                hashSet.add(object);
            }
        }
        if (this.sharesToUnshare != null) {
            for (Object object : this.sharesToUnshare) {
                IShareable iShareable = object.getShareable();
                this.shareablesToUnshare.add((Shareable)iShareable);
                ISharingDescriptor iSharingDescriptor = object.getSharingDescriptor();
                hashSet.add(new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent()));
            }
        }
        return hashSet;
    }

    static /* synthetic */ ArrayList access$0(UnshareOperation unshareOperation) {
        return unshareOperation.configurationsToUnshare;
    }

    static /* synthetic */ Collection access$1(UnshareOperation unshareOperation) {
        return unshareOperation.shareablesToUnshare;
    }

    static /* synthetic */ boolean access$2(UnshareOperation unshareOperation) {
        return unshareOperation.deleteContent;
    }

    static /* synthetic */ void access$3(UnshareOperation unshareOperation, IStatus iStatus) {
        unshareOperation.collectStatus(iStatus);
    }

    static /* synthetic */ UnshareDilemmaHandler access$4(UnshareOperation unshareOperation) {
        return unshareOperation.unshareDilemmaHandler;
    }
}

