/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.share.ShareVersionables$ShareableVersionablePair;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class ShareVersionables {
    final IWorkspaceConnection workspace;
    final IChangeSetHandle changeSet;
    final IComponent component;
    final IFolderHandle parentFolder;
    final String[] newFolderUnderParent;
    final boolean overwrite;
    private final List shareables;
    private CommitDilemmaHandler problemHandler;
    private Map changeSetsCommitted;
    private boolean newProjectContentsToBeCommitted;

    public ShareVersionables(IWorkspaceConnection iWorkspaceConnection, IChangeSetHandle iChangeSetHandle, IComponent iComponent, IFolderHandle iFolderHandle, String[] stringArray, boolean bl, CommitDilemmaHandler commitDilemmaHandler) {
        this.workspace = iWorkspaceConnection;
        this.changeSet = iChangeSetHandle;
        this.component = iComponent;
        this.parentFolder = iFolderHandle;
        this.newFolderUnderParent = stringArray;
        this.shareables = new ArrayList();
        this.overwrite = bl;
        this.problemHandler = commitDilemmaHandler;
        this.changeSetsCommitted = new HashMap();
    }

    public void addShareable(IShareable iShareable) {
        this.shareables.add(iShareable);
    }

    public Collection getShareables() {
        return this.shareables;
    }

    public int getShareableCount() {
        return this.shareables.size();
    }

    public void share(Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        this.changeSetsCommitted = new HashMap();
        if (this.shareables.isEmpty()) {
            return;
        }
        int n = this.shareables.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList arrayList = new ArrayList();
        IFolderHandle iFolderHandle = this.createNewFolderToShareUnder(this.parentFolder, map, arrayList);
        subMonitor.setTaskName(NLS.bind((String)Messages.ShareProjects_0, (Object)n, (Object[])new Object[0]));
        Map map2 = this.mapProjectsToVersionablesToBeCommitted(iFolderHandle, this.component.getName(), (IProgressMonitor)subMonitor.newChild(5));
        if (!map2.isEmpty() || !arrayList.isEmpty()) {
            this.commitNewProjects(this.component.getName(), iFolderHandle, arrayList, map2, subMonitor.newChild(15));
            if (!map2.isEmpty()) {
                this.newProjectContentsToBeCommitted = true;
            }
        }
    }

    private IFolderHandle createNewFolderToShareUnder(IFolderHandle iFolderHandle, Map map, ArrayList arrayList) {
        if (this.newFolderUnderParent.length > 0) {
            IWorkspaceConnection.IConfigurationOpFactory iConfigurationOpFactory = this.workspace.configurationOpFactory();
            String string = "";
            String[] stringArray = this.newFolderUnderParent;
            int n = this.newFolderUnderParent.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                IFolder iFolder = (IFolder)map.get(string = String.valueOf(string) + "/" + string2);
                if (iFolder == null) {
                    iFolder = (IFolder)IFolder.ITEM_TYPE.createItem();
                    iFolder.setName(string2);
                    iFolder.setParent(iFolderHandle);
                    arrayList.add(iConfigurationOpFactory.save((IVersionable)iFolder));
                    map.put(string, iFolder);
                }
                iFolderHandle = iFolder;
                ++n2;
            }
        }
        return iFolderHandle;
    }

    public void commitNewProjectContents(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        if (this.newProjectContentsToBeCommitted) {
            ICheckinOperation iCheckinOperation = IOperationFactory.instance.getCheckinOperation(this.problemHandler);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            iCheckinOperation.requestCheckin(this.shareables.toArray(new IShareable[this.shareables.size()]), this.changeSet, Messages.ShareProjects_1, (IProgressMonitor)subMonitor.newChild(1));
            iCheckinOperation.enableNonAtomicCommit(1);
            iCheckinOperation.run((IProgressMonitor)subMonitor.newChild(99));
            for (IChangeSetHandle iChangeSetHandle : iCheckinOperation.getCommittedChangeSets()) {
                this.changeSetsCommitted.put(iChangeSetHandle.getItemId(), iChangeSetHandle);
            }
        }
    }

    public Collection getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    private void commitNewProjects(String string, IFolderHandle iFolderHandle, ArrayList arrayList, Map map, SubMonitor subMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object4;
        Object object2;
        IItemUpdateReport iItemUpdateReport2;
        ShareVersionables$ShareableVersionablePair shareVersionables$ShareableVersionablePair2;
        IWorkspaceConnection.IConfigurationOpFactory iConfigurationOpFactory = this.workspace.configurationOpFactory();
        ArrayList<IWorkspaceConnection.ISaveOp> arrayList2 = new ArrayList<IWorkspaceConnection.ISaveOp>(map.size() + arrayList.size());
        arrayList2.addAll(arrayList);
        for (ShareVersionables$ShareableVersionablePair shareVersionables$ShareableVersionablePair2 : map.values()) {
            arrayList2.add(iConfigurationOpFactory.save(shareVersionables$ShareableVersionablePair2.getVersionable()));
        }
        IChangeSetHandle iChangeSetHandle = this.changeSet;
        if (iChangeSetHandle == null && (iChangeSetHandle = this.workspace.getCurrentChangeSet((IComponentHandle)this.component)) == null) {
            iChangeSetHandle = this.workspace.createChangeSet((IComponentHandle)this.component, Messages.ShareProjects_2, true, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.setTaskName(Messages.ShareProjects_3);
        shareVersionables$ShareableVersionablePair2 = this.workspace.commit(iChangeSetHandle, (Collection)arrayList2, (IProgressMonitor)subMonitor.newChild(4));
        this.changeSetsCommitted.put(iChangeSetHandle.getItemId(), iChangeSetHandle);
        SubMonitor subMonitor2 = subMonitor.newChild(10);
        ArrayList arrayList3 = new ArrayList(shareVersionables$ShareableVersionablePair2.updates().size() + shareVersionables$ShareableVersionablePair2.incidentalResolutionUpdates().size());
        arrayList3.addAll(shareVersionables$ShareableVersionablePair2.updates());
        arrayList3.addAll(shareVersionables$ShareableVersionablePair2.incidentalResolutionUpdates());
        int n = 0;
        int n2 = arrayList3.size();
        subMonitor2.setWorkRemaining(n2);
        ISyncTime iSyncTime = this.getConfigurationState(shareVersionables$ShareableVersionablePair2.getComponentStatesBefore());
        ISyncTime iSyncTime2 = this.getConfigurationState(shareVersionables$ShareableVersionablePair2.getComponentStatesAfter());
        for (IItemUpdateReport iItemUpdateReport2 : arrayList3) {
            Object object3 = (ShareVersionables$ShareableVersionablePair)map.get(iItemUpdateReport2.getNewCurrentState().getItemId());
            if (object3 != null) {
                subMonitor2.setTaskName(NLS.bind((String)Messages.ShareProjects_4, (Object)n, (Object[])new Object[]{n2, ((ShareVersionables$ShareableVersionablePair)object3).getShareable().getLocalPath()}));
                SharingDescriptor sharingDescriptor = new SharingDescriptor(this.workspace.teamRepository().getRepositoryURI(), this.workspace.teamRepository().getId(), (IConnection)this.workspace, (IComponentHandle)this.component, string, iItemUpdateReport2.getNewCurrentState(), iSyncTime2);
                if (iItemUpdateReport2.getNewCurrentState() instanceof IFolderHandle) {
                    object2 = new FileItemInfo((IFolderHandle)iItemUpdateReport2.getNewCurrentState(), ShareVersionables$ShareableVersionablePair.access$0((ShareVersionables$ShareableVersionablePair)object3).getParent(), ShareVersionables$ShareableVersionablePair.access$1((ShareVersionables$ShareableVersionablePair)object3).getLocalPath().lastSegment(), false);
                } else if (iItemUpdateReport2.getNewCurrentState() instanceof ISymbolicLinkHandle) {
                    ISymbolicLink iSymbolicLink = (ISymbolicLink)ShareVersionables$ShareableVersionablePair.access$0((ShareVersionables$ShareableVersionablePair)object3);
                    FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy(iItemUpdateReport2.getNewCurrentState(), ShareVersionables$ShareableVersionablePair.access$0((ShareVersionables$ShareableVersionablePair)object3).getParent(), ShareVersionables$ShareableVersionablePair.access$1((ShareVersionables$ShareableVersionablePair)object3).getLocalPath().lastSegment(), false);
                    fileItemInfoProxy.setTarget(((Shareable)((ShareVersionables$ShareableVersionablePair)object3).getShareable()).getFileStorage().getModificationStamp(), iSymbolicLink.getTarget());
                    object2 = fileItemInfoProxy.getFileItemInfo();
                } else {
                    throw (Throwable)new IllegalStateException("Share file not supported");
                }
                ((Shareable)((ShareVersionables$ShareableVersionablePair)object3).getShareable()).share(sharingDescriptor, (FileItemInfo)object2, this.overwrite, true, (IProgressMonitor)subMonitor2.newChild(1));
            } else {
                subMonitor2.worked(1);
            }
            ++n;
        }
        iItemUpdateReport2 = new HashSet();
        for (Object object4 : this.shareables) {
            iItemUpdateReport2.add(object4.getSandbox());
        }
        object4 = ICopyFileAreaManager.instance;
        for (Object object3 : iItemUpdateReport2) {
            object2 = object4.getExistingCopyFileArea(object3.getRoot());
            object2.setConfigurationState((IContextHandle)this.workspace.getResolvedWorkspace(), (IComponentHandle)this.component, iSyncTime, iSyncTime2, (IProgressMonitor)subMonitor2.newChild(1));
        }
        subMonitor2.done();
    }

    private ISyncTime getConfigurationState(Collection collection) {
        ISyncTime iSyncTime = null;
        for (IComponentStateSummary iComponentStateSummary : collection) {
            if (!iComponentStateSummary.getComponent().sameItemId((IItemHandle)this.component)) continue;
            iSyncTime = iComponentStateSummary.getConfigurationTime();
            break;
        }
        return iSyncTime;
    }

    private Map mapProjectsToVersionablesToBeCommitted(IFolderHandle iFolderHandle, String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        int n = this.shareables.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(n * 100));
        HashMap<UUID, ShareVersionables$ShareableVersionablePair> hashMap = new HashMap<UUID, ShareVersionables$ShareableVersionablePair>();
        try {
            int n2 = 0;
            for (IShareable iShareable : this.shareables) {
                IFolder iFolder;
                if (subMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                subMonitor.setTaskName(NLS.bind((String)Messages.ShareProjects_5, (Object)iShareable.getLocalPath().toString(), (Object[])new Object[]{++n2, n}));
                ResourceType resourceType = iShareable.getResourceType((IProgressMonitor)subMonitor.newChild(1));
                if (resourceType == ResourceType.FOLDER) {
                    iFolder = (IFolder)IFolder.ITEM_TYPE.createItem();
                    hashMap.put(iFolder.getItemId(), new ShareVersionables$ShareableVersionablePair(this, iShareable, (IVersionable)iFolder));
                    iFolder.setName(iShareable.getLocalPath().lastSegment());
                    iFolder.setParent(iFolderHandle);
                } else if (resourceType == ResourceType.FILE) {
                    iFolder = (IFileItem)IFileItem.ITEM_TYPE.createItem();
                    hashMap.put(iFolder.getItemId(), new ShareVersionables$ShareableVersionablePair(this, iShareable, (IVersionable)iFolder));
                    iFolder.setName(iShareable.getLocalPath().lastSegment());
                    iFolder.setParent(iFolderHandle);
                } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                    iFolder = (ISymbolicLink)ISymbolicLink.ITEM_TYPE.createItem();
                    hashMap.put(iFolder.getItemId(), new ShareVersionables$ShareableVersionablePair(this, iShareable, (IVersionable)iFolder));
                    iFolder.setName(iShareable.getLocalPath().lastSegment());
                    iFolder.setParent(iFolderHandle);
                    IFileStorage iFileStorage = ((Shareable)iShareable).getFileStorage();
                    iFolder.setTarget(iFileStorage.getTarget((IProgressMonitor)subMonitor.newChild(1)));
                    iFolder.setLinkTimestamp(new Date(iFileStorage.getLocalTimeStamp()));
                }
                subMonitor.worked(100);
            }
        }
        finally {
            subMonitor.done();
        }
        return hashMap;
    }

    public void removeProject(IShareable iShareable) {
        Iterator iterator = this.shareables.iterator();
        while (iterator.hasNext()) {
            IShareable iShareable2 = (IShareable)iterator.next();
            if (!iShareable2.equals(iShareable)) continue;
            iterator.remove();
        }
    }
}

