/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.share.MultipleSandboxShare;
import com.ibm.team.filesystem.client.internal.share.ReshareVersionables;
import com.ibm.team.filesystem.client.internal.share.ShareOperation$1;
import com.ibm.team.filesystem.client.internal.share.ShareOperation$ShareRequest;
import com.ibm.team.filesystem.client.internal.share.ShareOverlap;
import com.ibm.team.filesystem.client.internal.share.ShareVersionables;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class ShareOperation
extends FileSystemOperation
implements IShareOperation {
    private ShareDilemmaHandler problemHandler;
    private HashMap shareRequests = new HashMap();
    private HashMap reshares;
    private HashMap shares;
    private HashMap changeSetsCommitted;
    private HashSet allShares;

    public ShareOperation(ShareDilemmaHandler shareDilemmaHandler) {
        super(shareDilemmaHandler);
        this.problemHandler = shareDilemmaHandler == null ? ShareDilemmaHandler.getDefault() : shareDilemmaHandler;
        this.changeSetsCommitted = new HashMap();
        this.allShares = new HashSet();
    }

    public void share(IWorkspaceConnection iWorkspaceConnection, IChangeSetHandle iChangeSetHandle, IComponentHandle iComponentHandle, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.addShareRequest(iWorkspaceConnection, iChangeSetHandle, iComponentHandle, null, new String[0], null, list, bl, iProgressMonitor);
    }

    public void share(IWorkspaceConnection iWorkspaceConnection, IChangeSetHandle iChangeSetHandle, IComponentHandle iComponentHandle, IFolderHandle iFolderHandle, String[] stringArray, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (iFolderHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.addShareRequest(iWorkspaceConnection, iChangeSetHandle, iComponentHandle, iFolderHandle, stringArray, null, list, bl, iProgressMonitor);
    }

    public void share(IWorkspaceConnection iWorkspaceConnection, String string, String[] stringArray, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<ShareOperation$ShareRequest> arrayList;
        Object object;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            if (object == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            ++n2;
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (IPath)iterator.next();
            if (object != null) continue;
            throw (Throwable)new IllegalArgumentException("Share root can not be null");
        }
        object = (HashMap)this.shareRequests.get(iWorkspaceConnection);
        if (object == null) {
            object = new HashMap();
            this.shareRequests.put(iWorkspaceConnection, object);
        }
        if ((arrayList = (ArrayList<ShareOperation$ShareRequest>)((HashMap)object).get(iterator = null)) == null) {
            arrayList = new ArrayList<ShareOperation$ShareRequest>();
            ((HashMap)object).put(iterator, arrayList);
        }
        arrayList.add(new ShareOperation$ShareRequest(this, iWorkspaceConnection, string, stringArray, null, list, bl, iProgressMonitor));
    }

    public void share(IWorkspaceConnection iWorkspaceConnection, IChangeSetHandle iChangeSetHandle, IComponentHandle iComponentHandle, IFolderHandle iFolderHandle, String[] stringArray, ISandbox iSandbox, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (iFolderHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iSandbox == null) {
            throw (Throwable)new IllegalArgumentException("Sandbox must be supplied");
        }
        this.addShareRequest(iWorkspaceConnection, iChangeSetHandle, iComponentHandle, iFolderHandle, stringArray, iSandbox, list, bl, iProgressMonitor);
    }

    public void share(IWorkspaceConnection iWorkspaceConnection, String string, String[] stringArray, ISandbox iSandbox, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<ShareOperation$ShareRequest> arrayList;
        Object object;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            if (object == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            ++n2;
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iSandbox == null) {
            throw (Throwable)new IllegalArgumentException("Sandbox must be supplied");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (IPath)iterator.next();
            if (object != null) continue;
            throw (Throwable)new IllegalArgumentException("Project can not be null");
        }
        object = (HashMap)this.shareRequests.get(iWorkspaceConnection);
        if (object == null) {
            object = new HashMap();
            this.shareRequests.put(iWorkspaceConnection, object);
        }
        if ((arrayList = (ArrayList<ShareOperation$ShareRequest>)((HashMap)object).get(iterator = null)) == null) {
            arrayList = new ArrayList<ShareOperation$ShareRequest>();
            ((HashMap)object).put(iterator, arrayList);
        }
        arrayList.add(new ShareOperation$ShareRequest(this, iWorkspaceConnection, string, stringArray, iSandbox, list, bl, iProgressMonitor));
    }

    public void reshareAs(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IChangeSetHandle iChangeSetHandle, IFolderHandle iFolderHandle, ISandbox iSandbox, IPath iPath, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ConfigurationDescriptor configurationDescriptor;
        ArrayList<ShareOperation$ShareRequest> arrayList;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iFolderHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iSandbox == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath == null || iPath.segmentCount() < 1) {
            throw (Throwable)new IllegalArgumentException("share root must be supplied");
        }
        HashMap<ConfigurationDescriptor, ArrayList<ShareOperation$ShareRequest>> hashMap = (HashMap<ConfigurationDescriptor, ArrayList<ShareOperation$ShareRequest>>)this.shareRequests.get(iWorkspaceConnection);
        if (hashMap == null) {
            hashMap = new HashMap<ConfigurationDescriptor, ArrayList<ShareOperation$ShareRequest>>();
            this.shareRequests.put(iWorkspaceConnection, hashMap);
        }
        if ((arrayList = (ArrayList<ShareOperation$ShareRequest>)hashMap.get(configurationDescriptor = new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle))) == null) {
            arrayList = new ArrayList<ShareOperation$ShareRequest>();
            hashMap.put(configurationDescriptor, arrayList);
        }
        arrayList.add(new ShareOperation$ShareRequest(this, iWorkspaceConnection, iComponentHandle, iChangeSetHandle, iFolderHandle, iSandbox, iPath, iProgressMonitor));
    }

    private void addShareRequest(IWorkspaceConnection iWorkspaceConnection, IChangeSetHandle iChangeSetHandle, IComponentHandle iComponentHandle, IFolderHandle iFolderHandle, String[] stringArray, ISandbox iSandbox, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<ShareOperation$ShareRequest> arrayList;
        Object object;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            if (object == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            ++n2;
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (IPath)object2.next();
            if (object != null) continue;
            throw (Throwable)new IllegalArgumentException("share root can not be null");
        }
        object = (HashMap)this.shareRequests.get(iWorkspaceConnection);
        if (object == null) {
            object = new HashMap<Object, ArrayList<ShareOperation$ShareRequest>>();
            this.shareRequests.put(iWorkspaceConnection, object);
        }
        if ((arrayList = (ArrayList<ShareOperation$ShareRequest>)((HashMap)object).get(object2 = new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle))) == null) {
            arrayList = new ArrayList<ShareOperation$ShareRequest>();
            ((HashMap)object).put(object2, arrayList);
        }
        arrayList.add(new ShareOperation$ShareRequest(this, iWorkspaceConnection, iChangeSetHandle, iComponentHandle, iFolderHandle, stringArray, iSandbox, list, bl, iProgressMonitor));
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor;
        block10: {
            iProgressMonitor.setTaskName(Messages.ShareProjectsOperation_4);
            if (this.shareRequests.isEmpty()) {
                throw (Throwable)new IllegalStateException();
            }
            HashSet hashSet = new HashSet();
            ArrayList arrayList = new ArrayList();
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)202);
            this.getAffectedConfigurations(hashSet, arrayList, (IProgressMonitor)subMonitor.newChild(1));
            FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(hashSet, (Collection)arrayList, (Collection)Collections.EMPTY_LIST, (IProgressMonitor)subMonitor.newChild(1));
            try {
                try {
                    TeamRepositoryException[] object = new TeamRepositoryException[1];
                    ShareOperation$1 shareOperation$1 = new ShareOperation$1(this, hashSet);
                    this.runWithinFileSystemLock(shareOperation$1, Messages.ShareOperation_5, (IProgressMonitor)subMonitor.newChild(100));
                    if (object[0] != null) {
                        throw (Throwable)object[0];
                    }
                }
                catch (CoreException coreException) {
                    this.collectStatus(FileSystemStatus.getStatusFor(coreException));
                    WorkspaceLockUtil.release(flowNodeLock);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                WorkspaceLockUtil.release(flowNodeLock);
                throw throwable;
            }
            WorkspaceLockUtil.release(flowNodeLock);
        }
        subMonitor.setWorkRemaining(this.shares.size() * 100);
        for (Map.Entry entry : this.shares.entrySet()) {
            List list = (List)entry.getValue();
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            subMonitor2.setWorkRemaining(list.size() * 10);
            for (ShareVersionables shareVersionables : list) {
                shareVersionables.commitNewProjectContents((IProgressMonitor)subMonitor2.newChild(10));
                Collection collection = shareVersionables.getCommittedChangeSets();
                for (IChangeSetHandle iChangeSetHandle : collection) {
                    this.changeSetsCommitted.put(iChangeSetHandle.getItemId(), iChangeSetHandle);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doShare(Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        HashMap hashMap3;
        HashMap<Object, Object> hashMap2;
        Object object422;
        Object object5;
        Map.Entry entry22;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.ShareOperation_SHARE_PROGRESS_MESSAGE, (int)100);
        SubMonitor subMonitor2 = subMonitor.newChild(5);
        subMonitor2.setWorkRemaining(this.shareRequests.size() * 100);
        HashSet hashSet = new HashSet();
        for (Map.Entry entry22 : this.shareRequests.entrySet()) {
            Object object2;
            object5 = (List)((HashMap)entry22.getValue()).remove(null);
            if (object5 != null) {
                object422 = subMonitor2.newChild(50);
                object422.setWorkRemaining(object5.size());
                hashMap2 = new ArrayList(object5.size());
                IWorkspaceConnection n = (IWorkspaceConnection)entry22.getKey();
                object2 = SCMPlatform.getWorkspaceManager((ITeamRepository)n.teamRepository());
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    hashMap3 = (ShareOperation$ShareRequest)iterator.next();
                    object = RepositoryUtils.getLoggedInContributor(n.teamRepository());
                    ShareOperation$ShareRequest.access$1((ShareOperation$ShareRequest)((Object)hashMap3), (IComponentHandle)object2.createComponent(ShareOperation$ShareRequest.access$0((ShareOperation$ShareRequest)((Object)hashMap3)), (IAuditableHandle)object, (IProgressMonitor)object422.newChild(1)));
                    hashMap2.add(n.componentOpFactory().addComponent(ShareOperation$ShareRequest.access$2((ShareOperation$ShareRequest)((Object)hashMap3)), false));
                }
                n.applyComponentOperations((List)((Object)hashMap2), (IProgressMonitor)subMonitor2.newChild(20));
                Iterator iterator2 = object5.iterator();
                while (iterator2.hasNext()) {
                    hashMap3 = (ShareOperation$ShareRequest)iterator2.next();
                    object = new ArrayList(1);
                    object.add(hashMap3);
                    ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor((IConnection)n, ShareOperation$ShareRequest.access$2((ShareOperation$ShareRequest)((Object)hashMap3)));
                    ((HashMap)entry22.getValue()).put(configurationDescriptor, object);
                    set.add(configurationDescriptor);
                }
            }
            subMonitor2.setWorkRemaining(10 * ((HashMap)entry22.getValue()).size());
            for (Object object422 : ((HashMap)entry22.getValue()).values()) {
                SubMonitor subMonitor3 = subMonitor2.newChild(10).setWorkRemaining(object422.size());
                hashMap3 = object422.iterator();
                while (hashMap3.hasNext()) {
                    object2 = (ShareOperation$ShareRequest)hashMap3.next();
                    hashSet.addAll(((ShareOperation$ShareRequest)object2).getCopyFileAreaLocksNeeded((IProgressMonitor)subMonitor3.newChild(1)));
                }
            }
        }
        entry22 = ICopyFileAreaManager.instance.lock(hashSet, (IProgressMonitor)subMonitor.newChild(1));
        try {
            void var11_19;
            Iterator iterator;
            Object object3;
            Map map = this.findMultipleSandboxForConfig(set, (IProgressMonitor)subMonitor.newChild(5));
            object5 = this.organizeShares((IProgressMonitor)subMonitor.newChild(1));
            this.reshares = new HashMap();
            this.shares = new HashMap();
            object422 = new HashMap();
            hashMap2 = new HashMap<Object, Object>();
            subMonitor2 = subMonitor.newChild(5);
            subMonitor2.setWorkRemaining(this.shareRequests.size() * 10);
            for (Map.Entry n : this.shareRequests.entrySet()) {
                Object object4;
                hashMap3 = (IWorkspaceConnection)n.getKey();
                ArrayList<OverlapRequest> arrayList = new ArrayList<OverlapRequest>(((HashMap)n.getValue()).size());
                object = subMonitor2.newChild(9);
                object.setWorkRemaining(((HashMap)n.getValue()).size());
                for (Map.Entry entry : ((HashMap)n.getValue()).entrySet()) {
                    Object object62;
                    Object object7;
                    object4 = (ConfigurationDescriptor)entry.getKey();
                    List list = (List)entry.getValue();
                    this.determineReshares((IConnection)hashMap3, ((ConfigurationDescriptor)object4).componentHandle, list, (IProgressMonitor)object.newChild(1));
                    arrayList.add(this.buildOverlapRequest((IConnection)hashMap3, (ConfigurationDescriptor)object4, (HashMap)object5, (HashMap)object422));
                    object3 = (HashSet)map.get(object4);
                    if (object3 == null) {
                        object3 = new HashSet();
                        map.put(object4, object3);
                    }
                    Object object8 = list.iterator();
                    while (object8.hasNext()) {
                        object7 = (ShareOperation$ShareRequest)object8.next();
                        for (Object object62 : ShareOperation$ShareRequest.access$3((ShareOperation$ShareRequest)object7)) {
                            object3.add(object62.getSandbox());
                        }
                    }
                    if (object3 == null || object3.size() <= 1) continue;
                    object7 = (MultipleSandboxShare)hashMap2.get(object4);
                    if (object7 == null) {
                        object7 = new MultipleSandboxShare((ConfigurationDescriptor)object4, (Set)object3);
                        hashMap2.put(object4, object7);
                    }
                    object62 = list.iterator();
                    while (object62.hasNext()) {
                        object8 = (ShareOperation$ShareRequest)object62.next();
                        ((MultipleSandboxShare)object7).addShareables(ShareOperation$ShareRequest.access$3((ShareOperation$ShareRequest)object8));
                    }
                }
                object.done();
                FileSystemManager fileSystemManager = (FileSystemManager)FileSystemCore.getFileSystemManager(hashMap3.teamRepository());
                iterator = fileSystemManager.getFileSystemService();
                object4 = ((FileSystemServiceProxy)((Object)iterator)).detectOverlap(arrayList, null, (IProgressMonitor)subMonitor2.newChild(1));
                this.recordOverlaps((IWorkspaceConnection)hashMap3, (HashMap)object5, (List)object4, (HashMap)object422);
            }
            subMonitor2.done();
            if (!hashMap2.isEmpty()) {
                int n = this.problemHandler.multipleSandboxesForConfigurations(hashMap2.values());
                if (n == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                if (n != 0) {
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.ShareOperation_6)));
                }
            }
            if (!((HashMap)object422).isEmpty()) {
                int n = this.problemHandler.overlappingShareRequests(((HashMap)object422).values());
                if (n == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                if (n != 0) {
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.ShareProjectsOperation_0)));
                }
                this.updateSharesToDo((HashMap)object422);
            }
            boolean bl = false;
            int n = 0;
            for (HashMap hashMap3 : this.shares.values()) {
                Iterator iterator3 = hashMap3.iterator();
                while (iterator3.hasNext()) {
                    object = (ShareVersionables)iterator3.next();
                    var11_19 += ((ShareVersionables)object).getShareableCount();
                }
            }
            for (HashMap hashMap3 : this.reshares.values()) {
                n += hashMap3.size();
            }
            subMonitor.setWorkRemaining(n * 10 + var11_19 * 5 + 1);
            hashMap3 = new HashMap();
            for (Map.Entry entry : this.shares.entrySet()) {
                List list = (List)entry.getValue();
                iterator = (ConfigurationDescriptor)entry.getKey();
                for (Object object4 : list) {
                    object3 = this.getNewFoldersCreatedUnderParent((ConfigurationDescriptor)((Object)iterator), (ShareVersionables)object4, hashMap3);
                    ((ShareVersionables)object4).share((Map)object3, (IProgressMonitor)subMonitor.newChild(((ShareVersionables)object4).getShareableCount() * 5));
                }
            }
            for (List list : this.reshares.values()) {
                for (ReshareVersionables reshareVersionables : list) {
                    reshareVersionables.reShare((IProgressMonitor)subMonitor.newChild(10));
                }
            }
        }
        finally {
            entry22.release((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private Map getNewFoldersCreatedUnderParent(ConfigurationDescriptor configurationDescriptor, ShareVersionables shareVersionables, Map map) {
        HashMap hashMap;
        if (shareVersionables.newFolderUnderParent.length > 0) {
            HashMap hashMap2 = (HashMap)map.get(configurationDescriptor);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                map.put(configurationDescriptor, hashMap2);
            }
            if ((hashMap = (Map)hashMap2.get(shareVersionables.parentFolder.getItemId())) == null) {
                hashMap = new HashMap();
                hashMap2.put(shareVersionables.parentFolder.getItemId(), hashMap);
            }
        } else {
            hashMap = Collections.EMPTY_MAP;
        }
        return hashMap;
    }

    private void updateSharesToDo(HashMap hashMap) {
        for (ShareOverlap shareOverlap : hashMap.values()) {
            Object object;
            Object object2;
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(shareOverlap.getConnection(), shareOverlap.getComponent());
            IShareable iShareable = shareOverlap.getShareRoot();
            List list = (List)this.reshares.get(configurationDescriptor);
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (ReshareVersionables)object2.next();
                    if (!((ReshareVersionables)object).shareableRoot.equals(iShareable)) continue;
                    object2.remove();
                }
            }
            if ((object2 = (List)this.shares.get(configurationDescriptor)) == null) continue;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ShareVersionables)iterator.next();
                ((ShareVersionables)object).removeProject(iShareable);
            }
        }
    }

    private OverlapRequest buildOverlapRequest(IConnection iConnection, ConfigurationDescriptor configurationDescriptor, HashMap hashMap, HashMap hashMap2) {
        Object object;
        Object object22;
        OverlapRequest overlapRequest = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
        overlapRequest.setContext(configurationDescriptor.connectionHandle);
        overlapRequest.setComponent(configurationDescriptor.componentHandle);
        List list = overlapRequest.getGroup();
        HashMap hashMap3 = (HashMap)hashMap.get(configurationDescriptor);
        List list2 = (List)this.shares.get(configurationDescriptor);
        if (list2 != null) {
            for (Object object22 : list2) {
                ISharingDescriptor iSharingDescriptor;
                list.add(((ShareVersionables)object22).parentFolder);
                if (hashMap3 == null || (object = (IShare)hashMap3.get(((ShareVersionables)object22).parentFolder.getItemId())) == null || !(iSharingDescriptor = object.getSharingDescriptor()).isAssociatedWithConnection(iConnection) || !iSharingDescriptor.getComponent().sameItemId((IItemHandle)configurationDescriptor.componentHandle)) continue;
                for (IShareable iShareable : ((ShareVersionables)object22).getShareables()) {
                    ShareOverlap shareOverlap = (ShareOverlap)hashMap2.get(iShareable);
                    if (shareOverlap == null) {
                        shareOverlap = new ShareOverlap(iConnection, configurationDescriptor.componentHandle, iShareable);
                        hashMap2.put(iShareable, shareOverlap);
                    }
                    shareOverlap.addShareOverlap((IShare)object);
                }
            }
        }
        if ((object22 = (List)this.reshares.get(configurationDescriptor)) != null) {
            object = object22.iterator();
            while (object.hasNext()) {
                Object object3 = (ReshareVersionables)object.next();
                list.add(((ReshareVersionables)object3).remoteShare);
            }
        }
        if (hashMap3 != null) {
            for (Object object3 : hashMap3.values()) {
                list.add(object3.getSharingDescriptor().getRootVersionable());
            }
        }
        return overlapRequest;
    }

    private void recordOverlaps(IWorkspaceConnection iWorkspaceConnection, HashMap hashMap, List list, HashMap hashMap2) {
        for (OverlapResponse overlapResponse : list) {
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor((IConnection)iWorkspaceConnection, overlapResponse.getComponent());
            HashMap hashMap3 = (HashMap)hashMap.get(configurationDescriptor);
            for (OverlapDescription overlapDescription : overlapResponse.getOverlapDescriptions()) {
                ShareOverlap shareOverlap;
                Object object;
                Iterator iterator;
                Object object2;
                Shareable shareable;
                Object object3;
                Shareable shareable2 = this.getResharedProject(configurationDescriptor, overlapDescription.getElement());
                if (shareable2 != null) {
                    object3 = (ShareOverlap)hashMap2.get(shareable2);
                    if (object3 == null) {
                        object3 = new ShareOverlap((IConnection)iWorkspaceConnection, overlapResponse.getComponent(), shareable2);
                        hashMap2.put(shareable2, object3);
                    }
                    for (IVersionableHandle iVersionableHandle : overlapDescription.getOverlappedChildren()) {
                        shareable = this.getResharedProject(configurationDescriptor, iVersionableHandle);
                        if (shareable != null) {
                            ((ShareOverlap)object3).addShareRootOverlap(shareable);
                            object2 = (ShareOverlap)hashMap2.get(shareable);
                            if (object2 == null) {
                                object2 = new ShareOverlap((IConnection)iWorkspaceConnection, overlapResponse.getComponent(), shareable);
                                hashMap2.put(shareable, object2);
                            }
                            ((ShareOverlap)object2).addShareRootOverlap(shareable2);
                        }
                        object2 = this.getSharesForParent(configurationDescriptor, iVersionableHandle);
                        iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            object = (ShareVersionables)iterator.next();
                            for (IShareable iShareable : ((ShareVersionables)object).getShareables()) {
                                ((ShareOverlap)object3).addShareRootOverlap(iShareable);
                                shareOverlap = (ShareOverlap)hashMap2.get(iShareable);
                                if (shareOverlap == null) {
                                    shareOverlap = new ShareOverlap((IConnection)iWorkspaceConnection, overlapResponse.getComponent(), iShareable);
                                    hashMap2.put(iShareable, shareOverlap);
                                }
                                shareOverlap.addShareRootOverlap(shareable2);
                            }
                        }
                        object = (IShare)hashMap3.get(iVersionableHandle);
                        if (object == null) continue;
                        ((ShareOverlap)object3).addShareOverlap((IShare)object);
                    }
                    continue;
                }
                if (hashMap3 == null || (object3 = (IShare)hashMap3.get(overlapDescription.getElement().getItemId())) == null) continue;
                for (IVersionableHandle iVersionableHandle : overlapDescription.getOverlappedChildren()) {
                    shareable = this.getResharedProject(configurationDescriptor, iVersionableHandle);
                    if (shareable != null) {
                        object2 = (ShareOverlap)hashMap2.get(shareable);
                        if (object2 == null) {
                            object2 = new ShareOverlap((IConnection)iWorkspaceConnection, overlapResponse.getComponent(), shareable);
                            hashMap2.put(shareable, object2);
                        }
                        ((ShareOverlap)object2).addShareOverlap((IShare)object3);
                    }
                    object2 = this.getSharesForParent(configurationDescriptor, iVersionableHandle);
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (ShareVersionables)iterator.next();
                        for (IShareable iShareable : ((ShareVersionables)object).getShareables()) {
                            shareOverlap = (ShareOverlap)hashMap2.get(iShareable);
                            if (shareOverlap == null) {
                                shareOverlap = new ShareOverlap((IConnection)iWorkspaceConnection, overlapResponse.getComponent(), iShareable);
                                hashMap2.put(iShareable, shareOverlap);
                            }
                            shareOverlap.addShareOverlap((IShare)object3);
                        }
                    }
                }
            }
        }
    }

    private Collection getSharesForParent(ConfigurationDescriptor configurationDescriptor, IVersionableHandle iVersionableHandle) {
        ArrayList<ShareVersionables> arrayList = new ArrayList<ShareVersionables>();
        List list = (List)this.shares.get(configurationDescriptor);
        if (list != null) {
            for (ShareVersionables shareVersionables : list) {
                if (!shareVersionables.parentFolder.sameItemId((IItemHandle)iVersionableHandle)) continue;
                arrayList.add(shareVersionables);
            }
        }
        return arrayList;
    }

    private Shareable getResharedProject(ConfigurationDescriptor configurationDescriptor, IVersionableHandle iVersionableHandle) {
        List list = (List)this.reshares.get(configurationDescriptor);
        if (list != null) {
            for (ReshareVersionables reshareVersionables : list) {
                if (!reshareVersionables.remoteShare.sameItemId((IItemHandle)iVersionableHandle)) continue;
                return reshareVersionables.shareableRoot;
            }
        }
        return null;
    }

    private void determineReshares(IConnection iConnection, IComponentHandle iComponentHandle, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        ShareOperation$ShareRequest shareOperation$ShareRequest2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IComponent iComponent = (IComponent)iConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, (IProgressMonitor)subMonitor.newChild(2));
        ArrayList<IFolderHandle> arrayList = new ArrayList<IFolderHandle>(list.size());
        for (ShareOperation$ShareRequest shareOperation$ShareRequest2 : list) {
            object = ShareOperation$ShareRequest.access$4(shareOperation$ShareRequest2);
            if (object == null) {
                object = iComponent.getRootFolder();
            }
            arrayList.add((IFolderHandle)object);
        }
        shareOperation$ShareRequest2 = iConnection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)iConnection).configuration(iComponentHandle) : ((IBaselineConnection)iConnection).configuration();
        ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iConnection, iComponentHandle);
        object = shareOperation$ShareRequest2.childEntries(arrayList, (IProgressMonitor)subMonitor);
        int n = 0;
        while (n < list.size()) {
            Object object2;
            Object object3;
            Map map = (Map)object.get(n);
            if (map == null) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.ShareProjectsOperation_1)));
            }
            ShareOperation$ShareRequest shareOperation$ShareRequest3 = (ShareOperation$ShareRequest)list.get(n);
            if (shareOperation$ShareRequest3.isKnownReshare()) {
                object3 = (List)this.reshares.get(configurationDescriptor);
                if (object3 == null) {
                    object3 = new ArrayList();
                    this.reshares.put(configurationDescriptor, object3);
                }
                object2 = shareOperation$ShareRequest2.fetchCompleteItem((IVersionableHandle)ShareOperation$ShareRequest.access$5(shareOperation$ShareRequest3), (IProgressMonitor)subMonitor.newChild(1));
                object3.add(new ReshareVersionables(iConnection, iComponent, object2.getParent(), (IVersionableHandle)ShareOperation$ShareRequest.access$5(shareOperation$ShareRequest3), object2.getName(), (Shareable)ShareOperation$ShareRequest.access$3(shareOperation$ShareRequest3).get(0), ShareOperation$ShareRequest.access$6(shareOperation$ShareRequest3)));
                break;
            }
            object3 = ShareOperation$ShareRequest.access$4(shareOperation$ShareRequest3);
            if (object3 == null) {
                object3 = iComponent.getRootFolder();
            }
            if (ShareOperation$ShareRequest.access$7(shareOperation$ShareRequest3).length > 0 && map.get(ShareOperation$ShareRequest.access$7(shareOperation$ShareRequest3)[0]) != null) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, NLS.bind((String)Messages.ShareProjectsOperation_2, (Object)PathUtils.getString(ShareOperation$ShareRequest.access$7(shareOperation$ShareRequest3)), (Object[])new Object[0]))));
            }
            object2 = new ShareVersionables(ShareOperation$ShareRequest.access$8(shareOperation$ShareRequest3), ShareOperation$ShareRequest.access$9(shareOperation$ShareRequest3), iComponent, (IFolderHandle)object3, ShareOperation$ShareRequest.access$7(shareOperation$ShareRequest3), ShareOperation$ShareRequest.access$6(shareOperation$ShareRequest3), this.problemHandler);
            for (List<Object> list2 : ShareOperation$ShareRequest.access$3(shareOperation$ShareRequest3)) {
                if (ShareOperation$ShareRequest.access$7(shareOperation$ShareRequest3).length > 0) {
                    ((ShareVersionables)object2).addShareable((IShareable)((Object)list2));
                    continue;
                }
                String string = list2.getLocalPath().lastSegment();
                IVersionableHandle iVersionableHandle = (IVersionableHandle)map.get(string);
                if (iVersionableHandle == null) {
                    ((ShareVersionables)object2).addShareable((IShareable)((Object)list2));
                    continue;
                }
                if (ResourceType.getResourceType(iVersionableHandle) == list2.getResourceType((IProgressMonitor)subMonitor.newChild(1))) {
                    ArrayList<ReshareVersionables> arrayList2 = (ArrayList<ReshareVersionables>)this.reshares.get(configurationDescriptor);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<ReshareVersionables>();
                        this.reshares.put(configurationDescriptor, arrayList2);
                    }
                    arrayList2.add(new ReshareVersionables(iConnection, iComponent, (IFolderHandle)object3, iVersionableHandle, string, (Shareable)((Object)list2), ShareOperation$ShareRequest.access$6(shareOperation$ShareRequest3)));
                    continue;
                }
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, NLS.bind((String)Messages.ShareProjectsOperation_3, (Object)list2.getLocalPath(), (Object[])new Object[0]))));
            }
            if (((ShareVersionables)object2).getShareableCount() != 0) {
                List<Object> list2;
                list2 = (List)this.shares.get(configurationDescriptor);
                if (list2 == null) {
                    list2 = new ArrayList<Object>();
                    this.shares.put(configurationDescriptor, list2);
                }
                list2.add(object2);
            }
            ++n;
        }
    }

    private Set getAffectedConfigurations(Set set, Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.shareRequests.size());
        for (Map.Entry entry : this.shareRequests.entrySet()) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
            HashMap hashMap = (HashMap)entry.getValue();
            SubMonitor subMonitor2 = subMonitor.newChild(1).setWorkRemaining(hashMap.size());
            for (Map.Entry entry2 : hashMap.entrySet()) {
                List list = (List)entry2.getValue();
                for (ShareOperation$ShareRequest shareOperation$ShareRequest : list) {
                    set.addAll(shareOperation$ShareRequest.getConfigurationAffected((IProgressMonitor)subMonitor2.newChild(1)));
                }
                if (entry2.getKey() != null) continue;
                collection.add(iWorkspaceConnection.getContextHandle());
            }
        }
        return set;
    }

    private Map findMultipleSandboxForConfig(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        HashMap<ConfigurationDescriptor, HashSet<ISandbox>> hashMap = new HashMap<ConfigurationDescriptor, HashSet<ISandbox>>();
        Collection collection = SharingManager.getInstance().getRegisteredSandboxes();
        for (ISandbox iSandbox : collection) {
            Collection collection2 = iSandbox.allLoadedConfigurations(iProgressMonitor);
            for (LoadedConfigurationDescriptor loadedConfigurationDescriptor : collection2) {
                ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(loadedConfigurationDescriptor.id, loadedConfigurationDescriptor.uri, loadedConfigurationDescriptor.connectionHandle, loadedConfigurationDescriptor.componentHandle);
                if (!set.contains(configurationDescriptor)) continue;
                HashSet<ISandbox> hashSet = (HashSet<ISandbox>)hashMap.get(configurationDescriptor);
                if (hashSet == null) {
                    hashSet = new HashSet<ISandbox>();
                    hashMap.put(configurationDescriptor, hashSet);
                }
                hashSet.add(iSandbox);
            }
        }
        return hashMap;
    }

    private HashMap organizeShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        HashMap hashMap3;
        HashMap<ConfigurationDescriptor, HashMap<UUID, Object>> hashMap2 = new HashMap<ConfigurationDescriptor, HashMap<UUID, Object>>();
        HashSet hashSet = new HashSet();
        for (HashMap hashMap3 : this.shareRequests.values()) {
            for (Object object : hashMap3.values()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ShareOperation$ShareRequest shareOperation$ShareRequest = (ShareOperation$ShareRequest)iterator.next();
                    hashSet.addAll(shareOperation$ShareRequest.getSandboxesAffected());
                }
            }
        }
        hashMap3 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)hashSet.size());
        for (Object object : hashSet) {
            IShare[] iShareArray = object.allShares((IProgressMonitor)hashMap3.newChild(1));
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare iShare = iShareArray[n2];
                if (iShare.getSharingDescriptor() != null) {
                    ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                    ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
                    HashMap<UUID, Object> hashMap4 = (HashMap<UUID, Object>)hashMap2.get(configurationDescriptor);
                    if (hashMap4 == null) {
                        hashMap4 = new HashMap<UUID, Object>();
                        hashMap2.put(configurationDescriptor, hashMap4);
                    }
                    hashMap4.put(iSharingDescriptor.getRootVersionable().getItemId(), iShare);
                }
                ++n2;
            }
        }
        return hashMap2;
    }

    public Collection getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    static /* synthetic */ HashSet access$0(ShareOperation shareOperation) {
        return shareOperation.allShares;
    }

    static /* synthetic */ void access$1(ShareOperation shareOperation, Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        shareOperation.doShare(set, iProgressMonitor);
    }
}

