/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager$ICopyFileAreaLockRequestFactory;
import com.ibm.team.filesystem.client.internal.share.ShareOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

class ShareOperation$ShareRequest {
    private final IWorkspaceConnection workspace;
    private final IChangeSetHandle changeSet;
    private IComponentHandle component;
    private String componentName;
    private IFolderHandle parentFolder;
    private String[] newFolderUnderParent;
    private final boolean overwrite;
    private final List shareableRoots;
    private IFolderHandle remoteShare;
    final /* synthetic */ ShareOperation this$0;

    ShareOperation$ShareRequest(ShareOperation shareOperation, IWorkspaceConnection iWorkspaceConnection, IChangeSetHandle iChangeSetHandle, IComponentHandle iComponentHandle, IFolderHandle iFolderHandle, String[] stringArray, ISandbox iSandbox, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.this$0 = shareOperation;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException(Messages.ShareOperation_0);
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException(Messages.ShareOperation_1);
        }
        this.workspace = iWorkspaceConnection;
        this.changeSet = iChangeSetHandle;
        this.component = iComponentHandle;
        this.parentFolder = iFolderHandle;
        this.newFolderUnderParent = stringArray;
        this.overwrite = bl;
        this.shareableRoots = new ArrayList();
        this.init(iSandbox, list, iProgressMonitor);
    }

    public ShareOperation$ShareRequest(ShareOperation shareOperation, IWorkspaceConnection iWorkspaceConnection, String string, String[] stringArray, ISandbox iSandbox, List list, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.this$0 = shareOperation;
        this.workspace = iWorkspaceConnection;
        this.changeSet = null;
        this.componentName = string;
        this.parentFolder = null;
        this.newFolderUnderParent = stringArray;
        this.overwrite = bl;
        this.shareableRoots = new ArrayList();
        this.init(iSandbox, list, iProgressMonitor);
    }

    public ShareOperation$ShareRequest(ShareOperation shareOperation, IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IChangeSetHandle iChangeSetHandle, IFolderHandle iFolderHandle, ISandbox iSandbox, IPath iPath, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.this$0 = shareOperation;
        this.workspace = iWorkspaceConnection;
        this.changeSet = iChangeSetHandle;
        this.component = iComponentHandle;
        this.overwrite = false;
        this.shareableRoots = new ArrayList();
        this.remoteShare = iFolderHandle;
        this.init(iSandbox, Collections.singletonList(iPath), iProgressMonitor);
    }

    private void init(ISandbox iSandbox, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        IShareable iShareable;
        ResourceType resourceType;
        IFileInfo iFileInfo;
        IFileStore iFileStore;
        Path path;
        String string;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        SharingManager sharingManager = SharingManager.getInstance();
        if (iSandbox == null) {
            for (Object object : list) {
                string = PathUtils.getRealPath(object.removeTrailingSeparator().toOSString());
                if (string == null) {
                    throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_7, (Object)object.toOSString(), (Object[])new Object[0]));
                }
                path = new Path(string);
                iFileStore = EFS.getLocalFileSystem().getStore((IPath)path);
                try {
                    iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (CoreException coreException) {
                    throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_9, (Object)string, (Object[])new Object[0]), (Throwable)coreException);
                }
                resourceType = null;
                if (iFileInfo.getAttribute(32)) {
                    resourceType = ResourceType.SYMBOLIC_LINK;
                } else if (iFileInfo.isDirectory()) {
                    resourceType = ResourceType.FOLDER;
                } else if (iFileInfo.exists()) {
                    resourceType = ResourceType.FILE;
                }
                if (resourceType == null) {
                    throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_2, (Object)string, (Object[])new Object[0]));
                }
                iShareable = sharingManager.findShareable((IPath)path, resourceType);
                if (iShareable == null) {
                    IPath iPath = path.removeLastSegments(1);
                    boolean bl = false;
                    while (!bl && iPath.segmentCount() > 0) {
                        if (iCopyFileAreaManager.copyFileAreaExists(iPath, 1)) {
                            bl = true;
                            continue;
                        }
                        iPath = iPath.removeLastSegments(1);
                    }
                    if (!bl) {
                        iPath = path.removeLastSegments(1);
                    }
                    iShareable = sharingManager.findShareable(sharingManager.getSandbox(iPath, false), path.removeFirstSegments(iPath.segmentCount()).setDevice(null), resourceType);
                }
                this.shareableRoots.add(iShareable);
            }
        } else {
            for (Object object : list) {
                string = PathUtils.getRealPath(iSandbox.getRoot().append((IPath)object).removeTrailingSeparator().toOSString());
                if (string == null) {
                    throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_8, (Object)iSandbox.getRoot().append((IPath)object).toOSString(), (Object[])new Object[0]));
                }
                path = new Path(string);
                iFileStore = EFS.getLocalFileSystem().getStore((IPath)path);
                try {
                    iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (CoreException coreException) {
                    throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.ShareOperation_10, (Object)string, (Object[])new Object[0]), (Throwable)coreException);
                }
                resourceType = null;
                if (iFileInfo.getAttribute(32)) {
                    resourceType = ResourceType.SYMBOLIC_LINK;
                } else if (iFileInfo.isDirectory()) {
                    resourceType = ResourceType.FOLDER;
                } else if (iFileInfo.exists()) {
                    resourceType = ResourceType.FILE;
                }
                if (resourceType == null) {
                    throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_3, (Object)string, (Object[])new Object[0]));
                }
                if (path.segmentCount() <= iSandbox.getRoot().segmentCount()) {
                    throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_4, (Object)string, (Object[])new Object[]{iSandbox.toString()}));
                }
                object = path.removeFirstSegments(iSandbox.getRoot().segmentCount()).setDevice(null);
                iShareable = sharingManager.findShareable(iSandbox, (IPath)object, resourceType);
                this.shareableRoots.add(iShareable);
            }
        }
        for (Object object : this.shareableRoots) {
            if (ShareOperation.access$0(this.this$0).add(object)) continue;
            throw (Throwable)new IllegalArgumentException("Share root specified in more than 1 request: " + object.getFullPath().toString());
        }
    }

    Collection getConfigurationAffected(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.shareableRoots.size());
        if (!this.overwrite) {
            if (this.component == null) {
                return Collections.EMPTY_LIST;
            }
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor((IConnection)this.workspace, this.component);
            return Collections.singletonList(configurationDescriptor);
        }
        ArrayList<ConfigurationDescriptor> arrayList = new ArrayList<ConfigurationDescriptor>(2);
        if (this.component != null) {
            Object object = new ConfigurationDescriptor((IConnection)this.workspace, this.component);
            arrayList.add((ConfigurationDescriptor)object);
        }
        for (Object object : this.shareableRoots) {
            IShare iShare = object.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (iShare == null) continue;
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            arrayList.add(new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent()));
        }
        return arrayList;
    }

    Collection getSandboxesAffected() {
        HashSet<ISandbox> hashSet = new HashSet<ISandbox>();
        for (IShareable iShareable : this.shareableRoots) {
            hashSet.add(iShareable.getSandbox());
        }
        return hashSet;
    }

    String getComponentName() {
        return this.componentName;
    }

    Collection getCopyFileAreaLocksNeeded(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.shareableRoots.size());
        ICopyFileAreaManager$ICopyFileAreaLockRequestFactory iCopyFileAreaManager$ICopyFileAreaLockRequestFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        HashSet<ICopyFileAreaLockRequest> hashSet = new HashSet<ICopyFileAreaLockRequest>();
        for (IShareable iShareable : this.shareableRoots) {
            IShare iShare;
            hashSet.add(iCopyFileAreaManager$ICopyFileAreaLockRequestFactory.getLockRequest(iShareable.getSandbox().getRoot(), Collections.singleton(new ConfigurationDescriptor((IConnection)this.workspace, this.component)), false));
            if (!this.overwrite || (iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1))) == null) continue;
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            hashSet.add(iCopyFileAreaManager$ICopyFileAreaLockRequestFactory.getLockRequest(iShareable.getSandbox().getRoot(), Collections.singleton(new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent())), false));
        }
        return hashSet;
    }

    boolean isKnownReshare() {
        return this.remoteShare != null;
    }

    static /* synthetic */ String access$0(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.componentName;
    }

    static /* synthetic */ void access$1(ShareOperation$ShareRequest shareOperation$ShareRequest, IComponentHandle iComponentHandle) {
        shareOperation$ShareRequest.component = iComponentHandle;
    }

    static /* synthetic */ IComponentHandle access$2(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.component;
    }

    static /* synthetic */ List access$3(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.shareableRoots;
    }

    static /* synthetic */ IFolderHandle access$4(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.parentFolder;
    }

    static /* synthetic */ IFolderHandle access$5(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.remoteShare;
    }

    static /* synthetic */ boolean access$6(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.overwrite;
    }

    static /* synthetic */ String[] access$7(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.newFolderUnderParent;
    }

    static /* synthetic */ IWorkspaceConnection access$8(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.workspace;
    }

    static /* synthetic */ IChangeSetHandle access$9(ShareOperation$ShareRequest shareOperation$ShareRequest) {
        return shareOperation$ShareRequest.changeSet;
    }
}

