/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ReshareVersionables {
    private static final int BUFFER_LENGTH = 16384;
    final IConnection connection;
    final IComponent component;
    final Shareable shareableRoot;
    final IFolderHandle parentForShare;
    final IVersionableHandle remoteShare;
    final String remoteName;
    final boolean overwrite;

    public ReshareVersionables(IConnection iConnection, IComponent iComponent, IFolderHandle iFolderHandle, IVersionableHandle iVersionableHandle, String string, Shareable shareable, boolean bl) {
        this.connection = iConnection;
        this.component = iComponent;
        this.parentForShare = iFolderHandle;
        this.remoteShare = iVersionableHandle;
        this.remoteName = string;
        this.shareableRoot = shareable;
        this.overwrite = bl;
    }

    public void reShare(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        FileItemInfo fileItemInfo;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ITeamRepository iTeamRepository = this.connection.teamRepository();
        FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)FileSystemCore.getFileSystemManager(iTeamRepository)).getFileSystemService();
        iProgressMonitor.setTaskName(NLS.bind((String)Messages.ReshareProject_0, (Object)this.shareableRoot.getLocalPath(), (Object[])new Object[0]));
        IVersionableHandle iVersionableHandle = this.remoteShare;
        if (!this.remoteShare.hasStateId() || this.remoteShare instanceof IFileItemHandle || this.remoteShare instanceof ISymbolicLinkHandle) {
            iVersionableHandle = this.connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)this.connection).configuration((IComponentHandle)this.component).fetchCompleteItem(this.remoteShare, (IProgressMonitor)subMonitor.newChild(2)) : ((IBaselineConnection)this.connection).configuration().fetchCompleteItem(this.remoteShare, (IProgressMonitor)subMonitor.newChild(2));
        }
        if (iVersionableHandle instanceof IFolderHandle) {
            fileItemInfo = new FileItemInfoProxy(iVersionableHandle, this.parentForShare, this.remoteName, PathUtils.isLoadedWithAnotherName(this.shareableRoot.getSandbox(), this.shareableRoot.getLocalPath(), this.remoteName)).getFileItemInfo();
        } else if (iVersionableHandle instanceof ISymbolicLink) {
            object = (ISymbolicLink)iVersionableHandle;
            fileItemInfo = ReshareVersionables.sameLinkContents(this.shareableRoot, (ISymbolicLinkHandle)object.getStateHandle(), this.remoteName, this.parentForShare, object.getTarget(), (IProgressMonitor)subMonitor.newChild(1));
        } else if (iVersionableHandle instanceof IFileItem) {
            object = (IFileItem)iVersionableHandle;
            fileItemInfo = ReshareVersionables.sameFileContents(this.shareableRoot, (IFileItemHandle)object.getStateHandle(), this.remoteName, this.parentForShare, object.isExecutable(), object.getContentType(), (FileContent)object.getContent(), new byte[16384], iTeamRepository, (IProgressMonitor)subMonitor.newChild(1));
        } else {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.ReshareVersionables_0, (Object)this.remoteName, (Object[])new Object[]{iVersionableHandle.getItemType().getName()}));
        }
        object = new SharingDescriptor(iTeamRepository.getRepositoryURI(), iTeamRepository.getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), iVersionableHandle);
        SharingManager.getInstance().share(this.shareableRoot, (ISharingDescriptor)object, fileItemInfo, 1, (IProgressMonitor)subMonitor.newChild(3));
        LoadTree loadTree = fileSystemServiceProxy.getFileTreeByVersionable(this.connection, (IComponentHandle)this.component, new IVersionableHandle[]{this.remoteShare}, -1, true, null, (IProgressMonitor)subMonitor.newChild(20));
        iProgressMonitor.setTaskName(NLS.bind((String)Messages.ReshareProject_1, (Object)this.shareableRoot.getLocalPath().toString(), (Object[])new Object[0]));
        ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.shareableRoot.getSandbox().getRoot());
        this.loadMetadata(iCopyFileArea, loadTree.getFileAreaUpdates(), (IProgressMonitor)subMonitor.newChild(60));
        iCopyFileArea.setConfigurationState(this.connection.getContextHandle(), (IComponentHandle)this.component, this.shareableRoot.getLocalPath(), ISyncTime.FACTORY.createFrom(loadTree.getConfigurationState()), (IProgressMonitor)subMonitor.newChild(5));
        IShare iShare = this.shareableRoot.getShare((IProgressMonitor)subMonitor.newChild(1));
        LocalChangeManager.getInstance().refreshChanges(iShare, null, (IProgressMonitor)subMonitor.newChild(9));
    }

    private void loadMetadata(ICopyFileArea iCopyFileArea, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        HashMap<UUID, IPath> hashMap = new HashMap<UUID, IPath>();
        byte[] byArray = new byte[16384];
        SharingManager sharingManager = SharingManager.getInstance();
        ISandbox iSandbox = this.shareableRoot.getSandbox();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)list.size());
        try {
            try {
                for (FileAreaUpdate fileAreaUpdate : list) {
                    boolean bl;
                    IPath iPath;
                    SubMonitor subMonitor2 = subMonitor.newChild(1);
                    IPath iPath2 = (IPath)hashMap.get(fileAreaUpdate.parent().getItemId());
                    if (iPath2 == null) {
                        iPath = this.shareableRoot.getLocalPath();
                        bl = PathUtils.isLoadedWithAnotherName(iSandbox, iPath, fileAreaUpdate.getName());
                    } else {
                        iPath = iPath2.append(fileAreaUpdate.getName());
                        bl = false;
                    }
                    IVersionableHandle iVersionableHandle = fileAreaUpdate.afterState();
                    Assert.isTrue((boolean)iVersionableHandle.hasStateId());
                    ResourceType resourceType = ResourceType.getResourceType(iVersionableHandle);
                    Shareable shareable = sharingManager.findShareable(iSandbox, iPath, resourceType);
                    ResourceType resourceType2 = shareable.getResourceType((IProgressMonitor)subMonitor2.newChild(1));
                    if (resourceType == ResourceType.FOLDER) {
                        hashMap.put(iVersionableHandle.getItemId(), iPath);
                    }
                    IFolderHandle iFolderHandle = fileAreaUpdate.parent();
                    FileItemInfo fileItemInfo = null;
                    if (resourceType2 != null) {
                        if (resourceType2 == ResourceType.FOLDER) {
                            if (resourceType == ResourceType.FOLDER) {
                                fileItemInfo = new FileItemInfoProxy(iVersionableHandle, iFolderHandle, fileAreaUpdate.getName(), bl).getFileItemInfo();
                            }
                        } else if (resourceType2 == ResourceType.FILE) {
                            if (resourceType == ResourceType.FILE) {
                                subMonitor2.setWorkRemaining(2);
                                fileItemInfo = ReshareVersionables.sameFileContents(shareable, (IFileItemHandle)fileAreaUpdate.afterState(), fileAreaUpdate.getName(), fileAreaUpdate.getDestinationParent(), fileAreaUpdate.isExecutable(), fileAreaUpdate.getContentType(), (FileContent)fileAreaUpdate.getOptionalContent(), byArray, this.connection.teamRepository(), (IProgressMonitor)subMonitor2.newChild(1));
                            }
                        } else if (resourceType2 == ResourceType.SYMBOLIC_LINK && resourceType == ResourceType.SYMBOLIC_LINK) {
                            subMonitor2.setWorkRemaining(2);
                            fileItemInfo = ReshareVersionables.sameLinkContents(shareable, (ISymbolicLinkHandle)fileAreaUpdate.afterState(), fileAreaUpdate.getName(), fileAreaUpdate.getDestinationParent(), fileAreaUpdate.getLinkTarget(), (IProgressMonitor)subMonitor2);
                        }
                    }
                    subMonitor2.setWorkRemaining(1);
                    if (fileItemInfo != null) {
                        subMonitor2.setWorkRemaining(1);
                        iCopyFileArea.setItemMetaData(iPath, fileItemInfo, (IProgressMonitor)subMonitor2.newChild(1));
                    } else {
                        long l;
                        boolean bl2;
                        Object object;
                        ContentHash contentHash = null;
                        long l2 = -1L;
                        FileLineDelimiter fileLineDelimiter = null;
                        String string = null;
                        ContentHash contentHash2 = null;
                        long l3 = -1L;
                        String string2 = null;
                        ContentHash contentHash3 = null;
                        long l4 = -1L;
                        if (fileAreaUpdate.getOptionalContent() != null) {
                            object = (FileContent)fileAreaUpdate.getOptionalContent();
                            if (FileSystemCore.getContentManager(this.connection.teamRepository()).convertDelimitersDuringRetrieval((IFileContent)object)) {
                                subMonitor2.setWorkRemaining(10);
                                InputStream inputStream = FileSystemCore.getContentManager(this.connection.teamRepository()).retrieveContentStream((IFileItemHandle)fileAreaUpdate.afterState(), (IFileContent)object, (IProgressMonitor)subMonitor2.newChild(9));
                                try {
                                    DigestComputingInputStream digestComputingInputStream = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                    while (digestComputingInputStream.read(byArray) != -1) {
                                    }
                                    contentHash = ContentHash.valueOf((byte[])digestComputingInputStream.getFinalDigest());
                                    l2 = digestComputingInputStream.getContentSize();
                                }
                                finally {
                                    inputStream.close();
                                }
                            } else {
                                contentHash = object.getHash();
                                l2 = object.getEstimatedConvertedLength();
                            }
                            fileLineDelimiter = object.getLineDelimiter();
                            string = fileAreaUpdate.getContentType();
                            contentHash2 = object.getPredecessorHintHash();
                            l3 = object.getSize();
                            string2 = object.getCharacterEncoding();
                            contentHash3 = object.getHash();
                            l4 = object.getLineDelimiterCount();
                        } else if (fileAreaUpdate.afterState() instanceof ISymbolicLinkHandle) {
                            contentHash = contentHash3 = FileItemInfoProxy.getLinkTargetHash(fileAreaUpdate.getLinkTarget());
                        }
                        subMonitor2.setWorkRemaining(1);
                        object = iCopyFileArea.getItemInfo(iVersionableHandle, (IComponentHandle)this.component, this.connection.getContextHandle());
                        if (object == null || iVersionableHandle instanceof IFolderHandle) {
                            bl2 = false;
                            l = -1L;
                        } else if (((FileItemInfo)object).getHash() != null && ((FileItemInfo)object).getHash().equals((Object)contentHash) && (iVersionableHandle instanceof ISymbolicLinkHandle || iVersionableHandle instanceof IFileItemHandle && ((FileItemInfo)object).getContentLength() == l2)) {
                            bl2 = ((FileItemInfo)object).isContentChanged();
                            l = ((FileItemInfo)object).getLastContentChangeCheckStamp();
                        } else {
                            bl2 = true;
                            l = -1L;
                        }
                        fileItemInfo = new FileItemInfo(iVersionableHandle, bl2, l, iFolderHandle, fileAreaUpdate.getName(), bl, contentHash, l2, fileLineDelimiter, fileLineDelimiter, string, string, contentHash2, l3, string2, contentHash3, l4, fileAreaUpdate.isExecutable(), fileAreaUpdate.isExecutable());
                        iCopyFileArea.setItemMetaData(this.connection.getContextHandle(), (IComponentHandle)this.component, fileItemInfo, (IProgressMonitor)subMonitor2.newChild(1));
                    }
                    subMonitor2.done();
                }
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(teamRepositoryException)));
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private static FileItemInfo sameLinkContents(Shareable shareable, ISymbolicLinkHandle iSymbolicLinkHandle, String string, IFolderHandle iFolderHandle, String string2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ContentHash contentHash = FileItemInfoProxy.getLinkTargetHash(shareable.getFileStorage().getTarget((IProgressMonitor)subMonitor.newChild(1)));
        ContentHash contentHash2 = FileItemInfoProxy.getLinkTargetHash(string2);
        boolean bl = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), string);
        boolean bl2 = !contentHash.equals((Object)contentHash2);
        return new FileItemInfo(iSymbolicLinkHandle, bl2, iFolderHandle, string, bl, contentHash2, contentHash2);
    }

    private static FileItemInfo sameFileContents(Shareable shareable, IFileItemHandle iFileItemHandle, String string, IFolderHandle iFolderHandle, boolean bl, String string2, FileContent fileContent, byte[] byArray, ITeamRepository iTeamRepository, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        IFileInfo iFileInfo;
        Object object;
        String string3;
        String string4;
        FileLineDelimiter fileLineDelimiter;
        FileLineDelimiter fileLineDelimiter2;
        Object object2;
        long l;
        boolean bl2;
        long l2;
        SubMonitor subMonitor;
        block32: {
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            l2 = -1L;
            bl2 = true;
            l = fileContent.getEstimatedConvertedLength();
            object2 = null;
            fileLineDelimiter2 = fileContent.getLineDelimiter();
            fileLineDelimiter = fileContent.getLineDelimiter();
            string4 = string2;
            string3 = string2;
            IFileStorage iFileStorage = shareable.getFileStorage();
            URI uRI = iFileStorage.getLocationURI();
            if (uRI != null) {
                try {
                    DigestComputingInputStream digestComputingInputStream;
                    DigestComputingInputStream digestComputingInputStream2;
                    String string5;
                    object = EFS.getStore((URI)uRI);
                    iFileInfo = object.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
                    l2 = iFileStorage.getModificationStamp();
                    long l3 = iFileInfo.getLength();
                    if (l3 != fileContent.getEstimatedConvertedLength()) break block32;
                    InputStream inputStream = object.openInputStream(0, (IProgressMonitor)subMonitor.newChild(78));
                    IContentExaminer iContentExaminer = SharingManager.getInstance().getContentExaminer();
                    try {
                        block6 : switch (fileLineDelimiter2) {
                            case LINE_DELIMITER_CR: {
                                string5 = iContentExaminer.getEncoding(shareable, (IProgressMonitor)subMonitor.newChild(1));
                                inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inputStream, string5));
                                digestComputingInputStream = digestComputingInputStream2 = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                break;
                            }
                            case LINE_DELIMITER_PLATFORM: {
                                string5 = iContentExaminer.getEncoding(shareable, (IProgressMonitor)subMonitor.newChild(1));
                                switch (FileLineDelimiter.getPlatformDelimiter()) {
                                    case LINE_DELIMITER_CRLF: {
                                        inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inputStream, string5));
                                        digestComputingInputStream = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                        inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream((InputStream)digestComputingInputStream, string5));
                                        digestComputingInputStream2 = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                        break block6;
                                    }
                                    case LINE_DELIMITER_CR: {
                                        inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inputStream, string5));
                                        digestComputingInputStream = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                        inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream((InputStream)digestComputingInputStream, string5));
                                        digestComputingInputStream2 = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                        break block6;
                                    }
                                }
                                inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inputStream, string5));
                                digestComputingInputStream = digestComputingInputStream2 = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                break;
                            }
                            case LINE_DELIMITER_LF: {
                                string5 = iContentExaminer.getEncoding(shareable, (IProgressMonitor)subMonitor.newChild(1));
                                inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inputStream, string5));
                                digestComputingInputStream = digestComputingInputStream2 = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                break;
                            }
                            case LINE_DELIMITER_CRLF: {
                                string5 = iContentExaminer.getEncoding(shareable, (IProgressMonitor)subMonitor.newChild(1));
                                inputStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inputStream, string5));
                                digestComputingInputStream = digestComputingInputStream2 = ContentHash.getDigestComputingStream((InputStream)inputStream);
                                break;
                            }
                            default: {
                                digestComputingInputStream = digestComputingInputStream2 = ContentHash.getDigestComputingStream((InputStream)inputStream);
                            }
                        }
                        while (digestComputingInputStream2.read(byArray) != -1) {
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    string5 = ContentHash.valueOf((byte[])digestComputingInputStream2.getFinalDigest());
                    if (string5.equals((Object)fileContent.getHash()) && digestComputingInputStream2.getContentSize() == fileContent.getRawLength() && digestComputingInputStream.getContentSize() == fileContent.getEstimatedConvertedLength()) {
                        object2 = digestComputingInputStream == digestComputingInputStream2 ? string5 : ContentHash.valueOf((byte[])digestComputingInputStream.getFinalDigest());
                        l = digestComputingInputStream.getContentSize();
                        bl2 = false;
                    }
                }
                catch (ContentLineDelimiterError contentLineDelimiterError) {
                    fileLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {
                    fileLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                }
            }
        }
        if (object2 == null) {
            if (FileSystemCore.getContentManager(iTeamRepository).convertDelimitersDuringRetrieval((IFileContent)fileContent)) {
                subMonitor.setWorkRemaining(20);
                object = FileSystemCore.getContentManager(iTeamRepository).retrieveContentStream(iFileItemHandle, (IFileContent)fileContent, (IProgressMonitor)subMonitor.newChild(20));
                try {
                    try {
                        iFileInfo = ContentHash.getDigestComputingStream((InputStream)object);
                        while (iFileInfo.read(byArray) != -1) {
                        }
                        object2 = ContentHash.valueOf((byte[])iFileInfo.getFinalDigest());
                        l = iFileInfo.getContentSize();
                    }
                    catch (IOException iOException) {
                        throw (Throwable)new TeamRepositoryException((Throwable)iOException);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            } else {
                object2 = fileContent.getHash();
                l = fileContent.getEstimatedConvertedLength();
            }
        }
        boolean bl3 = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), string);
        return new FileItemInfo((IVersionableHandle)iFileItemHandle, bl2, l2, iFolderHandle, string, bl3, (ContentHash)object2, l, fileLineDelimiter2, fileLineDelimiter, string4, string3, fileContent.getPredecessorHintHash(), fileContent.getSize(), fileContent.getCharacterEncoding(), fileContent.getHash(), fileContent.getLineDelimiterCount(), bl, bl);
    }
}

