/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest;

import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.client.internal.magic.MagicPattern;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMagicList;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.MagicDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class MagicUtil {
    public static MagicDTO[] getMagic(IProgressMonitor monitor) {
        LocalContentExaminer ex = (LocalContentExaminer)LocalContentExaminer.getInstance();
        List patterns = ex.getMatchers(monitor);
        MagicDTO[] toReturn = new MagicDTO[patterns.size()];
        int i = 0;
        for (MagicPattern pat : patterns) {
            toReturn[i++] = MagicUtil.translate(pat);
        }
        return toReturn;
    }

    private static MagicDTO translate(MagicPattern pat) {
        MagicDTO dto = FilesystemRestClientDTOresourceFactory.eINSTANCE.createMagicDTO();
        dto.setPattern(pat.getPattern());
        dto.setEncoding(pat.getEncoding());
        dto.setLineDelimiter(LocalContentExaminer.getLineDelimiter(pat.getDelim()));
        dto.setMimeType(pat.getMimeType());
        dto.setBuiltIn(pat.isBuiltIn());
        return dto;
    }

    private static MagicPattern translate(ParmsMagicList.ParmsMagicEntry entry) {
        FileLineDelimiter delim;
        try {
            delim = LocalContentExaminer.getLineDelimiter(entry.delim);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delim = null;
        }
        return new MagicPattern(entry.pattern, entry.ignoreCase, entry.mimeType, delim, entry.encoding);
    }

    public static void postMagic(ParmsMagicList parms, IProgressMonitor monitor) throws TeamRepositoryException {
        ParmsMagicList.ParmsMagicEntry[] patterns = parms.entries;
        if (patterns == null) {
            patterns = new ParmsMagicList.ParmsMagicEntry[]{};
        }
        ArrayList<MagicPattern> toSave = new ArrayList<MagicPattern>(patterns.length);
        ParmsMagicList.ParmsMagicEntry[] parmsMagicEntryArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsMagicList.ParmsMagicEntry entry = parmsMagicEntryArray[n2];
            toSave.add(MagicUtil.translate(entry));
            ++n2;
        }
        LocalContentExaminer newExaminer = new LocalContentExaminer(parms.magicFileLocation);
        try {
            newExaminer.setMatchers(toSave, monitor);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        newExaminer.makeDefault();
    }
}

