/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateRequest$RequestType;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUpdateRequest {
    private WorkspaceUpdateRequest$RequestType type;
    private List baselines;
    private Map acceptComponents;
    private Map replaceComponents;
    private List changeSets;
    private List newComponentNames;
    private Map addComponents;
    private Map removeComponents;
    private IWorkspaceConnection workspace;
    private IBaselineConnection sourceBaselineConnection;
    private IBaselineSetHandle sourceSnapshot;
    private IWorkspaceConnection sourceWorkspace;
    private ITeamRepository sourceRepository = null;
    private IChangeHistorySyncReport syncReport;
    private HashSet affectedConfigurations;
    private Map componentOperations;
    private Map replaceCandidates;
    private List allBaselines;
    private List allChangeSets;

    private WorkspaceUpdateRequest(WorkspaceUpdateRequest$RequestType workspaceUpdateRequest$RequestType, IWorkspaceConnection iWorkspaceConnection) {
        this.type = workspaceUpdateRequest$RequestType;
        this.workspace = iWorkspaceConnection;
        this.sourceWorkspace = null;
        this.syncReport = null;
        this.baselines = new ArrayList();
        this.acceptComponents = new HashMap();
        this.replaceComponents = new HashMap();
        this.changeSets = new ArrayList();
        this.newComponentNames = new ArrayList();
        this.addComponents = new HashMap();
        this.removeComponents = new HashMap();
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, List list) {
        this(WorkspaceUpdateRequest$RequestType.CHANGE_SET_ONLY, iWorkspaceConnection);
        this.changeSets.addAll(list);
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, ITeamRepository iTeamRepository, List list) {
        this(WorkspaceUpdateRequest$RequestType.CHANGE_SET_ONLY, iWorkspaceConnection);
        this.changeSets.addAll(list);
        this.sourceRepository = iTeamRepository;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2, List list3) {
        this(WorkspaceUpdateRequest$RequestType.CHOICE, iWorkspaceConnection);
        this.sourceWorkspace = iWorkspaceConnection2;
        this.syncReport = iChangeHistorySyncReport;
        this.changeSets = new ArrayList(list2);
        this.baselines = new ArrayList(list);
        for (IComponentHandle iComponentHandle : list3) {
            this.acceptComponents.put(iComponentHandle.getItemId(), iComponentHandle);
        }
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, List list, boolean bl) {
        this(WorkspaceUpdateRequest$RequestType.CHOICE, iWorkspaceConnection);
        this.sourceWorkspace = iWorkspaceConnection2;
        this.syncReport = iChangeHistorySyncReport;
        Map map = bl ? this.replaceComponents : this.acceptComponents;
        for (IComponentHandle iComponentHandle : list) {
            map.put(iComponentHandle.getItemId(), iComponentHandle);
        }
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, boolean bl) {
        this(bl ? WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_REPLACE : WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_ACCEPT, iWorkspaceConnection);
        this.sourceWorkspace = iWorkspaceConnection2;
        this.syncReport = iChangeHistorySyncReport;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, IBaselineSetHandle iBaselineSetHandle, List list) {
        this(WorkspaceUpdateRequest$RequestType.CHOICE, iWorkspaceConnection);
        this.sourceSnapshot = iBaselineSetHandle;
        for (IComponentHandle iComponentHandle : list) {
            this.replaceComponents.put(iComponentHandle.getItemId(), iComponentHandle);
        }
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, IBaselineSetHandle iBaselineSetHandle) {
        this(WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_REPLACE, iWorkspaceConnection);
        this.sourceSnapshot = iBaselineSetHandle;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, IBaselineConnection iBaselineConnection) {
        this(WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_REPLACE, iWorkspaceConnection);
        this.sourceBaselineConnection = iBaselineConnection;
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, String string) {
        this(WorkspaceUpdateRequest$RequestType.CHOICE, iWorkspaceConnection);
        this.newComponentNames.add(string);
    }

    public WorkspaceUpdateRequest(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, boolean bl) {
        this(WorkspaceUpdateRequest$RequestType.CHOICE, iWorkspaceConnection);
        if (bl) {
            this.addComponents.put(iComponentHandle.getItemId(), iComponentHandle);
        } else {
            this.removeComponents.put(iComponentHandle.getItemId(), iComponentHandle);
        }
    }

    public void addComponents(List list, boolean bl) throws TeamRepositoryException {
        if (this.type == WorkspaceUpdateRequest$RequestType.CHOICE) {
            if (!bl && this.sourceWorkspace == null) {
                throw (Throwable)new TeamRepositoryException(Messages.WorkspaceUpdateRequest_2);
            }
            Map map = bl ? this.replaceComponents : this.acceptComponents;
            Map map2 = bl ? this.acceptComponents : this.replaceComponents;
            for (IComponentHandle iComponentHandle : list) {
                map.put(iComponentHandle.getItemId(), iComponentHandle);
                if (!map2.containsKey(iComponentHandle.getItemId())) continue;
                throw (Throwable)new TeamRepositoryException(Messages.WorkspaceUpdateRequest_0);
            }
            this.resetCachedInfo();
        }
    }

    public void addChangeSets(List list) {
        if (this.type == WorkspaceUpdateRequest$RequestType.CHANGE_SET_ONLY || this.type == WorkspaceUpdateRequest$RequestType.CHOICE) {
            this.changeSets.addAll(list);
            this.resetCachedInfo();
        }
    }

    public void addBaselines(List list) {
        if (this.type == WorkspaceUpdateRequest$RequestType.CHOICE) {
            this.baselines.addAll(list);
            this.resetCachedInfo();
        }
    }

    public void addNewComponent(String string) {
        this.newComponentNames.add(string);
    }

    public void addNewComponent(IComponentHandle iComponentHandle) {
        this.addComponents.put(iComponentHandle.getItemId(), iComponentHandle);
    }

    public void removeComponent(IComponentHandle iComponentHandle) {
        this.removeComponents.put(iComponentHandle.getItemId(), iComponentHandle);
    }

    public void updateSyncReport(IChangeHistorySyncReport iChangeHistorySyncReport) {
        this.syncReport = iChangeHistorySyncReport;
        this.resetCachedInfo();
    }

    public void setWorkspaceContext(boolean bl) {
        if (!bl && this.sourceWorkspace == null) {
            throw (Throwable)new IllegalArgumentException("Can only accept from workspaces");
        }
        this.type = bl ? WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_REPLACE : WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_ACCEPT;
        this.changeSets.clear();
        this.replaceComponents.clear();
        this.acceptComponents.clear();
        this.baselines.clear();
        this.resetCachedInfo();
    }

    public boolean isChangeSetContext() {
        return this.type == WorkspaceUpdateRequest$RequestType.CHANGE_SET_ONLY;
    }

    public List getBaselines(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.decideChanges(iProgressMonitor);
        return Collections.unmodifiableList(this.allBaselines);
    }

    public List getChangeSets(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.decideChanges(iProgressMonitor);
        return Collections.unmodifiableList(this.allChangeSets);
    }

    public List getNewComponentNames() {
        return Collections.unmodifiableList(this.newComponentNames);
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IWorkspaceConnection getSourceWorkspace() {
        return this.sourceWorkspace;
    }

    public ITeamRepository getSourceRepository() {
        return this.sourceRepository;
    }

    public IBaselineSetHandle getSourceSnapshot() {
        return this.sourceSnapshot;
    }

    public IBaselineConnection getSourceBaseline() {
        return this.sourceBaselineConnection;
    }

    public IChangeHistorySyncReport getSyncReport(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (this.syncReport == null && this.sourceWorkspace != null) {
            this.recomputeSyncReport(iProgressMonitor);
        }
        return this.syncReport;
    }

    public Collection getComponentOperations(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.decideChanges(iProgressMonitor);
        return Collections.unmodifiableCollection(this.componentOperations.values());
    }

    public Collection getReplaceCandidates(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.decideChanges(iProgressMonitor);
        return Collections.unmodifiableCollection(this.replaceCandidates.values());
    }

    private Collection getAffectedComponents(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Iterator<Object> iterator;
        Iterator iterator2;
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        HashMap<UUID, Object> hashMap = new HashMap<UUID, Object>();
        if (this.type == WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_ACCEPT || this.type == WorkspaceUpdateRequest$RequestType.WORKSPACE_CONTEXT_REPLACE) {
            if (this.sourceBaselineConnection == null) {
                for (Object object2 : this.workspace.getComponents()) {
                    hashMap.put(object2.getItemId(), object2);
                }
            } else {
                hashMap.put(this.sourceBaselineConnection.getComponent().getItemId(), this.sourceBaselineConnection.getComponent());
            }
        }
        if (!this.changeSets.isEmpty()) {
            object2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)subMonitor.newChild(50));
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                iterator = (IChangeSet)iterator2.next();
                hashMap.put(iterator.getComponent().getItemId(), iterator.getComponent());
            }
        }
        if (!this.baselines.isEmpty()) {
            object2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)subMonitor.newChild(50));
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                iterator = (IBaseline)iterator2.next();
                hashMap.put(iterator.getComponent().getItemId(), iterator.getComponent());
            }
        }
        for (Object object2 : this.acceptComponents.values()) {
            hashMap.put(object2.getItemId(), object2);
        }
        for (Object object2 : this.replaceComponents.values()) {
            hashMap.put(object2.getItemId(), object2);
        }
        return hashMap.values();
    }

    public Collection getAffectedConfigurations(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (this.affectedConfigurations == null) {
            IChangeSet iChangeSet;
            Iterator iterator;
            Object object2;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            this.decideChanges((IProgressMonitor)subMonitor.newChild(80));
            this.affectedConfigurations = new HashSet();
            if (!this.replaceCandidates.isEmpty()) {
                for (Object object2 : this.replaceCandidates.values()) {
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, object2.getComponent()));
                }
            }
            if (!this.componentOperations.isEmpty()) {
                for (Object object2 : this.componentOperations.values()) {
                    if (object2 instanceof IFlowNodeConnection.IComponentAdditionOp) continue;
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, object2.getComponent()));
                }
            }
            if (!this.allChangeSets.isEmpty()) {
                object2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.allChangeSets, 0, (IProgressMonitor)subMonitor.newChild(50));
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    iChangeSet = (IChangeSet)iterator.next();
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, iChangeSet.getComponent()));
                }
            }
            if (!this.allBaselines.isEmpty()) {
                object2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.allBaselines, 0, (IProgressMonitor)subMonitor.newChild(50));
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    iChangeSet = (IBaseline)iterator.next();
                    this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspace, iChangeSet.getComponent()));
                }
            }
        }
        return Collections.unmodifiableCollection(this.affectedConfigurations);
    }

    public void excludeComponentOps(List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        this.decideChanges(iProgressMonitor);
        for (IComponentHandle iComponentHandle : list) {
            if (this.componentOperations.containsKey(iComponentHandle.getItemId())) {
                this.componentOperations.remove(iComponentHandle.getItemId());
            }
            if (!this.replaceCandidates.containsKey(iComponentHandle.getItemId())) continue;
            this.replaceCandidates.remove(iComponentHandle.getItemId());
            this.decideComponentChanges(iComponentHandle);
        }
    }

    private void decideComponentChanges(IComponentHandle iComponentHandle) {
        if (this.allChangeSets == null) {
            this.allChangeSets = new ArrayList();
        }
        if (this.allBaselines == null) {
            this.allBaselines = new ArrayList();
        }
        if (this.syncReport != null) {
            if ((this.syncReport.getFlags() & WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO) == WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO) {
                IBaselineHandle iBaselineHandle = (IBaselineHandle)this.syncReport.remoteBases().get(iComponentHandle);
                for (IBaselineHandle iBaselineHandle2 : this.syncReport.incomingBaselines(iComponentHandle)) {
                    if (!iBaselineHandle2.sameItemId((IItemHandle)iBaselineHandle)) continue;
                    this.allBaselines.add(iBaselineHandle);
                    break;
                }
                this.allChangeSets.addAll(this.syncReport.incomingChangeSetsAfterBasis(iComponentHandle));
            } else {
                this.allChangeSets.addAll(this.syncReport.incomingChangeSets(iComponentHandle));
            }
        }
    }

    public void decideChanges(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.componentOperations == null) {
            this.componentOperations = new HashMap();
            this.replaceCandidates = new HashMap();
            this.allBaselines = new ArrayList();
            this.allChangeSets = new ArrayList();
            switch (this.type) {
                case CHOICE: {
                    IBaselineConnection iBaselineConnection;
                    IComponentHandle iComponentHandle222;
                    if (this.sourceWorkspace != null) {
                        List list = FlowUtils.getAcceptComponentSynchronizationOps((boolean)false, (Collection)this.getAffectedComponents((IProgressMonitor)subMonitor.newChild(10)), (IWorkspaceConnection)this.sourceWorkspace, (IWorkspaceConnection)this.workspace, (IChangeHistorySyncReport)this.getSyncReport((IProgressMonitor)subMonitor.newChild(90)));
                        for (IComponentHandle iComponentHandle222 : list) {
                            this.componentOperations.put(iComponentHandle222.getComponent().getItemId(), iComponentHandle222);
                        }
                        list = null;
                        for (IComponentHandle iComponentHandle222 : this.replaceComponents.values()) {
                            if (this.componentOperations.containsKey(iComponentHandle222.getItemId())) continue;
                            this.componentOperations.put(iComponentHandle222.getItemId(), this.workspace.componentOpFactory().replaceComponent(iComponentHandle222, (IConnection)this.sourceWorkspace, true));
                        }
                        this.decideComponentChanges(this.acceptComponents.values());
                        this.decideIndividualChanges((IProgressMonitor)subMonitor.newChild(1));
                        break;
                    }
                    if (this.sourceSnapshot == null) break;
                    IBaselineSet iBaselineSet = (IBaselineSet)this.workspace.teamRepository().itemManager().fetchCompleteItem((IItemHandle)this.sourceSnapshot, 0, (IProgressMonitor)subMonitor.newChild(10));
                    iComponentHandle222 = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspace.teamRepository());
                    Object object2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(iBaselineSet.getBaselines(), 0, (IProgressMonitor)subMonitor.newChild(10));
                    HashMap<UUID, IBaselineConnection> hashMap = new HashMap<UUID, IBaselineConnection>();
                    subMonitor.setWorkRemaining(10 * this.replaceComponents.size());
                    for (IBaselineHandle iBaselineHandle : this.replaceComponents.values()) {
                        iBaselineConnection = null;
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            IBaseline iBaseline = (IBaseline)iterator.next();
                            if (iBaseline == null || !iBaselineHandle.sameItemId((IItemHandle)iBaseline.getComponent())) continue;
                            iBaselineConnection = iComponentHandle222.getBaselineConnection(iBaseline, (IProgressMonitor)subMonitor.newChild(10));
                            break;
                        }
                        if (iBaselineConnection == null) {
                            throw (Throwable)new TeamRepositoryException(Messages.WorkspaceUpdateRequest_1);
                        }
                        hashMap.put(iBaselineHandle.getItemId(), iBaselineConnection);
                    }
                    for (IBaselineHandle iBaselineHandle : this.workspace.getComponents()) {
                        iBaselineConnection = (IBaselineConnection)hashMap.remove(iBaselineHandle.getItemId());
                        if (iBaselineConnection == null) continue;
                        this.componentOperations.put(iBaselineHandle.getItemId(), this.workspace.componentOpFactory().replaceComponent((IComponentHandle)iBaselineHandle, (IConnection)iBaselineConnection, true));
                    }
                    for (IBaselineHandle iBaselineHandle : hashMap.values()) {
                        this.componentOperations.put(iBaselineHandle.getComponent().getItemId(), this.workspace.componentOpFactory().addComponent(iBaselineHandle.getComponent(), (IConnection)iBaselineHandle, false));
                    }
                    break;
                }
                case WORKSPACE_CONTEXT_ACCEPT: {
                    IComponentHandle iComponentHandle222;
                    List list = FlowUtils.getAcceptComponentSynchronizationOps((boolean)true, (Collection)this.workspace.getComponents(), (IWorkspaceConnection)this.sourceWorkspace, (IWorkspaceConnection)this.workspace, (IChangeHistorySyncReport)this.getSyncReport((IProgressMonitor)subMonitor.newChild(90)));
                    for (IComponentHandle iComponentHandle222 : list) {
                        this.componentOperations.put(iComponentHandle222.getComponent().getItemId(), iComponentHandle222);
                    }
                    list = null;
                    this.decideComponentChanges(this.workspace.getComponents());
                    break;
                }
                case WORKSPACE_CONTEXT_REPLACE: {
                    IBaselineConnection iBaselineConnection;
                    HashMap<UUID, IBaselineConnection> hashMap;
                    Object object2;
                    IComponentHandle iComponentHandle222;
                    if (this.sourceWorkspace != null) {
                        IChangeHistorySyncReport iChangeHistorySyncReport = this.getSyncReport((IProgressMonitor)subMonitor.newChild(10));
                        iComponentHandle222 = new HashMap();
                        for (Object object2 : iChangeHistorySyncReport.remoteComponents()) {
                            iComponentHandle222.put(object2.getItemId(), object2);
                        }
                        for (Object object2 : iChangeHistorySyncReport.localComponents()) {
                            if (iComponentHandle222.remove(object2.getItemId()) != null) {
                                if (iChangeHistorySyncReport.incomingChangeSets((IComponentHandle)object2).isEmpty() && iChangeHistorySyncReport.outgoingChangeSets((IComponentHandle)object2).isEmpty() && iChangeHistorySyncReport.incomingBaselines((IComponentHandle)object2).isEmpty() && iChangeHistorySyncReport.outgoingBaselines((IComponentHandle)object2).isEmpty()) continue;
                                this.componentOperations.put(object2.getItemId(), this.workspace.componentOpFactory().replaceComponent((IComponentHandle)object2, (IConnection)this.sourceWorkspace, true));
                                continue;
                            }
                            this.componentOperations.put(object2.getItemId(), this.workspace.componentOpFactory().removeComponent((IComponentHandle)object2, false));
                        }
                        for (Object object2 : iComponentHandle222.values()) {
                            this.componentOperations.put(object2.getItemId(), this.workspace.componentOpFactory().addComponent((IComponentHandle)object2, (IConnection)this.sourceWorkspace, false));
                        }
                        break;
                    }
                    if (this.sourceSnapshot != null) {
                        IBaselineSet iBaselineSet = (IBaselineSet)this.workspace.teamRepository().itemManager().fetchCompleteItem((IItemHandle)this.sourceSnapshot, 0, (IProgressMonitor)subMonitor.newChild(10));
                        iComponentHandle222 = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspace.teamRepository());
                        object2 = subMonitor.newChild(10).setWorkRemaining(iBaselineSet.getBaselines().size());
                        hashMap = new HashMap();
                        for (IBaselineHandle iBaselineHandle : iBaselineSet.getBaselines()) {
                            iBaselineConnection = iComponentHandle222.getBaselineConnection(iBaselineHandle, (IProgressMonitor)object2.newChild(1));
                            hashMap.put(iBaselineConnection.getComponent().getItemId(), iBaselineConnection);
                        }
                        for (IBaselineHandle iBaselineHandle : this.workspace.getComponents()) {
                            iBaselineConnection = (IBaselineConnection)hashMap.remove(iBaselineHandle.getItemId());
                            if (iBaselineConnection != null) {
                                this.componentOperations.put(iBaselineHandle.getItemId(), this.workspace.componentOpFactory().replaceComponent((IComponentHandle)iBaselineHandle, (IConnection)iBaselineConnection, true));
                                continue;
                            }
                            this.componentOperations.put(iBaselineHandle.getItemId(), this.workspace.componentOpFactory().removeComponent((IComponentHandle)iBaselineHandle, false));
                        }
                        for (IBaselineHandle iBaselineHandle : hashMap.values()) {
                            this.componentOperations.put(iBaselineHandle.getComponent().getItemId(), this.workspace.componentOpFactory().addComponent(iBaselineHandle.getComponent(), (IConnection)iBaselineHandle, false));
                        }
                        break;
                    }
                    if (this.sourceBaselineConnection == null) break;
                    boolean bl = false;
                    for (IComponentHandle iComponentHandle222 : this.workspace.getComponents()) {
                        if (!iComponentHandle222.sameItemId((IItemHandle)this.sourceBaselineConnection.getComponent())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.componentOperations.put(this.sourceBaselineConnection.getComponent().getItemId(), this.workspace.componentOpFactory().addComponent(this.sourceBaselineConnection.getComponent(), (IConnection)this.sourceBaselineConnection, false));
                        break;
                    }
                    this.componentOperations.put(this.sourceBaselineConnection.getComponent().getItemId(), this.workspace.componentOpFactory().replaceComponent(this.sourceBaselineConnection.getComponent(), (IConnection)this.sourceBaselineConnection, true));
                    break;
                }
                case CHANGE_SET_ONLY: {
                    this.allChangeSets = new ArrayList();
                    this.allChangeSets.addAll(this.changeSets);
                }
            }
            for (IComponentHandle iComponentHandle : this.addComponents.values()) {
                this.componentOperations.put(iComponentHandle.getItemId(), this.workspace.componentOpFactory().addComponent(iComponentHandle, false));
            }
            for (IComponentHandle iComponentHandle : this.removeComponents.values()) {
                this.componentOperations.put(iComponentHandle.getItemId(), this.workspace.componentOpFactory().removeComponent(iComponentHandle, false));
            }
        }
    }

    private void decideIndividualChanges(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        UUID uUID;
        List list;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.allChangeSets == null) {
            this.allChangeSets = new ArrayList();
        }
        if (this.allBaselines == null) {
            this.allBaselines = new ArrayList();
        }
        if (!this.baselines.isEmpty()) {
            list = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)subMonitor.newChild(10));
            for (IBaseline iBaseline : list) {
                uUID = iBaseline.getComponent().getItemId();
                if (this.componentOperations.containsKey(uUID) || this.replaceCandidates.containsKey(uUID) || this.acceptComponents.containsKey(uUID)) continue;
                this.allBaselines.add(iBaseline);
            }
        }
        if (!this.changeSets.isEmpty()) {
            list = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)subMonitor.newChild(10));
            for (IBaseline iBaseline : list) {
                uUID = iBaseline.getComponent().getItemId();
                if (this.componentOperations.containsKey(uUID) || this.replaceCandidates.containsKey(uUID) || this.acceptComponents.containsKey(uUID)) continue;
                this.allChangeSets.add(iBaseline);
            }
        }
    }

    private void decideComponentChanges(Collection collection) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        if (this.syncReport != null && !this.syncReport.getReplacedComponents().isEmpty() && this.sourceWorkspace != null) {
            for (IComponentHandle iComponentHandle : this.syncReport.getReplacedComponents()) {
                if (this.syncReport.outgoingChangeSets(iComponentHandle).isEmpty()) continue;
                hashSet.add(iComponentHandle.getItemId());
            }
        }
        this.replaceCandidates = new HashMap();
        for (IComponentHandle iComponentHandle : collection) {
            if (hashSet.contains(iComponentHandle.getItemId())) {
                this.replaceCandidates.put(iComponentHandle.getItemId(), this.workspace.componentOpFactory().replaceComponent(iComponentHandle, (IConnection)this.sourceWorkspace, true));
                continue;
            }
            if (this.componentOperations.containsKey(iComponentHandle.getItemId())) continue;
            this.decideComponentChanges(iComponentHandle);
        }
    }

    public void recomputeSyncReport(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (this.sourceWorkspace == null) {
            throw (Throwable)new IllegalStateException("Can only obtain sync reports for workspaces");
        }
        int n = WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY;
        if (this.syncReport != null) {
            n = this.syncReport.getFlags();
        }
        this.syncReport = this.workspace.compareTo((IFlowNodeConnection)this.sourceWorkspace, n, Collections.EMPTY_LIST, iProgressMonitor);
    }

    private void resetCachedInfo() {
        this.componentOperations = null;
        this.replaceCandidates = null;
        this.affectedConfigurations = null;
        this.allBaselines = null;
        this.allChangeSets = null;
    }

    public void createNewComponents(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.newComponentNames.size());
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspace.teamRepository());
        Object object = this.workspace.isStream() ? this.workspace.getOwner() : RepositoryUtils.getLoggedInContributor(this.workspace.teamRepository());
        Iterator iterator = this.newComponentNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IComponent iComponent = iWorkspaceManager.createComponent(string, object, (IProgressMonitor)subMonitor);
            this.addComponents.put(iComponent.getItemId(), iComponent);
            this.componentOperations.put(iComponent.getItemId(), this.workspace.componentOpFactory().addComponent((IComponentHandle)iComponent, false));
            iterator.remove();
        }
    }
}

