/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.IWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateReport$ComponentChangeType;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation$IWorkspaceUpdateReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class WorkspaceUpdateReport
implements IWorkspaceUpdateOperation$IWorkspaceUpdateReport,
IWorkspaceUpdateReporter {
    MultiStatus errors = null;
    HashMap workspacesAndComponents = new HashMap();
    Map acceptedChangeSets = new HashMap();
    Map resumedChangeSets = new HashMap();
    Map acceptedBaselines = new HashMap();
    Map changedComps = new HashMap();

    private List getItems(Map map, IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        Map map2 = (Map)map.get(iWorkspaceConnection);
        if (map2 == null) {
            return Collections.emptyList();
        }
        List list = (List)map2.get(iComponentHandle.getItemId());
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public List getAcceptedChanges(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        return this.getItems(this.acceptedChangeSets, iWorkspaceConnection, iComponentHandle);
    }

    public List getResumedChanges(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        return this.getItems(this.resumedChangeSets, iWorkspaceConnection, iComponentHandle);
    }

    public List getBaselines(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        return this.getItems(this.acceptedBaselines, iWorkspaceConnection, iComponentHandle);
    }

    public List getAffectedComponents(IWorkspaceConnection iWorkspaceConnection) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(((Map)this.workspacesAndComponents.get(iWorkspaceConnection)).values());
        return arrayList;
    }

    public Collection getConnections() {
        return this.workspacesAndComponents.keySet();
    }

    public boolean wasComponentAdded(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        return false;
    }

    public boolean wasComponentRemoved(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        return false;
    }

    public boolean wasComponentReplaced(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        return false;
    }

    public void recordAccepted(IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) {
        try {
            List list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, iProgressMonitor);
            HashMap hashMap = (HashMap)this.acceptedChangeSets.get(iWorkspaceConnection);
            if (hashMap == null) {
                hashMap = new HashMap(iWorkspaceConnection.getComponents().size());
                this.acceptedChangeSets.put(iWorkspaceConnection, hashMap);
            }
            for (IChangeSet iChangeSet : list2) {
                UUID uUID = iChangeSet.getComponent().getItemId();
                ArrayList arrayList = (ArrayList)hashMap.get(uUID);
                if (arrayList == null) {
                    arrayList = new ArrayList(list2.size());
                    hashMap.put(uUID, arrayList);
                    this.recordModifiedComponent(iWorkspaceConnection, iChangeSet.getComponent());
                }
                CollectionUtil.addToMapOfLists((Map)hashMap, (Object)iChangeSet.getComponent().getItemId(), (Object)iChangeSet);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            this.record(teamRepositoryException);
        }
    }

    public void recordResumed(IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) {
        HashMap hashMap;
        List list2;
        try {
            list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, iProgressMonitor);
            hashMap = (HashMap)this.resumedChangeSets.get(iWorkspaceConnection);
            if (hashMap == null) {
                hashMap = new HashMap(iWorkspaceConnection.getComponents().size());
                this.resumedChangeSets.put(iWorkspaceConnection, hashMap);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            this.record(teamRepositoryException);
            return;
        }
        for (IChangeSet iChangeSet : list2) {
            UUID uUID = iChangeSet.getComponent().getItemId();
            ArrayList arrayList = (ArrayList)hashMap.get(uUID);
            if (arrayList == null) {
                arrayList = new ArrayList(list2.size());
                hashMap.put(uUID, arrayList);
                this.recordModifiedComponent(iWorkspaceConnection, iChangeSet.getComponent());
            }
            CollectionUtil.addToMapOfLists((Map)hashMap, (Object)iChangeSet.getComponent().getItemId(), (Object)iChangeSet);
        }
    }

    public void recordAccepted(IWorkspaceConnection iWorkspaceConnection, List list, SubMonitor subMonitor) {
        HashMap hashMap;
        List list2;
        try {
            list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, (IProgressMonitor)subMonitor);
            hashMap = (HashMap)this.acceptedBaselines.get(iWorkspaceConnection);
            if (hashMap == null) {
                hashMap = new HashMap(iWorkspaceConnection.getComponents().size());
                this.acceptedBaselines.put(iWorkspaceConnection, hashMap);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            this.record(teamRepositoryException);
            return;
        }
        for (IBaseline iBaseline : list2) {
            CollectionUtil.addToMapOfLists((Map)hashMap, (Object)iBaseline.getComponent().getItemId(), (Object)iBaseline);
            this.recordModifiedComponent(iWorkspaceConnection, iBaseline.getComponent());
        }
    }

    public void recordComponentOps(IWorkspaceConnection iWorkspaceConnection, List list) {
        HashMap<UUID, WorkspaceUpdateReport$ComponentChangeType> hashMap;
        try {
            hashMap = (HashMap<UUID, WorkspaceUpdateReport$ComponentChangeType>)this.changedComps.get(iWorkspaceConnection);
            if (hashMap == null) {
                hashMap = new HashMap<UUID, WorkspaceUpdateReport$ComponentChangeType>(iWorkspaceConnection.getComponents().size());
                this.changedComps.put(iWorkspaceConnection, hashMap);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            this.record(teamRepositoryException);
            return;
        }
        for (IFlowNodeConnection.IComponentOp iComponentOp : list) {
            WorkspaceUpdateReport$ComponentChangeType workspaceUpdateReport$ComponentChangeType;
            if (iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                workspaceUpdateReport$ComponentChangeType = WorkspaceUpdateReport$ComponentChangeType.ADDITION;
            } else if (iComponentOp instanceof IFlowNodeConnection.IComponentDeletionOp) {
                workspaceUpdateReport$ComponentChangeType = WorkspaceUpdateReport$ComponentChangeType.REMOVED;
            } else if (iComponentOp instanceof IFlowNodeConnection.IComponentReplacementOp) {
                workspaceUpdateReport$ComponentChangeType = WorkspaceUpdateReport$ComponentChangeType.REPLACED;
            } else {
                this.record(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Unknown component op type: {0}", (Object)iComponentOp.getClass().getSimpleName()), null));
                continue;
            }
            hashMap.put(iComponentOp.getComponent().getItemId(), workspaceUpdateReport$ComponentChangeType);
        }
    }

    private void recordModifiedComponent(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        HashMap<UUID, IComponentHandle> hashMap = (HashMap<UUID, IComponentHandle>)this.workspacesAndComponents.get(iWorkspaceConnection);
        if (hashMap == null) {
            hashMap = new HashMap<UUID, IComponentHandle>();
            this.workspacesAndComponents.put(iWorkspaceConnection, hashMap);
        }
        hashMap.put(iComponentHandle.getItemId(), iComponentHandle);
    }

    private void record(TeamRepositoryException teamRepositoryException) {
        this.record(FileSystemStatus.getStatusFor(teamRepositoryException));
    }

    private void record(IStatus iStatus) {
        if (this.errors == null) {
            this.errors = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.WorkspaceUpdateReport_ERROR_STORING_REPORT, null);
        }
        this.errors.add(iStatus);
    }

    public IWorkspaceUpdateOperation$IWorkspaceUpdateReport getReport() {
        return this;
    }
}

