/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.IWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.NullWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.ResumeOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation$1;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation$2;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateReport;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateRequest;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation$IWorkspaceUpdateReport;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.AcceptSuspendedChangeSetException;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUpdateOperation
extends ChangeHistoryChangeSetsOperation
implements IWorkspaceUpdateOperation {
    private static final int ACCEPT_CHANGE_SETS = 1;
    private static final int ACCEPT_COMBINED = 2;
    private static final int RESUME = 3;
    private int acceptFlags;
    protected HashMap acceptRequests;
    private final WorkspaceUpdateDilemmaHandler problemHandler;
    private Set componentsAdded;
    private Set componentsRemoved;
    private boolean redundantChangeSets;
    private boolean resumedChangeSets;
    private boolean problemsEncountered;
    private IDownloadListener downloadListener;
    private boolean populateUpdateReport = false;
    private IWorkspaceUpdateReporter changes;

    public WorkspaceUpdateOperation(WorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler) {
        super(workspaceUpdateDilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : workspaceUpdateDilemmaHandler);
        this.problemHandler = workspaceUpdateDilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : workspaceUpdateDilemmaHandler;
        this.acceptRequests = new HashMap();
        this.componentsAdded = new HashSet();
        this.componentsRemoved = new HashSet();
        this.redundantChangeSets = false;
        this.resumedChangeSets = false;
        this.acceptFlags = 0;
        this.problemsEncountered = false;
    }

    public void setPreflight(boolean bl) {
        this.acceptFlags = bl ? 1 : 0;
    }

    public boolean isPreflightOnly() {
        return (this.acceptFlags & 1) == 1;
    }

    public void setDownloadListener(IDownloadListener iDownloadListener) {
        this.downloadListener = iDownloadListener;
    }

    public void acceptChangeSets(IWorkspaceConnection iWorkspaceConnection, ITeamRepository iTeamRepository, List list) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException("Change sets to accept must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (!workspaceUpdateRequest2.isChangeSetContext()) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest == null) {
            arrayList.add(new WorkspaceUpdateRequest(iWorkspaceConnection, iTeamRepository, list));
        } else {
            workspaceUpdateRequest.addChangeSets(list);
        }
    }

    public void accept(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2, List list3) throws TeamRepositoryException {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iWorkspaceConnection2 == null) {
            throw (Throwable)new IllegalArgumentException("Source workspace must not be null");
        }
        if (iChangeHistorySyncReport == null) {
            throw (Throwable)new IllegalArgumentException("Sync compare report must not be null");
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException("Baselines to accept must not be null");
        }
        if (list2 == null) {
            throw (Throwable)new IllegalArgumentException("Change sets to accept must not be null");
        }
        if (list3 == null) {
            throw (Throwable)new IllegalArgumentException("Components to accept must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || !iWorkspaceConnection2.equals((Object)workspaceUpdateRequest2.getSourceWorkspace())) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.addBaselines(list);
            workspaceUpdateRequest.addChangeSets(list2);
            workspaceUpdateRequest.addComponents(list3, false);
            workspaceUpdateRequest.updateSyncReport(iChangeHistorySyncReport);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, list, list2, list3);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void accept(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport) throws TeamRepositoryException {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iWorkspaceConnection2 == null) {
            throw (Throwable)new IllegalArgumentException("Source workspace must not be null");
        }
        if (iChangeHistorySyncReport == null) {
            throw (Throwable)new IllegalArgumentException("Sync compare report must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || !iWorkspaceConnection2.equals((Object)workspaceUpdateRequest2.getSourceWorkspace())) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.setWorkspaceContext(false);
            workspaceUpdateRequest.updateSyncReport(iChangeHistorySyncReport);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, false);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void accept(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, List list) throws TeamRepositoryException {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iWorkspaceConnection2 == null) {
            throw (Throwable)new IllegalArgumentException("Source workspace must not be null");
        }
        if (iChangeHistorySyncReport == null) {
            throw (Throwable)new IllegalArgumentException("Sync compare report must not be null");
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException("Components must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || !iWorkspaceConnection2.equals((Object)workspaceUpdateRequest2.getSourceWorkspace())) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.addComponents(list, false);
            workspaceUpdateRequest.updateSyncReport(iChangeHistorySyncReport);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, list, false);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void replace(IWorkspaceConnection iWorkspaceConnection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        IFlowTable iFlowTable = iWorkspaceConnection.getFlowTable();
        ITeamRepository iTeamRepository = iWorkspaceConnection.teamRepository();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)iFlowTable.acceptSources().size());
        for (IFlowEntry iFlowEntry : iFlowTable.acceptSources()) {
            IFlowNodeHandle iFlowNodeHandle = iFlowEntry.getFlowNode();
            if (!(iFlowNodeHandle instanceof IWorkspaceHandle)) continue;
            IWorkspaceConnection iWorkspaceConnection2 = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getWorkspaceConnection((IWorkspaceHandle)iFlowNodeHandle, (IProgressMonitor)subMonitor.newChild(1));
            ArrayList arrayList = new ArrayList(iFlowTable.getComponentScopes(iFlowNodeHandle));
            if (arrayList.isEmpty()) {
                this.replace(iWorkspaceConnection, iWorkspaceConnection2);
                continue;
            }
            this.replace(iWorkspaceConnection, iWorkspaceConnection2, (List)arrayList);
        }
    }

    public void replace(IWorkspaceConnection iWorkspaceConnection, IBaselineSetHandle iBaselineSetHandle, List list) throws TeamRepositoryException {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iBaselineSetHandle == null) {
            throw (Throwable)new IllegalArgumentException("Source snapshot must not be null");
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException("Components must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || !iBaselineSetHandle.sameItemId((IItemHandle)workspaceUpdateRequest2.getSourceSnapshot())) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.addComponents(list, true);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iBaselineSetHandle, list);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void replace(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iWorkspaceConnection2 == null) {
            throw (Throwable)new IllegalArgumentException("Source workspace must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || iWorkspaceConnection2 != workspaceUpdateRequest2.getSourceWorkspace()) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iWorkspaceConnection2, null, true);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void replace(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, List list) throws TeamRepositoryException {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iWorkspaceConnection2 == null) {
            throw (Throwable)new IllegalArgumentException("Source workspace must not be null");
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException("Components must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || !iWorkspaceConnection2.equals((Object)workspaceUpdateRequest2.getSourceWorkspace())) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.addComponents(list, true);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iWorkspaceConnection2, null, list, true);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void replace(IWorkspaceConnection iWorkspaceConnection, IBaselineConnection iBaselineConnection) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iBaselineConnection == null) {
            throw (Throwable)new IllegalArgumentException("Source snapshot must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || workspaceUpdateRequest2.getSourceBaseline() == null || !iBaselineConnection.getBaseline().sameItemId((IItemHandle)workspaceUpdateRequest2.getSourceBaseline().getBaseline())) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iBaselineConnection);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void replace(IWorkspaceConnection iWorkspaceConnection, IBaselineSetHandle iBaselineSetHandle) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iBaselineSetHandle == null) {
            throw (Throwable)new IllegalArgumentException("Source snapshot must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext() || !iBaselineSetHandle.sameItemId((IItemHandle)workspaceUpdateRequest2.getSourceSnapshot())) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iBaselineSetHandle);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void addComponent(IWorkspaceConnection iWorkspaceConnection, String string) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("New Component name must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext()) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.addNewComponent(string);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, string);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void addComponent(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException("Component must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext()) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.addNewComponent(iComponentHandle);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iComponentHandle, true);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    public void removeComponent(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("Workspace must not be null");
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException("Component must not be null");
        }
        ArrayList<WorkspaceUpdateRequest> arrayList = (ArrayList<WorkspaceUpdateRequest>)this.acceptRequests.get(iWorkspaceConnection);
        WorkspaceUpdateRequest workspaceUpdateRequest = null;
        if (arrayList == null) {
            arrayList = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(iWorkspaceConnection, arrayList);
        }
        for (WorkspaceUpdateRequest workspaceUpdateRequest2 : arrayList) {
            if (workspaceUpdateRequest2.isChangeSetContext()) continue;
            workspaceUpdateRequest = workspaceUpdateRequest2;
            break;
        }
        if (workspaceUpdateRequest != null) {
            workspaceUpdateRequest.removeComponent(iComponentHandle);
        } else {
            WorkspaceUpdateRequest workspaceUpdateRequest2;
            workspaceUpdateRequest2 = new WorkspaceUpdateRequest(iWorkspaceConnection, iComponentHandle, false);
            arrayList.add(workspaceUpdateRequest2);
        }
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        this.changes = this.populateUpdateReport ? (IWorkspaceUpdateReporter)new WorkspaceUpdateReport() : (IWorkspaceUpdateReporter)new NullWorkspaceUpdateReporter();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.WorkspaceUpdateOperation_5, (int)100);
        this.problemsEncountered = false;
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ArrayList arrayList2 = new ArrayList();
        this.getAffectedConfigurations(hashSet, hashSet2, arrayList2, (IProgressMonitor)subMonitor.newChild(2));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(hashSet2, (Collection)hashSet, (Collection)arrayList, (IProgressMonitor)subMonitor.newChild(1));
        try {
            Object object;
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                object = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                for (ConfigurationDescriptor configurationDescriptor : hashSet2) {
                    object.addToVerify(configurationDescriptor.getConnection(null), configurationDescriptor.componentHandle);
                }
                object.run((IProgressMonitor)subMonitor.newChild(2));
            }
            object = new WorkspaceUpdateOperation$1(this, arrayList2, hashSet2);
            this.runWithinFileSystemLock((IRunnableWithProgress)object, Messages.WorkspaceUpdateOperation_6, (IProgressMonitor)subMonitor.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }

    public void runPreConditionsOnly(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.WorkspaceUpdateOperation_3, (int)100);
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ArrayList arrayList2 = new ArrayList();
        this.getAffectedConfigurations(hashSet, hashSet2, arrayList2, (IProgressMonitor)subMonitor.newChild(1));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(hashSet2, (Collection)hashSet, (Collection)arrayList, (IProgressMonitor)subMonitor.newChild(1));
        try {
            try {
                Object object;
                if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                    object = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                    for (ConfigurationDescriptor configurationDescriptor : hashSet2) {
                        object.addToVerify(configurationDescriptor.getConnection(null), configurationDescriptor.componentHandle);
                    }
                    object.run((IProgressMonitor)subMonitor.newChild(3));
                }
                object = new WorkspaceUpdateOperation$2(this, arrayList2, hashSet2);
                this.runWithinFileSystemLock((IRunnableWithProgress)object, Messages.WorkspaceUpdateOperation_7, (IProgressMonitor)subMonitor.newChild(95));
            }
            catch (FileSystemClientException fileSystemClientException) {
                throw (Throwable)new TeamRepositoryException((Throwable)((Object)fileSystemClientException));
            }
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }

    public Collection getComponentsAdded() {
        return this.componentsAdded;
    }

    private void doAccept(Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 + 100 * this.acceptRequests.size()));
        HashMap hashMap = new HashMap();
        this.runPreConditions(set, (IProgressMonitor)subMonitor.newChild(8));
        for (Map.Entry entry : this.acceptRequests.entrySet()) {
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            object = (IWorkspaceConnection)entry.getKey();
            List list = (List)entry.getValue();
            if (!this.isPreflightOnly()) {
                this.performComponentOperations((IWorkspaceConnection)object, list, hashMap, (IProgressMonitor)subMonitor2.newChild(5));
            }
            ArrayList arrayList = new ArrayList();
            subMonitor2.setWorkRemaining(20 + 10 * list.size());
            for (Object object2 : list) {
                this.performAcceptRequest((WorkspaceUpdateRequest)object2, hashMap, arrayList, (IProgressMonitor)subMonitor2.newChild(10));
                if (this.problemsEncountered) break;
                this.checkCancelled((IProgressMonitor)subMonitor);
            }
            subMonitor2.setWorkRemaining(10 + object.getComponents().size());
            if (!arrayList.isEmpty()) {
                Object object2;
                object2 = ResumeOperation.shouldMakeResumedCurrent((IWorkspaceConnection)object, arrayList, (IProgressMonitor)subMonitor2.newChild(10));
                for (IChangeSetHandle iChangeSetHandle : object2.values()) {
                    object.setCurrentChangeSet(iChangeSetHandle, (IProgressMonitor)subMonitor2.newChild(1));
                }
            }
            if (this.problemsEncountered) break;
        }
        if (!this.isPreflightOnly()) {
            SubMonitor subMonitor3 = subMonitor.setWorkRemaining(10 + hashMap.size() * 10);
            if (!this.componentsRemoved.isEmpty()) {
                try {
                    IUnshareOperation teamRepositoryException = this.getUnshareProjectsOperation(this.componentsRemoved);
                    teamRepositoryException.run((IProgressMonitor)subMonitor3.newChild(10));
                }
                catch (TeamRepositoryException fileSystemClientException) {
                    this.collectStatus(FileSystemStatus.getStatusFor(fileSystemClientException));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                object = new UpdateOperation((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), 3, this.problemHandler, this.downloadListener);
                this.disableVerifyInSync((IFileSystemOperation)object);
                try {
                    object.run((IProgressMonitor)subMonitor3.newChild(10));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    this.collectStatus(FileSystemStatus.getStatusFor(teamRepositoryException));
                }
            }
        }
    }

    private void performComponentOperations(IWorkspaceConnection iWorkspaceConnection, List list, HashMap hashMap, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(5 + 10 * list.size()));
        ArrayList arrayList = new ArrayList();
        for (WorkspaceUpdateRequest workspaceUpdateRequest : list) {
            workspaceUpdateRequest.createNewComponents((IProgressMonitor)subMonitor.newChild(1));
            arrayList.addAll(workspaceUpdateRequest.getComponentOperations((IProgressMonitor)subMonitor.newChild(1)));
            arrayList.addAll(workspaceUpdateRequest.getReplaceCandidates((IProgressMonitor)subMonitor.newChild(1)));
        }
        this.checkCancelled((IProgressMonitor)subMonitor);
        if (!arrayList.isEmpty()) {
            WorkspaceUpdateRequest workspaceUpdateRequest;
            workspaceUpdateRequest = iWorkspaceConnection.applyComponentOperations((List)arrayList, true, (IProgressMonitor)subMonitor.newChild(5));
            this.changes.recordComponentOps(iWorkspaceConnection, arrayList);
            this.holdUpdateReport(iWorkspaceConnection, (IUpdateReport)workspaceUpdateRequest, hashMap);
            for (Object object : list) {
                Collection collection = ((WorkspaceUpdateRequest)object).getComponentOperations((IProgressMonitor)subMonitor.newChild(1));
                SubMonitor subMonitor2 = subMonitor.newChild(6);
                subMonitor2.setWorkRemaining(collection.size());
                for (IFlowNodeConnection.IComponentOp iComponentOp : collection) {
                    if (iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        if (((WorkspaceUpdateRequest)object).getSourceWorkspace() != null && ((WorkspaceUpdateRequest)object).getWorkspace().getFlowTable().getDeliverFlow((IFlowNodeHandle)((WorkspaceUpdateRequest)object).getSourceWorkspace().getResolvedWorkspace()) != null) {
                            FlowUtils.addComponentSyncState((IWorkspaceConnection)iWorkspaceConnection, (IConnection)((IConnection)((WorkspaceUpdateRequest)object).getSourceWorkspace()), (IComponentHandle)iComponentOp.getComponent(), (IProgressMonitor)((IProgressMonitor)subMonitor2.newChild(1)));
                        }
                        this.componentsAdded.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentOp.getComponent()));
                        continue;
                    }
                    if (!(iComponentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    if (((WorkspaceUpdateRequest)object).getSourceWorkspace() != null && ((WorkspaceUpdateRequest)object).getWorkspace().getFlowTable().getDeliverFlow((IFlowNodeHandle)((WorkspaceUpdateRequest)object).getSourceWorkspace().getResolvedWorkspace()) != null) {
                        FlowUtils.removeComponentSyncState((IWorkspaceConnection)((WorkspaceUpdateRequest)object).getWorkspace(), (IConnection)((IConnection)((WorkspaceUpdateRequest)object).getSourceWorkspace()), (IComponentHandle)iComponentOp.getComponent(), (IProgressMonitor)((IProgressMonitor)subMonitor2.newChild(1)));
                    }
                    this.componentsRemoved.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentOp.getComponent()));
                }
            }
        }
    }

    private void runPreConditions(Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)50);
        this.verifyComponentFlowing((IProgressMonitor)subMonitor.newChild(10));
        this.checkinPendingChanges(set, this.problemHandler, true, (IProgressMonitor)subMonitor.newChild(10));
        this.verifyReplaceComponents((IProgressMonitor)subMonitor.newChild(10));
        this.disconnectedComponents(set, (IProgressMonitor)subMonitor.newChild(10));
        this.validateRequests((IProgressMonitor)subMonitor.newChild(10));
    }

    private void verifyReplaceComponents(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(10 + 10 * this.acceptRequests.size()));
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        HashMap hashMap = new HashMap();
        for (List list : this.acceptRequests.values()) {
            SubMonitor object = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor.newChild(10)), (int)(10 * list.size()));
            for (Object object2 : list) {
                Collection collection = ((WorkspaceUpdateRequest)object2).getReplaceCandidates((IProgressMonitor)object.newChild(10));
                ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>();
                for (IFlowNodeConnection.IComponentReplacementOp iComponentReplacementOp : collection) {
                    hashSet.add(new ConfigurationDescriptor((IConnection)((WorkspaceUpdateRequest)object2).getWorkspace(), iComponentReplacementOp.getComponent()));
                    arrayList.add(iComponentReplacementOp.getComponent());
                }
                hashMap.put(object2, arrayList);
            }
        }
        if (!hashSet.isEmpty()) {
            int n = this.getAcceptDilemmaHandler().componentReplacementCandidates(hashSet);
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n != 0) {
                if (n == 3) {
                    SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor.newChild(10)), (int)hashMap.size());
                    for (Map.Entry entry : hashMap.entrySet()) {
                        WorkspaceUpdateRequest workspaceUpdateRequest = (WorkspaceUpdateRequest)entry.getKey();
                        workspaceUpdateRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)subMonitor2.newChild(1));
                    }
                } else {
                    throw (Throwable)new TeamRepositoryException(Messages.WorkspaceUpdateOperation_1);
                }
            }
        }
    }

    private void getAffectedConfigurations(Set set, Set set2, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.acceptRequests.size());
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Object object2 : this.acceptRequests.values()) {
            SubMonitor subMonitor2 = subMonitor.newChild(1).setWorkRemaining(object2.size() * 2);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                WorkspaceUpdateRequest workspaceUpdateRequest = (WorkspaceUpdateRequest)iterator.next();
                set2.addAll(workspaceUpdateRequest.getAffectedConfigurations((IProgressMonitor)subMonitor2.newChild(1)));
                Collection collection = workspaceUpdateRequest.getComponentOperations((IProgressMonitor)subMonitor2.newChild(1));
                for (IFlowNodeConnection.IComponentOp iComponentOp : collection) {
                    if (!(iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(iComponentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    set.add(workspaceUpdateRequest.getWorkspace().getContextHandle());
                    break;
                }
                for (IFlowNodeConnection.IComponentOp iComponentOp : collection) {
                    if (!(iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp)) continue;
                    hashSet.add(new ConfigurationDescriptor((IConnection)workspaceUpdateRequest.getWorkspace(), iComponentOp.getComponent()));
                }
                if (workspaceUpdateRequest.getNewComponentNames().isEmpty()) continue;
                set.add(workspaceUpdateRequest.getWorkspace().getContextHandle());
            }
        }
        hashSet.addAll(set2);
        object2 = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(hashSet, true);
        list.add(object2);
    }

    private void disconnectedComponents(Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        HashSet hashSet = new HashSet(set);
        Map map = this.getCopyFileAreasAffected(set, (IProgressMonitor)subMonitor.newChild(10));
        for (Set set2 : map.values()) {
            hashSet.removeAll(set2);
        }
        if (!hashSet.isEmpty()) {
            int n = this.problemHandler.disconnectedComponents(hashSet);
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n != 0) {
                throw (Throwable)new TeamRepositoryException(Messages.WorkspaceUpdateOperation_2);
            }
        }
    }

    private void validateRequests(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(10 * this.acceptRequests.size()));
        for (List list : this.acceptRequests.values()) {
            SubMonitor subMonitor2 = subMonitor.newChild(10).setWorkRemaining(list.size() * 10);
            HashSet<UUID> hashSet = new HashSet<UUID>();
            for (WorkspaceUpdateRequest workspaceUpdateRequest : list) {
                Object object22;
                HashSet<UUID> hashSet2 = new HashSet<UUID>();
                Collection collection = workspaceUpdateRequest.getAffectedConfigurations((IProgressMonitor)subMonitor2.newChild(1));
                for (Object object22 : collection) {
                    hashSet2.add(((ConfigurationDescriptor)object22).componentHandle.getItemId());
                }
                object22 = workspaceUpdateRequest.getComponentOperations((IProgressMonitor)subMonitor2.newChild(1));
                Iterator iterator = object22.iterator();
                while (iterator.hasNext()) {
                    IFlowNodeConnection.IComponentOp iComponentOp = (IFlowNodeConnection.IComponentOp)iterator.next();
                    hashSet2.add(iComponentOp.getComponent().getItemId());
                }
                for (UUID uUID : hashSet2) {
                    if (hashSet.add(uUID)) continue;
                    IComponent iComponent = (IComponent)workspaceUpdateRequest.getWorkspace().teamRepository().itemManager().fetchCompleteItem(IComponent.ITEM_TYPE.createItemHandle(uUID, null), 0, (IProgressMonitor)subMonitor2.newChild(1));
                    throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.WorkspaceUpdateOperation_4, (Object)iComponent.getName(), (Object[])new Object[]{workspaceUpdateRequest.getWorkspace().getResolvedWorkspace().getName()}));
                }
            }
        }
    }

    private void performAcceptRequest(WorkspaceUpdateRequest workspaceUpdateRequest, HashMap hashMap, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        int n = 10;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(10 + 16 * n));
        ArrayList arrayList = new ArrayList(workspaceUpdateRequest.getChangeSets((IProgressMonitor)subMonitor.newChild(1)));
        ArrayList arrayList2 = new ArrayList(workspaceUpdateRequest.getBaselines((IProgressMonitor)subMonitor.newChild(1)));
        if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
            boolean bl = true;
            int n2 = 0;
            ArrayList arrayList3 = new ArrayList();
            while (bl && !this.problemsEncountered && n-- > 0) {
                this.checkCancelled((IProgressMonitor)subMonitor);
                bl = false;
                int n3 = 0;
                try {
                    IUpdateReport iUpdateReport;
                    if (workspaceUpdateRequest.isChangeSetContext() && arrayList2.isEmpty() && !arrayList.isEmpty()) {
                        n3 = 1;
                        iUpdateReport = workspaceUpdateRequest.getWorkspace().accept(this.acceptFlags, (List)arrayList, workspaceUpdateRequest.getSourceRepository(), (IProgressMonitor)subMonitor.newChild(8));
                        this.changes.recordAccepted(workspaceUpdateRequest.getWorkspace(), (List)arrayList, (IProgressMonitor)subMonitor.newChild(1));
                        this.holdUpdateReport(workspaceUpdateRequest.getWorkspace(), iUpdateReport, hashMap);
                        arrayList.clear();
                    } else if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
                        n3 = 2;
                        iUpdateReport = workspaceUpdateRequest.getWorkspace().accept(this.acceptFlags, workspaceUpdateRequest.getSourceWorkspace(), workspaceUpdateRequest.getSyncReport((IProgressMonitor)subMonitor.newChild(1)), (List)arrayList2, (List)arrayList, (IProgressMonitor)subMonitor.newChild(7));
                        this.changes.recordAccepted(workspaceUpdateRequest.getWorkspace(), (List)arrayList, (IProgressMonitor)subMonitor.newChild(1));
                        this.changes.recordAccepted(workspaceUpdateRequest.getWorkspace(), (List)arrayList2, subMonitor.newChild(1));
                        this.holdUpdateReport(workspaceUpdateRequest.getWorkspace(), iUpdateReport, hashMap);
                        arrayList.clear();
                        arrayList2.clear();
                    }
                    if (arrayList3.isEmpty()) continue;
                    n3 = 3;
                    iUpdateReport = workspaceUpdateRequest.getWorkspace().resume(this.acceptFlags, (List)arrayList3, (IProgressMonitor)subMonitor.newChild(4));
                    this.changes.recordAccepted(workspaceUpdateRequest.getWorkspace(), (List)arrayList3, (IProgressMonitor)subMonitor.newChild(1));
                    this.holdUpdateReport(workspaceUpdateRequest.getWorkspace(), iUpdateReport, hashMap);
                    this.resumedChangeSets = true;
                    list.addAll(arrayList3);
                    arrayList3.clear();
                }
                catch (ActiveChangeSetsOverlapException activeChangeSetsOverlapException) {
                    bl = this.handleActiveChangeSetsOverlap(workspaceUpdateRequest, arrayList3, activeChangeSetsOverlapException, (IProgressMonitor)subMonitor.newChild(3));
                }
                catch (GapException gapException) {
                    bl = this.handleGap(workspaceUpdateRequest, n3 == 3 ? arrayList3 : arrayList, arrayList3, !arrayList3.isEmpty(), gapException, subMonitor.newChild(3));
                }
                catch (ChangeSetAlreadyInHistoryException changeSetAlreadyInHistoryException) {
                    bl = this.handleChangeSetAlreadyInHistory(workspaceUpdateRequest, n3 == 3 ? arrayList3 : arrayList, (TeamRepositoryException)((Object)changeSetAlreadyInHistoryException), (IProgressMonitor)subMonitor.newChild(3));
                    if (bl) continue;
                    this.handleProblem((TeamRepositoryException)((Object)changeSetAlreadyInHistoryException));
                }
                catch (ActiveChangeSetsException activeChangeSetsException) {
                    bl = this.handleActiveChangeSets(workspaceUpdateRequest, arrayList, (TeamRepositoryException)((Object)activeChangeSetsException), (IProgressMonitor)subMonitor.newChild(3));
                }
                catch (AcceptSuspendedChangeSetException acceptSuspendedChangeSetException) {
                    bl = this.handleSuspendedChangeSets(workspaceUpdateRequest, arrayList, arrayList3, (IProgressMonitor)subMonitor.newChild(3));
                    if (bl) continue;
                    this.handleProblem((TeamRepositoryException)((Object)acceptSuspendedChangeSetException));
                }
                catch (StaleDataException staleDataException) {
                    bl = this.handleStaleData(workspaceUpdateRequest, n2, staleDataException, (IProgressMonitor)subMonitor.newChild(3));
                    ++n2;
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    bl = this.handleChangeSetAlreadyInHistory(workspaceUpdateRequest, arrayList, teamRepositoryException, (IProgressMonitor)subMonitor.newChild(1));
                    if (!bl) {
                        bl = this.handleSuspendedChangeSets(workspaceUpdateRequest, arrayList, arrayList3, (IProgressMonitor)subMonitor.newChild(1));
                    }
                    if (!bl) {
                        bl = this.handleActiveChangeSets(workspaceUpdateRequest, arrayList, teamRepositoryException, (IProgressMonitor)subMonitor.newChild(1));
                    }
                    if (bl) continue;
                    this.handleProblem(teamRepositoryException);
                }
            }
        }
    }

    private boolean handleStaleData(WorkspaceUpdateRequest workspaceUpdateRequest, int n, StaleDataException staleDataException, IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        if (n > 0) {
            this.handleProblem((TeamRepositoryException)((Object)staleDataException));
        } else {
            int n2 = this.problemHandler.staleData(workspaceUpdateRequest.getWorkspace(), workspaceUpdateRequest.getSourceWorkspace());
            if (n2 == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n2 == 0) {
                try {
                    workspaceUpdateRequest.recomputeSyncReport(iProgressMonitor);
                    bl = true;
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    this.collectStatus(FileSystemStatus.getStatusFor(teamRepositoryException));
                    this.handleProblem(teamRepositoryException);
                }
            } else {
                this.handleProblem((TeamRepositoryException)((Object)staleDataException));
            }
        }
        return bl;
    }

    private void handleProblem(TeamRepositoryException teamRepositoryException) {
        this.collectStatus(FileSystemStatus.getStatusFor(teamRepositoryException));
        this.problemsEncountered = true;
    }

    private boolean handleChangeSetAlreadyInHistory(WorkspaceUpdateRequest workspaceUpdateRequest, List list, TeamRepositoryException teamRepositoryException, IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        try {
            List list2 = workspaceUpdateRequest.getWorkspace().changeSetsInHistory(list, (IProgressMonitor)subMonitor.newChild(2));
            if (!list2.isEmpty()) {
                IChangeSetHandle iChangeSetHandle2;
                HashSet<UUID> hashSet = new HashSet<UUID>();
                for (IChangeSetHandle iChangeSetHandle2 : list2) {
                    hashSet.add(iChangeSetHandle2.getItemId());
                }
                iChangeSetHandle2 = list.iterator();
                while (iChangeSetHandle2.hasNext()) {
                    IChangeSetHandle iChangeSetHandle3 = (IChangeSetHandle)iChangeSetHandle2.next();
                    if (!hashSet.contains(iChangeSetHandle3.getItemId())) continue;
                    iChangeSetHandle2.remove();
                    this.redundantChangeSets = true;
                    bl = true;
                }
            }
        }
        catch (TeamRepositoryException teamRepositoryException2) {
            this.collectStatus(FileSystemStatus.getStatusFor(teamRepositoryException));
            this.handleProblem(teamRepositoryException2);
        }
        return bl;
    }

    private boolean handleSuspendedChangeSets(WorkspaceUpdateRequest workspaceUpdateRequest, List list, List list2, IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        List list3 = workspaceUpdateRequest.getWorkspace().suspendedChangeSets();
        if (!list3.isEmpty()) {
            IChangeSetHandle iChangeSetHandle2;
            HashSet<UUID> hashSet = new HashSet<UUID>();
            for (IChangeSetHandle iChangeSetHandle2 : list3) {
                hashSet.add(iChangeSetHandle2.getItemId());
            }
            iChangeSetHandle2 = list.iterator();
            while (iChangeSetHandle2.hasNext()) {
                IChangeSetHandle iChangeSetHandle3 = (IChangeSetHandle)iChangeSetHandle2.next();
                if (!hashSet.contains(iChangeSetHandle3.getItemId())) continue;
                iChangeSetHandle2.remove();
                list2.add(iChangeSetHandle3);
                bl = true;
            }
        }
        return bl;
    }

    private boolean handleActiveChangeSets(WorkspaceUpdateRequest workspaceUpdateRequest, List list, TeamRepositoryException teamRepositoryException, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        boolean bl = false;
        HashSet<UUID> hashSet = new HashSet<UUID>();
        ArrayList<IChangeSetHandle> arrayList = new ArrayList<IChangeSetHandle>();
        try {
            IChangeSetHandle iChangeSetHandle;
            Iterator iterator;
            Object object;
            if (workspaceUpdateRequest.isChangeSetContext() || workspaceUpdateRequest.getSourceWorkspace() == null) {
                object = workspaceUpdateRequest.getWorkspace().teamRepository().itemManager().fetchCompleteItems(list, 0, (IProgressMonitor)subMonitor);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    iChangeSetHandle = (IChangeSet)iterator.next();
                    if (!iChangeSetHandle.isActive()) continue;
                    hashSet.add(iChangeSetHandle.getItemId());
                }
            } else {
                object = workspaceUpdateRequest.getSourceWorkspace().activeChangeSets();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    iChangeSetHandle = (IChangeSetHandle)iterator.next();
                    hashSet.add(iChangeSetHandle.getItemId());
                }
            }
            if (!hashSet.isEmpty()) {
                object = list.iterator();
                while (object.hasNext()) {
                    iChangeSetHandle = (IChangeSetHandle)object.next();
                    if (!hashSet.contains(iChangeSetHandle.getItemId())) continue;
                    object.remove();
                    arrayList.add(iChangeSetHandle);
                }
                if (!arrayList.isEmpty()) {
                    int n = this.problemHandler.activeChangeSets(workspaceUpdateRequest.getWorkspace(), arrayList);
                    if (n == 0) {
                        bl = true;
                    } else if (n != 3) {
                        if (n == 1) {
                            throw (Throwable)new OperationCanceledException();
                        }
                        this.handleProblem(teamRepositoryException);
                    }
                }
            }
        }
        catch (TeamRepositoryException teamRepositoryException2) {
            this.collectStatus(FileSystemStatus.getStatusFor(teamRepositoryException));
            this.handleProblem(teamRepositoryException2);
        }
        return bl;
    }

    private boolean handleActiveChangeSetsOverlap(WorkspaceUpdateRequest workspaceUpdateRequest, List list, ActiveChangeSetsOverlapException activeChangeSetsOverlapException, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        boolean bl = false;
        try {
            List list2 = workspaceUpdateRequest.getWorkspace().teamRepository().itemManager().fetchCompleteItems(list, 0, (IProgressMonitor)subMonitor.newChild(50));
            ArrayList<IChangeSet> arrayList = new ArrayList<IChangeSet>();
            for (IChangeSet iChangeSet : list2) {
                if (!iChangeSet.isActive()) continue;
                arrayList.add(iChangeSet);
            }
            int n = this.problemHandler.activeChangeSetsOverlap(workspaceUpdateRequest.getWorkspace(), arrayList);
            if (n == 0) {
                workspaceUpdateRequest.getWorkspace().closeChangeSets((Collection)arrayList, (IProgressMonitor)subMonitor.newChild(50));
                bl = true;
            } else if (n != 3) {
                if (n == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                this.handleProblem((TeamRepositoryException)((Object)activeChangeSetsOverlapException));
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            this.collectStatus(FileSystemStatus.getStatusFor(activeChangeSetsOverlapException));
            this.handleProblem(teamRepositoryException);
        }
        return bl;
    }

    private boolean handleGap(WorkspaceUpdateRequest workspaceUpdateRequest, List list, List list2, boolean bl, GapException gapException, SubMonitor subMonitor) {
        boolean bl2 = false;
        int n = this.problemHandler.gap(workspaceUpdateRequest.getWorkspace(), list, bl);
        if (n != 0) {
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            this.handleProblem((TeamRepositoryException)((Object)gapException));
        }
        return bl2;
    }

    private void holdUpdateReport(IWorkspaceConnection iWorkspaceConnection, IUpdateReport iUpdateReport, HashMap hashMap) {
        ArrayList<IUpdateReport> arrayList = (ArrayList<IUpdateReport>)hashMap.get(iWorkspaceConnection);
        if (arrayList == null) {
            arrayList = new ArrayList<IUpdateReport>();
            hashMap.put(iWorkspaceConnection, arrayList);
        }
        arrayList.add(iUpdateReport);
    }

    private void verifyComponentFlowing(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(10 + this.acceptRequests.size() * 10));
        HashMap<Object, ArrayList<IComponentHandle>> hashMap = new HashMap<Object, ArrayList<IComponentHandle>>();
        ArrayList<ConfigurationDescriptor> arrayList = new ArrayList<ConfigurationDescriptor>();
        ArrayList<ConfigurationDescriptor> arrayList2 = new ArrayList<ConfigurationDescriptor>();
        for (List list : this.acceptRequests.values()) {
            SubMonitor object = subMonitor.newChild(10).setWorkRemaining(list.size());
            for (Object object2 : list) {
                if (((WorkspaceUpdateRequest)object2).isChangeSetContext()) continue;
                Collection collection = ((WorkspaceUpdateRequest)object2).getComponentOperations((IProgressMonitor)object.newChild(1));
                for (IFlowNodeConnection.IComponentOp iComponentOp : collection) {
                    if (!(iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(iComponentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    if (iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        arrayList.add(new ConfigurationDescriptor((IConnection)((WorkspaceUpdateRequest)object2).getWorkspace(), iComponentOp.getComponent()));
                    } else {
                        arrayList2.add(new ConfigurationDescriptor((IConnection)((WorkspaceUpdateRequest)object2).getWorkspace(), iComponentOp.getComponent()));
                    }
                    ArrayList<IComponentHandle> arrayList3 = (ArrayList<IComponentHandle>)hashMap.get(object2);
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<IComponentHandle>();
                        hashMap.put(object2, arrayList3);
                    }
                    arrayList3.add(iComponentOp.getComponent());
                }
            }
        }
        if (arrayList.size() > 0 || arrayList2.size() > 0) {
            int n = this.getAcceptDilemmaHandler().componentsToBeAddedOrRemoved(arrayList, arrayList2);
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n == 3) {
                SubMonitor subMonitor2 = subMonitor.newChild(10);
                subMonitor2.setWorkRemaining(hashMap.entrySet().size());
                for (Map.Entry entry : hashMap.entrySet()) {
                    WorkspaceUpdateRequest workspaceUpdateRequest = (WorkspaceUpdateRequest)entry.getKey();
                    workspaceUpdateRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)subMonitor2.newChild(1));
                }
            } else if (n != 0) {
                throw (Throwable)new TeamRepositoryException(Messages.WorkspaceUpdateOperation_0);
            }
        }
    }

    protected final WorkspaceUpdateDilemmaHandler getAcceptDilemmaHandler() {
        return this.problemHandler;
    }

    public boolean changeSetsAlreadyInHistory() {
        return this.redundantChangeSets;
    }

    public boolean acceptedSuspendedChangeSets() {
        return this.resumedChangeSets;
    }

    private IUnshareOperation getUnshareProjectsOperation(Set set) {
        IUnshareOperation iUnshareOperation = IOperationFactory.instance.getUnshareOperation(null);
        iUnshareOperation.requestUnshare(set);
        iUnshareOperation.setDeleteContent(true);
        return iUnshareOperation;
    }

    public IWorkspaceUpdateOperation$IWorkspaceUpdateReport getUpdateReport() {
        if (this.changes == null) {
            throw (Throwable)new IllegalStateException();
        }
        return this.changes.getReport();
    }

    public void setPopulateUpdateReport(boolean bl) {
        if (this.changes != null) {
            throw (Throwable)new IllegalStateException();
        }
        this.populateUpdateReport = bl;
    }

    protected void refreshLocal(IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        int n = 0;
        for (Map.Entry entry : this.acceptRequests.entrySet()) {
            n += ((List)entry.getValue()).size();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)n);
        for (Map.Entry entry : this.acceptRequests.entrySet()) {
            for (WorkspaceUpdateRequest workspaceUpdateRequest : (List)entry.getValue()) {
                Object object2;
                Collection collection = workspaceUpdateRequest.getComponentOperations((IProgressMonitor)subMonitor.newChild(1));
                SubMonitor subMonitor2 = subMonitor.newChild(1);
                subMonitor2.setWorkRemaining(collection.size() * 3);
                for (Object object2 : collection) {
                    if (!(object2 instanceof IFlowNodeConnection.IComponentAdditionOp)) {
                        SubMonitor subMonitor3 = subMonitor2.newChild(1);
                        subMonitor3.setWorkRemaining(map.size());
                        iFilesystemRefresher.addToRefresh(map.keySet(), ((IWorkspaceConnection)entry.getKey()).getContextHandle(), object2.getComponent(), (IProgressMonitor)subMonitor2.newChild(1));
                        continue;
                    }
                    subMonitor2.worked(1);
                }
                subMonitor2.setWorkRemaining(4);
                ChangeSetRefreshUtils.refreshForBaselineChange(iFilesystemRefresher, map.keySet(), (IWorkspaceConnection)entry.getKey(), workspaceUpdateRequest.getBaselines((IProgressMonitor)subMonitor2.newChild(1)), (IProgressMonitor)subMonitor2.newChild(1));
                object2 = workspaceUpdateRequest.getChangeSets((IProgressMonitor)subMonitor2.newChild(1));
                ChangeSetRefreshUtils.refreshLocalForAddition(iFilesystemRefresher, map, (IWorkspaceConnection)entry.getKey(), (List)object2, (IProgressMonitor)subMonitor2.newChild(1));
            }
        }
    }

    static /* synthetic */ void access$0(WorkspaceUpdateOperation workspaceUpdateOperation, Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        workspaceUpdateOperation.doAccept(set, iProgressMonitor);
    }

    static /* synthetic */ void access$1(WorkspaceUpdateOperation workspaceUpdateOperation, Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        workspaceUpdateOperation.runPreConditions(set, iProgressMonitor);
    }
}

