/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager$ICopyFileAreaLockRequestFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ShareOutOfSync;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class VerifySharesOperation
extends FileSystemOperation
implements IVerifyInSyncOperation {
    private boolean alreadyExecuted;
    protected final OutOfSyncDilemmaHandler verifyInSyncDilemmaHandler;
    private boolean verifyAgainstCache;
    private HashMap connectionsToVerify;
    private HashMap configurationsToVerify;
    private ArrayList sharesToVerify;
    private ArrayList shareConnections;
    private HashMap connectionComponentStates;

    public VerifySharesOperation(OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        super(outOfSyncDilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : outOfSyncDilemmaHandler);
        this.verifyInSyncDilemmaHandler = outOfSyncDilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : outOfSyncDilemmaHandler;
        this.verifyAgainstCache = false;
        this.connectionsToVerify = new HashMap();
        this.configurationsToVerify = new HashMap();
        this.sharesToVerify = new ArrayList();
        this.shareConnections = new ArrayList();
        this.connectionComponentStates = new HashMap();
    }

    public void setVerifyAgainstCache(boolean bl) {
        this.verifyAgainstCache = bl;
    }

    public void addToVerify(IWorkspaceConnection iWorkspaceConnection) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.connectionsToVerify.put(iWorkspaceConnection.getContextHandle().getItemId(), iWorkspaceConnection);
    }

    public void addToVerify(IConnection iConnection, IComponentHandle iComponentHandle) {
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.configurationsToVerify.put(new ConfigurationDescriptor(iConnection, iComponentHandle), iConnection);
    }

    public void addToVerify(IConnection iConnection, Collection collection) {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (IShare iShare : collection) {
            if (!iShare.getSharingDescriptor().isAssociatedWithConnection(iConnection)) {
                throw (Throwable)new IllegalArgumentException();
            }
            this.shareConnections.add(iConnection);
            this.sharesToVerify.add(iShare);
        }
    }

    public void addToVerify(IConnection iConnection, IShare iShare) {
        if (iShare == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!iShare.getSharingDescriptor().isAssociatedWithConnection(iConnection)) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.shareConnections.add(iConnection);
        this.sharesToVerify.add(iShare);
    }

    public void addToVerifyAgainst(IConnection iConnection, Collection collection) {
        Object object2;
        IWorkspace iWorkspace;
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection instanceof IWorkspaceConnection) {
            iWorkspace = ((IWorkspaceConnection)iConnection).getResolvedWorkspace();
        } else if (iConnection instanceof IBaselineConnection) {
            iWorkspace = ((IBaselineConnection)iConnection).getBaseline();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        for (Object object2 : collection) {
            if (object2 != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        object2 = (HashMap)this.connectionComponentStates.get(iWorkspace.getItemId());
        if (object2 == null) {
            object2 = new HashMap();
            this.connectionComponentStates.put(iWorkspace.getItemId(), object2);
        }
        for (IComponentStateSummary iComponentStateSummary : collection) {
            ((HashMap)object2).put(iComponentStateSummary.getComponent().getItemId(), iComponentStateSummary.getConfigurationTime());
        }
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (this.alreadyExecuted) {
            throw (Throwable)new IllegalStateException();
        }
        this.alreadyExecuted = true;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (this.sharesToVerify.isEmpty() && this.configurationsToVerify.isEmpty() && this.connectionsToVerify.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)200);
        Collection collection = this.getAffectedConfigurationsToLock((IProgressMonitor)subMonitor.newChild(1));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireRead(collection, (IProgressMonitor)subMonitor.newChild(1));
        HashSet hashSet = new HashSet();
        try {
            ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
            Collection collection2 = this.getCopyFileAreaLocksToObtain((IProgressMonitor)subMonitor.newChild(1));
            ICopyFileAreasLock iCopyFileAreasLock = iCopyFileAreaManager.lock(collection2, (IProgressMonitor)subMonitor.newChild(1));
            try {
                this.getComponentStatesToVerifyAgainst((IProgressMonitor)subMonitor.newChild(50));
                this.verifyShares(hashSet, (IProgressMonitor)subMonitor.newChild(20));
                this.verifyConfigurations(hashSet, (IProgressMonitor)subMonitor.newChild(20));
                this.verifyConnections(hashSet, (IProgressMonitor)subMonitor.newChild(5));
            }
            finally {
                iCopyFileAreasLock.release((IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        if (!hashSet.isEmpty()) {
            this.handleOutOfSyncShares(hashSet, (IProgressMonitor)subMonitor.newChild(100));
        }
        if (iProgressMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
    }

    private Collection getCopyFileAreaLocksToObtain(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Object object2;
        ICopyFileAreaManager$ICopyFileAreaLockRequestFactory iCopyFileAreaManager$ICopyFileAreaLockRequestFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        ArrayList<ICopyFileAreaLockRequest> arrayList = new ArrayList<ICopyFileAreaLockRequest>(2);
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Object object2 : this.connectionsToVerify.values()) {
            for (Object object3 : object2.getComponents()) {
                hashSet.add(new ConfigurationDescriptor((IConnection)object2, (IComponentHandle)object3));
            }
        }
        hashSet.addAll(this.configurationsToVerify.keySet());
        if (!hashSet.isEmpty()) {
            arrayList.add(iCopyFileAreaManager$ICopyFileAreaLockRequestFactory.getLockRequest(hashSet, false));
        }
        object2 = new ArrayList(this.sharesToVerify.size());
        for (Object object4 : this.sharesToVerify) {
            ((ArrayList)object2).add(object4.getShareable());
        }
        if (!((ArrayList)object2).isEmpty()) {
            iCopyFileAreaManager$ICopyFileAreaLockRequestFactory.getLockRequest((Collection)object2);
        }
        return arrayList;
    }

    private Collection getAffectedConfigurationsToLock(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        if (this.verifyAgainstCache) {
            Object object2;
            for (Object object2 : this.connectionsToVerify.values()) {
                for (IComponentHandle iComponentHandle : object2.getComponents()) {
                    hashSet.add(new ConfigurationDescriptor((IConnection)object2, iComponentHandle));
                }
            }
            hashSet.addAll(this.configurationsToVerify.keySet());
            object2 = this.shareConnections.iterator();
            for (Object object3 : this.sharesToVerify) {
                IConnection iConnection = (IConnection)object2.next();
                if (iConnection instanceof IBaselineConnection) continue;
                ISharingDescriptor iSharingDescriptor = object3.getSharingDescriptor();
                hashSet.add(new ConfigurationDescriptor(iConnection, iSharingDescriptor.getComponent()));
            }
        }
        subMonitor.done();
        return hashSet;
    }

    private void getComponentStatesToVerifyAgainst(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        block9: {
            SubMonitor subMonitor;
            block8: {
                IConnection iConnection;
                Object object2;
                subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(2 * (this.sharesToVerify.size() + this.configurationsToVerify.size() + this.connectionsToVerify.size())));
                if (!this.verifyAgainstCache) break block8;
                for (Object object2 : this.connectionsToVerify.values()) {
                    for (Object object3 : object2.getComponentsInfo()) {
                        this.addSyncTime((IContextHandle)object2.getResolvedWorkspace(), object3.getComponent(), object3.configurationTime());
                    }
                }
                for (Object object2 : this.configurationsToVerify.keySet()) {
                    Object object3;
                    object3 = ((ConnectionDescriptor)object2).getConnection((IProgressMonitor)subMonitor.newChild(1));
                    if (object3 instanceof IBaselineConnection) {
                        this.addSyncTime(object3.getContextHandle(), ((IBaselineConnection)object3).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)object3).getResolvedBaseline(), null));
                        continue;
                    }
                    iConnection = ((IWorkspaceConnection)object3).getComponentInfo(((ConfigurationDescriptor)object2).componentHandle);
                    this.addSyncTime(object3.getContextHandle(), ((ConfigurationDescriptor)object2).componentHandle, iConnection.configurationTime());
                }
                object2 = this.shareConnections.iterator();
                for (Object object4 : this.sharesToVerify) {
                    iConnection = (IConnection)object2.next();
                    if (iConnection instanceof IBaselineConnection) {
                        this.addSyncTime(iConnection.getContextHandle(), ((IBaselineConnection)iConnection).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)iConnection).getResolvedBaseline(), null));
                        continue;
                    }
                    ISharingDescriptor iSharingDescriptor = object4.getSharingDescriptor();
                    ICurrentComponentInfo iCurrentComponentInfo = ((IWorkspaceConnection)iConnection).getComponentInfo(iSharingDescriptor.getComponent());
                    this.addSyncTime(iConnection.getContextHandle(), iSharingDescriptor.getComponent(), iCurrentComponentInfo.configurationTime());
                }
                break block9;
            }
            if (!this.connectionComponentStates.isEmpty()) break block9;
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.connectionsToVerify.values());
            hashSet.addAll(this.configurationsToVerify.values());
            hashSet.addAll(this.shareConnections);
            for (IConnection iConnection : hashSet) {
                FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)FileSystemCore.getFileSystemManager(iConnection.teamRepository())).getFileSystemService();
                List list = fileSystemServiceProxy.getComponentStateSummaries(iConnection, (IProgressMonitor)subMonitor.newChild(1));
                for (IComponentStateSummary iComponentStateSummary : list) {
                    this.addSyncTime(iConnection.getContextHandle(), iComponentStateSummary.getComponent(), iComponentStateSummary.getConfigurationTime());
                }
            }
        }
    }

    private void addSyncTime(IContextHandle iContextHandle, IComponentHandle iComponentHandle, ISyncTime iSyncTime) {
        HashMap<UUID, ISyncTime> hashMap = (HashMap<UUID, ISyncTime>)this.connectionComponentStates.get(iContextHandle.getItemId());
        if (hashMap == null) {
            hashMap = new HashMap<UUID, ISyncTime>();
            this.connectionComponentStates.put(iContextHandle.getItemId(), hashMap);
        }
        hashMap.put(iComponentHandle.getItemId(), iSyncTime);
    }

    private void verifyShares(Set set, IProgressMonitor iProgressMonitor) {
        Iterator iterator = this.shareConnections.iterator();
        for (IShare iShare : this.sharesToVerify) {
            IConnection iConnection = (IConnection)iterator.next();
            this.validShare(iConnection, iShare, set);
        }
    }

    private boolean validShare(IConnection iConnection, IShare iShare, Set set) {
        SharingDescriptor sharingDescriptor = (SharingDescriptor)iShare.getSharingDescriptor();
        HashMap hashMap = (HashMap)this.connectionComponentStates.get(sharingDescriptor.getConnectionHandle().getItemId());
        ISyncTime iSyncTime = (ISyncTime)hashMap.get(sharingDescriptor.getComponent().getItemId());
        if (!sharingDescriptor.getConfigurationState().equals(iSyncTime)) {
            set.add(iShare);
            return false;
        }
        return true;
    }

    private HashMap verifyConnections(Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.connectionsToVerify.size() * 10));
        HashMap hashMap = new HashMap();
        SharingManager sharingManager = SharingManager.getInstance();
        for (IConnection iConnection : this.connectionsToVerify.values()) {
            Collection collection = sharingManager.getShares(iConnection, (IProgressMonitor)subMonitor);
            for (IShare iShare : collection) {
                if (this.validShare(iConnection, iShare, set)) continue;
                HashMap<UUID, IComponentHandle> hashMap2 = (HashMap<UUID, IComponentHandle>)hashMap.get(iConnection);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<UUID, IComponentHandle>();
                    hashMap.put(iConnection, hashMap2);
                }
                ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                hashMap2.put(iSharingDescriptor.getComponent().getItemId(), iSharingDescriptor.getComponent());
            }
        }
        return hashMap;
    }

    private HashMap verifyConfigurations(Set set, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.connectionsToVerify.size() * 10));
        HashMap hashMap = new HashMap();
        SharingManager sharingManager = SharingManager.getInstance();
        for (Map.Entry entry : this.configurationsToVerify.entrySet()) {
            ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)entry.getKey();
            IConnection iConnection = (IConnection)entry.getValue();
            Collection collection = sharingManager.getShares(configurationDescriptor, (IProgressMonitor)subMonitor);
            for (IShare iShare : collection) {
                if (this.validShare(iConnection, iShare, set)) continue;
                HashMap<UUID, IComponentHandle> hashMap2 = (HashMap<UUID, IComponentHandle>)hashMap.get(iConnection);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<UUID, IComponentHandle>();
                    hashMap.put(iConnection, hashMap2);
                }
                ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                hashMap2.put(iSharingDescriptor.getComponent().getItemId(), iSharingDescriptor.getComponent());
            }
        }
        return hashMap;
    }

    private void handleOutOfSyncShares(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ArrayList<ShareOutOfSync> arrayList = new ArrayList<ShareOutOfSync>(set.size());
        for (IShare iShare : set) {
            arrayList.add(new ShareOutOfSync(iShare));
        }
        int n = this.verifyInSyncDilemmaHandler.outOfSync(arrayList);
        if (n == 100) {
            this.reloadOutOfSync(set, iProgressMonitor);
        } else if (n != 1) {
            IShare iShare2;
            IStatus[] iStatusArray = new IStatus[set.size()];
            int n2 = 0;
            for (IShare iShare2 : set) {
                iStatusArray[n2] = new FileSystemStatus(1, 208, NLS.bind((String)Messages.VerifySharesOperation_0, (Object)iShare2.getPath().toString()));
                ++n2;
            }
            iShare2 = new MultiStatus("com.ibm.team.filesystem.client", 4, iStatusArray, Messages.VerifySharesOperation_1, null);
            if (n == 0) {
                LoggingHelper.log((IStatus)iShare2);
            } else {
                this.collectStatus((IStatus)iShare2);
            }
        } else {
            throw (Throwable)new OperationCanceledException();
        }
    }

    protected void reloadOutOfSync(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!set.isEmpty()) {
            ILoadOperation iLoadOperation = IOperationFactory.instance.getLoadOperation(this.verifyInSyncDilemmaHandler);
            iLoadOperation.setEclipseSpecificLoadOptions(4);
            iLoadOperation.requestReLoad(set, (IProgressMonitor)subMonitor.newChild(10));
            iLoadOperation.run((IProgressMonitor)subMonitor.newChild(90));
        }
    }
}

