/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager$ICopyFileAreaLockRequestFactory;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation$1;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class UpdateOperation
extends FileSystemOperation {
    private final List updateReports;
    private final HashSet affectedConfigurations;
    private final HashSet copyFileAreasAffected;
    private final IWorkspaceConnection connection;
    public static final int PROCESS_UPDATES = 1;
    public static final int PROCESS_INCIDENTAL_UPDATES = 2;
    public static final int PROCESS_ALL_UPDATES = 3;
    private final int updatesToProcess;
    private int updateCount;
    private HashMap excludedComponents;
    private ISynchronizationInfo synchronizationInfo;
    protected final UpdateDilemmaHandler problemHandler;
    private Map ignoreList = new HashMap();
    private final IDownloadListener downloadMonitor;

    public UpdateOperation(IWorkspaceConnection iWorkspaceConnection, List list, int n, UpdateDilemmaHandler updateDilemmaHandler, IDownloadListener iDownloadListener) {
        this(iWorkspaceConnection, list, Collections.EMPTY_LIST, n, updateDilemmaHandler, iDownloadListener);
    }

    public UpdateOperation(IWorkspaceConnection iWorkspaceConnection, List list, Collection collection, int n, UpdateDilemmaHandler updateDilemmaHandler, IDownloadListener iDownloadListener) {
        super(updateDilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : updateDilemmaHandler);
        UpdateDilemmaHandler updateDilemmaHandler2 = this.problemHandler = updateDilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : updateDilemmaHandler;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null || list.isEmpty()) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if ((n | 3) != 3 || n == 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.excludedComponents = new HashMap();
        for (Object object : collection) {
            this.excludedComponents.put(object.getItemId(), object);
        }
        this.connection = iWorkspaceConnection;
        this.updateReports = list;
        this.downloadMonitor = iDownloadListener;
        this.affectedConfigurations = new HashSet();
        for (Iterator iterator : list) {
            if (!(iterator instanceof IUpdateReport)) {
                throw (Throwable)new IllegalArgumentException();
            }
            IUpdateReport iUpdateReport = (IUpdateReport)iterator;
            for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
                this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle));
            }
            for (IComponentHandle iComponentHandle : iUpdateReport.getComponentStatesBefore()) {
                this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle.getComponent()));
            }
            for (IComponentHandle iComponentHandle : iUpdateReport.getComponentStatesAfter()) {
                this.affectedConfigurations.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle.getComponent()));
            }
        }
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 1;
        }
        if ((n & 2) == 2) {
            n2 |= 2;
        }
        this.updatesToProcess = n2;
        this.copyFileAreasAffected = new HashSet();
    }

    public void setSynchronizationInfo(ISynchronizationInfo iSynchronizationInfo) {
        this.synchronizationInfo = iSynchronizationInfo;
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        UpdateOperation$1 updateOperation$1 = new UpdateOperation$1(this);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireRead(this.affectedConfigurations, (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.runWithinFileSystemLock(updateOperation$1, Messages.UpdateOperation_4, (IProgressMonitor)subMonitor.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        subMonitor.done();
    }

    /*
     * Unable to fully structure code
     */
    private void updateCopyFileArea(IProgressMonitor var1_1) throws FileSystemClientException, TeamRepositoryException {
        var1_1.setTaskName(Messages.UpdateOperation_0);
        var2_2 = SubMonitor.convert((IProgressMonitor)var1_1, (int)(30 + 100 * this.updateReports.size()));
        var3_3 = this.cfaLockRequests();
        var4_4 = ICopyFileAreaManager.instance.lock(var3_3, (IProgressMonitor)var2_2.newChild(1));
        try {
            this.determineCopyFileAreasAffected((IProgressMonitor)var2_2.newChild(10));
            var5_5 = this.getAdditionalComponentsToExclude(this.connection, this.excludedComponents.values(), this.updateReports, (IProgressMonitor)var2_2.newChild(10));
            for (Object var6_8 : var5_5) {
                this.excludedComponents.put(var6_8.getItemId(), var6_8);
            }
            var6_8 = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
            this.verifyShares((IProgressMonitor)var2_2.newChild(8));
            var7_7 = 0;
            try {
                var8_9 = this.updateReports.size();
                var9_10 = 1;
                var1_1.setTaskName(Messages.UpdateOperation_1);
                SharingManager.getInstance().disableChangeMonitoring();
                for (IUpdateReport var11_12 : this.updateReports) {
                    if (var8_9 > 1) {
                        var1_1.setTaskName(NLS.bind((String)Messages.UpdateOperation_2, (Object)var9_10, (Object)var8_9));
                    }
                    try {
                        var12_13 = this.getSharePoints(var11_12, (IProgressMonitor)var2_2.newChild(1));
                        var13_16 = var6_8.incrementalFileLoadStream(this.connection, var11_12, this.excludedComponents.values(), var12_13, true, this.updatesToProcess, this.synchronizationInfo, (IProgressMonitor)var2_2.newChild(50));
                        this.loadFileArea(this.connection, var11_12.getComponentStatesBefore(), var11_12.getComponentStatesAfter(), var13_16, (IProgressMonitor)var2_2.newChild(49));
                        this.updateCount += var13_16.getAdds().size() + var13_16.getDeletes().size() + var13_16.getModifies().size() + var13_16.getMoves().size();
                        ++var7_7;
                    }
                    catch (FileSystemClientException var12_14) {
                        this.collectStatus(FileSystemStatus.getStatusFor((Throwable)var12_14));
                    }
                    catch (TeamRepositoryException var12_15) {
                        this.collectStatus(FileSystemStatus.getStatusFor(4, Messages.UpdateOperation_3, (Throwable)var12_15));
                    }
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
                ** for (var15_21 : this.copyFileAreasAffected)
            }
lbl-1000:
            // 1 sources

            {
                var15_21.syncMetaData();
                continue;
lbl42:
                // 1 sources

            }
        }
        finally {
            var4_4.release((IProgressMonitor)var2_2.newChild(1));
        }
        var2_2.done();
    }

    private void determineCopyFileAreasAffected(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.affectedConfigurations.size());
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationDescriptor configurationDescriptor : this.affectedConfigurations) {
            this.copyFileAreasAffected.addAll(iCopyFileAreaManager.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1)));
        }
    }

    private List cfaLockRequests() {
        ICopyFileAreaManager$ICopyFileAreaLockRequestFactory iCopyFileAreaManager$ICopyFileAreaLockRequestFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Object e : this.updateReports) {
            if (!(e instanceof IUpdateReport)) {
                throw (Throwable)new IllegalArgumentException();
            }
            IUpdateReport iUpdateReport = (IUpdateReport)e;
            for (IComponentStateSummary iComponentStateSummary : iUpdateReport.getComponentStatesBefore()) {
                hashSet.add(new ConfigurationDescriptor((IConnection)this.connection, iComponentStateSummary.getComponent()));
            }
        }
        return Collections.singletonList(iCopyFileAreaManager$ICopyFileAreaLockRequestFactory.getLockRequest(hashSet, true));
    }

    private Collection getSharePoints(IUpdateReport iUpdateReport, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)iUpdateReport.getAffectedComponents().size());
        SharingManager sharingManager = SharingManager.getInstance();
        ArrayList<SharePoint> arrayList = new ArrayList<SharePoint>();
        for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            if (this.excludedComponents.containsKey(iComponentHandle.getItemId())) continue;
            try {
                subMonitor2.setWorkRemaining(this.copyFileAreasAffected.size());
                for (ICopyFileArea iCopyFileArea : this.copyFileAreasAffected) {
                    IShare[] iShareArray = sharingManager.allShares(iCopyFileArea.getRoot(), (IProgressMonitor)subMonitor2.newChild(1));
                    String string = iCopyFileArea.getRoot().toString();
                    IShare[] iShareArray2 = iShareArray;
                    int n = iShareArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IShare iShare = iShareArray2[n2];
                        ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                        if (iSharingDescriptor != null && iSharingDescriptor.isAssociatedWithConnection((IConnection)this.connection) && iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle)) {
                            SharePoint sharePoint = FilesystemDTOFactory.eINSTANCE.createSharePoint();
                            sharePoint.setContext(this.connection.getContextHandle());
                            sharePoint.setComponent(iComponentHandle);
                            sharePoint.setVersionable(iSharingDescriptor.getRootVersionable());
                            sharePoint.setCopyFileArea(string);
                            List<String> list = Arrays.asList(iShare.getPath().removeLastSegments(1).segments());
                            sharePoint.getRelativePath().addAll((Collection)list);
                            arrayList.add(sharePoint);
                        }
                        ++n2;
                    }
                }
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
            }
        }
        return arrayList;
    }

    private void verifyShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (!this.verifyInSyncEnabled() || this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            iProgressMonitor.done();
            return;
        }
        VerifySharesOperation verifySharesOperation = new VerifySharesOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        HashMap<UUID, IComponentHandle> hashMap = new HashMap<UUID, IComponentHandle>();
        for (IUpdateReport iUpdateReport : this.updateReports) {
            Object object2;
            if (this.excludedComponents.isEmpty()) {
                for (Object object2 : iUpdateReport.getAffectedComponents()) {
                    verifySharesOperation.addToVerify((IConnection)this.connection, (IComponentHandle)object2);
                }
            } else {
                for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
                    if (this.excludedComponents.containsKey(iComponentHandle.getItemId())) continue;
                    verifySharesOperation.addToVerify((IConnection)this.connection, iComponentHandle);
                }
            }
            object2 = iUpdateReport.getComponentStatesBefore().iterator();
            while (object2.hasNext()) {
                IComponentHandle iComponentHandle;
                iComponentHandle = (IComponentStateSummary)object2.next();
                if (hashMap.get(iComponentHandle.getComponent().getItemId()) != null) continue;
                hashMap.put(iComponentHandle.getComponent().getItemId(), iComponentHandle);
            }
        }
        verifySharesOperation.addToVerifyAgainst((IConnection)this.connection, hashMap.values());
        verifySharesOperation.run(iProgressMonitor);
    }

    public void setIgnoreList(Map map) {
        this.ignoreList = map;
    }

    private void loadFileArea(IWorkspaceConnection iWorkspaceConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        UpdateMutator updateMutator = SharingManager.getInstance().getUpdateMutator((IConnection)iWorkspaceConnection, collection, collection2, fileAreaUpdateReport, this.copyFileAreasAffected, this.problemHandler, this.downloadMonitor);
        updateMutator.setSkipStoreContent(this.ignoreList);
        updateMutator.run(iProgressMonitor);
    }

    private Collection getAdditionalComponentsToExclude(IWorkspaceConnection iWorkspaceConnection, Collection collection, List list, IProgressMonitor iProgressMonitor) {
        IWorkspace iWorkspace2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.copyFileAreasAffected.size() * this.affectedConfigurations.size()));
        HashMap<UUID, IComponentHandle> hashMap = new HashMap<UUID, IComponentHandle>();
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (IWorkspace iWorkspace2 : collection) {
            hashSet.add(iWorkspace2.getItemId());
        }
        iWorkspace2 = iWorkspaceConnection.getResolvedWorkspace();
        for (IUpdateReport iUpdateReport : list) {
            for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
                if (hashSet.contains(iComponentHandle.getItemId())) continue;
                try {
                    boolean bl = false;
                    for (ICopyFileArea iCopyFileArea : this.copyFileAreasAffected) {
                        if (!iCopyFileArea.isConfigurationShared((IContextHandle)iWorkspace2, iComponentHandle, (IProgressMonitor)subMonitor.newChild(1))) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        hashMap.put(iComponentHandle.getItemId(), iComponentHandle);
                    }
                }
                catch (FileSystemClientException fileSystemClientException) {}
                hashSet.add(iComponentHandle.getItemId());
            }
        }
        return hashMap.values();
    }

    protected String getTraceMessage() {
        return String.valueOf(super.getTraceMessage()) + " : " + this.connection.getName() + " " + this.updateCount + " updates";
    }

    static /* synthetic */ void access$0(UpdateOperation updateOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        updateOperation.updateCopyFileArea(iProgressMonitor);
    }
}

