/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.operations.ITransferLockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class TransferLockOperation
extends AbstractLockOperation
implements ITransferLockOperation {
    private Map map = new HashMap();

    public TransferLockOperation(LockDilemmaHandler lockDilemmaHandler) {
        super(lockDilemmaHandler);
    }

    protected IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory iVersionableLockOperationFactory, LockEntry lockEntry, IWorkspaceConnection iWorkspaceConnection) {
        return iVersionableLockOperationFactory.transfer(lockEntry.getVersionable(), iWorkspaceConnection, lockEntry.getComponent(), (IContributorHandle)this.map.get(lockEntry));
    }

    public void transfer(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IContributorHandle iContributorHandle, IContributorHandle iContributorHandle2) {
        LockEntry lockEntry = this.add(iWorkspaceConnection, iComponentHandle, iVersionableHandle, iContributorHandle);
        this.map.put(lockEntry, iContributorHandle2);
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        int n = this.checkLockOwners();
        switch (n) {
            case 1: {
                throw (Throwable)new OperationCanceledException();
            }
            case 2: {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.UnlockOperation_0)));
            }
            case 0: {
                break;
            }
        }
        super.execute(iProgressMonitor);
    }
}

