/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class SynchronizeOperation {
    private SynchronizeOperation() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void synchronize(IShare ishare, IRepositoryResolver resolver, ISynchronizationInfo synchronizationInfo, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        if (resolver == null) {
            resolver = LocalChangeManager.DEFAULT_RESOLVER;
        }
        Share share = (Share)ishare;
        ISharingDescriptor desc = share.getSharingDescriptor();
        IComponentHandle component = desc.getComponent();
        IContextHandle connection = desc.getConnectionHandle();
        ITeamRepository repo = resolver.getRepoFor(desc.getRepositoryUri(), desc.getRepositoryId());
        IFileContentManager contentManager = FileSystemCore.getContentManager(repo);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(share.getCopyFileAreaPath());
        ArrayList<IStatus> otherErrors = new ArrayList<IStatus>();
        try {
            Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)progress.newChild(1));
            AbstractLock rule = CFALockUtil.createAndLockForUpdate(share.getCopyFileAreaPath(), connection, component, (IProgressMonitor)progress.newChild(1));
            try {
                InverseFileItemInfo oldInfo;
                LoadTree tree;
                IBaselineConnection lconnection;
                IConfiguration configuration;
                ICopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(share.getCopyFileAreaPath());
                ISharingDescriptor newDesc = ((CopyFileAreaStore)((Object)cfa)).getSharingInfo(share.getPath());
                if (!desc.equals(newDesc)) {
                    return;
                }
                IWorkspaceManager wMgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                if (desc.getConnectionHandle() instanceof IBaselineHandle) {
                    IBaselineConnection bConnection = wMgr.getBaselineConnection((IBaselineHandle)desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(3));
                    configuration = bConnection.configuration();
                    lconnection = bConnection;
                } else {
                    IWorkspaceConnection wConnection = wMgr.getWorkspaceConnection((IWorkspaceHandle)desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(3));
                    configuration = wConnection.configuration(component);
                    lconnection = wConnection;
                }
                IFileSystemManager fsm = FileSystemCore.getFileSystemManager(repo);
                FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
                boolean needHashes = FileLineDelimiter.getPlatformDelimiter() != FileLineDelimiter.LINE_DELIMITER_LF;
                try {
                    tree = fss.getFileTreeByVersionable((IConnection)lconnection, desc.getComponent(), new IVersionableHandle[]{desc.getRootVersionable()}, -1, true, synchronizationInfo, (IProgressMonitor)progress.newChild(needHashes ? 20 : 35));
                }
                catch (TeamRepositoryException e) {
                    progress.setWorkRemaining(56);
                    try {
                        List root = configuration.fetchCompleteItems(Collections.singletonList(desc.getRootVersionable()), (IProgressMonitor)progress.newChild(15));
                        if (root.get(0) != null) throw e;
                        ((Shareable)share.getShareable()).forget((IProgressMonitor)progress.newChild(20));
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        throw e;
                    }
                    SynchronizeOperation.refreshChanges(share, (IProgressMonitor)progress.newChild(20));
                    return;
                }
                List updates = tree.getFileAreaUpdates();
                TreeBuilder builder = new TreeBuilder(needHashes);
                HashSet<UUID> inTree = new HashSet<UUID>((int)((double)updates.size() / 0.75));
                IFileContentManagerSession contentSession = needHashes ? contentManager.createSession("", true, updates.size(), (IProgressMonitor)progress.newChild(15)) : null;
                for (FileAreaUpdate update : updates) {
                    inTree.add(update.getItem().getItemId());
                    if (!update.getItem().sameItemId((IItemHandle)desc.getRootVersionable())) {
                        builder.updateChildren(update);
                    }
                    if (!needHashes) continue;
                    if (update.getOptionalContent() != null && contentManager.convertDelimitersDuringRetrieval(update.getOptionalContent())) {
                        InverseFileItemInfo oldInfo2 = ((CopyFileAreaStore)((Object)cfa)).getItemInfo(update.getItem(), component, connection);
                        if (oldInfo2 != null && update.afterState().sameStateId((IItemHandle)oldInfo2.getVersionableHandle())) {
                            contentSession.decrementTransferCount(1L);
                            continue;
                        }
                        contentSession.retrieveContent((IFileItemHandle)update.afterState(), update.getOptionalContent(), builder);
                        continue;
                    }
                    contentSession.decrementTransferCount(1L);
                }
                if (needHashes) {
                    contentSession.join();
                }
                ISharingMetadata md = ((CopyFileAreaStore)((Object)cfa)).internalGetMetadata();
                ArrayList<IVersionableHandle> deletedItems = new ArrayList<IVersionableHandle>();
                SubMonitor subProgress = progress.newChild(25);
                subProgress.setWorkRemaining(updates.size());
                for (FileAreaUpdate update : updates) {
                    InverseFileItemInfo newInfo;
                    SubMonitor subSubProgress = subProgress.newChild(1);
                    subSubProgress.setWorkRemaining(100);
                    oldInfo = ((CopyFileAreaStore)((Object)cfa)).getItemInfo(update.getItem(), component, connection);
                    IPath localPath = ((CopyFileAreaStore)((Object)cfa)).getLocalPathFor(update.getItem(), component, connection, (IProgressMonitor)subSubProgress.newChild(33));
                    Map<String, IVersionableHandle> children = builder.getChildren(update);
                    IVersionableHandle item = update.afterState();
                    IFolderHandle parent = update.getDestinationParent();
                    String name = update.getName();
                    ContentHash hash = null;
                    long size = -1L;
                    FileLineDelimiter originalLineDelimiter = null;
                    String originalContentType = null;
                    ContentHash predecessorHintHash = null;
                    long sizeInRepo = -1L;
                    String encoding = null;
                    ContentHash hashInRepo = null;
                    long numLineDelimiters = -1L;
                    if (update.getOptionalContent() != null) {
                        size = update.getOptionalContent().getEstimatedConvertedLength();
                        hash = builder.getHash(update, oldInfo);
                        if (hash == null) continue;
                        originalLineDelimiter = update.getOptionalContent().getLineDelimiter();
                        originalContentType = update.getContentType();
                        FileContent content = (FileContent)update.getOptionalContent();
                        predecessorHintHash = content.getPredecessorHintHash();
                        sizeInRepo = content.getSize();
                        encoding = content.getCharacterEncoding();
                        hashInRepo = content.getHash();
                        numLineDelimiters = content.getLineDelimiterCount();
                    } else if (update.getItem() instanceof ISymbolicLinkHandle) {
                        try {
                            hashInRepo = LocalChangeTracker.getLinkHash(update.getLinkTarget());
                        }
                        catch (IOException e) {
                            otherErrors.add(FileSystemStatus.getStatusFor(e));
                            continue;
                        }
                        hash = hashInRepo;
                    }
                    if (oldInfo == null) {
                        newInfo = new InverseFileItemInfo(item, false, -1L, parent, name, false, children, null, null, hash, size, originalLineDelimiter, originalLineDelimiter, originalContentType, originalContentType, predecessorHintHash, sizeInRepo, encoding, hashInRepo, numLineDelimiters, update.isExecutable(), update.isExecutable());
                    } else {
                        long modStamp;
                        boolean contentChanged;
                        boolean useOldContentInfo;
                        boolean loadedWithAnotherName;
                        IFolderHandle localParent = oldInfo.getLocalParent();
                        if (localParent == null && item.sameItemId((IItemHandle)desc.getRootVersionable()) && oldInfo.getParent() == null) {
                            localParent = parent;
                            loadedWithAnotherName = !name.equals(oldInfo.getLocalName());
                            useOldContentInfo = false;
                        } else {
                            loadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
                            useOldContentInfo = true;
                        }
                        if (hash != null) {
                            if (hash.equals((Object)oldInfo.getHash()) && size == oldInfo.getContentLength()) {
                                contentChanged = oldInfo.isContentChanged();
                                modStamp = oldInfo.getLastContentChangeCheckStamp();
                            } else {
                                contentChanged = oldInfo.getLocalName() != null;
                                modStamp = -1L;
                            }
                        } else {
                            modStamp = -1L;
                            contentChanged = false;
                        }
                        newInfo = new InverseFileItemInfo(item, contentChanged, modStamp, parent, name, loadedWithAnotherName, children, localParent, oldInfo.getLocalName(), hash, size, originalLineDelimiter, useOldContentInfo ? oldInfo.getLineDelimiter() : originalLineDelimiter, originalContentType, useOldContentInfo ? oldInfo.getContentType() : originalContentType, predecessorHintHash, sizeInRepo, encoding, hashInRepo, numLineDelimiters, useOldContentInfo ? oldInfo.isExecutable() : update.isExecutable(), update.isExecutable());
                        if (localPath != null) {
                            md.setFileItemInfo(localPath, newInfo);
                            subSubProgress.worked(33);
                        }
                        for (IVersionableHandle h : oldInfo.getRemoteChildren().values()) {
                            if (inTree.contains(h.getItemId())) continue;
                            deletedItems.add(h);
                        }
                    }
                    subSubProgress.setWorkRemaining(33);
                    md.setFileItemInfo(item, component, connection, newInfo);
                    subSubProgress.done();
                }
                subProgress.done();
                subProgress = progress.newChild(9);
                while (!deletedItems.isEmpty()) {
                    subProgress.setWorkRemaining(deletedItems.size() + 1);
                    SubMonitor subSubProgress = subProgress.newChild(1);
                    subSubProgress.setWorkRemaining(100);
                    IVersionableHandle deleted = (IVersionableHandle)deletedItems.remove(deletedItems.size() - 1);
                    IPath localPath = ((CopyFileAreaStore)((Object)cfa)).getLocalPathFor(deleted, component, connection, (IProgressMonitor)subSubProgress.newChild(25));
                    oldInfo = md.setFileItemInfo(deleted, component, connection, null);
                    subSubProgress.worked(25);
                    if (localPath != null) {
                        IVersionableHandle newHandle = (IVersionableHandle)oldInfo.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null);
                        InverseFileItemInfo newInfo = new InverseFileItemInfo(newHandle, false, -1L, null, null, false, Collections.EMPTY_MAP, oldInfo.getLocalParent(), oldInfo.getLocalName(), null, -1L, null, oldInfo.getLineDelimiter(), null, oldInfo.getContentType(), null, -1L, null, null, -1L, oldInfo.isExecutable(), false);
                        md.setFileItemInfo(localPath, newInfo);
                        subSubProgress.worked(12);
                        md.setFileItemInfo(newHandle, component, connection, newInfo);
                        subSubProgress.worked(13);
                        if (oldInfo.isFolder()) {
                            Shareable shareable = share.getShareable(localPath, ResourceType.FOLDER);
                            Map childInfos = ((CopyFileAreaStore)((Object)cfa)).getChildInfos(shareable.getLocalPath(), (IProgressMonitor)subSubProgress.newChild(5));
                            IFolderHandle parent = (IFolderHandle)newHandle;
                            subSubProgress.setWorkRemaining(childInfos.size());
                            for (FileItemInfo info : childInfos.values()) {
                                InverseFileItemInfo inverseInfo = ((CopyFileAreaStore)((Object)cfa)).getItemInfo(info.getVersionableHandle(), component, connection);
                                InverseFileItemInfo newChildInfo = new InverseFileItemInfo(inverseInfo.getVersionableHandle(), inverseInfo.isContentChanged(), inverseInfo.getLastContentChangeCheckStamp(), inverseInfo.getParent(), inverseInfo.getName(), inverseInfo.isLoadedWithAnotherName(), inverseInfo.getRemoteChildren(), parent, inverseInfo.getLocalName(), inverseInfo.getHash(), inverseInfo.getContentLength(), inverseInfo.getOriginalLineDelimiter(), inverseInfo.getLineDelimiter(), inverseInfo.getOriginalContentType(), inverseInfo.getContentType(), inverseInfo.getStoredPredecessorHintHash(), inverseInfo.getStoredSize(), inverseInfo.getStoredEncoding(), inverseInfo.getStoredHash(), inverseInfo.getStoredNumLineDelimiters(), inverseInfo.isExecutable(), inverseInfo.isOriginalExecutable());
                                md.setFileItemInfo(newChildInfo.getVersionableHandle(), component, connection, newChildInfo);
                                subSubProgress.worked(1);
                            }
                        }
                    }
                    for (IVersionableHandle h : oldInfo.getRemoteChildren().values()) {
                        if (inTree.contains(h.getItemId())) continue;
                        deletedItems.add(h);
                    }
                    subSubProgress.done();
                }
                subProgress.done();
                if (builder.hasFailedFetches()) {
                    ((CopyFileAreaStore)((Object)cfa)).setConfigurationState(connection, component, share.getPath(), ISyncTime.TIME_NONE, (IProgressMonitor)progress.newChild(1));
                } else {
                    ((CopyFileAreaStore)((Object)cfa)).setConfigurationState(connection, component, share.getPath(), ISyncTime.FACTORY.createFrom(tree.getConfigurationState()), (IProgressMonitor)progress.newChild(1));
                }
                SynchronizeOperation.refreshChanges(share, (IProgressMonitor)progress.newChild(24));
                if (needHashes) {
                    if (!otherErrors.isEmpty()) {
                        IStatus[] contentDownloadErrors;
                        IStatus[] iStatusArray = contentDownloadErrors = contentSession.getErrorStatus();
                        int n = contentDownloadErrors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus status = iStatusArray[n2];
                            otherErrors.add(status);
                            ++n2;
                        }
                    } else {
                        RepositoryUtils.throwAppropriateException(Messages.SynchronizeOperation_1, contentSession.getErrorStatus());
                    }
                }
                if (otherErrors.isEmpty()) return;
                RepositoryUtils.throwAppropriateException(Messages.SynchronizeOperation_1, otherErrors.toArray(new IStatus[otherErrors.size()]));
                return;
            }
            finally {
                CFALockUtil.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(trackingRule);
            progress.done();
        }
    }

    private static void refreshChanges(IShare share, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Shareable rootShareable = (Shareable)share.getShareable();
        SharingManager shMgr = SharingManager.getInstance();
        shMgr.disableChangeMonitoring();
        try {
            rootShareable.getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(40));
        }
        finally {
            shMgr.enableChangeMonitoring();
        }
        ILocalChangeManager changeManager = shMgr.getLocalChangeManager();
        ((LocalChangeManager)changeManager).refreshChanges(share, rootShareable, (IProgressMonitor)progress.newChild(60));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeBuilder
    extends FileDownloadHandler {
        private Map<UUID, Map<String, FileAreaUpdate>> childMap = new HashMap<UUID, Map<String, FileAreaUpdate>>();
        private Map<UUID, ContentHash> fetchedHashes;
        private Set<UUID> failedFetches;
        private final boolean needsHashes;

        public TreeBuilder(boolean needsHashes) {
            this.needsHashes = needsHashes;
            if (needsHashes) {
                this.fetchedHashes = new HashMap<UUID, ContentHash>();
                this.failedFetches = new HashSet<UUID>();
            }
        }

        public void updateChildren(FileAreaUpdate update) {
            Map<String, FileAreaUpdate> children = this.childMap.get(update.getDestinationParent().getItemId());
            if (children == null) {
                children = new HashMap<String, FileAreaUpdate>();
                this.childMap.put(update.getDestinationParent().getItemId(), children);
            }
            children.put(update.getName(), update);
        }

        public Map<String, IVersionableHandle> getChildren(FileAreaUpdate update) {
            Map<String, FileAreaUpdate> map = this.childMap.get(update.getItem().getItemId());
            if (map == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, IVersionableHandle> result = new HashMap<String, IVersionableHandle>();
            for (Map.Entry<String, FileAreaUpdate> entry : map.entrySet()) {
                if (!this.includeVersionable(entry.getValue())) continue;
                result.put(entry.getKey(), entry.getValue().getItem());
            }
            return result;
        }

        private boolean includeVersionable(FileAreaUpdate fileAreaUpdate) {
            if (this.failedFetches == null) {
                return true;
            }
            if (fileAreaUpdate.getOptionalContent() == null) {
                return true;
            }
            return !this.failedFetches.contains(fileAreaUpdate.getOptionalContent());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadStreamAcquired(IFileItemHandle handle, IFileContent content, InputStream in) throws TeamRepositoryException {
            ContentHash hash;
            try {
                try {
                    hash = ContentHash.valueOf((InputStream)in);
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {}
            Map<UUID, ContentHash> map = this.fetchedHashes;
            synchronized (map) {
                this.fetchedHashes.put(handle.getItemId(), hash);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadFailed(IFileItemHandle handle, IFileContent content, Exception e) {
            Set<UUID> set = this.failedFetches;
            synchronized (set) {
                this.failedFetches.add(handle.getItemId());
            }
        }

        public ContentHash getHash(FileAreaUpdate update, InverseFileItemInfo oldInfo) {
            if (this.needsHashes) {
                if (update.getOptionalContent().getLineDelimiter() == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
                    if (oldInfo != null && update.afterState().sameStateId((IItemHandle)oldInfo.getVersionableHandle())) {
                        return oldInfo.getHash();
                    }
                    ContentHash hash = this.fetchedHashes.get(update.getItem().getItemId());
                    if (hash == null && !this.failedFetches.contains(update.getItem().getItemId())) {
                        this.failedFetches.add(update.getItem().getItemId());
                        LoggingHelper.log(new FileSystemStatus(NLS.bind((String)"Content was required but not fetched for file ''{0}''", (Object)update.getName())));
                    }
                    return hash;
                }
                return update.getOptionalContent().getHash();
            }
            return update.getOptionalContent().getHash();
        }

        public boolean hasFailedFetches() {
            return this.failedFetches != null && !this.failedFetches.isEmpty();
        }
    }
}

