/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.SuspendOperation$1;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class SuspendOperation
extends ChangeHistoryChangeSetsOperation
implements ISuspendOperation {
    private final SuspendDilemmaHandler problemHandler;
    private Map suspendRequests;

    public SuspendOperation(SuspendDilemmaHandler suspendDilemmaHandler) {
        super(suspendDilemmaHandler == null ? SuspendDilemmaHandler.getDefault() : suspendDilemmaHandler);
        this.problemHandler = suspendDilemmaHandler == null ? SuspendDilemmaHandler.getDefault() : suspendDilemmaHandler;
        this.suspendRequests = new HashMap();
    }

    public void suspend(IWorkspaceConnection iWorkspaceConnection, Collection collection) {
        Object object2;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection.isEmpty()) {
            throw (Throwable)new IllegalArgumentException();
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (Object object2 : collection) {
            if (object2 == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (hashSet.add(object2.getItemId())) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        object2 = (List)this.suspendRequests.get(iWorkspaceConnection);
        if (object2 == null) {
            ArrayList arrayList = new ArrayList(collection);
            this.suspendRequests.put(iWorkspaceConnection, arrayList);
        } else {
            object2.addAll(collection);
        }
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object2;
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.SuspendOperation_ProgressMessage, (int)100);
        HashSet hashSet = new HashSet();
        ArrayList arrayList = new ArrayList();
        for (Object object2 : this.suspendRequests.keySet()) {
            List list = (List)this.suspendRequests.get(object2);
            hashSet.addAll(this.getAffectedConfigurations(arrayList, (IWorkspaceConnection)object2, list, (IProgressMonitor)subMonitor.newChild(4)));
        }
        object2 = WorkspaceLockUtil.acquireWrite(hashSet, (Collection)arrayList, (IProgressMonitor)subMonitor.newChild(1));
        try {
            SuspendOperation$1 suspendOperation$1 = new SuspendOperation$1(this, hashSet);
            this.runWithinFileSystemLock(suspendOperation$1, Messages.SuspendOperation_0, (IProgressMonitor)subMonitor.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(object2);
        }
        subMonitor.done();
    }

    private void suspend(Set set, IWorkspaceConnection iWorkspaceConnection, Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)175);
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        IUpdateReport iUpdateReport = iWorkspaceConnection.suspend(collection, (IProgressMonitor)subMonitor.newChild(75));
        UpdateOperation updateOperation = new UpdateOperation(iWorkspaceConnection, Collections.singletonList(iUpdateReport), 3, this.problemHandler, null);
        this.disableVerifyInSync(updateOperation);
        updateOperation.run((IProgressMonitor)subMonitor.newChild(50));
    }

    private Set getAffectedConfigurations(Collection collection, IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        List list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, iProgressMonitor);
        collection.addAll(collection);
        for (IChangeSet iChangeSet : list2) {
            hashSet.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iChangeSet.getComponent()));
        }
        return hashSet;
    }

    protected void refreshLocal(IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        for (Object k : this.suspendRequests.keySet()) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)k;
            List list = (List)this.suspendRequests.get(k);
            ChangeSetRefreshUtils.refreshLocalForRemoval(iFilesystemRefresher, map, iWorkspaceConnection, list, iProgressMonitor);
        }
    }

    static /* synthetic */ SuspendDilemmaHandler access$0(SuspendOperation suspendOperation) {
        return suspendOperation.problemHandler;
    }

    static /* synthetic */ Map access$1(SuspendOperation suspendOperation) {
        return suspendOperation.suspendRequests;
    }

    static /* synthetic */ void access$2(SuspendOperation suspendOperation, Set set, IWorkspaceConnection iWorkspaceConnection, Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        suspendOperation.suspend(set, iWorkspaceConnection, collection, iProgressMonitor);
    }
}

