/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation$ComponentCheckInRequest;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RationalizingTree;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public class ShareableCheckinRequest
extends NewCheckInOperation$ComponentCheckInRequest {
    private final IShareable[] shareables;
    ILocalChange[] changes = null;

    ShareableCheckinRequest(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, ISandbox iSandbox, IShareable[] iShareableArray, IChangeSetHandle iChangeSetHandle, String string) {
        super(iSandbox, iWorkspaceConnection, iComponentHandle, iChangeSetHandle, string);
        this.shareables = iShareableArray;
    }

    public ILocalChange[] getChanges(boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (this.changes == null) {
            this.changes = this.internalGetChanges(bl, iProgressMonitor);
        }
        return this.changes;
    }

    private ILocalChange[] internalGetChanges(boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (!CFALockUtil.isLockedForUpdate(this.sandbox.getRoot(), this.component, this.workspace.getContextHandle())) {
            return new ILocalChange[0];
        }
        LocalChangeManager localChangeManager = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        if (bl) {
            RationalizingTree rationalizingTree = new RationalizingTree();
            IShareable[] iShareableArray = this.shareables;
            int n = this.shareables.length;
            int n2 = 0;
            while (n2 < n) {
                IShareable iShareable = iShareableArray[n2];
                rationalizingTree.put(iShareable.getLocalPath().segments(), iShareable);
                ++n2;
            }
            subMonitor.setWorkRemaining(rationalizingTree.size() * 4);
            for (IShareable iShareable : rationalizingTree) {
                ((Shareable)iShareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
            }
            for (IShareable iShareable : rationalizingTree) {
                localChangeManager.refreshChanges(iShareable.getShare((IProgressMonitor)subMonitor), iShareable, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.setWorkRemaining(2);
        }
        localChangeManager.syncPendingChanges((IContextHandle)this.workspace.getResolvedWorkspace(), this.component, this.sandbox, (IProgressMonitor)subMonitor.newChild(1));
        return this.cleanChanges(localChangeManager.getPendingChanges(this.shareables, (IProgressMonitor)subMonitor.newChild(1)));
    }

    private ILocalChange[] cleanChanges(ILocalChange[] iLocalChangeArray) {
        ArrayList<ILocalChange> arrayList = new ArrayList<ILocalChange>(iLocalChangeArray.length);
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray;
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = iLocalChangeArray2[n2];
            if (this.component.sameItemId((IItemHandle)iLocalChange.getComponent()) && this.workspace.getContextHandle().sameItemId((IItemHandle)iLocalChange.getConnection()) && PathUtils.samePath(this.sandbox.getRoot(), this.sandbox.isCaseSensitive(), ((LocalChange)iLocalChange).getCfaRoot(), this.sandbox.isCaseSensitive())) {
                arrayList.add(iLocalChange);
            }
            ++n2;
        }
        return arrayList.toArray(new ILocalChange[arrayList.size()]);
    }

    public void validate(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.shareables.length);
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", -1, "Errors validating checkin request", null);
        IShareable[] iShareableArray = this.shareables;
        int n = this.shareables.length;
        int n2 = 0;
        while (n2 < n) {
            IShare iShare;
            IShareable iShareable = iShareableArray[n2];
            if (!iShareable.getSandbox().equals(this.sandbox)) {
                multiStatus.add(FileSystemStatus.getStatusFor(4, "Wrong sandbox for " + iShareable.getLocalPath().toOSString(), null));
            }
            if ((iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1))) != null) {
                ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                if (!iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)this.workspace.getContextHandle())) {
                    multiStatus.add(FileSystemStatus.getStatusFor(4, "Wrong connection for " + iShareable.getLocalPath().toOSString(), null));
                }
                if (!iSharingDescriptor.getComponent().sameItemId((IItemHandle)this.component)) {
                    multiStatus.add(FileSystemStatus.getStatusFor(4, "Wrong component for " + iShareable.getLocalPath().toOSString(), null));
                }
            }
            ++n2;
        }
        if (multiStatus.getChildren().length > 0) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
    }
}

