/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.ResumeOperation$1;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class ResumeOperation
extends ChangeHistoryChangeSetsOperation
implements IResumeOperation {
    private final Map resumeRequests;
    private final ResumeDilemmaHandler problemHandler;

    public ResumeOperation(ResumeDilemmaHandler resumeDilemmaHandler) {
        super(resumeDilemmaHandler == null ? ResumeDilemmaHandler.getDefault() : resumeDilemmaHandler);
        this.problemHandler = resumeDilemmaHandler == null ? ResumeDilemmaHandler.getDefault() : resumeDilemmaHandler;
        this.resumeRequests = new HashMap();
    }

    public void resume(IWorkspaceConnection iWorkspaceConnection, Collection collection) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ArrayList arrayList = (ArrayList)this.resumeRequests.get(iWorkspaceConnection);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.resumeRequests.put(iWorkspaceConnection, arrayList);
        }
        arrayList.addAll(collection);
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.ResumeOperation_ProgressMessage, (int)100);
        ArrayList arrayList = new ArrayList();
        Set set = this.getAffectedConfigurations(arrayList, (IProgressMonitor)subMonitor.newChild(4));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(set, (Collection)arrayList, (IProgressMonitor)subMonitor.newChild(1));
        try {
            ResumeOperation$1 resumeOperation$1 = new ResumeOperation$1(this, set);
            this.runWithinFileSystemLock(resumeOperation$1, Messages.ResumeOperation_0, (IProgressMonitor)subMonitor.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        subMonitor.done();
    }

    private void resume(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(43 + 100 * this.resumeRequests.size()));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            object2 = subMonitor.newChild(1);
            object2.setWorkRemaining(set.size());
            object = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationDescriptor object3 : set) {
                object.addToVerify(object3.getConnection((IProgressMonitor)object2.newChild(1)), object3.componentHandle);
            }
            object.run((IProgressMonitor)subMonitor.newChild(20));
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        object2 = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(set, true);
        object = ICopyFileAreaManager.instance.lock(Collections.singleton(object2), (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.checkinPendingChanges(set, this.problemHandler, true, (IProgressMonitor)subMonitor.newChild(20));
            for (Map.Entry entry : this.resumeRequests.entrySet()) {
                IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
                List list = (List)entry.getValue();
                Map map = ResumeOperation.shouldMakeResumedCurrent(iWorkspaceConnection, list, (IProgressMonitor)subMonitor.newChild(5));
                if (subMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                IUpdateReport iUpdateReport = iWorkspaceConnection.resume(0, list, (IProgressMonitor)subMonitor.newChild(45));
                UpdateOperation updateOperation = new UpdateOperation(iWorkspaceConnection, Collections.singletonList(iUpdateReport), 3, this.problemHandler, null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)subMonitor.newChild(45));
                SubMonitor subMonitor2 = subMonitor.newChild(5);
                subMonitor2.setWorkRemaining(map.size());
                for (IChangeSetHandle iChangeSetHandle : map.values()) {
                    iWorkspaceConnection.setCurrentChangeSet(iChangeSetHandle, (IProgressMonitor)subMonitor2.newChild(1));
                }
            }
        }
        finally {
            object.release((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static Map shouldMakeResumedCurrent(IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<IChangeSet> arrayList;
        IComponentHandle iComponentHandle;
        HashMap<UUID, ArrayList<IChangeSet>> hashMap = new HashMap<UUID, ArrayList<IChangeSet>>();
        HashMap<IComponentHandle, IChangeSetHandle> hashMap2 = new HashMap<IComponentHandle, IChangeSetHandle>();
        List list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, iProgressMonitor);
        for (IChangeSet iChangeSet : list2) {
            if (!iChangeSet.isActive()) continue;
            iComponentHandle = iChangeSet.getComponent();
            arrayList = (ArrayList<IChangeSet>)hashMap.get(iComponentHandle.getItemId());
            if (arrayList == null) {
                arrayList = new ArrayList<IChangeSet>();
                hashMap.put(iComponentHandle.getItemId(), arrayList);
            }
            arrayList.add(iChangeSet);
        }
        for (IChangeSet iChangeSet : hashMap.keySet()) {
            iComponentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)iChangeSet, null);
            arrayList = iWorkspaceConnection.getCurrentChangeSet(iComponentHandle);
            List list3 = (List)hashMap.get(iChangeSet);
            if (arrayList != null || list3.size() != 1) continue;
            hashMap2.put(iComponentHandle, (IChangeSetHandle)list3.get(0));
        }
        return hashMap2;
    }

    private Set getAffectedConfigurations(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry entry : this.resumeRequests.entrySet()) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
            List list = (List)entry.getValue();
            List list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, iProgressMonitor);
            collection.addAll(list2);
            for (IChangeSet iChangeSet : list2) {
                hashSet.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iChangeSet.getComponent()));
            }
        }
        return hashSet;
    }

    protected void refreshLocal(IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        for (Map.Entry entry : this.resumeRequests.entrySet()) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
            List list = (List)entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForAddition(iFilesystemRefresher, map, iWorkspaceConnection, list, iProgressMonitor);
        }
    }

    static /* synthetic */ void access$0(ResumeOperation resumeOperation, Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        resumeOperation.resume(set, iProgressMonitor);
    }
}

