/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation$1;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.filesystem.common.internal.dto.Resolution;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ResolveConflictsOperation
extends FileSystemOperation {
    protected IWorkspaceConnection connection;
    protected HashSet changes;
    private ILogicalConflictReport conflictReport;

    public ResolveConflictsOperation(IWorkspaceConnection iWorkspaceConnection, ILogicalConflictReport iLogicalConflictReport, Collection collection, UpdateDilemmaHandler updateDilemmaHandler) throws FileSystemClientException {
        super(updateDilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : updateDilemmaHandler);
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iLogicalConflictReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.connection = iWorkspaceConnection;
        this.changes = new HashSet(collection);
        this.conflictReport = iLogicalConflictReport;
    }

    public Collection getRequiredChanges() {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        this.getRequiredChanges(this.changes, hashSet, hashSet2);
        return hashSet2;
    }

    public void getRequiredChanges(Collection collection, HashSet hashSet, HashSet hashSet2) {
        for (ILogicalChange iLogicalChange : collection) {
            if (hashSet.contains(iLogicalChange)) continue;
            hashSet.add(iLogicalChange);
            if (iLogicalChange.kind() == 1 && !this.changes.contains(iLogicalChange)) {
                hashSet2.add(iLogicalChange);
            }
            List list = this.conflictReport.getRequiredChanges(iLogicalChange);
            this.getRequiredChanges(list, hashSet, hashSet2);
        }
    }

    public void addChangesToResolve(Collection collection) {
        this.changes.addAll(collection);
    }

    protected void updateCopyFileArea(ConflictResolutionReport conflictResolutionReport, UpdateDilemmaHandler updateDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ArrayList<IUpdateReport> arrayList = new ArrayList<IUpdateReport>(conflictResolutionReport.getResolutions().size());
        for (Resolution resolution : conflictResolutionReport.getResolutions()) {
            arrayList.add(resolution.getUpdateReport());
        }
        this.updateCopyFileArea(arrayList, updateDilemmaHandler, iProgressMonitor);
    }

    protected final UpdateDilemmaHandler getIgnoreHandler(UpdateDilemmaHandler updateDilemmaHandler) {
        return new ResolveConflictsOperation$1(this, updateDilemmaHandler);
    }

    protected void updateCopyFileArea(List list, UpdateDilemmaHandler updateDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        UpdateOperation updateOperation = new UpdateOperation(this.connection, list, 3, updateDilemmaHandler, null);
        this.disableVerifyInSync(updateOperation);
        updateOperation.run(iProgressMonitor);
    }
}

