/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class OperationRequest {
    private final IWorkspaceConnection workspace;
    private IChangeHistorySyncReport syncReport;
    private List baselines;
    private List changeSets;
    private final List components;
    private final IWorkspaceConnection source;
    private ITeamRepository optionalSource;

    public OperationRequest(IWorkspaceConnection iWorkspaceConnection, ITeamRepository iTeamRepository, List list, IWorkspaceConnection iWorkspaceConnection2) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.workspace = iWorkspaceConnection;
        this.optionalSource = iTeamRepository;
        this.changeSets = list;
        this.components = Collections.EMPTY_LIST;
        this.baselines = Collections.EMPTY_LIST;
        this.syncReport = null;
        this.source = iWorkspaceConnection2;
    }

    public OperationRequest(IWorkspaceConnection iWorkspaceConnection, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2, IWorkspaceConnection iWorkspaceConnection2) {
        this(iWorkspaceConnection, iChangeHistorySyncReport, list, list2, Collections.EMPTY_LIST, iWorkspaceConnection2);
    }

    public OperationRequest(IWorkspaceConnection iWorkspaceConnection, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2, List list3, IWorkspaceConnection iWorkspaceConnection2) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iChangeHistorySyncReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list3 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iChangeHistorySyncReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.syncReport = iChangeHistorySyncReport;
        this.baselines = list;
        this.workspace = iWorkspaceConnection;
        this.changeSets = list2;
        this.components = list3;
        this.source = iWorkspaceConnection2;
    }

    public void clearChanges(IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<IChangeSet> arrayList;
        List list;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        if (this.changeSets.size() > 0) {
            list = this.getSourceRepository().itemManager().fetchPartialItems(this.changeSets, 0, (Collection)Collections.singletonList(IChangeSet.COMPONENT_PROPERTY), (IProgressMonitor)subMonitor.newChild(5));
            arrayList = new ArrayList<IChangeSet>();
            for (IChangeSet iChangeSet : list) {
                if (iChangeSet.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                arrayList.add(iChangeSet);
            }
            this.changeSets = arrayList;
        }
        if (this.baselines.size() > 0) {
            list = this.getSourceRepository().itemManager().fetchPartialItems(this.baselines, 0, (Collection)Collections.singletonList(IBaseline.COMPONENT_PROPERTY), (IProgressMonitor)subMonitor.newChild(5));
            arrayList = new ArrayList();
            for (IChangeSet iChangeSet : list) {
                if (iChangeSet.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                arrayList.add(iChangeSet);
            }
            this.baselines = arrayList;
        }
    }

    private ITeamRepository getSourceRepository() {
        if (this.optionalSource != null) {
            return this.optionalSource;
        }
        return this.workspace.teamRepository();
    }

    public Collection getAffectedConfigurations(List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        List list2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        if (!this.changeSets.isEmpty()) {
            list2 = this.getSourceRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)subMonitor.newChild(50));
            list.addAll(list2);
            for (IChangeSet iChangeSet : list2) {
                hashSet.add(new ConfigurationDescriptor((IConnection)this.workspace, iChangeSet.getComponent()));
            }
        }
        if (!this.baselines.isEmpty()) {
            list2 = this.getSourceRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)subMonitor.newChild(50));
            list.addAll(list2);
            for (IChangeSet iChangeSet : list2) {
                hashSet.add(new ConfigurationDescriptor((IConnection)this.workspace, iChangeSet.getComponent()));
            }
        }
        if (!this.components.isEmpty()) {
            list2 = this.getSourceRepository().itemManager().fetchCompleteItems(this.components, 0, (IProgressMonitor)subMonitor.newChild(50));
            list.addAll(list2);
            for (IChangeSet iChangeSet : this.components) {
                hashSet.add(new ConfigurationDescriptor((IConnection)this.workspace, (IComponentHandle)iChangeSet));
            }
        }
        return hashSet;
    }

    public List getAffectedComponents(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Collection collection = this.getAffectedConfigurations(new ArrayList(), iProgressMonitor);
        ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>(collection.size());
        for (ConfigurationDescriptor configurationDescriptor : collection) {
            arrayList.add(configurationDescriptor.componentHandle);
        }
        return arrayList;
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IWorkspaceConnection getSourceWorkspace() {
        return this.source;
    }

    public IChangeHistorySyncReport getSyncReport() {
        return this.syncReport;
    }

    public void addBaseline(IBaselineHandle iBaselineHandle) {
        for (IBaselineHandle iBaselineHandle2 : this.baselines) {
            if (!iBaselineHandle2.sameItemId((IItemHandle)iBaselineHandle) && iBaselineHandle != null) continue;
            return;
        }
        this.baselines.add(iBaselineHandle);
    }

    public void addBaseline(List list) {
        for (IBaselineHandle iBaselineHandle : list) {
            this.addBaseline(iBaselineHandle);
        }
    }

    public void addChangeSet(IChangeSetHandle iChangeSetHandle) {
        for (IChangeSetHandle iChangeSetHandle2 : this.changeSets) {
            if (!iChangeSetHandle2.sameItemId((IItemHandle)iChangeSetHandle) && iChangeSetHandle != null) continue;
            return;
        }
        this.changeSets.add(iChangeSetHandle);
    }

    public void addChangeSet(List list) {
        for (IChangeSetHandle iChangeSetHandle : list) {
            this.addChangeSet(iChangeSetHandle);
        }
    }

    public void addComponent(IComponentHandle iComponentHandle) {
        for (IComponentHandle iComponentHandle2 : this.components) {
            if (!iComponentHandle2.sameItemId((IItemHandle)iComponentHandle) && iComponentHandle != null) continue;
            return;
        }
        this.components.add(iComponentHandle);
    }

    public void addComponent(List list) {
        for (IComponentHandle iComponentHandle : list) {
            this.addComponent(iComponentHandle);
        }
    }

    public List getBaselines() {
        return Collections.unmodifiableList(this.baselines);
    }

    public List getChangeSets() {
        return Collections.unmodifiableList(this.changeSets);
    }

    public List getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public void setReport(IChangeHistorySyncReport iChangeHistorySyncReport) {
        this.syncReport = iChangeHistorySyncReport;
    }

    public ITeamRepository getOptionalSourceRepository() {
        return this.optionalSource;
    }
}

